/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.cloud.autoscaling;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import org.apache.solr.client.solrj.cloud.autoscaling.Cell;
import org.apache.solr.client.solrj.cloud.autoscaling.Clause;
import org.apache.solr.client.solrj.cloud.autoscaling.NodeStateProvider;
import org.apache.solr.client.solrj.cloud.autoscaling.ReplicaInfo;
import org.apache.solr.client.solrj.cloud.autoscaling.SolrCloudManager;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.util.Pair;
import org.apache.solr.common.util.Utils;

public class Row
implements MapWriter {
    public final String node;
    final Cell[] cells;
    public Map<String, Map<String, List<ReplicaInfo>>> collectionVsShardVsReplicas;
    boolean anyValueMissing = false;
    boolean isLive = true;

    public Row(String node, List<String> params, List<String> perReplicaAttributes, SolrCloudManager cloudManager) {
        NodeStateProvider nodeStateProvider = cloudManager.getNodeStateProvider();
        this.collectionVsShardVsReplicas = nodeStateProvider.getReplicaInfo(node, perReplicaAttributes);
        if (this.collectionVsShardVsReplicas == null) {
            this.collectionVsShardVsReplicas = new HashMap<String, Map<String, List<ReplicaInfo>>>();
        }
        this.node = node;
        this.cells = new Cell[params.size()];
        this.isLive = cloudManager.getClusterStateProvider().getLiveNodes().contains(node);
        Map vals = this.isLive ? nodeStateProvider.getNodeValues(node, params) : Collections.emptyMap();
        for (int i = 0; i < params.size(); ++i) {
            String s = params.get(i);
            this.cells[i] = new Cell(i, s, Clause.validate(s, vals.get(s), false));
            if ("node".equals(s)) {
                this.cells[i].val = node;
            }
            if (this.cells[i].val != null) continue;
            this.anyValueMissing = true;
        }
    }

    public Row(String node, Cell[] cells, boolean anyValueMissing, Map<String, Map<String, List<ReplicaInfo>>> collectionVsShardVsReplicas, boolean isLive) {
        this.node = node;
        this.isLive = isLive;
        this.cells = new Cell[cells.length];
        for (int i = 0; i < this.cells.length; ++i) {
            this.cells[i] = cells[i].copy();
        }
        this.anyValueMissing = anyValueMissing;
        this.collectionVsShardVsReplicas = collectionVsShardVsReplicas;
    }

    @Override
    public void writeMap(MapWriter.EntryWriter ew) throws IOException {
        ew.put(this.node, iw -> {
            iw.add(e -> e.put("replicas", this.collectionVsShardVsReplicas));
            for (Cell cell : this.cells) {
                iw.add(cell);
            }
        });
    }

    Row copy() {
        return new Row(this.node, this.cells, this.anyValueMissing, Utils.getDeepCopy(this.collectionVsShardVsReplicas, 3), this.isLive);
    }

    Object getVal(String name) {
        for (Cell cell : this.cells) {
            if (!cell.name.equals(name)) continue;
            return cell.val;
        }
        return null;
    }

    Object getVal(String name, Object def) {
        for (Cell cell : this.cells) {
            if (!cell.name.equals(name)) continue;
            return cell.val == null ? def : cell.val;
        }
        return def;
    }

    public String toString() {
        return this.node;
    }

    public Row addReplica(String coll, String shard, Replica.Type type) {
        Row row = this.copy();
        Map c = row.collectionVsShardVsReplicas.computeIfAbsent(coll, k -> new HashMap());
        List replicas = c.computeIfAbsent(shard, k -> new ArrayList());
        String replicaname = "" + new Random().nextInt(1000) + 1000;
        replicas.add(new ReplicaInfo(replicaname, replicaname, coll, shard, type, this.node, Collections.singletonMap("type", type != null ? type.toString() : Replica.Type.NRT.toString())));
        for (Cell cell : row.cells) {
            if (!cell.name.equals("cores")) continue;
            cell.val = cell.val == null ? 0L : ((Number)cell.val).longValue() + 1L;
        }
        return row;
    }

    public Pair<Row, ReplicaInfo> removeReplica(String coll, String shard, Replica.Type type) {
        Row row = this.copy();
        Map<String, List<ReplicaInfo>> c = row.collectionVsShardVsReplicas.get(coll);
        if (c == null) {
            return null;
        }
        List<ReplicaInfo> r = c.get(shard);
        if (r == null) {
            return null;
        }
        int idx = -1;
        for (int i = 0; i < r.size(); ++i) {
            ReplicaInfo info = r.get(i);
            if (type != null && info.getType() != type) continue;
            idx = i;
            break;
        }
        if (idx == -1) {
            return null;
        }
        for (Cell cell : row.cells) {
            if (!cell.name.equals("cores")) continue;
            cell.val = cell.val == null ? 0L : ((Number)cell.val).longValue() - 1L;
        }
        return new Pair<Row, ReplicaInfo>(row, r.remove(idx));
    }

    public Cell[] getCells() {
        return this.cells;
    }

    public void forEachReplica(Consumer<ReplicaInfo> consumer) {
        Row.forEachReplica(this.collectionVsShardVsReplicas, consumer);
    }

    public static void forEachReplica(Map<String, Map<String, List<ReplicaInfo>>> collectionVsShardVsReplicas, Consumer<ReplicaInfo> consumer) {
        collectionVsShardVsReplicas.forEach((coll, shardVsReplicas) -> shardVsReplicas.forEach((shard, replicaInfos) -> {
            for (ReplicaInfo r : replicaInfos) {
                consumer.accept(r);
            }
        }));
    }
}

