/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.TimeUnit;
import org.apache.solr.util.TimeSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionThrottle {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private volatile Long lastActionStartedAt;
    private volatile Long minMsBetweenActions;
    private final String name;
    private final TimeSource timeSource;

    public ActionThrottle(String name, long minMsBetweenActions) {
        this.name = name;
        this.minMsBetweenActions = minMsBetweenActions;
        this.timeSource = TimeSource.NANO_TIME;
    }

    public ActionThrottle(String name, long minMsBetweenActions, TimeSource timeSource) {
        this.name = name;
        this.minMsBetweenActions = minMsBetweenActions;
        this.timeSource = timeSource;
    }

    public ActionThrottle(String name, long minMsBetweenActions, long lastActionStartedAt) {
        this.name = name;
        this.minMsBetweenActions = minMsBetweenActions;
        this.lastActionStartedAt = lastActionStartedAt;
        this.timeSource = TimeSource.NANO_TIME;
    }

    public void reset() {
        this.lastActionStartedAt = null;
    }

    public void markAttemptingAction() {
        this.lastActionStartedAt = this.timeSource.getTime();
    }

    public void minimumWaitBetweenActions() {
        if (this.lastActionStartedAt == null) {
            return;
        }
        long diff = this.timeSource.getTime() - this.lastActionStartedAt;
        int diffMs = (int)TimeUnit.MILLISECONDS.convert(diff, TimeUnit.NANOSECONDS);
        long minNsBetweenActions = TimeUnit.NANOSECONDS.convert(this.minMsBetweenActions, TimeUnit.MILLISECONDS);
        log.info("The last {} attempt started {}ms ago.", (Object)this.name, (Object)diffMs);
        int sleep = 0;
        if (diffMs > 0 && diff < minNsBetweenActions) {
            sleep = (int)TimeUnit.MILLISECONDS.convert(minNsBetweenActions - diff, TimeUnit.NANOSECONDS);
        } else if (diffMs == 0) {
            sleep = this.minMsBetweenActions.intValue();
        }
        if (sleep > 0) {
            log.info("Throttling {} attempts - waiting for {}ms", (Object)this.name, (Object)sleep);
            try {
                Thread.sleep(sleep);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public Long getLastActionStartedAt() {
        return this.lastActionStartedAt;
    }
}

