/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import org.apache.solr.client.solrj.request.CollectionApiMapping;
import org.apache.solr.handler.admin.BaseHandlerApiSupport;
import org.apache.solr.handler.admin.ConfigSetsHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;

public class ConfigSetsHandlerApi
extends BaseHandlerApiSupport {
    public static final String DEFAULT_CONFIGSET_NAME = "_default";
    final ConfigSetsHandler configSetHandler;
    static Collection<BaseHandlerApiSupport.ApiCommand> apiCommands = ConfigSetsHandlerApi.createMapping();

    private static Collection<BaseHandlerApiSupport.ApiCommand> createMapping() {
        EnumMap<CollectionApiMapping.ConfigSetMeta, 1> result = new EnumMap<CollectionApiMapping.ConfigSetMeta, 1>(CollectionApiMapping.ConfigSetMeta.class);
        for (final CollectionApiMapping.ConfigSetMeta meta : CollectionApiMapping.ConfigSetMeta.values()) {
            for (final ConfigSetsHandler.ConfigSetOperation op : ConfigSetsHandler.ConfigSetOperation.values()) {
                if (op.action != meta.action) continue;
                result.put(meta, new BaseHandlerApiSupport.ApiCommand(){

                    @Override
                    public CollectionApiMapping.CommandMeta meta() {
                        return meta;
                    }

                    @Override
                    public void invoke(SolrQueryRequest req, SolrQueryResponse rsp, BaseHandlerApiSupport apiHandler) throws Exception {
                        ((ConfigSetsHandlerApi)apiHandler).configSetHandler.invokeAction(req, rsp, op.action);
                    }
                });
            }
        }
        for (final CollectionApiMapping.ConfigSetMeta meta : CollectionApiMapping.ConfigSetMeta.values()) {
            if (result.get(meta) != null) continue;
            throw new RuntimeException("No implementation for " + meta.name());
        }
        return result.values();
    }

    public ConfigSetsHandlerApi(ConfigSetsHandler configSetHandler) {
        this.configSetHandler = configSetHandler;
    }

    @Override
    protected Collection<BaseHandlerApiSupport.ApiCommand> getCommands() {
        return apiCommands;
    }

    protected List<CollectionApiMapping.V2EndPoint> getEndPoints() {
        return Arrays.asList(CollectionApiMapping.ConfigSetEndPoint.values());
    }
}

