/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.request.json;

import java.util.List;
import java.util.Map;
import org.apache.solr.common.SolrException;

class JsonQueryConverter {
    private int numParams = 0;

    JsonQueryConverter() {
    }

    String toLocalParams(Object jsonQueryObject, Map<String, String[]> additionalParams) {
        if (jsonQueryObject instanceof String) {
            return jsonQueryObject.toString();
        }
        StringBuilder builder = new StringBuilder();
        this.buildLocalParams(builder, jsonQueryObject, true, additionalParams);
        return builder.toString();
    }

    private String putParam(String val, Map<String, String[]> additionalParams) {
        String name = "_tt" + this.numParams++;
        additionalParams.put(name, new String[]{val});
        return name;
    }

    private void buildLocalParams(StringBuilder builder, Object val, boolean isQParser, Map<String, String[]> additionalParams) {
        if (!isQParser && !(val instanceof Map)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error when parsing json query, expect a json object here, but found : " + val);
        }
        if (val instanceof String) {
            builder.append('$').append(this.putParam(val.toString(), additionalParams));
            return;
        }
        if (val instanceof Number) {
            builder.append(val);
            return;
        }
        if (!(val instanceof Map)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error when parsing json query, expect a json object here, but found : " + val);
        }
        Map map = (Map)val;
        if (isQParser) {
            if (map.size() != 1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error when parsing json query, expect only one query parser here, but found : " + map.keySet());
            }
            String qtype = (String)map.keySet().iterator().next();
            Object subVal = map.get(qtype);
            boolean useSubBuilder = builder.length() > 0;
            StringBuilder subBuilder = builder;
            if (useSubBuilder) {
                subBuilder = new StringBuilder();
            }
            subBuilder = subBuilder.append("{!").append(qtype).append(' ');
            this.buildLocalParams(subBuilder, subVal, false, additionalParams);
            subBuilder.append("}");
            if (useSubBuilder) {
                builder.append('$').append(this.putParam(subBuilder.toString(), additionalParams));
            }
        } else {
            for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                if (entry.getValue() instanceof List) {
                    if (key.equals("query")) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error when parsing json query, value of query field should not be a list, found : " + entry.getValue());
                    }
                    List l = (List)entry.getValue();
                    for (Object subVal : l) {
                        builder.append(key).append("=");
                        this.buildLocalParams(builder, subVal, true, additionalParams);
                        builder.append(" ");
                    }
                    continue;
                }
                if (key.equals("query")) {
                    key = "v";
                }
                builder.append(key).append("=");
                this.buildLocalParams(builder, entry.getValue(), true, additionalParams);
                builder.append(" ");
            }
        }
    }
}

