/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response.transform;

import java.util.Set;
import org.apache.lucene.index.IndexableField;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.response.transform.DocTransformer;
import org.apache.solr.schema.FieldType;

public abstract class BaseEditorialTransformer
extends DocTransformer {
    final String name;
    final String idFieldName;
    final FieldType ft;

    public BaseEditorialTransformer(String name, String idFieldName, FieldType ft) {
        this.name = name;
        this.idFieldName = idFieldName;
        this.ft = ft;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void transform(SolrDocument doc, int docid) {
        Set<String> ids = this.getIdSet();
        if (ids != null && !ids.isEmpty()) {
            String key = this.getKey(doc);
            doc.setField(this.name, (Object)ids.contains(key));
        } else {
            doc.setField(this.name, (Object)Boolean.FALSE);
        }
    }

    protected abstract Set<String> getIdSet();

    protected String getKey(SolrDocument doc) {
        Object obj = doc.get((Object)this.idFieldName);
        if (obj instanceof IndexableField) {
            IndexableField f = (IndexableField)obj;
            Number n = f.numericValue();
            if (n != null) {
                return this.ft.readableToIndexed(n.toString());
            }
            return this.ft.readableToIndexed(f.stringValue());
        }
        throw new AssertionError((Object)("Expected an IndexableField but got: " + obj.getClass()));
    }
}

