/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.ltr.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Explanation;
import org.apache.solr.ltr.feature.Feature;
import org.apache.solr.ltr.model.LTRScoringModel;
import org.apache.solr.ltr.model.ModelException;
import org.apache.solr.ltr.norm.Normalizer;

public class LinearModel
extends LTRScoringModel {
    protected Float[] featureToWeight;

    public void setWeights(Object weights) {
        Map modelWeights = (Map)weights;
        for (int ii = 0; ii < this.features.size(); ++ii) {
            String key = ((Feature)((Object)this.features.get(ii))).getName();
            Double val = (Double)modelWeights.get(key);
            this.featureToWeight[ii] = val == null ? null : new Float(val.floatValue());
        }
    }

    public LinearModel(String name, List<Feature> features, List<Normalizer> norms, String featureStoreName, List<Feature> allFeatures, Map<String, Object> params) {
        super(name, features, norms, featureStoreName, allFeatures, params);
        this.featureToWeight = new Float[features.size()];
    }

    @Override
    protected void validate() throws ModelException {
        super.validate();
        ArrayList<String> missingWeightFeatureNames = new ArrayList<String>();
        for (int i = 0; i < this.features.size(); ++i) {
            if (this.featureToWeight[i] != null) continue;
            missingWeightFeatureNames.add(((Feature)((Object)this.features.get(i))).getName());
        }
        if (missingWeightFeatureNames.size() == this.features.size()) {
            throw new ModelException("Model " + this.name + " doesn't contain any weights");
        }
        if (!missingWeightFeatureNames.isEmpty()) {
            throw new ModelException("Model " + this.name + " lacks weight(s) for " + missingWeightFeatureNames);
        }
    }

    @Override
    public float score(float[] modelFeatureValuesNormalized) {
        float score = 0.0f;
        for (int i = 0; i < modelFeatureValuesNormalized.length; ++i) {
            score += modelFeatureValuesNormalized[i] * this.featureToWeight[i].floatValue();
        }
        return score;
    }

    @Override
    public Explanation explain(LeafReaderContext context, int doc, float finalScore, List<Explanation> featureExplanations) {
        ArrayList<Explanation> details = new ArrayList<Explanation>();
        int index = 0;
        for (Explanation featureExplain : featureExplanations) {
            ArrayList<Explanation> featureDetails = new ArrayList<Explanation>();
            featureDetails.add(Explanation.match((float)this.featureToWeight[index].floatValue(), (String)"weight on feature", (Explanation[])new Explanation[0]));
            featureDetails.add(featureExplain);
            details.add(Explanation.match((float)(featureExplain.getValue() * this.featureToWeight[index].floatValue()), (String)"prod of:", featureDetails));
            ++index;
        }
        return Explanation.match((float)finalScore, (String)(this.toString() + " model applied to features, sum of:"), details);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("(name=").append(this.getName());
        sb.append(",featureWeights=[");
        for (int ii = 0; ii < this.features.size(); ++ii) {
            if (ii > 0) {
                sb.append(',');
            }
            String key = ((Feature)((Object)this.features.get(ii))).getName();
            sb.append(key).append('=').append(this.featureToWeight[ii]);
        }
        sb.append("])");
        return sb.toString();
    }
}

