/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.ltr.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Explanation;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.ltr.feature.Feature;
import org.apache.solr.ltr.model.LTRScoringModel;
import org.apache.solr.ltr.model.ModelException;
import org.apache.solr.ltr.norm.Normalizer;

public abstract class WrapperModel
extends LTRScoringModel {
    protected SolrResourceLoader solrResourceLoader;
    protected LTRScoringModel model;

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.model == null ? 0 : this.model.hashCode());
        result = 31 * result + (this.solrResourceLoader == null ? 0 : this.solrResourceLoader.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WrapperModel other = (WrapperModel)obj;
        if (this.model == null ? other.model != null : !this.model.equals(other.model)) {
            return false;
        }
        return !(this.solrResourceLoader == null ? other.solrResourceLoader != null : !this.solrResourceLoader.equals(other.solrResourceLoader));
    }

    public WrapperModel(String name, List<Feature> features, List<Normalizer> norms, String featureStoreName, List<Feature> allFeatures, Map<String, Object> params) {
        super(name, features, norms, featureStoreName, allFeatures, params);
    }

    @Override
    protected void validate() throws ModelException {
        if (!this.features.isEmpty()) {
            throw new ModelException("features must be empty for the wrapper model " + this.name);
        }
        if (!this.norms.isEmpty()) {
            throw new ModelException("norms must be empty for the wrapper model " + this.name);
        }
        if (this.model != null) {
            super.validate();
            this.model.validate();
            String wrappedFeatureStoreName = this.model.getFeatureStoreName();
            if (wrappedFeatureStoreName == null || !wrappedFeatureStoreName.equals(this.getFeatureStoreName())) {
                throw new ModelException("wrapper feature store name (" + this.getFeatureStoreName() + ") must match the wrapped feature store name (" + wrappedFeatureStoreName + ")");
            }
        }
    }

    public void setSolrResourceLoader(SolrResourceLoader solrResourceLoader) {
        this.solrResourceLoader = solrResourceLoader;
    }

    public void updateModel(LTRScoringModel model) {
        this.model = model;
        this.validate();
    }

    public abstract Map<String, Object> fetchModelMap() throws ModelException;

    @Override
    public List<Normalizer> getNorms() {
        return this.model.getNorms();
    }

    @Override
    public List<Feature> getFeatures() {
        return this.model.getFeatures();
    }

    @Override
    public Collection<Feature> getAllFeatures() {
        return this.model.getAllFeatures();
    }

    @Override
    public float score(float[] modelFeatureValuesNormalized) {
        return this.model.score(modelFeatureValuesNormalized);
    }

    @Override
    public Explanation explain(LeafReaderContext context, int doc, float finalScore, List<Explanation> featureExplanations) {
        return this.model.explain(context, doc, finalScore, featureExplanations);
    }

    @Override
    public void normalizeFeaturesInPlace(float[] modelFeatureValues) {
        this.model.normalizeFeaturesInPlace(modelFeatureValues);
    }

    @Override
    public Explanation getNormalizerExplanation(Explanation e, int idx) {
        return this.model.getNormalizerExplanation(e, idx);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("(name=").append(this.getName());
        sb.append(",model=(").append(this.model.toString()).append(")");
        return sb.toString();
    }
}

