/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util.configuration;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import org.apache.solr.common.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLConfigurations {
    private final Map<String, String> envVars;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public SSLConfigurations(Map<String, String> envVars) {
        this.envVars = envVars;
    }

    public void init() {
        String clientKeystorePassword = this.envVars.get("SOLR_SSL_CLIENT_KEY_STORE_PASSWORD");
        String keystorePassword = this.envVars.get("SOLR_SSL_KEY_STORE_PASSWORD");
        String clientTruststorePassword = this.envVars.get("SOLR_SSL_CLIENT_TRUST_STORE_PASSWORD");
        String truststorePassword = this.envVars.get("SOLR_SSL_TRUST_STORE_PASSWORD");
        if (!(!this.isEmpty(System.getProperty("javax.net.ssl.keyStorePassword")) || this.isEmpty(clientKeystorePassword) && this.isEmpty(keystorePassword))) {
            log.debug("Setting {} based on env var", (Object)"javax.net.ssl.keyStorePassword");
            System.setProperty("javax.net.ssl.keyStorePassword", clientKeystorePassword != null ? clientKeystorePassword : keystorePassword);
        }
        if (!(!this.isEmpty(System.getProperty("javax.net.ssl.trustStorePassword")) || this.isEmpty(clientTruststorePassword) && this.isEmpty(truststorePassword))) {
            log.debug("Setting {} based on env var", (Object)"javax.net.ssl.trustStorePassword");
            System.setProperty("javax.net.ssl.trustStorePassword", clientTruststorePassword != null ? clientTruststorePassword : truststorePassword);
        }
    }

    private boolean isEmpty(String str) {
        return StringUtils.isEmpty((String)str);
    }

    public static class EnvVars {
        public static final String SOLR_SSL_CLIENT_KEY_STORE_PASSWORD = "SOLR_SSL_CLIENT_KEY_STORE_PASSWORD";
        public static final String SOLR_SSL_KEY_STORE_PASSWORD = "SOLR_SSL_KEY_STORE_PASSWORD";
        public static final String SOLR_SSL_CLIENT_TRUST_STORE_PASSWORD = "SOLR_SSL_CLIENT_TRUST_STORE_PASSWORD";
        public static final String SOLR_SSL_TRUST_STORE_PASSWORD = "SOLR_SSL_TRUST_STORE_PASSWORD";
    }

    public static class SysProps {
        public static final String SSL_KEY_STORE_PASSWORD = "javax.net.ssl.keyStorePassword";
        public static final String SSL_TRUST_STORE_PASSWORD = "javax.net.ssl.trustStorePassword";
    }
}

