/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.cubeoutput;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.zip.GZIPOutputStream;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.cubeoutput.CubeOutputData;
import org.pentaho.di.trans.steps.cubeoutput.CubeOutputMeta;
import org.pentaho.di.trans.steps.cubeoutput.Messages;

public class CubeOutput
extends BaseStep
implements StepInterface {
    private CubeOutputMeta meta;
    private CubeOutputData data;

    public CubeOutput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (CubeOutputMeta)smi;
        this.data = (CubeOutputData)sdi;
        boolean result = true;
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first && this.meta.isDoNotOpenNewFileInit()) {
            try {
                this.PrepareFile();
                this.data.oneFileOpened = true;
            }
            catch (IOException ioe) {
                this.logError(Messages.getString("CubeOutput.Log.ErrorOpeningCubeOutputFile") + ioe.toString());
                this.setErrors(1L);
                return false;
            }
        }
        if (!(result = this.writeRowToFile(r))) {
            this.setErrors(1L);
            this.stopAll();
            return false;
        }
        this.putRow(this.data.outputMeta, r);
        if (this.checkFeedback(this.getLinesOutput()) && this.log.isBasic()) {
            this.logBasic(Messages.getString("CubeOutput.Log.LineNumber") + this.getLinesOutput());
        }
        return result;
    }

    private synchronized boolean writeRowToFile(Object[] r) {
        try {
            if (this.first) {
                this.data.outputMeta = this.getInputRowMeta().clone();
                this.data.outputMeta.writeMeta(this.data.dos);
                this.first = false;
            }
            this.data.outputMeta.writeData(this.data.dos, r);
        }
        catch (Exception e) {
            this.logError(Messages.getString("CubeOutput.Log.ErrorWritingLine") + e.toString());
            return false;
        }
        this.incrementLinesOutput();
        return true;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (CubeOutputMeta)smi;
        this.data = (CubeOutputData)sdi;
        if (super.init(smi, sdi)) {
            if (!this.meta.isDoNotOpenNewFileInit()) {
                try {
                    this.PrepareFile();
                    this.data.oneFileOpened = true;
                    return true;
                }
                catch (IOException ioe) {
                    this.logError(Messages.getString("CubeOutput.Log.ErrorOpeningCubeOutputFile") + ioe.toString());
                }
            } else {
                return true;
            }
        }
        return false;
    }

    private void PrepareFile() throws IOException {
        String filename = this.environmentSubstitute(this.meta.getFilename());
        if (this.meta.isAddToResultFiles()) {
            ResultFile resultFile = new ResultFile(0, KettleVFS.getFileObject((String)filename), this.getTransMeta().getName(), this.getStepname());
            resultFile.setComment("This file was created with a cube file output step");
            this.addResultFile(resultFile);
        }
        this.data.fos = KettleVFS.getOutputStream((String)filename, (boolean)false);
        this.data.zip = new GZIPOutputStream(this.data.fos);
        this.data.dos = new DataOutputStream(this.data.zip);
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        if (this.data.oneFileOpened) {
            try {
                if (this.data.dos != null) {
                    this.data.dos.close();
                    this.data.dos = null;
                }
                if (this.data.zip != null) {
                    this.data.zip.close();
                    this.data.zip = null;
                }
                if (this.data.fos != null) {
                    this.data.fos.close();
                    this.data.fos = null;
                }
            }
            catch (IOException e) {
                this.logError(Messages.getString("CubeOutput.Log.ErrorClosingFile") + this.meta.getFilename());
                this.setErrors(1L);
                this.stopAll();
            }
        }
        super.dispose(smi, sdi);
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }
}

