# This file was automatically generated by bifcl from event.bif.

##! The protocol-independent events that the C/C++ core of Bro can generate.
##!
##! This is mostly events not related to a specific transport- or
##! application-layer protocol, but also includes a few that may be generated
##! by more than one protocols analyzer (like events generated by both UDP and
##! TCP analysis.)


























## Generated at Bro initialization time. The event engine generates this
## event just before normal input processing begins. It can be used to execute
## one-time initialization code at startup. At the time a handler runs, Bro will
## have executed any global initializations and statements.
##
## .. bro:see:: bro_done
##
## .. note::
##
##    When a ``bro_init`` handler executes, Bro has not yet seen any input
##    packets and therefore :bro:id:`network_time` is not initialized yet. An
##    artifact of that is that any timer installed in a ``bro_init`` handler
##    will fire immediately with the first packet. The standard way to work
##    around that is to ignore the first time the timer fires and immediately
##    reschedule.
##
export {
global bro_init: event();


## Generated at Bro termination time. The event engine generates this event when
## Bro is about to terminate, either due to having exhausted reading its input
## trace file(s), receiving a termination signal, or because Bro was run without
## a network input source and has finished executing any global statements.
##
## .. bro:see:: bro_init
##
## .. note::
##
##    If Bro terminates due to an invocation of :bro:id:`exit`, then this event
##    is not generated.
global bro_done: event();


## Generated for every new connection. This event is raised with the first
## packet of a previously unknown connection. Bro uses a flow-based definition
## of "connection" here that includes not only TCP sessions but also UDP and
## ICMP flows.
##
## c: The connection.
##
## .. bro:see:: connection_EOF connection_SYN_packet connection_attempt
##    connection_established connection_external connection_finished
##    connection_first_ACK connection_half_finished connection_partial_close
##    connection_pending connection_rejected connection_reset connection_reused
##    connection_state_remove connection_status_update connection_timeout
##    scheduled_analyzer_applied new_connection_contents partial_connection
##
## .. note::
##
##    Handling this event is potentially expensive. For example, during a SYN
##    flooding attack, every spoofed SYN packet will lead to a new
##    event.
global new_connection: event(c: connection );


## Generated for a connection whose tunneling has changed.  This could
## be from a previously seen connection now being encapsulated in a tunnel,
## or from the outer encapsulation changing.  Note that connection *c*'s
## *tunnel* field is NOT automatically/internally assigned to the new
## encapsulation value of *e* after this event is raised.  If the desired
## behavior is to track the latest tunnel encapsulation per-connection,
## then a handler of this event should assign *e* to ``c$tunnel`` (which Bro's
## default scripts are doing).
##
## c: The connection whose tunnel/encapsulation changed.
##
## e: The new encapsulation.
global tunnel_changed: event(c: connection , e: EncapsulatingConnVector );


## Generated when a TCP connection timed out. This event is raised when
## no activity was seen for an interval of at least
## :bro:id:`tcp_connection_linger`, and either one endpoint has already
## closed the connection or one side never became active.
##
## c: The connection.
##
## .. bro:see:: connection_EOF connection_SYN_packet connection_attempt
##    connection_established connection_external connection_finished
##    connection_first_ACK connection_half_finished connection_partial_close
##    connection_pending connection_rejected connection_reset connection_reused
##    connection_state_remove connection_status_update
##    scheduled_analyzer_applied new_connection new_connection_contents
##    partial_connection
##
## .. note::
##
##    The precise semantics of this event can be unintuitive as it only
##    covers a subset of cases where a connection times out. Often, handling
##    :bro:id:`connection_state_remove` is the better option. That one will be
##    generated reliably when an interval of ``tcp_inactivity_timeout`` has
##    passed without any activity seen (but also for all other ways a
##    connection may terminate).
global connection_timeout: event(c: connection );


## Generated when a connection's internal state is about to be removed from
## memory. Bro generates this event reliably once for every connection when it
## is about to delete the internal state. As such, the event is well-suited for
## script-level cleanup that needs to be performed for every connection.  This
## event is generated not only for TCP sessions but also for UDP and ICMP
## flows.
##
## c: The connection.
##
## .. bro:see:: connection_EOF connection_SYN_packet connection_attempt
##    connection_established connection_external connection_finished
##    connection_first_ACK connection_half_finished connection_partial_close
##    connection_pending connection_rejected connection_reset connection_reused
##    connection_status_update connection_timeout scheduled_analyzer_applied
##    new_connection new_connection_contents partial_connection udp_inactivity_timeout
##    tcp_inactivity_timeout icmp_inactivity_timeout conn_stats
global connection_state_remove: event(c: connection );


## Generated when a connection 4-tuple is reused. This event is raised when Bro
## sees a new TCP session or UDP flow using a 4-tuple matching that of an
## earlier connection it still considers active.
##
## c: The connection.
##
## .. bro:see:: connection_EOF connection_SYN_packet connection_attempt
##    connection_established connection_external connection_finished
##    connection_first_ACK connection_half_finished connection_partial_close
##    connection_pending connection_rejected connection_reset connection_state_remove
##    connection_status_update connection_timeout scheduled_analyzer_applied
##    new_connection new_connection_contents partial_connection
global connection_reused: event(c: connection );


## Generated in regular intervals during the lifetime of a connection. The
## event is raised each ``connection_status_update_interval`` seconds
## and can be used to check conditions on a regular basis.
##
## c: The connection.
##
## .. bro:see:: connection_EOF connection_SYN_packet connection_attempt
##    connection_established connection_external connection_finished
##    connection_first_ACK connection_half_finished connection_partial_close
##    connection_pending connection_rejected connection_reset connection_reused
##    connection_state_remove  connection_timeout scheduled_analyzer_applied
##    new_connection new_connection_contents partial_connection
global connection_status_update: event(c: connection );


## Generated for a connection over IPv6 when one direction has changed
## the flow label that it's using.
##
## c: The connection.
##
## is_orig: True if the event is raised for the originator side.
##
## old_label: The old flow label that the endpoint was using.
##
## new_label: The new flow label that the endpoint is using.
##
## .. bro:see:: connection_established new_connection
global connection_flow_label_changed: event(c: connection , is_orig: bool , old_label: count , new_label: count );


## Generated for a new connection received from the communication subsystem.
## Remote peers can inject packets into Bro's packet loop, for example via
## :doc:`Broccoli </components/broccoli/README>`.  The communication system
## raises this event with the first packet of a connection coming in this way.
##
## c: The connection.
##
## tag: TODO.
global connection_external: event(c: connection , tag: string );


## Generated when a UDP session for a supported protocol has finished. Some of
## Bro's application-layer UDP analyzers flag the end of a session by raising
## this event. Currently, the analyzers for DNS, NTP, Netbios, Syslog, AYIYA,
## Teredo, and GTPv1 support this.
##
## u: The connection record for the corresponding UDP flow.
##
## .. bro:see:: udp_contents udp_reply udp_request
global udp_session_done: event(u: connection );


## Generated when a connection is seen that is marked as being expected.
## The function :bro:id:`Analyzer::schedule_analyzer` tells Bro to expect a
## particular connection to come up, and which analyzer to associate with it.
## Once the first packet of such a connection is indeed seen, this event is
## raised.
##
## c: The connection.
##
## a: The analyzer that was scheduled for the connection with the
##    :bro:id:`Analyzer::schedule_analyzer` call. When the event is raised, that
##    analyzer will already have been activated to process the connection. The
##    ``count`` is one of the ``ANALYZER_*`` constants, e.g., ``ANALYZER_HTTP``.
##
## .. bro:see:: connection_EOF connection_SYN_packet connection_attempt
##    connection_established connection_external connection_finished
##    connection_first_ACK connection_half_finished connection_partial_close
##    connection_pending connection_rejected connection_reset connection_reused
##    connection_state_remove connection_status_update connection_timeout
##    new_connection new_connection_contents partial_connection
##
## .. todo:: We don't have a good way to document the automatically generated
##    ``ANALYZER_*`` constants right now.
global scheduled_analyzer_applied: event(c: connection , a: Analyzer::Tag );


## Generated for every packet Bro sees that have a valid link-layer header. This
## is a very very low-level and expensive event that should be avoided when at all
## possible. It's usually infeasible to handle when processing even medium volumes
## of traffic in real-time. That said, if you work from a trace and want to do some
## packet-level analysis, it may come in handy.
##
## p: Information from the header of the packet that triggered the event.
##
## .. bro:see:: new_packet packet_contents
global raw_packet: event(p: raw_pkt_hdr );


## Generated for all packets that make it into Bro's connection processing. In
## contrast to :bro:id:`raw_packet` this filters out some more packets that don't
## pass certain sanity checks.
##
## This is a very low-level and expensive event that should be avoided when at all
## possible. It's usually infeasible to handle when processing even medium volumes
## of traffic in real-time. That said, if you work from a trace and want to do some
## packet-level analysis, it may come in handy.
##
## c: The connection the packet is part of.
##
## p: Information from the header of the packet that triggered the event.
##
## .. bro:see:: tcp_packet packet_contents raw_packet
global new_packet: event(c: connection , p: pkt_hdr );


## Generated for every IPv6 packet that contains extension headers.
## This is potentially an expensive event to handle if analysing IPv6 traffic
## that happens to utilize extension headers frequently.
##
## c: The connection the packet is part of.
##
## p: Information from the header of the packet that triggered the event.
##
## .. bro:see:: new_packet tcp_packet packet_contents esp_packet
global ipv6_ext_headers: event(c: connection , p: pkt_hdr );


## Generated for any packets using the IPv6 Encapsulating Security Payload (ESP)
## extension header.
##
## p: Information from the header of the packet that triggered the event.
##
## .. bro:see:: new_packet tcp_packet ipv6_ext_headers
global esp_packet: event(p: pkt_hdr );


## Generated for any packet using a Mobile IPv6 Mobility Header.
##
## p: Information from the header of the packet that triggered the event.
##
## .. bro:see:: new_packet tcp_packet ipv6_ext_headers
global mobile_ipv6_message: event(p: pkt_hdr );


## Generated for every packet that has a non-empty transport-layer payload.
## This is a very low-level and expensive event that should be avoided when
## at all possible.  It's usually infeasible to handle when processing even
## medium volumes of traffic in real-time. It's even worse than
## :bro:id:`new_packet`. That said, if you work from a trace and want to
## do some packet-level analysis, it may come in handy.
##
## c: The connection the packet is part of.
##
## contents: The raw transport-layer payload.
##
## .. bro:see:: new_packet tcp_packet
global packet_contents: event(c: connection , contents: string );


## Generated when Bro detects a TCP retransmission inconsistency. When
## reassembling a TCP stream, Bro buffers all payload until it sees the
## responder acking it. If during that time, the sender resends a chunk of
## payload but with different content than originally, this event will be
## raised. In addition, if :bro:id:`tcp_max_old_segments` is larger than zero,
## mismatches with that older still-buffered data will likewise trigger the event.
##
## c: The connection showing the inconsistency.
##
## t1: The original payload.
##
## t2: The new payload.
##
## tcp_flags: A string with the TCP flags of the packet triggering the
##            inconsistency. In the string, each character corresponds to one
##            set flag, as follows: ``S`` -> SYN; ``F`` -> FIN; ``R`` -> RST;
##            ``A`` -> ACK; ``P`` -> PUSH. This string will not always be set,
##            only if the information is available; it's "best effort".
##
## .. bro:see:: tcp_rexmit tcp_contents
global rexmit_inconsistency: event(c: connection , t1: string , t2: string , tcp_flags: string );


## Generated when Bro detects a gap in a reassembled TCP payload stream. This
## event is raised when Bro, while reassembling a payload stream, determines
## that a chunk of payload is missing (e.g., because the responder has already
## acknowledged it, even though Bro didn't see it).
##
## c: The connection.
##
## is_orig: True if the gap is on the originator's side.
##
## seq: The sequence number where the gap starts.
##
## length: The number of bytes missing.
##
## .. note::
##
##    Content gaps tend to occur occasionally for various reasons, including
##    broken TCP stacks. If, however, one finds lots of them, that typically
##    means that there is a problem with the monitoring infrastructure such as
##    a tap dropping packets, split routing on the path, or reordering at the
##    tap.
global content_gap: event(c: connection , is_orig: bool , seq: count , length: count );


## Generated when a protocol analyzer confirms that a connection is indeed
## using that protocol. Bro's dynamic protocol detection heuristically activates
## analyzers as soon as it believes a connection *could* be using a particular
## protocol. It is then left to the corresponding analyzer to verify whether
## that is indeed the case; if so, this event will be generated.
##
## c: The connection.
##
## atype: The type of the analyzer confirming that its protocol is in
##        use. The value is one of the ``Analyzer::ANALYZER_*`` constants. For example,
##        ``Analyzer::ANALYZER_HTTP`` means the HTTP analyzer determined that it's indeed
##        parsing an HTTP connection.
##
## aid:   A unique integer ID identifying the specific *instance* of the
##        analyzer *atype*  that is analyzing the connection ``c``. The ID can
##        be used to reference the analyzer when using builtin functions like
##        :bro:id:`disable_analyzer`.
##
## .. bro:see:: protocol_violation
##
## .. note::
##
##    Bro's default scripts use this event to determine the ``service`` column
##    of :bro:type:`Conn::Info`: once confirmed, the protocol will be listed
##    there (and thus in ``conn.log``).
global protocol_confirmation: event(c: connection , atype: Analyzer::Tag , aid: count );


## Generated when a protocol analyzer determines that a connection it is parsing
## is not conforming to the protocol it expects. Bro's dynamic protocol
## detection heuristically activates analyzers as soon as it believes a
## connection *could* be using a particular protocol. It is then left to the
## corresponding analyzer to verify whether that is indeed the case; if not,
## the analyzer will trigger this event.
##
## c: The connection.
##
## atype: The type of the analyzer confirming that its protocol is in
##        use. The value is one of the ``Analyzer::ANALYZER_*`` constants. For example,
##        ``Analyzer::ANALYZER_HTTP`` means the HTTP analyzer determined that it's indeed
##        parsing an HTTP connection.
##
## aid:   A unique integer ID identifying the specific *instance* of the
##        analyzer *atype*  that is analyzing the connection ``c``. The ID can
##        be used to reference the analyzer when using builtin functions like
##        :bro:id:`disable_analyzer`.
##
## reason: TODO.
##
## .. bro:see:: protocol_confirmation
##
## .. note::
##
##    Bro's default scripts use this event to disable an analyzer via
##    :bro:id:`disable_analyzer` if it's parsing the wrong protocol. That's
##    however a script-level decision and not done automatically by the event
##    engine.
global protocol_violation: event(c: connection , atype: Analyzer::Tag , aid: count , reason: string );


## Generated when a TCP connection terminated, passing on statistics about the
## two endpoints. This event is always generated when Bro flushes the internal
## connection state, independent of how a connection terminates.
##
## c: The connection.
##
## os: Statistics for the originator endpoint.
##
## rs: Statistics for the responder endpoint.
##
## .. bro:see:: connection_state_remove
global conn_stats: event(c: connection , os: endpoint_stats , rs: endpoint_stats );


## Generated for unexpected activity related to a specific connection.  When
## Bro's packet analysis encounters activity that does not conform to a
## protocol's specification, it raises one of the ``*_weird`` events to report
## that. This event is raised if the activity is tied directly to a specific
## connection.
##
## name: A unique name for the specific type of "weird" situation. Bro's default
##       scripts use this name in filtering policies that specify which
##       "weirds" are worth reporting.
##
## c: The corresponding connection.
##
## addl: Optional additional context further describing the situation.
##
## .. bro:see:: flow_weird net_weird
##
## .. note:: "Weird" activity is much more common in real-world network traffic
##    than one would intuitively expect. While in principle, any protocol
##    violation could be an attack attempt, it's much more likely that an
##    endpoint's implementation interprets an RFC quite liberally.
global conn_weird: event(name: string , c: connection , addl: string );


## Generated for unexpected activity related to a pair of hosts, but independent
## of a specific connection.  When Bro's packet analysis encounters activity
## that does not conform to a protocol's specification, it raises one of
## the ``*_weird`` events to report that. This event is raised if the activity
## is related to a pair of hosts, yet not to a specific connection between
## them.
##
## name: A unique name for the specific type of "weird" situation. Bro's default
##       scripts use this name in filtering policies that specify which
##       "weirds" are worth reporting.
##
## src: The source address corresponding to the activity.
##
## dst: The destination address corresponding to the activity.
##
## .. bro:see:: conn_weird net_weird
##
## .. note:: "Weird" activity is much more common in real-world network traffic
##    than one would intuitively expect. While in principle, any protocol
##    violation could be an attack attempt, it's much more likely that an
##    endpoint's implementation interprets an RFC quite liberally.
global flow_weird: event(name: string , src: addr , dst: addr );


## Generated for unexpected activity that is not tied to a specific connection
## or pair of hosts. When Bro's packet analysis encounters activity that
## does not conform to a protocol's specification, it raises one of the
## ``*_weird`` events to report that. This event is raised if the activity is
## not tied directly to a specific connection or pair of hosts.
##
## name: A unique name for the specific type of "weird" situation. Bro's default
##       scripts use this name in filtering policies that specify which
##       "weirds" are worth reporting.
##
## .. bro:see:: flow_weird
##
## .. note:: "Weird" activity is much more common in real-world network traffic
##    than one would intuitively expect. While in principle, any protocol
##    violation could be an attack attempt, it's much more likely that an
##    endpoint's implementation interprets an RFC quite liberally.
global net_weird: event(name: string );


## Generated regularly for the purpose of profiling Bro's processing. This event
## is raised for every :bro:id:`load_sample_freq` packet. For these packets,
## Bro records script-level functions executed during their processing as well
## as further internal locations. By sampling the processing in this form, one
## can understand where Bro spends its time.
##
## samples: A set with functions and locations seen during the processing of
##          the sampled packet.
##
## CPU: The CPU time spent on processing the sampled packet.
##
## dmem: The difference in memory usage caused by processing the sampled packet.
global load_sample: event(samples: load_sample_info , CPU: interval , dmem: int );


## Generated when a signature matches. Bro's signature engine provides
## high-performance pattern matching separately from the normal script
## processing. If a signature with an ``event`` action matches, this event is
## raised.
##
## See the :doc:`user manual </frameworks/signatures>` for more information
## about Bro's signature engine.
##
## state: Context about the match, including which signatures triggered the
##        event and the connection for which the match was found.
##
## msg: The message passed to the ``event`` signature action.
##
## data: The last chunk of input that triggered the match. Note that the
##       specifics here are not well-defined as Bro does not buffer any input.
##       If a match is split across packet boundaries, only the last chunk
##       triggering the match will be passed on to the event.
global signature_match: event(state: signature_state , msg: string , data: string );


## Generated when a protocol analyzer finds an identification of a software
## used on a system. This is a protocol-independent event that is fed by
## different analyzers. For example, the HTTP analyzer reports user-agent and
## server software by raising this event, assuming it can parse it (if not,
## :bro:id:`software_parse_error` will be generated instead).
##
## c: The connection.
##
## host: The host running the reported software.
##
## s: A description of the software found.
##
## descr: The raw (unparsed) software identification string as extracted from
##        the protocol.
##
## .. bro:see:: software_parse_error software_unparsed_version_found OS_version_found
global software_version_found: event(c: connection , host: addr , s: software , descr: string );


## Generated when a protocol analyzer finds an identification of a software
## used on a system but cannot parse it. This is a protocol-independent event
## that is fed by different analyzers. For example, the HTTP analyzer reports
## user-agent and server software by raising this event if it cannot parse them
## directly (if it can :bro:id:`software_version_found` will be generated
## instead).
##
## c: The connection.
##
## host: The host running the reported software.
##
## descr: The raw (unparsed) software identification string as extracted from
##        the protocol.
##
## .. bro:see:: software_version_found software_unparsed_version_found
##    OS_version_found
global software_parse_error: event(c: connection , host: addr , descr: string );


## Generated when a protocol analyzer finds an identification of a software
## used on a system. This is a protocol-independent event that is fed by
## different analyzers. For example, the HTTP analyzer reports user-agent and
## server software by raising this event. Different from
## :bro:id:`software_version_found`  and :bro:id:`software_parse_error`, this
## event is always raised, independent of whether Bro can parse the version
## string.
##
## c: The connection.
##
## host: The host running the reported software.
##
## str: The software identification string as extracted from the protocol.
##
## .. bro:see:: software_parse_error software_version_found OS_version_found
global software_unparsed_version_found: event(c: connection , host: addr , str: string );


## Generated when an operating system has been fingerprinted. Bro uses `p0f
## <http://lcamtuf.coredump.cx/p0f.shtml>`__ to fingerprint endpoints passively,
## and it raises this event for each system identified. The p0f fingerprints are
## defined by :bro:id:`passive_fingerprint_file`.
##
## c: The connection.
##
## host: The host running the reported OS.
##
## OS: The OS version string.
##
## .. bro:see:: passive_fingerprint_file software_parse_error
##    software_version_found software_unparsed_version_found
##    generate_OS_version_event
global OS_version_found: event(c: connection , host: addr , OS: OS_version );


## Generated when a connection to a remote Bro has been established. This event
## is intended primarily for use by Bro's communication framework, but it can
## also trigger additional code if helpful.
##
## p: A record describing the peer.
##
## .. bro:see:: remote_capture_filter remote_connection_closed remote_connection_error
##    remote_connection_handshake_done remote_event_registered remote_log remote_pong
##    remote_state_access_performed remote_state_inconsistency print_hook
global remote_connection_established: event(p: event_peer );


## Generated when a connection to a remote Bro has been closed. This event is
## intended primarily for use by Bro's communication framework, but it can
## also trigger additional code if helpful.
##
## p: A record describing the peer.
##
## .. bro:see:: remote_capture_filter  remote_connection_error
##    remote_connection_established remote_connection_handshake_done
##    remote_event_registered remote_log remote_pong remote_state_access_performed
##    remote_state_inconsistency print_hook
global remote_connection_closed: event(p: event_peer );


## Generated when a remote connection's initial handshake has been completed.
## This event is intended primarily for use by Bro's communication framework,
## but it can also trigger additional code if helpful.
##
## p: A record describing the peer.
##
## .. bro:see:: remote_capture_filter remote_connection_closed remote_connection_error
##    remote_connection_established remote_event_registered remote_log remote_pong
##    remote_state_access_performed remote_state_inconsistency print_hook
global remote_connection_handshake_done: event(p: event_peer );


## Generated for each event registered by a remote peer. This event is intended
## primarily for use by Bro's communication framework, but it can also trigger
## additional code if helpful.
##
## p: A record describing the peer.
##
## name: TODO.
##
## .. bro:see:: remote_capture_filter remote_connection_closed
##    remote_connection_error remote_connection_established
##    remote_connection_handshake_done remote_log remote_pong
##    remote_state_access_performed remote_state_inconsistency print_hook
global remote_event_registered: event(p: event_peer , name: string );


## Generated when a connection to a remote Bro encountered an error. This event
## is intended primarily for use by Bro's communication framework, but it can
## also trigger additional code if helpful.
##
## p: A record describing the peer.
##
## reason: A textual description of the error.
##
## .. bro:see:: remote_capture_filter remote_connection_closed
##    remote_connection_established remote_connection_handshake_done
##    remote_event_registered remote_log remote_pong remote_state_access_performed
##    remote_state_inconsistency print_hook
global remote_connection_error: event(p: event_peer , reason: string );


## Generated when a remote peer sent us a capture filter. While this event is
## intended primarily for use by Bro's communication framework, it can also
## trigger additional code if helpful.
##
## p: A record describing the peer.
##
## filter: The filter string sent by the peer.
##
## .. bro:see::  remote_connection_closed remote_connection_error
##    remote_connection_established remote_connection_handshake_done
##    remote_event_registered remote_log remote_pong remote_state_access_performed
##    remote_state_inconsistency print_hook
global remote_capture_filter: event(p: event_peer , filter: string );


## Generated after a call to :bro:id:`send_state` when all data has been
## successfully sent to the remote side. While this event is
## intended primarily for use by Bro's communication framework, it can also
## trigger additional code if helpful.
##
## p: A record describing the remote peer.
##
## .. bro:see:: remote_capture_filter remote_connection_closed
##    remote_connection_error remote_connection_established
##    remote_connection_handshake_done remote_event_registered remote_log remote_pong
##    remote_state_access_performed remote_state_inconsistency print_hook
global finished_send_state: event(p: event_peer );


## Generated if state synchronization detects an inconsistency.  While this
## event is intended primarily for use by Bro's communication framework, it can
## also trigger additional code if helpful. This event is only raised if
## :bro:id:`remote_check_sync_consistency` is false.
##
## operation: The textual description of the state operation performed.
##
## id: The name of the Bro script identifier that was operated on.
##
## expected_old: A textual representation of the value of *id* that was
##               expected to be found before the operation was carried out.
##
## real_old: A textual representation of the value of *id* that was actually
##           found before the operation was carried out. The difference between
##           *real_old* and *expected_old* is the inconsistency being reported.
##
## .. bro:see:: remote_capture_filter remote_connection_closed
##    remote_connection_error remote_connection_established
##    remote_connection_handshake_done remote_event_registered remote_log remote_pong
##    remote_state_access_performed print_hook remote_check_sync_consistency
global remote_state_inconsistency: event(operation: string , id: string , expected_old: string , real_old: string );


## Generated for communication log messages. While this event is
## intended primarily for use by Bro's communication framework, it can also
## trigger additional code if helpful.
##
## level: The log level, which is either :bro:id:`REMOTE_LOG_INFO` or
##        :bro:id:`REMOTE_LOG_ERROR`.
##
## src: The component of the communication system that logged the message.
##      Currently, this will be one of :bro:id:`REMOTE_SRC_CHILD` (Bro's
##      child process), :bro:id:`REMOTE_SRC_PARENT` (Bro's main process), or
##      :bro:id:`REMOTE_SRC_SCRIPT` (the script level).
##
## msg: The message logged.
##
## .. bro:see:: remote_capture_filter remote_connection_closed remote_connection_error
##    remote_connection_established remote_connection_handshake_done
##    remote_event_registered  remote_pong remote_state_access_performed
##    remote_state_inconsistency print_hook remote_log_peer
global remote_log: event(level: count , src: count , msg: string );


## Generated for communication log messages. While this event is
## intended primarily for use by Bro's communication framework, it can also
## trigger additional code if helpful.  This event is equivalent to
## :bro:see:`remote_log` except the message is with respect to a certain peer.
##
## p: A record describing the remote peer.
##
## level: The log level, which is either :bro:id:`REMOTE_LOG_INFO` or
##        :bro:id:`REMOTE_LOG_ERROR`.
##
## src: The component of the communication system that logged the message.
##      Currently, this will be one of :bro:id:`REMOTE_SRC_CHILD` (Bro's
##      child process), :bro:id:`REMOTE_SRC_PARENT` (Bro's main process), or
##      :bro:id:`REMOTE_SRC_SCRIPT` (the script level).
##
## msg: The message logged.
##
## .. bro:see:: remote_capture_filter remote_connection_closed remote_connection_error
##    remote_connection_established remote_connection_handshake_done
##    remote_event_registered  remote_pong remote_state_access_performed
##    remote_state_inconsistency print_hook remote_log
global remote_log_peer: event(p: event_peer , level: count , src: count , msg: string );


## Generated when a remote peer has answered to our ping. This event is part of
## Bro's infrastructure for measuring communication latency. One can send a ping
## by calling :bro:id:`send_ping` and when a corresponding reply is received,
## this event will be raised.
##
## p: The peer sending us the pong.
##
## seq: The sequence number passed to the original :bro:id:`send_ping` call.
##      The number is sent back by the peer in its response.
##
## d1: The time interval between sending the ping and receiving the pong. This
##     is the latency of the complete path.
##
## d2: The time interval between sending out the ping to the network and its
##     reception at the peer. This is the network latency.
##
## d3: The time interval between when the peer's child process received the
##     ping and when its parent process sent the pong. This is the
##     processing latency at the peer.
##
## .. bro:see:: remote_capture_filter remote_connection_closed remote_connection_error
##    remote_connection_established remote_connection_handshake_done
##    remote_event_registered remote_log  remote_state_access_performed
##    remote_state_inconsistency print_hook
global remote_pong: event(p: event_peer , seq: count , d1: interval , d2: interval , d3: interval );


## Generated each time a remote state access has been replayed locally. This
## event is primarily intended for debugging.
##
## id: The name of the Bro script variable that's being operated on.
##
## v: The new value of the variable.
##
## .. bro:see:: remote_capture_filter remote_connection_closed remote_connection_error
##    remote_connection_established remote_connection_handshake_done
##    remote_event_registered remote_log remote_pong remote_state_inconsistency
##    print_hook
global remote_state_access_performed: event(id: string , v: any );


## Generated each time Bro's internal profiling log is updated. The file is
## defined by :bro:id:`profiling_file`, and its update frequency by
## :bro:id:`profiling_interval` and :bro:id:`expensive_profiling_multiple`.
##
## f: The profiling file.
##
## expensive: True if this event corresponds to heavier-weight profiling as
##            indicated by the :bro:id:`expensive_profiling_multiple` variable.
##
## .. bro:see::  profiling_interval expensive_profiling_multiple
global profiling_update: event(f: file , expensive: bool );


## Raised for informational messages reported via Bro's reporter framework. Such
## messages may be generated internally by the event engine and also by other
## scripts calling :bro:id:`Reporter::info`.
##
## t: The time the message was passed to the reporter.
##
## msg: The message itself.
##
## location: A (potentially empty) string describing a location associated with
##           the message.
##
## .. bro:see:: reporter_warning reporter_error Reporter::info Reporter::warning
##    Reporter::error
##
## .. note:: Bro will not call reporter events recursively. If the handler of
##    any reporter event triggers a new reporter message itself, the output
##    will go to ``stderr`` instead.
global reporter_info: event(t: time , msg: string , location: string ) &error_handler;


## Raised for warnings reported via Bro's reporter framework. Such messages may
## be generated internally by the event engine and also by other scripts calling
## :bro:id:`Reporter::warning`.
##
## t: The time the warning was passed to the reporter.
##
## msg: The warning message.
##
## location: A (potentially empty) string describing a location associated with
##     the warning.
##
## .. bro:see:: reporter_info reporter_error Reporter::info Reporter::warning
##    Reporter::error
##
## .. note:: Bro will not call reporter events recursively. If the handler of
##    any reporter event triggers a new reporter message itself, the output
##    will go to ``stderr`` instead.
global reporter_warning: event(t: time , msg: string , location: string ) &error_handler;


## Raised for errors reported via Bro's reporter framework. Such messages may
## be generated internally by the event engine and also by other scripts calling
## :bro:id:`Reporter::error`.
##
## t: The time the error was passed to the reporter.
##
## msg: The error message.
##
## location: A (potentially empty) string describing a location associated with
##     the error.
##
## .. bro:see:: reporter_info reporter_warning Reporter::info Reporter::warning
##    Reporter::error
##
## .. note:: Bro will not call reporter events recursively. If the handler of
##    any reporter event triggers a new reporter message itself, the output
##    will go to ``stderr`` instead.
global reporter_error: event(t: time , msg: string , location: string ) &error_handler;


## Raised for each policy script loaded by the script interpreter.
##
## path: The full path to the script loaded.
##
## level: The "nesting level": zero for a top-level Bro script and incremented
##        recursively for each ``@load``.
global bro_script_loaded: event(path: string , level: count );


## Generated each time Bro's script interpreter opens a file. This event is
## triggered only for files opened via :bro:id:`open`, and in particular not for
## normal log files as created by log writers.
##
## f: The opened file.
global file_opened: event(f: file );


## Marks a point in the event stream at which the event queue started flushing.
global event_queue_flush_point: event();


## This event is handled to provide feedback to the file analysis framework
## about how to identify the logical "file" to which some data/input
## belongs.  All incoming data to the framework is buffered, and depends
## on a handler for this event to return a string value that uniquely
## identifies a file.  Among all handlers of this event, the last one to
## call :bro:see:`set_file_handle` will "win".
##
## tag: The analyzer which is carrying the file data.
##
## c: The connection which is carrying the file data.
##
## is_orig: The direction the file data is flowing over the connection.
##
## .. bro:see:: set_file_handle
global get_file_handle: event(tag: Analyzer::Tag , c: connection , is_orig: bool );


## Indicates that an analysis of a new file has begun. The analysis can be
## augmented at this time via :bro:see:`Files::add_analyzer`.
##
## f: The file.
##
## .. bro:see:: file_over_new_connection file_timeout file_gap
##    file_sniff file_state_remove
global file_new: event(f: fa_file );


## Indicates that a file has been seen being transferred over a connection
## different from the original.
##
## f: The file.
##
## c: The new connection over which the file is seen being transferred.
##
## is_orig: true if the originator of *c* is the one sending the file.
##
## .. bro:see:: file_new file_timeout file_gap file_sniff
##    file_state_remove
global file_over_new_connection: event(f: fa_file , c: connection , is_orig: bool );


## Provide all metadata that has been inferred about a particular file
## from inspection of the initial content that been seen at the beginning
## of the file.  The analysis can be augmented at this time via
## :bro:see:`Files::add_analyzer`.  The amount of data fed into the file
## sniffing can be increased or decreased by changing either
## :bro:see:`default_file_bof_buffer_size` or the `bof_buffer_size` field
## in an `fa_file` record. The event will be raised even if content inspection
## has been unable to infer any metadata, in which case the fields in *meta*
## will be left all unset.
##
## f: The file.
##
## meta: Metadata that's been discovered about the file.
##
## .. bro:see:: file_over_new_connection file_timeout file_gap
##    file_state_remove
global file_sniff: event(f: fa_file , meta: fa_metadata );


## Indicates that file analysis has timed out because no activity was seen
## for the file in a while.
##
## f: The file.
##
## .. bro:see:: file_new file_over_new_connection file_gap
##    file_sniff file_state_remove default_file_timeout_interval
##    Files::set_timeout_interval
global file_timeout: event(f: fa_file );


## Indicates that a chunk of the file is missing.
##
## f: The file.
##
## offset: The byte offset from the start of the file at which the gap begins.
##
## len: The number of missing bytes.
##
## .. bro:see:: file_new file_over_new_connection file_timeout
##    file_sniff file_state_remove file_reassembly_overflow
global file_gap: event(f: fa_file , offset: count , len: count );


## Indicates that the file had an overflow of the reassembly buffer.
## This is a specialization of the :bro:id:`file_gap` event.
##
## f: The file.
##
## offset: The byte offset from the start of the file at which the reassembly
##         couldn't continue due to running out of reassembly buffer space.
##
## skipped: The number of bytes of the file skipped over to flush some
##          file data and get back under the reassembly buffer size limit.
##          This value will also be represented as a gap.
##
## .. bro:see:: file_new file_over_new_connection file_timeout
##    file_sniff file_state_remove file_gap
##    Files::enable_reassembler Files::reassembly_buffer_size
##    Files::enable_reassembly Files::disable_reassembly
##    Files::set_reassembly_buffer_size
global file_reassembly_overflow: event(f: fa_file , offset: count , skipped: count );


## This event is generated each time file analysis is ending for a given file.
##
## f: The file.
##
## .. bro:see:: file_new file_over_new_connection file_timeout file_gap
##    file_sniff
global file_state_remove: event(f: fa_file );


## Generated when an internal DNS lookup produces the same result as last time.
## Bro keeps an internal DNS cache for host names and IP addresses it has
## already resolved. This event is generated when a subsequent lookup returns
## the same result as stored in the cache.
##
## dm: A record describing the new resolver result (which matches the old one).
##
## .. bro:see:: dns_mapping_altered dns_mapping_lost_name dns_mapping_new_name
##    dns_mapping_unverified
global dns_mapping_valid: event(dm: dns_mapping );


## Generated when an internal DNS lookup got no answer even though it had
## succeeded in the past. Bro keeps an internal DNS cache for host names and IP
## addresses it has already resolved. This event is generated when a
## subsequent lookup does not produce an answer even though we have
## already stored a result in the cache.
##
## dm: A record describing the old resolver result.
##
## .. bro:see:: dns_mapping_altered dns_mapping_lost_name dns_mapping_new_name
##    dns_mapping_valid
global dns_mapping_unverified: event(dm: dns_mapping );


## Generated when an internal DNS lookup succeeded but an earlier attempt
## did not. Bro keeps an internal DNS cache for host names and IP
## addresses it has already resolved. This event is generated when a subsequent
## lookup produces an answer for a query that was marked as failed in the cache.
##
## dm: A record describing the new resolver result.
##
## .. bro:see:: dns_mapping_altered dns_mapping_lost_name dns_mapping_unverified
##    dns_mapping_valid
global dns_mapping_new_name: event(dm: dns_mapping );


## Generated when an internal DNS lookup returned zero answers even though it
## had succeeded in the past. Bro keeps an internal DNS cache for host names
## and IP addresses it has already resolved. This event is generated when
## on a subsequent lookup we receive an answer that is empty even
## though we have already stored a result in the cache.
##
## dm: A record describing the old resolver result.
##
## .. bro:see:: dns_mapping_altered dns_mapping_new_name dns_mapping_unverified
##    dns_mapping_valid
global dns_mapping_lost_name: event(dm: dns_mapping );


## Generated when an internal DNS lookup produced a different result than in
## the past.  Bro keeps an internal DNS cache for host names and IP addresses
## it has already resolved. This event is generated when a subsequent lookup
## returns a different answer than we have stored in the cache.
##
## dm: A record describing the new resolver result.
##
## old_addrs: Addresses that used to be part of the returned set for the query
##            described by *dm*, but are not anymore.
##
## new_addrs: Addresses that were not part of the returned set for the query
##            described by *dm*, but now are.
##
## .. bro:see:: dns_mapping_lost_name dns_mapping_new_name dns_mapping_unverified
##    dns_mapping_valid
global dns_mapping_altered: event(dm: dns_mapping , old_addrs: addr_set , new_addrs: addr_set );


## A meta event generated for events that Bro raises. This will report all
## events for which at least one handler is defined.
##
## Note that handling this meta event is expensive and should be limited to
## debugging purposes.
##
## name: The name of the event.
##
## params: The event's parameters.
global new_event: event(name: string , params: call_argument_vector );


## Deprecated. Will be removed.
global root_backdoor_signature_found: event(c: connection );


## Deprecated. Will be removed.
global napster_signature_found: event(c: connection );


## Deprecated. Will be removed.
global kazaa_signature_found: event(c: connection );


## Deprecated. Will be removed.
global gaobot_signature_found: event(c: connection );


## Deprecated. Will be removed.
global anonymization_mapping: event(orig: addr , mapped: addr );


## Deprecated. Will be removed.
global rotate_interval: event(f: file );


## Deprecated. Will be removed.
global rotate_size: event(f: file );


## Deprecated. Will be removed.
global print_hook: event(f: file , s: string );

} # end of export section
module GLOBAL;
