/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.qt;

import gnu.java.awt.peer.qt.QtComponentPeer;
import gnu.java.awt.peer.qt.QtToolkit;
import java.awt.Dimension;
import java.awt.List;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.peer.ListPeer;

public class QtListPeer
extends QtComponentPeer
implements ListPeer {
    private boolean ignoreNextSelect = false;

    public QtListPeer(QtToolkit kit, List owner) {
        super(kit, owner);
    }

    public native void init();

    protected void setup() {
        super.setup();
        List o = (List)this.owner;
        this.setMultipleMode(o.isMultipleMode());
        String[] items = o.getItems();
        int i = 0;
        while (i < items.length) {
            this.add(items[i], i);
            ++i;
        }
        int[] selected = o.getSelectedIndexes();
        int i2 = 0;
        while (i2 < selected.length) {
            this.select(selected[i2]);
            ++i2;
        }
        if (selected.length == 0 && items.length > 0) {
            this.select(0);
        }
    }

    private void fireChoice(int index) {
        this.ignoreNextSelect = true;
        if (index == -1) {
            ((List)this.owner).deselect(((List)this.owner).getSelectedIndex());
        } else {
            ((List)this.owner).select(index);
            ItemEvent e = new ItemEvent((List)this.owner, 701, "" + index, 1);
            QtToolkit.eventQueue.postEvent(e);
        }
    }

    private void itemDoubleClicked(int index, int modifiers) {
        ActionEvent e = new ActionEvent(this.owner, 1001, ((List)this.owner).getItem(index), System.currentTimeMillis(), modifiers);
        QtToolkit.eventQueue.postEvent(e);
    }

    private native void select(int var1, boolean var2);

    public native void add(String var1, int var2);

    public void addItem(String item, int index) {
        this.add(item, index);
    }

    public void clear() {
        this.removeAll();
    }

    public native void delItems(int var1, int var2);

    public void deselect(int index) {
        if (this.ignoreNextSelect) {
            this.ignoreNextSelect = false;
        } else {
            this.select(index, false);
        }
    }

    public native int[] getSelectedIndexes();

    public native void makeVisible(int var1);

    public Dimension minimumSize(int s) {
        return this.getMinimumSize(s);
    }

    public Dimension preferredSize(int s) {
        return this.getPreferredSize(s);
    }

    public void removeAll() {
        this.delItems(0, ((List)this.owner).getItemCount() - 1);
    }

    public void select(int index) {
        if (this.ignoreNextSelect) {
            this.ignoreNextSelect = false;
        } else {
            this.select(index, true);
        }
    }

    public native void setMultipleMode(boolean var1);

    public void setMultipleSelections(boolean multi) {
        this.setMultipleMode(multi);
    }

    public Dimension getPreferredSize(int s) {
        return this.getPreferredSize();
    }

    public Dimension getMinimumSize(int s) {
        return this.getMinimumSize();
    }
}

