/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.sasl;

import gnu.javax.crypto.sasl.AuthInfoProviderFactory;
import gnu.javax.crypto.sasl.IAuthInfoProvider;
import gnu.javax.crypto.sasl.IAuthInfoProviderFactory;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class AuthInfo {
    private static final ArrayList factories = new ArrayList();

    static {
        AuthInfoProviderFactory ours = new AuthInfoProviderFactory();
        String pkgs = System.getProperty("gnu.crypto.sasl.auth.info.provider.pkgs", null);
        if (pkgs != null) {
            StringTokenizer st = new StringTokenizer(pkgs, "|");
            while (st.hasMoreTokens()) {
                String clazz = st.nextToken().trim();
                if ("gnu.javax.crypto.sasl".equals(clazz)) continue;
                clazz = String.valueOf(clazz) + ".AuthInfoProviderFactory";
                try {
                    IAuthInfoProviderFactory factory = (IAuthInfoProviderFactory)Class.forName(clazz).newInstance();
                    factories.add(factory);
                }
                catch (ClassCastException classCastException) {
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
        }
        if (!factories.contains(ours)) {
            factories.add(ours);
        }
    }

    private AuthInfo() {
    }

    public static IAuthInfoProvider getProvider(String mechanism) {
        for (IAuthInfoProviderFactory factory : factories) {
            IAuthInfoProvider result = factory.getInstance(mechanism);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

