/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.Builder;
import gnu.javax.net.ssl.provider.Constructed;
import gnu.javax.net.ssl.provider.KeyExchangeAlgorithm;
import gnu.javax.net.ssl.provider.ServerDHParams;
import gnu.javax.net.ssl.provider.ServerKeyExchangeParams;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;

public class ServerDHE_PSKParameters
implements Constructed,
Builder,
ServerKeyExchangeParams {
    private ByteBuffer buffer;

    public ServerDHE_PSKParameters(ByteBuffer buffer) {
        this.buffer = buffer.duplicate().order(ByteOrder.BIG_ENDIAN);
    }

    public ServerDHE_PSKParameters(String identityHint, ServerDHParams dhParams) {
        this(identityHint, dhParams.buffer());
    }

    public ServerDHE_PSKParameters(String identityHint, ByteBuffer dhParams) {
        Charset utf8 = Charset.forName("UTF-8");
        ByteBuffer hintBuf = utf8.encode(identityHint);
        this.buffer = ByteBuffer.allocate(2 + hintBuf.remaining() + dhParams.remaining());
        this.buffer.putShort((short)hintBuf.remaining());
        this.buffer.put(hintBuf);
        this.buffer.put(dhParams);
    }

    public KeyExchangeAlgorithm algorithm() {
        return KeyExchangeAlgorithm.DHE_PSK;
    }

    public int length() {
        return (this.buffer.getShort(0) & 0xFFFF) + 2 + this.params().length();
    }

    private int hintLength() {
        return (this.buffer.getShort(0) & 0xFFFF) + 2;
    }

    public String identityHint() {
        Charset utf8 = Charset.forName("UTF-8");
        return utf8.decode((ByteBuffer)this.buffer.duplicate().position(2).limit(this.hintLength())).toString();
    }

    public ServerDHParams params() {
        return new ServerDHParams(((ByteBuffer)this.buffer.duplicate().position(this.hintLength()).limit(this.buffer.capacity())).slice());
    }

    public ByteBuffer buffer() {
        return (ByteBuffer)this.buffer.duplicate().rewind().limit(this.length());
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String prefix) {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        if (prefix != null) {
            out.print(prefix);
        }
        out.println("struct {");
        if (prefix != null) {
            out.print(prefix);
        }
        out.print("  identity_hint = ");
        out.print(this.identityHint());
        out.println(";");
        if (prefix != null) {
            out.print(prefix);
        }
        out.println("  params =");
        out.println(this.params().toString(prefix != null ? String.valueOf(prefix) + "    " : "    "));
        if (prefix != null) {
            out.print(prefix);
        }
        out.print("} ServerDHE_PSKParameters;");
        return str.toString();
    }
}

