/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScheduledThreadPoolExecutor
extends ThreadPoolExecutor
implements ScheduledExecutorService {
    private volatile boolean continueExistingPeriodicTasksAfterShutdown;
    private volatile boolean executeExistingDelayedTasksAfterShutdown = true;
    private static final AtomicLong sequencer = new AtomicLong(0L);
    private static final long NANO_ORIGIN = System.nanoTime();

    final long now() {
        return System.nanoTime() - NANO_ORIGIN;
    }

    private void delayedExecute(Runnable command) {
        if (this.isShutdown()) {
            this.reject(command);
            return;
        }
        if (this.getPoolSize() < this.getCorePoolSize()) {
            this.prestartCoreThread();
        }
        super.getQueue().add(command);
    }

    private void cancelUnwantedTasks() {
        boolean keepDelayed = this.getExecuteExistingDelayedTasksAfterShutdownPolicy();
        boolean keepPeriodic = this.getContinueExistingPeriodicTasksAfterShutdownPolicy();
        if (!keepDelayed && !keepPeriodic) {
            super.getQueue().clear();
        } else if (keepDelayed || keepPeriodic) {
            Object[] entries = super.getQueue().toArray();
            int i = 0;
            while (i < entries.length) {
                RunnableScheduledFuture t;
                Object e = entries[i];
                if (e instanceof RunnableScheduledFuture && ((t = (RunnableScheduledFuture)e).isPeriodic() ? !keepPeriodic : !keepDelayed)) {
                    t.cancel(false);
                }
                ++i;
            }
            entries = null;
            this.purge();
        }
    }

    @Override
    public boolean remove(Runnable task) {
        if (!(task instanceof RunnableScheduledFuture)) {
            return false;
        }
        return this.getQueue().remove(task);
    }

    protected <V> RunnableScheduledFuture<V> decorateTask(Runnable runnable, RunnableScheduledFuture<V> task) {
        return task;
    }

    protected <V> RunnableScheduledFuture<V> decorateTask(Callable<V> callable, RunnableScheduledFuture<V> task) {
        return task;
    }

    public ScheduledThreadPoolExecutor(int corePoolSize) {
        super(corePoolSize, Integer.MAX_VALUE, 0L, TimeUnit.NANOSECONDS, new DelayedWorkQueue());
    }

    public ScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory) {
        super(corePoolSize, Integer.MAX_VALUE, 0L, TimeUnit.NANOSECONDS, (BlockingQueue<Runnable>)new DelayedWorkQueue(), threadFactory);
    }

    public ScheduledThreadPoolExecutor(int corePoolSize, RejectedExecutionHandler handler) {
        super(corePoolSize, Integer.MAX_VALUE, 0L, TimeUnit.NANOSECONDS, (BlockingQueue<Runnable>)new DelayedWorkQueue(), handler);
    }

    public ScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, Integer.MAX_VALUE, 0L, TimeUnit.NANOSECONDS, new DelayedWorkQueue(), threadFactory, handler);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        if (command == null || unit == null) {
            throw new NullPointerException();
        }
        long triggerTime = this.now() + unit.toNanos(delay);
        RunnableScheduledFuture<Object> t = this.decorateTask(command, new ScheduledFutureTask<Object>(command, null, triggerTime));
        this.delayedExecute(t);
        return t;
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        if (callable == null || unit == null) {
            throw new NullPointerException();
        }
        if (delay < 0L) {
            delay = 0L;
        }
        long triggerTime = this.now() + unit.toNanos(delay);
        RunnableScheduledFuture<V> t = this.decorateTask(callable, new ScheduledFutureTask<V>(callable, triggerTime));
        this.delayedExecute(t);
        return t;
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        if (command == null || unit == null) {
            throw new NullPointerException();
        }
        if (period <= 0L) {
            throw new IllegalArgumentException();
        }
        if (initialDelay < 0L) {
            initialDelay = 0L;
        }
        long triggerTime = this.now() + unit.toNanos(initialDelay);
        RunnableScheduledFuture<Object> t = this.decorateTask(command, new ScheduledFutureTask<Object>(command, null, triggerTime, unit.toNanos(period)));
        this.delayedExecute(t);
        return t;
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        if (command == null || unit == null) {
            throw new NullPointerException();
        }
        if (delay <= 0L) {
            throw new IllegalArgumentException();
        }
        if (initialDelay < 0L) {
            initialDelay = 0L;
        }
        long triggerTime = this.now() + unit.toNanos(initialDelay);
        RunnableScheduledFuture<Object> t = this.decorateTask(command, new ScheduledFutureTask<Object>(command, null, triggerTime, unit.toNanos(-delay)));
        this.delayedExecute(t);
        return t;
    }

    @Override
    public void execute(Runnable command) {
        if (command == null) {
            throw new NullPointerException();
        }
        this.schedule(command, 0L, TimeUnit.NANOSECONDS);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.schedule(task, 0L, TimeUnit.NANOSECONDS);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.schedule(Executors.callable(task, result), 0L, TimeUnit.NANOSECONDS);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.schedule(task, 0L, TimeUnit.NANOSECONDS);
    }

    public void setContinueExistingPeriodicTasksAfterShutdownPolicy(boolean value) {
        this.continueExistingPeriodicTasksAfterShutdown = value;
        if (!value && this.isShutdown()) {
            this.cancelUnwantedTasks();
        }
    }

    public boolean getContinueExistingPeriodicTasksAfterShutdownPolicy() {
        return this.continueExistingPeriodicTasksAfterShutdown;
    }

    public void setExecuteExistingDelayedTasksAfterShutdownPolicy(boolean value) {
        this.executeExistingDelayedTasksAfterShutdown = value;
        if (!value && this.isShutdown()) {
            this.cancelUnwantedTasks();
        }
    }

    public boolean getExecuteExistingDelayedTasksAfterShutdownPolicy() {
        return this.executeExistingDelayedTasksAfterShutdown;
    }

    @Override
    public void shutdown() {
        this.cancelUnwantedTasks();
        super.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return super.shutdownNow();
    }

    @Override
    public BlockingQueue<Runnable> getQueue() {
        return super.getQueue();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DelayedWorkQueue
    extends AbstractCollection<Runnable>
    implements BlockingQueue<Runnable> {
        private final DelayQueue<RunnableScheduledFuture> dq = new DelayQueue();

        private DelayedWorkQueue() {
        }

        @Override
        public Runnable poll() {
            return (Runnable)this.dq.poll();
        }

        @Override
        public Runnable peek() {
            return (Runnable)this.dq.peek();
        }

        @Override
        public Runnable take() throws InterruptedException {
            return (Runnable)this.dq.take();
        }

        @Override
        public Runnable poll(long timeout, TimeUnit unit) throws InterruptedException {
            return (Runnable)this.dq.poll(timeout, unit);
        }

        @Override
        public boolean add(Runnable x) {
            return this.dq.add((RunnableScheduledFuture)x);
        }

        @Override
        public boolean offer(Runnable x) {
            return this.dq.offer((RunnableScheduledFuture)x);
        }

        @Override
        public void put(Runnable x) {
            this.dq.put((RunnableScheduledFuture)x);
        }

        @Override
        public boolean offer(Runnable x, long timeout, TimeUnit unit) {
            return this.dq.offer((RunnableScheduledFuture)x, timeout, unit);
        }

        @Override
        public Runnable remove() {
            return (Runnable)this.dq.remove();
        }

        @Override
        public Runnable element() {
            return (Runnable)this.dq.element();
        }

        @Override
        public void clear() {
            this.dq.clear();
        }

        @Override
        public int drainTo(Collection<? super Runnable> c) {
            return this.dq.drainTo(c);
        }

        @Override
        public int drainTo(Collection<? super Runnable> c, int maxElements) {
            return this.dq.drainTo(c, maxElements);
        }

        @Override
        public int remainingCapacity() {
            return this.dq.remainingCapacity();
        }

        @Override
        public boolean remove(Object x) {
            return this.dq.remove(x);
        }

        @Override
        public boolean contains(Object x) {
            return this.dq.contains(x);
        }

        @Override
        public int size() {
            return this.dq.size();
        }

        @Override
        public boolean isEmpty() {
            return this.dq.isEmpty();
        }

        @Override
        public Object[] toArray() {
            return this.dq.toArray();
        }

        @Override
        public <T> T[] toArray(T[] array) {
            return this.dq.toArray(array);
        }

        @Override
        public Iterator<Runnable> iterator() {
            return new Iterator<Runnable>(this){
                private Iterator<RunnableScheduledFuture> it;
                final /* synthetic */ DelayedWorkQueue this$1;
                {
                    this.this$1 = delayedWorkQueue;
                    this.it = DelayedWorkQueue.access$10(delayedWorkQueue).iterator();
                }

                public boolean hasNext() {
                    return this.it.hasNext();
                }

                public Runnable next() {
                    return this.it.next();
                }

                public void remove() {
                    this.it.remove();
                }
            };
        }

        static /* synthetic */ DelayQueue access$10(DelayedWorkQueue delayedWorkQueue) {
            return delayedWorkQueue.dq;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ScheduledFutureTask<V>
    extends FutureTask<V>
    implements RunnableScheduledFuture<V> {
        private final long sequenceNumber;
        private long time;
        private final long period;

        ScheduledFutureTask(Runnable r, V result, long ns) {
            super(r, result);
            this.time = ns;
            this.period = 0L;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        ScheduledFutureTask(Runnable r, V result, long ns, long period) {
            super(r, result);
            this.time = ns;
            this.period = period;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        ScheduledFutureTask(Callable<V> callable, long ns) {
            super(callable);
            this.time = ns;
            this.period = 0L;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        @Override
        public long getDelay(TimeUnit unit) {
            long d = unit.convert(this.time - ScheduledThreadPoolExecutor.this.now(), TimeUnit.NANOSECONDS);
            return d;
        }

        @Override
        public int compareTo(Delayed other) {
            if (other == this) {
                return 0;
            }
            if (other instanceof ScheduledFutureTask) {
                ScheduledFutureTask x = (ScheduledFutureTask)other;
                long diff = this.time - x.time;
                if (diff < 0L) {
                    return -1;
                }
                if (diff > 0L) {
                    return 1;
                }
                if (this.sequenceNumber < x.sequenceNumber) {
                    return -1;
                }
                return 1;
            }
            long d = this.getDelay(TimeUnit.NANOSECONDS) - other.getDelay(TimeUnit.NANOSECONDS);
            return d == 0L ? 0 : (d < 0L ? -1 : 1);
        }

        @Override
        public boolean isPeriodic() {
            return this.period != 0L;
        }

        private void runPeriodic() {
            boolean ok = ScheduledFutureTask.super.runAndReset();
            boolean down = ScheduledThreadPoolExecutor.this.isShutdown();
            if (ok && (!down || ScheduledThreadPoolExecutor.this.getContinueExistingPeriodicTasksAfterShutdownPolicy() && !ScheduledThreadPoolExecutor.this.isTerminating())) {
                long p = this.period;
                this.time = p > 0L ? (this.time += p) : ScheduledThreadPoolExecutor.this.now() - p;
                ScheduledThreadPoolExecutor.super.getQueue().add(this);
            } else if (down) {
                ScheduledThreadPoolExecutor.this.interruptIdleWorkers();
            }
        }

        @Override
        public void run() {
            if (this.isPeriodic()) {
                this.runPeriodic();
            } else {
                ScheduledFutureTask.super.run();
            }
        }
    }
}

