#!/bin/sh
p="${0%/*}/bin/ghc-pkg --no-user-package-db --global-package-db ${0%/*}/package.conf.d"
$p register --force - << 'EOF'
name: rts
version: 1.0
id: rts
key: rts
license: BSD3
maintainer: glasgow-haskell-users@haskell.org
exposed: True
indefinite: False
abi: 
trusted: False
library-dirs: /usr/local/lib/ghc/rts
hs-libraries: HSrts Cffi
extra-libraries:
    m pthread
include-dirs: /usr/local/lib/ghc/include
includes:
    Stg.h
ld-options: "-Wl,-u,base_GHCziInt_I16zh_con_info"
            "-Wl,-u,base_GHCziInt_I32zh_con_info"
            "-Wl,-u,base_GHCziInt_I64zh_con_info"
            "-Wl,-u,base_GHCziInt_I8zh_con_info"
            "-Wl,-u,base_GHCziPtr_FunPtr_con_info"
            "-Wl,-u,base_GHCziPtr_Ptr_con_info"
            "-Wl,-u,base_GHCziStable_StablePtr_con_info"
            "-Wl,-u,base_GHCziWord_W16zh_con_info"
            "-Wl,-u,base_GHCziWord_W32zh_con_info"
            "-Wl,-u,base_GHCziWord_W64zh_con_info"
            "-Wl,-u,base_GHCziWord_W8zh_con_info"
            "-Wl,-u,ghczmprim_GHCziTypes_Czh_con_info"
            "-Wl,-u,ghczmprim_GHCziTypes_Dzh_con_info"
            "-Wl,-u,ghczmprim_GHCziTypes_Fzh_con_info"
            "-Wl,-u,ghczmprim_GHCziTypes_Izh_con_info"
            "-Wl,-u,ghczmprim_GHCziTypes_Wzh_con_info"
            "-Wl,-u,ghczmprim_GHCziTuple_Z0T_closure"
            "-Wl,-u,ghczmprim_GHCziTypes_False_closure"
            "-Wl,-u,ghczmprim_GHCziTypes_True_closure"
            "-Wl,-u,base_GHCziPack_unpackCString_closure"
            "-Wl,-u,base_GHCziIOziException_stackOverflow_closure"
            "-Wl,-u,base_GHCziIOziException_heapOverflow_closure"
            "-Wl,-u,base_ControlziExceptionziBase_nonTermination_closure"
            "-Wl,-u,base_GHCziIOziException_blockedIndefinitelyOnMVar_closure"
            "-Wl,-u,base_GHCziIOziException_blockedIndefinitelyOnSTM_closure"
            "-Wl,-u,base_GHCziIOziException_allocationLimitExceeded_closure"
            "-Wl,-u,base_GHCziIOziException_cannotCompactFunction_closure"
            "-Wl,-u,base_GHCziIOziException_cannotCompactPinned_closure"
            "-Wl,-u,base_GHCziIOziException_cannotCompactMutable_closure"
            "-Wl,-u,base_ControlziExceptionziBase_nestedAtomically_closure"
            "-Wl,-u,base_GHCziEventziThread_blockedOnBadFD_closure"
            "-Wl,-u,base_GHCziWeak_runFinalizzerBatch_closure"
            "-Wl,-u,base_GHCziTopHandler_flushStdHandles_closure"
            "-Wl,-u,base_GHCziTopHandler_runIO_closure"
            "-Wl,-u,base_GHCziTopHandler_runNonIO_closure"
            "-Wl,-u,base_GHCziTopHandler_runMainIO_closure"
            "-Wl,-u,base_GHCziConcziIO_ensureIOManagerIsRunning_closure"
            "-Wl,-u,base_GHCziConcziIO_ioManagerCapabilitiesChanged_closure"
            "-Wl,-u,base_GHCziConcziSync_runSparks_closure"
            "-Wl,-u,base_GHCziConcziSignal_runHandlersPtr_closure"
            "-Wl,-u,hs_atomic_add8" "-Wl,-u,hs_atomic_add16"
            "-Wl,-u,hs_atomic_add32" "-Wl,-u,hs_atomic_sub8"
            "-Wl,-u,hs_atomic_sub16" "-Wl,-u,hs_atomic_sub32"
            "-Wl,-u,hs_atomic_and8" "-Wl,-u,hs_atomic_and16"
            "-Wl,-u,hs_atomic_and32" "-Wl,-u,hs_atomic_nand8"
            "-Wl,-u,hs_atomic_nand16" "-Wl,-u,hs_atomic_nand32"
            "-Wl,-u,hs_atomic_or8" "-Wl,-u,hs_atomic_or16"
            "-Wl,-u,hs_atomic_or32" "-Wl,-u,hs_atomic_xor8"
            "-Wl,-u,hs_atomic_xor16" "-Wl,-u,hs_atomic_xor32"
            "-Wl,-u,hs_cmpxchg8" "-Wl,-u,hs_cmpxchg16" "-Wl,-u,hs_cmpxchg32"
            "-Wl,-u,hs_atomicread8" "-Wl,-u,hs_atomicread16"
            "-Wl,-u,hs_atomicread32" "-Wl,-u,hs_atomicwrite8"
            "-Wl,-u,hs_atomicwrite16" "-Wl,-u,hs_atomicwrite32"
pkgroot: "/usr/obj/ports/ghc-8.2.2/fake-i386/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: ghc-prim
version: 0.5.1.1
id: ghc-prim-0.5.1.1
key: ghc-prim-0.5.1.1
license: BSD3
maintainer: libraries@haskell.org
synopsis: GHC primitives
description:
    This package contains the primitive types and operations supplied by GHC.
category: GHC
exposed: True
indefinite: False
exposed-modules:
    GHC.CString GHC.Classes GHC.Debug GHC.IntWord64 GHC.Magic GHC.Prim
    GHC.PrimopWrappers GHC.Tuple GHC.Types
abi: 84323a6edd008b04bf217464a4ccaf16
trusted: False
import-dirs: /usr/local/lib/ghc/ghc-prim-0.5.1.1
library-dirs: /usr/local/lib/ghc/ghc-prim-0.5.1.1
              /usr/local/lib/ghc/ghc-prim-0.5.1.1
data-dir: /usr/local/share/i386-openbsd-ghc-8.2.2/ghc-prim-0.5.1.1
hs-libraries: HSghc-prim-0.5.1.1
depends:
    rts
abi-depends: rts=
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/ghc-prim-0.5.1.1/ghc-prim.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/ghc-prim-0.5.1.1
pkgroot: "/usr/obj/ports/ghc-8.2.2/fake-i386/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: integer-gmp
version: 1.0.1.0
id: integer-gmp-1.0.1.0
key: integer-gmp-1.0.1.0
license: BSD3
maintainer: hvr@gnu.org
synopsis: Integer library based on GMP
category: Numeric, Algebra
author: Herbert Valerio Riedel
exposed: True
indefinite: False
exposed-modules:
    GHC.Integer GHC.Integer.GMP.Internals GHC.Integer.Logarithms
    GHC.Integer.Logarithms.Internals
hidden-modules: GHC.Integer.Type
abi: 7d948c9c98bb9ecc021f32964406f9ad
trusted: False
import-dirs: /usr/local/lib/ghc/integer-gmp-1.0.1.0
library-dirs: /usr/local/lib/ghc/integer-gmp-1.0.1.0
              /usr/local/lib/ghc/integer-gmp-1.0.1.0
data-dir: /usr/local/share/i386-openbsd-ghc-8.2.2/integer-gmp-1.0.1.0
hs-libraries: HSinteger-gmp-1.0.1.0
include-dirs: /usr/local/lib/ghc/integer-gmp-1.0.1.0/include
depends:
    ghc-prim-0.5.1.1
abi-depends: ghc-prim-0.5.1.1=84323a6edd008b04bf217464a4ccaf16
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/integer-gmp-1.0.1.0/integer-gmp.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/integer-gmp-1.0.1.0
pkgroot: "/usr/obj/ports/ghc-8.2.2/fake-i386/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: base
version: 4.10.1.0
id: base-4.10.1.0
key: base-4.10.1.0
license: BSD3
maintainer: libraries@haskell.org
synopsis: Basic libraries
description:
    This package contains the "Prelude" and its support libraries,
    and a large collection of useful libraries ranging from data
    structures to parsing combinators and debugging utilities.
category: Prelude
exposed: True
indefinite: False
exposed-modules:
    Control.Applicative Control.Arrow Control.Category
    Control.Concurrent Control.Concurrent.Chan Control.Concurrent.MVar
    Control.Concurrent.QSem Control.Concurrent.QSemN Control.Exception
    Control.Exception.Base Control.Monad Control.Monad.Fail
    Control.Monad.Fix Control.Monad.IO.Class Control.Monad.Instances
    Control.Monad.ST Control.Monad.ST.Lazy Control.Monad.ST.Lazy.Safe
    Control.Monad.ST.Lazy.Unsafe Control.Monad.ST.Safe
    Control.Monad.ST.Strict Control.Monad.ST.Unsafe Control.Monad.Zip
    Data.Bifoldable Data.Bifunctor Data.Bitraversable Data.Bits
    Data.Bool Data.Char Data.Coerce Data.Complex Data.Data Data.Dynamic
    Data.Either Data.Eq Data.Fixed Data.Foldable Data.Function
    Data.Functor Data.Functor.Classes Data.Functor.Compose
    Data.Functor.Const Data.Functor.Identity Data.Functor.Product
    Data.Functor.Sum Data.IORef Data.Int Data.Ix Data.Kind Data.List
    Data.List.NonEmpty Data.Maybe Data.Monoid Data.Ord Data.Proxy
    Data.Ratio Data.STRef Data.STRef.Lazy Data.STRef.Strict
    Data.Semigroup Data.String Data.Traversable Data.Tuple
    Data.Type.Bool Data.Type.Coercion Data.Type.Equality Data.Typeable
    Data.Unique Data.Version Data.Void Data.Word Debug.Trace Foreign
    Foreign.C Foreign.C.Error Foreign.C.String Foreign.C.Types
    Foreign.Concurrent Foreign.ForeignPtr Foreign.ForeignPtr.Safe
    Foreign.ForeignPtr.Unsafe Foreign.Marshal Foreign.Marshal.Alloc
    Foreign.Marshal.Array Foreign.Marshal.Error Foreign.Marshal.Pool
    Foreign.Marshal.Safe Foreign.Marshal.Unsafe Foreign.Marshal.Utils
    Foreign.Ptr Foreign.Safe Foreign.StablePtr Foreign.Storable GHC.Arr
    GHC.Base GHC.Char GHC.Conc GHC.Conc.IO GHC.Conc.Signal
    GHC.Conc.Sync GHC.ConsoleHandler GHC.Constants GHC.Desugar GHC.Enum
    GHC.Environment GHC.Err GHC.Event GHC.Exception GHC.ExecutionStack
    GHC.ExecutionStack.Internal GHC.Exts GHC.Fingerprint
    GHC.Fingerprint.Type GHC.Float GHC.Float.ConversionUtils
    GHC.Float.RealFracMethods GHC.Foreign GHC.ForeignPtr GHC.GHCi
    GHC.Generics GHC.IO GHC.IO.Buffer GHC.IO.BufferedIO GHC.IO.Device
    GHC.IO.Encoding GHC.IO.Encoding.CodePage GHC.IO.Encoding.Failure
    GHC.IO.Encoding.Iconv GHC.IO.Encoding.Latin1 GHC.IO.Encoding.Types
    GHC.IO.Encoding.UTF16 GHC.IO.Encoding.UTF32 GHC.IO.Encoding.UTF8
    GHC.IO.Exception GHC.IO.FD GHC.IO.Handle GHC.IO.Handle.FD
    GHC.IO.Handle.Internals GHC.IO.Handle.Lock GHC.IO.Handle.Text
    GHC.IO.Handle.Types GHC.IO.IOMode GHC.IO.Unsafe GHC.IOArray
    GHC.IORef GHC.Int GHC.List GHC.MVar GHC.Natural GHC.Num GHC.OldList
    GHC.OverloadedLabels GHC.PArr GHC.Pack GHC.Profiling GHC.Ptr
    GHC.RTS.Flags GHC.Read GHC.Real GHC.Records GHC.ST GHC.STRef
    GHC.Show GHC.Stable GHC.Stack GHC.Stack.CCS GHC.Stack.Types
    GHC.StaticPtr GHC.Stats GHC.Storable GHC.TopHandler GHC.TypeLits
    GHC.TypeNats GHC.Unicode GHC.Weak GHC.Word Numeric Numeric.Natural
    Prelude System.CPUTime System.Console.GetOpt System.Environment
    System.Exit System.IO System.IO.Error System.IO.Unsafe System.Info
    System.Mem System.Mem.StableName System.Mem.Weak
    System.Posix.Internals System.Posix.Types System.Timeout
    Text.ParserCombinators.ReadP Text.ParserCombinators.ReadPrec
    Text.Printf Text.Read Text.Read.Lex Text.Show Text.Show.Functions
    Type.Reflection Type.Reflection.Unsafe Unsafe.Coerce
hidden-modules: Control.Monad.ST.Imp Control.Monad.ST.Lazy.Imp
                Data.Functor.Utils Data.OldList Data.Typeable.Internal
                Foreign.ForeignPtr.Imp GHC.StaticPtr.Internal
                System.Environment.ExecutablePath System.CPUTime.Utils
                GHC.Event.Arr GHC.Event.Array GHC.Event.Clock GHC.Event.Control
                GHC.Event.EPoll GHC.Event.IntTable GHC.Event.Internal
                GHC.Event.KQueue GHC.Event.Manager GHC.Event.PSQ GHC.Event.Poll
                GHC.Event.Thread GHC.Event.TimerManager GHC.Event.Unique
                System.CPUTime.Posix.ClockGetTime System.CPUTime.Posix.Times
                System.CPUTime.Posix.RUsage System.CPUTime.Unsupported
abi: 3c10740f6cf9df7b9dca6d01ba411ea7
trusted: False
import-dirs: /usr/local/lib/ghc/base-4.10.1.0
library-dirs: /usr/local/lib/ghc/base-4.10.1.0
              /usr/local/lib/ghc/base-4.10.1.0 /usr/local/lib
data-dir: /usr/local/share/i386-openbsd-ghc-8.2.2/base-4.10.1.0
hs-libraries: HSbase-4.10.1.0
extra-libraries:
    iconv
include-dirs: /usr/local/include
              /usr/local/lib/ghc/base-4.10.1.0/include
includes:
    HsBase.h
depends:
    rts ghc-prim-0.5.1.1 integer-gmp-1.0.1.0
abi-depends: rts= ghc-prim-0.5.1.1=84323a6edd008b04bf217464a4ccaf16
             integer-gmp-1.0.1.0=7d948c9c98bb9ecc021f32964406f9ad
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/base-4.10.1.0/base.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/base-4.10.1.0
pkgroot: "/usr/obj/ports/ghc-8.2.2/fake-i386/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: filepath
version: 1.4.1.2
id: filepath-1.4.1.2
key: filepath-1.4.1.2
license: BSD3
copyright: Neil Mitchell 2005-2017
maintainer: Neil Mitchell <ndmitchell@gmail.com>
homepage: https://github.com/haskell/filepath#readme
synopsis: Library for manipulating FilePaths in a cross platform way.
description:
    This package provides functionality for manipulating @FilePath@ values, and is shipped with both <https://www.haskell.org/ghc/ GHC> and the <https://www.haskell.org/platform/ Haskell Platform>. It provides three modules:
    .
    * "System.FilePath.Posix" manipulates POSIX\/Linux style @FilePath@ values (with @\/@ as the path separator).
    .
    * "System.FilePath.Windows" manipulates Windows style @FilePath@ values (with either @\\@ or @\/@ as the path separator, and deals with drives).
    .
    * "System.FilePath" is an alias for the module appropriate to your platform.
    .
    All three modules provide the same API, and the same documentation (calling out differences in the different variants).
category: System
author: Neil Mitchell <ndmitchell@gmail.com>
exposed: True
indefinite: False
exposed-modules:
    System.FilePath System.FilePath.Posix System.FilePath.Windows
abi: ef9a1704901889a61779624199ca7499
trusted: False
import-dirs: /usr/local/lib/ghc/filepath-1.4.1.2
library-dirs: /usr/local/lib/ghc/filepath-1.4.1.2
              /usr/local/lib/ghc/filepath-1.4.1.2
data-dir: /usr/local/share/i386-openbsd-ghc-8.2.2/filepath-1.4.1.2
hs-libraries: HSfilepath-1.4.1.2
depends:
    base-4.10.1.0
abi-depends: base-4.10.1.0=3c10740f6cf9df7b9dca6d01ba411ea7
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/filepath-1.4.1.2/filepath.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/filepath-1.4.1.2
pkgroot: "/usr/obj/ports/ghc-8.2.2/fake-i386/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: array
version: 0.5.2.0
id: array-0.5.2.0
key: array-0.5.2.0
license: BSD3
maintainer: libraries@haskell.org
synopsis: Mutable and immutable arrays
description:
    In addition to providing the "Data.Array" module
    <http://www.haskell.org/onlinereport/haskell2010/haskellch14.html as specified in the Haskell 2010 Language Report>,
    this package also defines the classes 'IArray' of
    immutable arrays and 'MArray' of arrays mutable within appropriate
    monads, as well as some instances of these classes.
category: Data Structures
exposed: True
indefinite: False
exposed-modules:
    Data.Array Data.Array.Base Data.Array.IArray Data.Array.IO
    Data.Array.IO.Internals Data.Array.IO.Safe Data.Array.MArray
    Data.Array.MArray.Safe Data.Array.ST Data.Array.ST.Safe
    Data.Array.Storable Data.Array.Storable.Internals
    Data.Array.Storable.Safe Data.Array.Unboxed Data.Array.Unsafe
abi: c3a92ef97c0191e4bc82f0a7399f51b4
trusted: False
import-dirs: /usr/local/lib/ghc/array-0.5.2.0
library-dirs: /usr/local/lib/ghc/array-0.5.2.0
              /usr/local/lib/ghc/array-0.5.2.0
data-dir: /usr/local/share/i386-openbsd-ghc-8.2.2/array-0.5.2.0
hs-libraries: HSarray-0.5.2.0
depends:
    base-4.10.1.0
abi-depends: base-4.10.1.0=3c10740f6cf9df7b9dca6d01ba411ea7
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/array-0.5.2.0/array.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/array-0.5.2.0
pkgroot: "/usr/obj/ports/ghc-8.2.2/fake-i386/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: deepseq
version: 1.4.3.0
id: deepseq-1.4.3.0
key: deepseq-1.4.3.0
license: BSD3
maintainer: libraries@haskell.org
synopsis: Deep evaluation of data structures
description:
    This package provides methods for fully evaluating data structures
    (\"deep evaluation\"). Deep evaluation is often used for adding
    strictness to a program, e.g. in order to force pending exceptions,
    remove space leaks, or force lazy I/O to happen. It is also useful
    in parallel programs, to ensure pending work does not migrate to the
    wrong thread.
    .
    The primary use of this package is via the 'deepseq' function, a
    \"deep\" version of 'seq'. It is implemented on top of an 'NFData'
    typeclass (\"Normal Form Data\", data structures with no unevaluated
    components) which defines strategies for fully evaluating different
    data types.
category: Control
exposed: True
indefinite: False
exposed-modules:
    Control.DeepSeq
hidden-modules: Control.DeepSeq.BackDoor
abi: a3192b565ae21910ed279f609cad2bc5
trusted: False
import-dirs: /usr/local/lib/ghc/deepseq-1.4.3.0
library-dirs: /usr/local/lib/ghc/deepseq-1.4.3.0
              /usr/local/lib/ghc/deepseq-1.4.3.0
data-dir: /usr/local/share/i386-openbsd-ghc-8.2.2/deepseq-1.4.3.0
hs-libraries: HSdeepseq-1.4.3.0
depends:
    base-4.10.1.0 array-0.5.2.0
abi-depends: base-4.10.1.0=3c10740f6cf9df7b9dca6d01ba411ea7
             array-0.5.2.0=c3a92ef97c0191e4bc82f0a7399f51b4
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/deepseq-1.4.3.0/deepseq.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/deepseq-1.4.3.0
pkgroot: "/usr/obj/ports/ghc-8.2.2/fake-i386/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: bytestring
version: 0.10.8.2
id: bytestring-0.10.8.2
key: bytestring-0.10.8.2
license: BSD3
copyright: Copyright (c) Don Stewart          2005-2009,
           (c) Duncan Coutts        2006-2015,
           (c) David Roundy         2003-2005,
           (c) Jasper Van der Jeugt 2010,
           (c) Simon Meier          2010-2013.
maintainer: Duncan Coutts <duncan@community.haskell.org>
homepage: https://github.com/haskell/bytestring
synopsis: Fast, compact, strict and lazy byte strings with a list interface
description:
    An efficient compact, immutable byte string type (both strict and lazy)
    suitable for binary or 8-bit character data.
    .
    The 'ByteString' type represents sequences of bytes or 8-bit characters.
    It is suitable for high performance use, both in terms of large data
    quantities, or high speed requirements. The 'ByteString' functions follow
    the same style as Haskell\'s ordinary lists, so it is easy to convert code
    from using 'String' to 'ByteString'.
    .
    Two 'ByteString' variants are provided:
    .
    * Strict 'ByteString's keep the string as a single large array. This
    makes them convenient for passing data between C and Haskell.
    .
    * Lazy 'ByteString's use a lazy list of strict chunks which makes it
    suitable for I\/O streaming tasks.
    .
    The @Char8@ modules provide a character-based view of the same
    underlying 'ByteString' types. This makes it convenient to handle mixed
    binary and 8-bit character content (which is common in many file formats
    and network protocols).
    .
    The 'Builder' module provides an efficient way to build up 'ByteString's
    in an ad-hoc way by repeated concatenation. This is ideal for fast
    serialisation or pretty printing.
    .
    There is also a 'ShortByteString' type which has a lower memory overhead
    and can can be converted to or from a 'ByteString', but supports very few
    other operations. It is suitable for keeping many short strings in memory.
    .
    'ByteString's are not designed for Unicode. For Unicode strings you should
    use the 'Text' type from the @text@ package.
    .
    These modules are intended to be imported qualified, to avoid name clashes
    with "Prelude" functions, e.g.
    .
    > import qualified Data.ByteString as BS
category: Data
author: Don Stewart,
        Duncan Coutts
exposed: True
indefinite: False
exposed-modules:
    Data.ByteString Data.ByteString.Builder
    Data.ByteString.Builder.Extra Data.ByteString.Builder.Internal
    Data.ByteString.Builder.Prim Data.ByteString.Builder.Prim.Internal
    Data.ByteString.Char8 Data.ByteString.Internal Data.ByteString.Lazy
    Data.ByteString.Lazy.Builder Data.ByteString.Lazy.Builder.ASCII
    Data.ByteString.Lazy.Builder.Extras Data.ByteString.Lazy.Char8
    Data.ByteString.Lazy.Internal Data.ByteString.Short
    Data.ByteString.Short.Internal Data.ByteString.Unsafe
hidden-modules: Data.ByteString.Builder.ASCII
                Data.ByteString.Builder.Prim.Binary
                Data.ByteString.Builder.Prim.ASCII
                Data.ByteString.Builder.Prim.Internal.Floating
                Data.ByteString.Builder.Prim.Internal.UncheckedShifts
                Data.ByteString.Builder.Prim.Internal.Base16
abi: 3f834c69e2158c4ad5032b0346c29480
trusted: False
import-dirs: /usr/local/lib/ghc/bytestring-0.10.8.2
library-dirs: /usr/local/lib/ghc/bytestring-0.10.8.2
              /usr/local/lib/ghc/bytestring-0.10.8.2
data-dir: /usr/local/share/i386-openbsd-ghc-8.2.2/bytestring-0.10.8.2
hs-libraries: HSbytestring-0.10.8.2
include-dirs: /usr/local/lib/ghc/bytestring-0.10.8.2/include
includes:
    fpstring.h
depends:
    base-4.10.1.0 ghc-prim-0.5.1.1 deepseq-1.4.3.0 integer-gmp-1.0.1.0
abi-depends: base-4.10.1.0=3c10740f6cf9df7b9dca6d01ba411ea7
             ghc-prim-0.5.1.1=84323a6edd008b04bf217464a4ccaf16
             deepseq-1.4.3.0=a3192b565ae21910ed279f609cad2bc5
             integer-gmp-1.0.1.0=7d948c9c98bb9ecc021f32964406f9ad
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/bytestring-0.10.8.2/bytestring.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/bytestring-0.10.8.2
pkgroot: "/usr/obj/ports/ghc-8.2.2/fake-i386/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: ghc-compact
version: 0.1.0.0
id: ghc-compact-0.1.0.0
key: ghc-compact-0.1.0.0
license: BSD3
maintainer: libraries@haskell.org
synopsis: In memory storage of deeply evaluated data structure
description:
    This package provides minimal functionality for working with
    "compact regions", which hold a fully evaluated Haskell object graph.
    These regions maintain the invariant that no pointers live inside the struct
    that point outside it, which ensures efficient garbage collection without
    ever reading the structure contents (effectively, it works as a manually
    managed "oldest generation" which is never freed until the whole is
    released).
    Internally, the struct is stored a single contiguous block of memory,
    which allows efficient serialization and deserialization of structs
    for distributed computing.
category: Data
exposed: True
indefinite: False
exposed-modules:
    GHC.Compact GHC.Compact.Serialized
abi: c1d78764afb1eb8971d7b1dd628742f3
trusted: False
import-dirs: /usr/local/lib/ghc/ghc-compact-0.1.0.0
library-dirs: /usr/local/lib/ghc/ghc-compact-0.1.0.0
              /usr/local/lib/ghc/ghc-compact-0.1.0.0
data-dir: /usr/local/share/i386-openbsd-ghc-8.2.2/ghc-compact-0.1.0.0
hs-libraries: HSghc-compact-0.1.0.0
depends:
    ghc-prim-0.5.1.1 base-4.10.1.0 bytestring-0.10.8.2
abi-depends: ghc-prim-0.5.1.1=84323a6edd008b04bf217464a4ccaf16
             base-4.10.1.0=3c10740f6cf9df7b9dca6d01ba411ea7
             bytestring-0.10.8.2=3f834c69e2158c4ad5032b0346c29480
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/ghc-compact-0.1.0.0/ghc-compact.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/ghc-compact-0.1.0.0
pkgroot: "/usr/obj/ports/ghc-8.2.2/fake-i386/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: containers
version: 0.5.10.2
id: containers-0.5.10.2
key: containers-0.5.10.2
license: BSD3
maintainer: libraries@haskell.org
synopsis: Assorted concrete container types
description:
    This package contains efficient general-purpose implementations
    of various basic immutable container types.  The declared cost of
    each operation is either worst-case or amortized, but remains
    valid even if structures are shared.
category: Data Structures
exposed: True
indefinite: False
exposed-modules:
    Data.Graph Data.IntMap Data.IntMap.Internal
    Data.IntMap.Internal.Debug Data.IntMap.Lazy Data.IntMap.Merge.Lazy
    Data.IntMap.Merge.Strict Data.IntMap.Strict Data.IntSet
    Data.IntSet.Internal Data.Map Data.Map.Internal
    Data.Map.Internal.Debug Data.Map.Lazy Data.Map.Lazy.Merge
    Data.Map.Merge.Lazy Data.Map.Merge.Strict Data.Map.Strict
    Data.Map.Strict.Internal Data.Map.Strict.Merge Data.Sequence
    Data.Sequence.Internal Data.Set Data.Set.Internal Data.Tree
    Utils.Containers.Internal.BitQueue
    Utils.Containers.Internal.BitUtil
    Utils.Containers.Internal.StrictPair
hidden-modules: Utils.Containers.Internal.StrictFold
                Utils.Containers.Internal.StrictMaybe
                Utils.Containers.Internal.PtrEquality
                Data.Map.Internal.DeprecatedShowTree
                Data.IntMap.Internal.DeprecatedDebug
abi: a2c92baf4a812b005ca4fa7f0772cd30
trusted: False
import-dirs: /usr/local/lib/ghc/containers-0.5.10.2
library-dirs: /usr/local/lib/ghc/containers-0.5.10.2
              /usr/local/lib/ghc/containers-0.5.10.2
data-dir: /usr/local/share/i386-openbsd-ghc-8.2.2/containers-0.5.10.2
hs-libraries: HScontainers-0.5.10.2
depends:
    base-4.10.1.0 array-0.5.2.0 deepseq-1.4.3.0 ghc-prim-0.5.1.1
abi-depends: base-4.10.1.0=3c10740f6cf9df7b9dca6d01ba411ea7
             array-0.5.2.0=c3a92ef97c0191e4bc82f0a7399f51b4
             deepseq-1.4.3.0=a3192b565ae21910ed279f609cad2bc5
             ghc-prim-0.5.1.1=84323a6edd008b04bf217464a4ccaf16
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/containers-0.5.10.2/containers.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/containers-0.5.10.2
pkgroot: "/usr/obj/ports/ghc-8.2.2/fake-i386/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: binary
version: 0.8.5.1
id: binary-0.8.5.1
key: binary-0.8.5.1
license: BSD3
maintainer: Lennart Kolmodin, Don Stewart <dons00@gmail.com>
stability: provisional
homepage: https://github.com/kolmodin/binary
synopsis: Binary serialisation for Haskell values using lazy ByteStrings
description:
    Efficient, pure binary serialisation using lazy ByteStrings.
    Haskell values may be encoded to and from binary formats,
    written to disk as binary, or sent over the network.
    The format used can be automatically generated, or
    you can choose to implement a custom format if needed.
    Serialisation speeds of over 1 G\/sec have been observed,
    so this library should be suitable for high performance
    scenarios.
category: Data, Parsing
author: Lennart Kolmodin <kolmodin@gmail.com>
exposed: True
indefinite: False
exposed-modules:
    Data.Binary Data.Binary.Builder Data.Binary.Get
    Data.Binary.Get.Internal Data.Binary.Put
hidden-modules: Data.Binary.Class Data.Binary.Internal
                Data.Binary.Generic Data.Binary.FloatCast
abi: a96dcb415eb3046ea6a98be8bea83198
trusted: False
import-dirs: /usr/local/lib/ghc/binary-0.8.5.1
library-dirs: /usr/local/lib/ghc/binary-0.8.5.1
              /usr/local/lib/ghc/binary-0.8.5.1
data-dir: /usr/local/share/i386-openbsd-ghc-8.2.2/binary-0.8.5.1
hs-libraries: HSbinary-0.8.5.1
depends:
    base-4.10.1.0 bytestring-0.10.8.2 containers-0.5.10.2 array-0.5.2.0
abi-depends: base-4.10.1.0=3c10740f6cf9df7b9dca6d01ba411ea7
             bytestring-0.10.8.2=3f834c69e2158c4ad5032b0346c29480
             containers-0.5.10.2=a2c92baf4a812b005ca4fa7f0772cd30
             array-0.5.2.0=c3a92ef97c0191e4bc82f0a7399f51b4
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/binary-0.8.5.1/binary.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/binary-0.8.5.1
pkgroot: "/usr/obj/ports/ghc-8.2.2/fake-i386/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: hoopl
version: 3.10.2.2
id: hoopl-3.10.2.2
key: hoopl-3.10.2.2
license: BSD3
maintainer: Ning Wang <email@ningwang.org>, Michal Terepeta <michal.terepeta@gmail.com>, Norman Ramsey <nr@cs.tufts.edu>
homepage: https://github.com/haskell/hoopl
synopsis: A library to support dataflow analysis and optimization
description:
    Higher-order optimization library
    .
    See /Norman Ramsey, Joao Dias, and Simon Peyton Jones./
    <http://research.microsoft.com/en-us/um/people/simonpj/Papers/c--/hoopl-haskell10.pdf "Hoopl: A Modular, Reusable Library for Dataflow Analysis and Transformation"> /(2010)/ for more details.
category: Compilers/Interpreters
author: Norman Ramsey, Joao Dias, Simon Marlow and Simon Peyton Jones
exposed: True
indefinite: False
exposed-modules:
    Compiler.Hoopl Compiler.Hoopl.Internals Compiler.Hoopl.Passes.DList
    Compiler.Hoopl.Passes.Dominator Compiler.Hoopl.Wrappers
hidden-modules: Compiler.Hoopl.Checkpoint
                Compiler.Hoopl.Collections Compiler.Hoopl.Combinators
                Compiler.Hoopl.Dataflow Compiler.Hoopl.Debug Compiler.Hoopl.Block
                Compiler.Hoopl.Graph Compiler.Hoopl.Label Compiler.Hoopl.MkGraph
                Compiler.Hoopl.Fuel Compiler.Hoopl.Pointed Compiler.Hoopl.Shape
                Compiler.Hoopl.Show Compiler.Hoopl.Unique Compiler.Hoopl.XUtil
abi: 976ef256e3a4dac14ada0d90bd3026fc
trusted: False
import-dirs: /usr/local/lib/ghc/hoopl-3.10.2.2
library-dirs: /usr/local/lib/ghc/hoopl-3.10.2.2
              /usr/local/lib/ghc/hoopl-3.10.2.2
data-dir: /usr/local/share/i386-openbsd-ghc-8.2.2/hoopl-3.10.2.2
hs-libraries: HShoopl-3.10.2.2
depends:
    base-4.10.1.0 containers-0.5.10.2
abi-depends: base-4.10.1.0=3c10740f6cf9df7b9dca6d01ba411ea7
             containers-0.5.10.2=a2c92baf4a812b005ca4fa7f0772cd30
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/hoopl-3.10.2.2/hoopl.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/hoopl-3.10.2.2
pkgroot: "/usr/obj/ports/ghc-8.2.2/fake-i386/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: time
version: 1.8.0.2
id: time-1.8.0.2
key: time-1.8.0.2
license: BSD3
maintainer: <ashley@semantic.org>
stability: stable
homepage: https://github.com/haskell/time
synopsis: A time library
description:
    A time library
category: Time
author: Ashley Yakeley
exposed: True
indefinite: False
exposed-modules:
    Data.Time Data.Time.Calendar Data.Time.Calendar.Easter
    Data.Time.Calendar.Julian Data.Time.Calendar.MonthDay
    Data.Time.Calendar.OrdinalDate Data.Time.Calendar.WeekDate
    Data.Time.Clock Data.Time.Clock.POSIX Data.Time.Clock.System
    Data.Time.Clock.TAI Data.Time.Format Data.Time.LocalTime
hidden-modules: Data.Time.Calendar.Private Data.Time.Calendar.Days
                Data.Time.Calendar.Gregorian Data.Time.Calendar.JulianYearDay
                Data.Time.Clock.Internal.DiffTime
                Data.Time.Clock.Internal.AbsoluteTime
                Data.Time.Clock.Internal.NominalDiffTime
                Data.Time.Clock.Internal.POSIXTime
                Data.Time.Clock.Internal.UniversalTime
                Data.Time.Clock.Internal.SystemTime
                Data.Time.Clock.Internal.UTCTime Data.Time.Clock.Internal.CTimeval
                Data.Time.Clock.Internal.CTimespec Data.Time.Clock.Internal.UTCDiff
                Data.Time.LocalTime.Internal.TimeZone
                Data.Time.LocalTime.Internal.TimeOfDay
                Data.Time.LocalTime.Internal.LocalTime
                Data.Time.LocalTime.Internal.ZonedTime Data.Time.Format.Parse
                Data.Time.Format.Locale
abi: 4e7e761020e68f00617832ab1b4f94d5
trusted: False
import-dirs: /usr/local/lib/ghc/time-1.8.0.2
library-dirs: /usr/local/lib/ghc/time-1.8.0.2
              /usr/local/lib/ghc/time-1.8.0.2
data-dir: /usr/local/share/i386-openbsd-ghc-8.2.2/time-1.8.0.2
hs-libraries: HStime-1.8.0.2
include-dirs: /usr/local/lib/ghc/time-1.8.0.2/include
depends:
    base-4.10.1.0 deepseq-1.4.3.0
abi-depends: base-4.10.1.0=3c10740f6cf9df7b9dca6d01ba411ea7
             deepseq-1.4.3.0=a3192b565ae21910ed279f609cad2bc5
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/time-1.8.0.2/time.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/time-1.8.0.2
pkgroot: "/usr/obj/ports/ghc-8.2.2/fake-i386/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: unix
version: 2.7.2.2
id: unix-2.7.2.2
key: unix-2.7.2.2
license: BSD3
maintainer: libraries@haskell.org
homepage: https://github.com/haskell/unix
synopsis: POSIX functionality
description:
    This package gives you access to the set of operating system
    services standardised by
    <http://pubs.opengroup.org/onlinepubs/9699919799/ POSIX.1-2008>
    (or the IEEE Portable Operating System Interface for Computing
    Environments - IEEE Std. 1003.1).
    .
    The package is not supported under Windows.
category: System
exposed: True
indefinite: False
exposed-modules:
    System.OpenBSD.Process System.Posix System.Posix.ByteString
    System.Posix.ByteString.FilePath System.Posix.Directory
    System.Posix.Directory.ByteString System.Posix.DynamicLinker
    System.Posix.DynamicLinker.ByteString
    System.Posix.DynamicLinker.Module
    System.Posix.DynamicLinker.Module.ByteString
    System.Posix.DynamicLinker.Prim System.Posix.Env
    System.Posix.Env.ByteString System.Posix.Error System.Posix.Fcntl
    System.Posix.Files System.Posix.Files.ByteString System.Posix.IO
    System.Posix.IO.ByteString System.Posix.Process
    System.Posix.Process.ByteString System.Posix.Process.Internals
    System.Posix.Resource System.Posix.Semaphore System.Posix.SharedMem
    System.Posix.Signals System.Posix.Signals.Exts System.Posix.Temp
    System.Posix.Temp.ByteString System.Posix.Terminal
    System.Posix.Terminal.ByteString System.Posix.Time
    System.Posix.Unistd System.Posix.User
hidden-modules: System.Posix.Directory.Common
                System.Posix.DynamicLinker.Common System.Posix.Files.Common
                System.Posix.IO.Common System.Posix.Process.Common
                System.Posix.Terminal.Common
abi: fdb14956a5b19c6bc5b505e3d2c05085
trusted: False
import-dirs: /usr/local/lib/ghc/unix-2.7.2.2
library-dirs: /usr/local/lib/ghc/unix-2.7.2.2
              /usr/local/lib/ghc/unix-2.7.2.2
data-dir: /usr/local/share/i386-openbsd-ghc-8.2.2/unix-2.7.2.2
hs-libraries: HSunix-2.7.2.2
extra-libraries:
    util pthread
include-dirs: /usr/local/lib/ghc/unix-2.7.2.2/include
includes:
    HsUnix.h execvpe.h
depends:
    base-4.10.1.0 bytestring-0.10.8.2 time-1.8.0.2
abi-depends: base-4.10.1.0=3c10740f6cf9df7b9dca6d01ba411ea7
             bytestring-0.10.8.2=3f834c69e2158c4ad5032b0346c29480
             time-1.8.0.2=4e7e761020e68f00617832ab1b4f94d5
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/unix-2.7.2.2/unix.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/unix-2.7.2.2
pkgroot: "/usr/obj/ports/ghc-8.2.2/fake-i386/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: directory
version: 1.3.0.2
id: directory-1.3.0.2
key: directory-1.3.0.2
license: BSD3
maintainer: libraries@haskell.org
synopsis: Platform-agnostic library for filesystem operations
description:
    This library provides a basic set of operations for manipulating files and
    directories in a portable way.
category: System
exposed: True
indefinite: False
exposed-modules:
    System.Directory System.Directory.Internal
    System.Directory.Internal.Prelude
hidden-modules: System.Directory.Internal.Config
                System.Directory.Internal.C_utimensat
                System.Directory.Internal.Posix System.Directory.Internal.Windows
abi: 1eef9b3048ad9e2e85c4a64b4bf56e7e
trusted: False
import-dirs: /usr/local/lib/ghc/directory-1.3.0.2
library-dirs: /usr/local/lib/ghc/directory-1.3.0.2
              /usr/local/lib/ghc/directory-1.3.0.2
data-dir: /usr/local/share/i386-openbsd-ghc-8.2.2/directory-1.3.0.2
hs-libraries: HSdirectory-1.3.0.2
include-dirs: /usr/local/lib/ghc/directory-1.3.0.2/include
depends:
    base-4.10.1.0 time-1.8.0.2 filepath-1.4.1.2 unix-2.7.2.2
abi-depends: base-4.10.1.0=3c10740f6cf9df7b9dca6d01ba411ea7
             time-1.8.0.2=4e7e761020e68f00617832ab1b4f94d5
             filepath-1.4.1.2=ef9a1704901889a61779624199ca7499
             unix-2.7.2.2=fdb14956a5b19c6bc5b505e3d2c05085
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/directory-1.3.0.2/directory.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/directory-1.3.0.2
pkgroot: "/usr/obj/ports/ghc-8.2.2/fake-i386/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: process
version: 1.6.1.0
id: process-1.6.1.0
key: process-1.6.1.0
license: BSD3
maintainer: libraries@haskell.org
synopsis: Process libraries
description:
    This package contains libraries for dealing with system processes.
    .
    The typed-process package is a more recent take on a process API,
    which uses this package internally. It features better binary
    support, easier concurrency, and a more composable API. You can
    read more about it at
    <https://haskell-lang.org/library/typed-process>.
category: System
exposed: True
indefinite: False
exposed-modules:
    System.Cmd System.Process System.Process.Internals
hidden-modules: System.Process.Common System.Process.Posix
abi: 6300085e5ed51248cf7e29323581f4ed
trusted: False
import-dirs: /usr/local/lib/ghc/process-1.6.1.0
library-dirs: /usr/local/lib/ghc/process-1.6.1.0
              /usr/local/lib/ghc/process-1.6.1.0
data-dir: /usr/local/share/i386-openbsd-ghc-8.2.2/process-1.6.1.0
hs-libraries: HSprocess-1.6.1.0
include-dirs: /usr/local/lib/ghc/process-1.6.1.0/include
includes:
    runProcess.h
depends:
    base-4.10.1.0 directory-1.3.0.2 filepath-1.4.1.2 deepseq-1.4.3.0
    unix-2.7.2.2
abi-depends: base-4.10.1.0=3c10740f6cf9df7b9dca6d01ba411ea7
             directory-1.3.0.2=1eef9b3048ad9e2e85c4a64b4bf56e7e
             filepath-1.4.1.2=ef9a1704901889a61779624199ca7499
             deepseq-1.4.3.0=a3192b565ae21910ed279f609cad2bc5
             unix-2.7.2.2=fdb14956a5b19c6bc5b505e3d2c05085
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/process-1.6.1.0/process.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/process-1.6.1.0
pkgroot: "/usr/obj/ports/ghc-8.2.2/fake-i386/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: hpc
version: 0.6.0.3
id: hpc-0.6.0.3
key: hpc-0.6.0.3
license: BSD3
maintainer: ghc-devs@haskell.org
synopsis: Code Coverage Library for Haskell
description:
    This package provides the code coverage library for Haskell.
    .
    See <http://www.haskell.org/haskellwiki/Haskell_program_coverage> for more
    information.
category: Control
author: Andy Gill
exposed: True
indefinite: False
exposed-modules:
    Trace.Hpc.Mix Trace.Hpc.Reflect Trace.Hpc.Tix Trace.Hpc.Util
abi: 5652ca99bf346707bd8b4b1e5fc76dbc
trusted: False
import-dirs: /usr/local/lib/ghc/hpc-0.6.0.3
library-dirs: /usr/local/lib/ghc/hpc-0.6.0.3
              /usr/local/lib/ghc/hpc-0.6.0.3
data-dir: /usr/local/share/i386-openbsd-ghc-8.2.2/hpc-0.6.0.3
hs-libraries: HShpc-0.6.0.3
depends:
    base-4.10.1.0 containers-0.5.10.2 directory-1.3.0.2
    filepath-1.4.1.2 time-1.8.0.2
abi-depends: base-4.10.1.0=3c10740f6cf9df7b9dca6d01ba411ea7
             containers-0.5.10.2=a2c92baf4a812b005ca4fa7f0772cd30
             directory-1.3.0.2=1eef9b3048ad9e2e85c4a64b4bf56e7e
             filepath-1.4.1.2=ef9a1704901889a61779624199ca7499
             time-1.8.0.2=4e7e761020e68f00617832ab1b4f94d5
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/hpc-0.6.0.3/hpc.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/hpc-0.6.0.3
pkgroot: "/usr/obj/ports/ghc-8.2.2/fake-i386/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: pretty
version: 1.1.3.3
id: pretty-1.1.3.3
key: pretty-1.1.3.3
license: BSD3
maintainer: David Terei <code@davidterei.com>
stability: Stable
homepage: http://github.com/haskell/pretty
synopsis: Pretty-printing library
description:
    This package contains a pretty-printing library, a set of API's
    that provides a way to easily print out text in a consistent
    format of your choosing. This is useful for compilers and related
    tools.
    .
    This library was originally designed by John Hughes's and has since
    been heavily modified by Simon Peyton Jones.
category: Text
exposed: True
indefinite: False
exposed-modules:
    Text.PrettyPrint Text.PrettyPrint.Annotated
    Text.PrettyPrint.Annotated.HughesPJ
    Text.PrettyPrint.Annotated.HughesPJClass Text.PrettyPrint.HughesPJ
    Text.PrettyPrint.HughesPJClass
abi: 7e4ff47e6f9a790083a87f97e74bf9b6
trusted: False
import-dirs: /usr/local/lib/ghc/pretty-1.1.3.3
library-dirs: /usr/local/lib/ghc/pretty-1.1.3.3
              /usr/local/lib/ghc/pretty-1.1.3.3
data-dir: /usr/local/share/i386-openbsd-ghc-8.2.2/pretty-1.1.3.3
hs-libraries: HSpretty-1.1.3.3
depends:
    base-4.10.1.0 deepseq-1.4.3.0 ghc-prim-0.5.1.1
abi-depends: base-4.10.1.0=3c10740f6cf9df7b9dca6d01ba411ea7
             deepseq-1.4.3.0=a3192b565ae21910ed279f609cad2bc5
             ghc-prim-0.5.1.1=84323a6edd008b04bf217464a4ccaf16
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/pretty-1.1.3.3/pretty.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/pretty-1.1.3.3
pkgroot: "/usr/obj/ports/ghc-8.2.2/fake-i386/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: Cabal
version: 2.0.1.0
id: Cabal-2.0.1.0
key: Cabal-2.0.1.0
license: BSD3
copyright: 2003-2017, Cabal Development Team (see AUTHORS file)
maintainer: cabal-devel@haskell.org
homepage: http://www.haskell.org/cabal/
synopsis: A framework for packaging Haskell software
description:
    The Haskell Common Architecture for Building Applications and
    Libraries: a framework defining a common interface for authors to more
    easily build their Haskell applications in a portable way.
    .
    The Haskell Cabal is part of a larger infrastructure for distributing,
    organizing, and cataloging Haskell libraries and tools.
category: Distribution
author: Cabal Development Team <cabal-devel@haskell.org>
exposed: True
indefinite: False
exposed-modules:
    Distribution.Backpack Distribution.Backpack.ComponentsGraph
    Distribution.Backpack.Configure
    Distribution.Backpack.ConfiguredComponent
    Distribution.Backpack.DescribeUnitId
    Distribution.Backpack.FullUnitId
    Distribution.Backpack.LinkedComponent
    Distribution.Backpack.ModSubst Distribution.Backpack.ModuleShape
    Distribution.Compat.Binary Distribution.Compat.CreatePipe
    Distribution.Compat.DList Distribution.Compat.Environment
    Distribution.Compat.Exception Distribution.Compat.Graph
    Distribution.Compat.Internal.TempFile
    Distribution.Compat.Map.Strict Distribution.Compat.Prelude.Internal
    Distribution.Compat.ReadP Distribution.Compat.Semigroup
    Distribution.Compat.Stack Distribution.Compat.Time
    Distribution.Compiler Distribution.InstalledPackageInfo
    Distribution.License Distribution.Make Distribution.ModuleName
    Distribution.Package Distribution.PackageDescription
    Distribution.PackageDescription.Check
    Distribution.PackageDescription.Configuration
    Distribution.PackageDescription.Parse
    Distribution.PackageDescription.PrettyPrint
    Distribution.PackageDescription.Utils Distribution.ParseUtils
    Distribution.PrettyUtils Distribution.ReadE Distribution.Simple
    Distribution.Simple.Bench Distribution.Simple.Build
    Distribution.Simple.Build.Macros
    Distribution.Simple.Build.PathsModule
    Distribution.Simple.BuildPaths Distribution.Simple.BuildTarget
    Distribution.Simple.BuildToolDepends Distribution.Simple.CCompiler
    Distribution.Simple.Command Distribution.Simple.Compiler
    Distribution.Simple.Configure Distribution.Simple.Doctest
    Distribution.Simple.GHC Distribution.Simple.GHCJS
    Distribution.Simple.Haddock Distribution.Simple.HaskellSuite
    Distribution.Simple.Hpc Distribution.Simple.Install
    Distribution.Simple.InstallDirs Distribution.Simple.JHC
    Distribution.Simple.LHC Distribution.Simple.LocalBuildInfo
    Distribution.Simple.PackageIndex Distribution.Simple.PreProcess
    Distribution.Simple.PreProcess.Unlit Distribution.Simple.Program
    Distribution.Simple.Program.Ar Distribution.Simple.Program.Builtin
    Distribution.Simple.Program.Db Distribution.Simple.Program.Find
    Distribution.Simple.Program.GHC Distribution.Simple.Program.HcPkg
    Distribution.Simple.Program.Hpc
    Distribution.Simple.Program.Internal Distribution.Simple.Program.Ld
    Distribution.Simple.Program.Run Distribution.Simple.Program.Script
    Distribution.Simple.Program.Strip Distribution.Simple.Program.Types
    Distribution.Simple.Register Distribution.Simple.Setup
    Distribution.Simple.SrcDist Distribution.Simple.Test
    Distribution.Simple.Test.ExeV10 Distribution.Simple.Test.LibV09
    Distribution.Simple.Test.Log Distribution.Simple.UHC
    Distribution.Simple.UserHooks Distribution.Simple.Utils
    Distribution.System Distribution.TestSuite Distribution.Text
    Distribution.Types.AbiHash Distribution.Types.AnnotatedId
    Distribution.Types.Benchmark Distribution.Types.BenchmarkInterface
    Distribution.Types.BenchmarkType Distribution.Types.BuildInfo
    Distribution.Types.BuildType Distribution.Types.Component
    Distribution.Types.ComponentId Distribution.Types.ComponentInclude
    Distribution.Types.ComponentLocalBuildInfo
    Distribution.Types.ComponentName
    Distribution.Types.ComponentRequestedSpec
    Distribution.Types.CondTree Distribution.Types.Condition
    Distribution.Types.Dependency Distribution.Types.DependencyMap
    Distribution.Types.ExeDependency Distribution.Types.Executable
    Distribution.Types.ExecutableScope Distribution.Types.ForeignLib
    Distribution.Types.ForeignLibOption
    Distribution.Types.ForeignLibType
    Distribution.Types.GenericPackageDescription
    Distribution.Types.HookedBuildInfo
    Distribution.Types.IncludeRenaming
    Distribution.Types.LegacyExeDependency Distribution.Types.Library
    Distribution.Types.LocalBuildInfo Distribution.Types.Mixin
    Distribution.Types.Module Distribution.Types.ModuleReexport
    Distribution.Types.ModuleRenaming
    Distribution.Types.MungedPackageId
    Distribution.Types.MungedPackageName
    Distribution.Types.PackageDescription Distribution.Types.PackageId
    Distribution.Types.PackageName
    Distribution.Types.PkgconfigDependency
    Distribution.Types.PkgconfigName Distribution.Types.SetupBuildInfo
    Distribution.Types.SourceRepo Distribution.Types.TargetInfo
    Distribution.Types.TestSuite Distribution.Types.TestSuiteInterface
    Distribution.Types.TestType Distribution.Types.UnitId
    Distribution.Types.UnqualComponentName Distribution.Utils.Generic
    Distribution.Utils.LogProgress Distribution.Utils.MapAccum
    Distribution.Utils.NubList Distribution.Utils.Progress
    Distribution.Utils.ShortText Distribution.Verbosity
    Distribution.Version Language.Haskell.Extension
hidden-modules: Distribution.Backpack.PreExistingComponent
                Distribution.Backpack.ReadyComponent Distribution.Backpack.MixLink
                Distribution.Backpack.ModuleScope Distribution.Backpack.UnifyM
                Distribution.Backpack.Id Distribution.Utils.UnionFind
                Distribution.Utils.Base62 Distribution.Compat.CopyFile
                Distribution.Compat.GetShortPathName Distribution.Compat.MonadFail
                Distribution.Compat.Prelude Distribution.Compat.SnocList
                Distribution.GetOpt Distribution.Lex Distribution.Utils.String
                Distribution.Simple.GHC.Internal Distribution.Simple.GHC.IPI642
                Distribution.Simple.GHC.IPIConvert Distribution.Simple.GHC.ImplInfo
                Paths_Cabal
abi: 7bc7ffb5e2c8451ab397317cb02e0228
trusted: False
import-dirs: /usr/local/lib/ghc/Cabal-2.0.1.0
library-dirs: /usr/local/lib/ghc/Cabal-2.0.1.0
              /usr/local/lib/ghc/Cabal-2.0.1.0
data-dir: /usr/local/share/i386-openbsd-ghc-8.2.2/Cabal-2.0.1.0
hs-libraries: HSCabal-2.0.1.0
depends:
    array-0.5.2.0 base-4.10.1.0 bytestring-0.10.8.2 containers-0.5.10.2
    deepseq-1.4.3.0 filepath-1.4.1.2 pretty-1.1.3.3 process-1.6.1.0
    time-1.8.0.2 directory-1.3.0.2 binary-0.8.5.1 unix-2.7.2.2
abi-depends: array-0.5.2.0=c3a92ef97c0191e4bc82f0a7399f51b4
             base-4.10.1.0=3c10740f6cf9df7b9dca6d01ba411ea7
             bytestring-0.10.8.2=3f834c69e2158c4ad5032b0346c29480
             containers-0.5.10.2=a2c92baf4a812b005ca4fa7f0772cd30
             deepseq-1.4.3.0=a3192b565ae21910ed279f609cad2bc5
             filepath-1.4.1.2=ef9a1704901889a61779624199ca7499
             pretty-1.1.3.3=7e4ff47e6f9a790083a87f97e74bf9b6
             process-1.6.1.0=6300085e5ed51248cf7e29323581f4ed
             time-1.8.0.2=4e7e761020e68f00617832ab1b4f94d5
             directory-1.3.0.2=1eef9b3048ad9e2e85c4a64b4bf56e7e
             binary-0.8.5.1=a96dcb415eb3046ea6a98be8bea83198
             unix-2.7.2.2=fdb14956a5b19c6bc5b505e3d2c05085
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/Cabal-2.0.1.0/Cabal.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/Cabal-2.0.1.0
pkgroot: "/usr/obj/ports/ghc-8.2.2/fake-i386/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: ghc-boot-th
version: 8.2.2
id: ghc-boot-th-8.2.2
key: ghc-boot-th-8.2.2
license: BSD3
maintainer: ghc-devs@haskell.org
synopsis: Shared functionality between GHC and the @template-haskell@
          library
description:
    This library contains various bits shared between the @ghc@ and
    @template-haskell@ libraries.
    .
    This package exists to ensure that @template-haskell@ has a
    minimal set of transitive dependencies, since it is intended to
    be depended upon by user code.
category: GHC
exposed: True
indefinite: False
exposed-modules:
    GHC.ForeignSrcLang.Type GHC.LanguageExtensions.Type GHC.Lexeme
abi: 3238f73fc62d93b870a169421fe85c54
trusted: False
import-dirs: /usr/local/lib/ghc/ghc-boot-th-8.2.2
library-dirs: /usr/local/lib/ghc/ghc-boot-th-8.2.2
              /usr/local/lib/ghc/ghc-boot-th-8.2.2
data-dir: /usr/local/share/i386-openbsd-ghc-8.2.2/ghc-boot-th-8.2.2
hs-libraries: HSghc-boot-th-8.2.2
depends:
    base-4.10.1.0
abi-depends: base-4.10.1.0=3c10740f6cf9df7b9dca6d01ba411ea7
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/ghc-boot-th-8.2.2/ghc-boot-th.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/ghc-boot-th-8.2.2
pkgroot: "/usr/obj/ports/ghc-8.2.2/fake-i386/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: template-haskell
version: 2.12.0.0
id: template-haskell-2.12.0.0
key: template-haskell-2.12.0.0
license: BSD3
maintainer: libraries@haskell.org
synopsis: Support library for Template Haskell
description:
    This package provides modules containing facilities for manipulating
    Haskell source code using Template Haskell.
    .
    See <http://www.haskell.org/haskellwiki/Template_Haskell> for more
    information.
category: Template Haskell
exposed: True
indefinite: False
exposed-modules:
    Language.Haskell.TH Language.Haskell.TH.LanguageExtensions
    Language.Haskell.TH.Lib Language.Haskell.TH.Ppr
    Language.Haskell.TH.PprLib Language.Haskell.TH.Quote
    Language.Haskell.TH.Syntax
hidden-modules: Language.Haskell.TH.Lib.Map
abi: c86c34a1f7deb29023e2cbca17d693d7
trusted: False
import-dirs: /usr/local/lib/ghc/template-haskell-2.12.0.0
library-dirs: /usr/local/lib/ghc/template-haskell-2.12.0.0
              /usr/local/lib/ghc/template-haskell-2.12.0.0
data-dir: /usr/local/share/i386-openbsd-ghc-8.2.2/template-haskell-2.12.0.0
hs-libraries: HStemplate-haskell-2.12.0.0
depends:
    base-4.10.1.0 ghc-boot-th-8.2.2 pretty-1.1.3.3
abi-depends: base-4.10.1.0=3c10740f6cf9df7b9dca6d01ba411ea7
             ghc-boot-th-8.2.2=3238f73fc62d93b870a169421fe85c54
             pretty-1.1.3.3=7e4ff47e6f9a790083a87f97e74bf9b6
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/template-haskell-2.12.0.0/template-haskell.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/template-haskell-2.12.0.0
pkgroot: "/usr/obj/ports/ghc-8.2.2/fake-i386/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: ghc-boot
version: 8.2.2
id: ghc-boot-8.2.2
key: ghc-boot-8.2.2
license: BSD3
maintainer: ghc-devs@haskell.org
synopsis: Shared functionality between GHC and its boot libraries
description:
    This library is shared between GHC, ghc-pkg, and other boot
    libraries.
    .
    A note about "GHC.PackageDb": it only deals with the subset of
    the package database that the compiler cares about: modules
    paths etc and not package metadata like description, authors
    etc. It is thus not a library interface to ghc-pkg and is *not*
    suitable for modifying GHC package databases.
    .
    The package database format and this library are constructed in
    such a way that while ghc-pkg depends on Cabal, the GHC library
    and program do not have to depend on Cabal.
category: GHC
exposed: True
indefinite: False
exposed-modules:
    GHC.ForeignSrcLang GHC.LanguageExtensions GHC.PackageDb
    GHC.Serialized
abi: 7e02c4e8809872a4ae97cd79ef945f0b
trusted: False
import-dirs: /usr/local/lib/ghc/ghc-boot-8.2.2
library-dirs: /usr/local/lib/ghc/ghc-boot-8.2.2
              /usr/local/lib/ghc/ghc-boot-8.2.2
data-dir: /usr/local/share/i386-openbsd-ghc-8.2.2/ghc-boot-8.2.2
hs-libraries: HSghc-boot-8.2.2
depends:
    base-4.10.1.0 binary-0.8.5.1 bytestring-0.10.8.2 directory-1.3.0.2
    filepath-1.4.1.2 ghc-boot-th-8.2.2
abi-depends: base-4.10.1.0=3c10740f6cf9df7b9dca6d01ba411ea7
             binary-0.8.5.1=a96dcb415eb3046ea6a98be8bea83198
             bytestring-0.10.8.2=3f834c69e2158c4ad5032b0346c29480
             directory-1.3.0.2=1eef9b3048ad9e2e85c4a64b4bf56e7e
             filepath-1.4.1.2=ef9a1704901889a61779624199ca7499
             ghc-boot-th-8.2.2=3238f73fc62d93b870a169421fe85c54
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/ghc-boot-8.2.2/ghc-boot.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/ghc-boot-8.2.2
pkgroot: "/usr/obj/ports/ghc-8.2.2/fake-i386/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: transformers
version: 0.5.2.0
id: transformers-0.5.2.0
key: transformers-0.5.2.0
license: BSD3
maintainer: Ross Paterson <R.Paterson@city.ac.uk>
synopsis: Concrete functor and monad transformers
description:
    A portable library of functor and monad transformers, inspired by
    the paper \"Functional Programming with Overloading and Higher-Order
    Polymorphism\", by Mark P Jones,
    in /Advanced School of Functional Programming/, 1995
    (<http://web.cecs.pdx.edu/~mpj/pubs/springschool.html>).
    .
    This package contains:
    .
    * the monad transformer class (in "Control.Monad.Trans.Class")
    and IO monad class (in "Control.Monad.IO.Class")
    .
    * concrete functor and monad transformers, each with associated
    operations and functions to lift operations associated with other
    transformers.
    .
    The package can be used on its own in portable Haskell code, in
    which case operations need to be manually lifted through transformer
    stacks (see "Control.Monad.Trans.Class" for some examples).
    Alternatively, it can be used with the non-portable monad classes in
    the @mtl@ or @monads-tf@ packages, which automatically lift operations
    introduced by monad transformers through other transformers.
category: Control
author: Andy Gill, Ross Paterson
exposed: True
indefinite: False
exposed-modules:
    Control.Applicative.Backwards Control.Applicative.Lift
    Control.Monad.Signatures Control.Monad.Trans.Class
    Control.Monad.Trans.Cont Control.Monad.Trans.Error
    Control.Monad.Trans.Except Control.Monad.Trans.Identity
    Control.Monad.Trans.List Control.Monad.Trans.Maybe
    Control.Monad.Trans.RWS Control.Monad.Trans.RWS.Lazy
    Control.Monad.Trans.RWS.Strict Control.Monad.Trans.Reader
    Control.Monad.Trans.State Control.Monad.Trans.State.Lazy
    Control.Monad.Trans.State.Strict Control.Monad.Trans.Writer
    Control.Monad.Trans.Writer.Lazy Control.Monad.Trans.Writer.Strict
    Data.Functor.Constant Data.Functor.Reverse
abi: 650a984849062cc36a998e6c890bf69a
trusted: False
import-dirs: /usr/local/lib/ghc/transformers-0.5.2.0
library-dirs: /usr/local/lib/ghc/transformers-0.5.2.0
              /usr/local/lib/ghc/transformers-0.5.2.0
data-dir: /usr/local/share/i386-openbsd-ghc-8.2.2/transformers-0.5.2.0
hs-libraries: HStransformers-0.5.2.0
depends:
    base-4.10.1.0
abi-depends: base-4.10.1.0=3c10740f6cf9df7b9dca6d01ba411ea7
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/transformers-0.5.2.0/transformers.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/transformers-0.5.2.0
pkgroot: "/usr/obj/ports/ghc-8.2.2/fake-i386/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: ghci
version: 8.2.2
id: ghci-8.2.2
key: ghci-8.2.2
license: BSD3
maintainer: ghc-devs@haskell.org
synopsis: The library supporting GHC's interactive interpreter
description:
    This library offers interfaces which mediate interactions between the
    @ghci@ interactive shell and @iserv@, GHC's out-of-process interpreter
    backend.
category: GHC
exposed: True
indefinite: False
exposed-modules:
    GHCi.BreakArray GHCi.CreateBCO GHCi.FFI GHCi.InfoTable GHCi.Message
    GHCi.ObjLink GHCi.RemoteTypes GHCi.ResolvedBCO GHCi.Run
    GHCi.Signals GHCi.StaticPtrTable GHCi.TH GHCi.TH.Binary SizedSeq
abi: 00051a1ba1ccfd9947b0bd13766da652
trusted: False
import-dirs: /usr/local/lib/ghc/ghci-8.2.2
library-dirs: /usr/local/lib/ghc/ghci-8.2.2
              /usr/local/lib/ghc/ghci-8.2.2
data-dir: /usr/local/share/i386-openbsd-ghc-8.2.2/ghci-8.2.2
hs-libraries: HSghci-8.2.2
depends:
    array-0.5.2.0 base-4.10.1.0 binary-0.8.5.1 bytestring-0.10.8.2
    containers-0.5.10.2 deepseq-1.4.3.0 filepath-1.4.1.2 ghc-boot-8.2.2
    ghc-boot-th-8.2.2 template-haskell-2.12.0.0 transformers-0.5.2.0
    unix-2.7.2.2
abi-depends: array-0.5.2.0=c3a92ef97c0191e4bc82f0a7399f51b4
             base-4.10.1.0=3c10740f6cf9df7b9dca6d01ba411ea7
             binary-0.8.5.1=a96dcb415eb3046ea6a98be8bea83198
             bytestring-0.10.8.2=3f834c69e2158c4ad5032b0346c29480
             containers-0.5.10.2=a2c92baf4a812b005ca4fa7f0772cd30
             deepseq-1.4.3.0=a3192b565ae21910ed279f609cad2bc5
             filepath-1.4.1.2=ef9a1704901889a61779624199ca7499
             ghc-boot-8.2.2=7e02c4e8809872a4ae97cd79ef945f0b
             ghc-boot-th-8.2.2=3238f73fc62d93b870a169421fe85c54
             template-haskell-2.12.0.0=c86c34a1f7deb29023e2cbca17d693d7
             transformers-0.5.2.0=650a984849062cc36a998e6c890bf69a
             unix-2.7.2.2=fdb14956a5b19c6bc5b505e3d2c05085
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/ghci-8.2.2/ghci.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/ghci-8.2.2
pkgroot: "/usr/obj/ports/ghc-8.2.2/fake-i386/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: xhtml
version: 3000.2.2
id: xhtml-3000.2.2
key: xhtml-3000.2.2
license: BSD3
copyright: Bjorn Bringert 2004-2006, Andy Gill and the Oregon
           Graduate Institute of Science and Technology, 1999-2001
maintainer: Chris Dornan <chris@chrisdornan.com>
stability: Stable
homepage: https://github.com/haskell/xhtml
synopsis: An XHTML combinator library
description:
    This package provides combinators for producing
    XHTML 1.0, including the Strict, Transitional and
    Frameset variants.
category: Web, XML, Pretty Printer
author: Bjorn Bringert
exposed: True
indefinite: False
exposed-modules:
    Text.XHtml Text.XHtml.Debug Text.XHtml.Frameset Text.XHtml.Strict
    Text.XHtml.Table Text.XHtml.Transitional
hidden-modules: Text.XHtml.Strict.Attributes
                Text.XHtml.Strict.Elements Text.XHtml.Frameset.Attributes
                Text.XHtml.Frameset.Elements Text.XHtml.Transitional.Attributes
                Text.XHtml.Transitional.Elements Text.XHtml.BlockTable
                Text.XHtml.Extras Text.XHtml.Internals
abi: 5cb0c10110a0b2d8bb980b215363d8ed
trusted: False
import-dirs: /usr/local/lib/ghc/xhtml-3000.2.2
library-dirs: /usr/local/lib/ghc/xhtml-3000.2.2
              /usr/local/lib/ghc/xhtml-3000.2.2
data-dir: /usr/local/share/i386-openbsd-ghc-8.2.2/xhtml-3000.2.2
hs-libraries: HSxhtml-3000.2.2
depends:
    base-4.10.1.0
abi-depends: base-4.10.1.0=3c10740f6cf9df7b9dca6d01ba411ea7
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/xhtml-3000.2.2/xhtml.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/xhtml-3000.2.2
pkgroot: "/usr/obj/ports/ghc-8.2.2/fake-i386/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: terminfo
version: 0.4.1.0
id: terminfo-0.4.1.0
key: terminfo-0.4.1.0
license: BSD3
copyright: (c) Judah Jacobson
maintainer: Judah Jacobson <judah.jacobson@gmail.com>
stability: Stable
homepage: https://github.com/judah/terminfo
synopsis: Haskell bindings to the terminfo library.
description:
    This library provides an interface to the terminfo database (via bindings to the
    curses library).  <http://en.wikipedia.org/wiki/Terminfo Terminfo> allows POSIX
    systems to interact with a variety of terminals using a standard set of capabilities.
category: User Interfaces
author: Judah Jacobson
exposed: True
indefinite: False
exposed-modules:
    System.Console.Terminfo System.Console.Terminfo.Base
    System.Console.Terminfo.Color System.Console.Terminfo.Cursor
    System.Console.Terminfo.Edit System.Console.Terminfo.Effects
    System.Console.Terminfo.Keys
abi: a9de8e576c50bd8ff5e7eb0eb416decc
trusted: False
import-dirs: /usr/local/lib/ghc/terminfo-0.4.1.0
library-dirs: /usr/local/lib/ghc/terminfo-0.4.1.0
              /usr/local/lib/ghc/terminfo-0.4.1.0
data-dir: /usr/local/share/i386-openbsd-ghc-8.2.2/terminfo-0.4.1.0
hs-libraries: HSterminfo-0.4.1.0
extra-libraries:
    ncursesw
depends:
    base-4.10.1.0
abi-depends: base-4.10.1.0=3c10740f6cf9df7b9dca6d01ba411ea7
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/terminfo-0.4.1.0/terminfo.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/terminfo-0.4.1.0
pkgroot: "/usr/obj/ports/ghc-8.2.2/fake-i386/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: haskeline
version: 0.7.4.0
id: haskeline-0.7.4.0
key: haskeline-0.7.4.0
license: BSD3
copyright: (c) Judah Jacobson
maintainer: Judah Jacobson <judah.jacobson@gmail.com>
stability: Stable
homepage: http://trac.haskell.org/haskeline
synopsis: A command-line interface for user input, written in Haskell.
description:
    Haskeline provides a user interface for line input in command-line
    programs.  This library is similar in purpose to readline, but since
    it is written in Haskell it is (hopefully) more easily used in other
    Haskell programs.
    .
    Haskeline runs both on POSIX-compatible systems and on Windows.
category: User Interfaces
author: Judah Jacobson
exposed: True
indefinite: False
exposed-modules:
    System.Console.Haskeline System.Console.Haskeline.Completion
    System.Console.Haskeline.History System.Console.Haskeline.IO
    System.Console.Haskeline.MonadException
hidden-modules: System.Console.Haskeline.Backend
                System.Console.Haskeline.Backend.WCWidth
                System.Console.Haskeline.Command
                System.Console.Haskeline.Command.Completion
                System.Console.Haskeline.Command.History
                System.Console.Haskeline.Command.KillRing
                System.Console.Haskeline.Directory System.Console.Haskeline.Emacs
                System.Console.Haskeline.InputT System.Console.Haskeline.Key
                System.Console.Haskeline.LineState System.Console.Haskeline.Monads
                System.Console.Haskeline.Prefs System.Console.Haskeline.Recover
                System.Console.Haskeline.RunCommand System.Console.Haskeline.Term
                System.Console.Haskeline.Command.Undo System.Console.Haskeline.Vi
                System.Console.Haskeline.Backend.Posix
                System.Console.Haskeline.Backend.Posix.Encoder
                System.Console.Haskeline.Backend.DumbTerm
                System.Console.Haskeline.Backend.Terminfo
abi: d1ac42e782352910bdcce85fb0c283bd
trusted: False
import-dirs: /usr/local/lib/ghc/haskeline-0.7.4.0
library-dirs: /usr/local/lib/ghc/haskeline-0.7.4.0
              /usr/local/lib/ghc/haskeline-0.7.4.0
data-dir: /usr/local/share/i386-openbsd-ghc-8.2.2/haskeline-0.7.4.0
hs-libraries: HShaskeline-0.7.4.0
depends:
    base-4.10.1.0 containers-0.5.10.2 directory-1.3.0.2
    bytestring-0.10.8.2 filepath-1.4.1.2 transformers-0.5.2.0
    process-1.6.1.0 unix-2.7.2.2 terminfo-0.4.1.0
abi-depends: base-4.10.1.0=3c10740f6cf9df7b9dca6d01ba411ea7
             containers-0.5.10.2=a2c92baf4a812b005ca4fa7f0772cd30
             directory-1.3.0.2=1eef9b3048ad9e2e85c4a64b4bf56e7e
             bytestring-0.10.8.2=3f834c69e2158c4ad5032b0346c29480
             filepath-1.4.1.2=ef9a1704901889a61779624199ca7499
             transformers-0.5.2.0=650a984849062cc36a998e6c890bf69a
             process-1.6.1.0=6300085e5ed51248cf7e29323581f4ed
             unix-2.7.2.2=fdb14956a5b19c6bc5b505e3d2c05085
             terminfo-0.4.1.0=a9de8e576c50bd8ff5e7eb0eb416decc
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/haskeline-0.7.4.0/haskeline.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/haskeline-0.7.4.0
pkgroot: "/usr/obj/ports/ghc-8.2.2/fake-i386/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: ghc
version: 8.2.2
id: ghc-8.2.2
key: ghc-8.2.2
license: BSD3
maintainer: glasgow-haskell-users@haskell.org
homepage: http://www.haskell.org/ghc/
synopsis: The GHC API
description:
    GHC's functionality can be useful for more things than just
    compiling Haskell programs. Important use cases are programs
    that analyse (and perhaps transform) Haskell code. Others
    include loading Haskell code dynamically in a GHCi-like manner.
    For this reason, a lot of GHC's functionality is made available
    through this package.
category: Development
author: The GHC Team
exposed: False
indefinite: False
exposed-modules:
    Annotations, ApiAnnotation, AsmCodeGen, Avail, Bag, BasicTypes,
    BinFingerprint, BinIface, Binary, Bitmap, BkpSyn, BlockId,
    BooleanFormula, BufWrite, BuildTyCl, ByteCodeAsm, ByteCodeGen,
    ByteCodeInstr, ByteCodeItbls, ByteCodeLink, ByteCodeTypes, CLabel,
    CPrim, CSE, CallArity, CgUtils, Check, Class, CmdLineParser, Cmm,
    CmmBuildInfoTables, CmmCallConv, CmmCommonBlockElim,
    CmmContFlowOpt, CmmExpr, CmmImplementSwitchPlans, CmmInfo,
    CmmLayoutStack, CmmLex, CmmLint, CmmLive, CmmMachOp, CmmMonad,
    CmmNode, CmmOpt, CmmParse, CmmPipeline, CmmProcPoint, CmmSink,
    CmmSwitch, CmmType, CmmUtils, CoAxiom, CodeGen.Platform,
    CodeGen.Platform.ARM, CodeGen.Platform.ARM64,
    CodeGen.Platform.NoRegs, CodeGen.Platform.PPC,
    CodeGen.Platform.PPC_Darwin, CodeGen.Platform.SPARC,
    CodeGen.Platform.X86, CodeGen.Platform.X86_64, CodeOutput,
    Coercion, ConLike, Config, Constants, Convert, CoreArity, CoreFVs,
    CoreLint, CoreMonad, CoreOpt, CorePrep, CoreSeq, CoreStats,
    CoreSubst, CoreSyn, CoreTidy, CoreToStg, CoreUnfold, CoreUtils,
    CostCentre, Coverage, Ctype, DataCon, Debug, Debugger,
    DebuggerUtils, Demand, Desugar, Digraph, DmdAnal, DriverBkp,
    DriverMkDepend, DriverPhases, DriverPipeline, DsArrows, DsBinds,
    DsCCall, DsExpr, DsForeign, DsGRHSs, DsListComp, DsMeta, DsMonad,
    DsUsage, DsUtils, Dwarf, Dwarf.Constants, Dwarf.Types, DynFlags,
    DynamicLoading, Elf, Encoding, ErrUtils, Exception, FV, FamInst,
    FamInstEnv, FastFunctions, FastMutInt, FastString, FastStringEnv,
    FieldLabel, Finder, Fingerprint, FiniteMap, FlagChecker, FloatIn,
    FloatOut, ForeignCall, Format, FunDeps, GHC, GHCi, GhcMake,
    GhcMonad, GhcPlugins, GraphBase, GraphColor, GraphOps, GraphPpr,
    HaddockUtils, HeaderInfo, Hooks, Hoopl, Hoopl.Dataflow, HsBinds,
    HsDecls, HsDoc, HsDumpAst, HsExpr, HsImpExp, HsLit, HsPat, HsSyn,
    HsTypes, HsUtils, HscMain, HscStats, HscTypes, IOEnv, Id, IdInfo,
    IfaceEnv, IfaceSyn, IfaceType, Inst, InstEnv, Instruction,
    InteractiveEval, InteractiveEvalTypes, Json, Kind, KnownUniques,
    Lexeme, Lexer, LiberateCase, Linker, ListSetOps, ListT, Literal,
    Llvm, Llvm.AbsSyn, Llvm.MetaData, Llvm.PpLlvm, Llvm.Types,
    LlvmCodeGen, LlvmCodeGen.Base, LlvmCodeGen.CodeGen,
    LlvmCodeGen.Data, LlvmCodeGen.Ppr, LlvmCodeGen.Regs, LlvmMangler,
    LoadIface, Match, MatchCon, MatchLit, Maybes, MkCore, MkGraph,
    MkId, MkIface, Module, MonadUtils, NCGMonad, Name, NameCache,
    NameEnv, NameSet, NameShape, OccName, OccurAnal, OptCoercion,
    OrdList, Outputable, PIC, PPC.CodeGen, PPC.Cond, PPC.Instr,
    PPC.Ppr, PPC.RegInfo, PPC.Regs, PackageConfig, Packages, Pair,
    Panic, Parser, PatSyn, PipelineMonad, PlaceHolder, Platform,
    PlatformConstants, Plugins, PmExpr, PprBase, PprC, PprCmm,
    PprCmmDecl, PprCmmExpr, PprColour, PprCore, PprTyThing, PrelInfo,
    PrelNames, PrelRules, Pretty, PrimOp, ProfInit, RdrHsSyn, RdrName,
    Reg, RegAlloc.Graph.ArchBase, RegAlloc.Graph.ArchX86,
    RegAlloc.Graph.Coalesce, RegAlloc.Graph.Main, RegAlloc.Graph.Spill,
    RegAlloc.Graph.SpillClean, RegAlloc.Graph.SpillCost,
    RegAlloc.Graph.Stats, RegAlloc.Graph.TrivColorable,
    RegAlloc.Linear.Base, RegAlloc.Linear.FreeRegs,
    RegAlloc.Linear.JoinToTargets, RegAlloc.Linear.Main,
    RegAlloc.Linear.PPC.FreeRegs, RegAlloc.Linear.SPARC.FreeRegs,
    RegAlloc.Linear.StackMap, RegAlloc.Linear.State,
    RegAlloc.Linear.Stats, RegAlloc.Linear.X86.FreeRegs,
    RegAlloc.Linear.X86_64.FreeRegs, RegAlloc.Liveness, RegClass,
    RepType, RnBinds, RnEnv, RnExpr, RnHsDoc, RnModIface, RnNames,
    RnPat, RnSource, RnSplice, RnTypes, RtClosureInspect, Rules, SAT,
    SCCfinal, SMRep, SPARC.AddrMode, SPARC.Base, SPARC.CodeGen,
    SPARC.CodeGen.Amode, SPARC.CodeGen.Base, SPARC.CodeGen.CondCode,
    SPARC.CodeGen.Expand, SPARC.CodeGen.Gen32, SPARC.CodeGen.Gen64,
    SPARC.CodeGen.Sanity, SPARC.Cond, SPARC.Imm, SPARC.Instr,
    SPARC.Ppr, SPARC.Regs, SPARC.ShortcutJump, SPARC.Stack,
    Serialized from ghc-boot-8.2.2:GHC.Serialized, SetLevels,
    SimplCore, SimplEnv, SimplMonad, SimplStg, SimplUtils, Simplify,
    SpecConstr, Specialise, SrcLoc, State, StaticPtrTable, StgCmm,
    StgCmmArgRep, StgCmmBind, StgCmmClosure, StgCmmCon, StgCmmEnv,
    StgCmmExpr, StgCmmExtCode, StgCmmForeign, StgCmmHeap, StgCmmHpc,
    StgCmmLayout, StgCmmMonad, StgCmmPrim, StgCmmProf, StgCmmTicky,
    StgCmmUtils, StgCse, StgLint, StgStats, StgSyn, Stream,
    StringBuffer, SysTools, SysTools.Terminal, THNames, TargetReg,
    TcAnnotations, TcArrows, TcBackpack, TcBinds, TcCanonical,
    TcClassDcl, TcDefaults, TcDeriv, TcDerivInfer, TcDerivUtils, TcEnv,
    TcErrors, TcEvidence, TcExpr, TcFlatten, TcForeign, TcGenDeriv,
    TcGenFunctor, TcGenGenerics, TcHsSyn, TcHsType, TcIface,
    TcInstDcls, TcInteract, TcMType, TcMatches, TcPat, TcPatSyn,
    TcPluginM, TcRnDriver, TcRnExports, TcRnMonad, TcRnTypes, TcRules,
    TcSMonad, TcSigs, TcSimplify, TcSplice, TcTyClsDecls, TcTyDecls,
    TcType, TcTypeNats, TcTypeable, TcUnify, TcValidity, TidyPgm,
    TmOracle, ToIface, TrieMap, TyCoRep, TyCon, Type, TysPrim,
    TysWiredIn, UnVarGraph, UnariseStg, Unify, UniqDFM, UniqDSet,
    UniqFM, UniqSet, UniqSupply, Unique, Util, Var, VarEnv, VarSet,
    Vectorise, Vectorise.Builtins, Vectorise.Builtins.Base,
    Vectorise.Builtins.Initialise, Vectorise.Convert, Vectorise.Env,
    Vectorise.Exp, Vectorise.Generic.Description,
    Vectorise.Generic.PADict, Vectorise.Generic.PAMethods,
    Vectorise.Generic.PData, Vectorise.Monad, Vectorise.Monad.Base,
    Vectorise.Monad.Global, Vectorise.Monad.InstEnv,
    Vectorise.Monad.Local, Vectorise.Monad.Naming,
    Vectorise.Type.Classify, Vectorise.Type.Env,
    Vectorise.Type.TyConDecl, Vectorise.Type.Type, Vectorise.Utils,
    Vectorise.Utils.Base, Vectorise.Utils.Closure,
    Vectorise.Utils.Hoisting, Vectorise.Utils.PADict,
    Vectorise.Utils.Poly, Vectorise.Var, Vectorise.Vect, WorkWrap,
    WwLib, X86.CodeGen, X86.Cond, X86.Instr, X86.Ppr, X86.RegInfo,
    X86.Regs
abi: 2c98798b6a7392b29182505aedee163f
trusted: False
import-dirs: /usr/local/lib/ghc/ghc-8.2.2
library-dirs: /usr/local/lib/ghc/ghc-8.2.2
              /usr/local/lib/ghc/ghc-8.2.2
data-dir: /usr/local/share/i386-openbsd-ghc-8.2.2/ghc-8.2.2
hs-libraries: HSghc-8.2.2
include-dirs: /usr/local/lib/ghc/ghc-8.2.2/include
depends:
    base-4.10.1.0 deepseq-1.4.3.0 directory-1.3.0.2 process-1.6.1.0
    bytestring-0.10.8.2 binary-0.8.5.1 time-1.8.0.2 containers-0.5.10.2
    array-0.5.2.0 filepath-1.4.1.2 template-haskell-2.12.0.0
    hpc-0.6.0.3 transformers-0.5.2.0 ghc-boot-8.2.2 ghc-boot-th-8.2.2
    ghci-8.2.2 hoopl-3.10.2.2 unix-2.7.2.2 terminfo-0.4.1.0
abi-depends: base-4.10.1.0=3c10740f6cf9df7b9dca6d01ba411ea7
             deepseq-1.4.3.0=a3192b565ae21910ed279f609cad2bc5
             directory-1.3.0.2=1eef9b3048ad9e2e85c4a64b4bf56e7e
             process-1.6.1.0=6300085e5ed51248cf7e29323581f4ed
             bytestring-0.10.8.2=3f834c69e2158c4ad5032b0346c29480
             binary-0.8.5.1=a96dcb415eb3046ea6a98be8bea83198
             time-1.8.0.2=4e7e761020e68f00617832ab1b4f94d5
             containers-0.5.10.2=a2c92baf4a812b005ca4fa7f0772cd30
             array-0.5.2.0=c3a92ef97c0191e4bc82f0a7399f51b4
             filepath-1.4.1.2=ef9a1704901889a61779624199ca7499
             template-haskell-2.12.0.0=c86c34a1f7deb29023e2cbca17d693d7
             hpc-0.6.0.3=5652ca99bf346707bd8b4b1e5fc76dbc
             transformers-0.5.2.0=650a984849062cc36a998e6c890bf69a
             ghc-boot-8.2.2=7e02c4e8809872a4ae97cd79ef945f0b
             ghc-boot-th-8.2.2=3238f73fc62d93b870a169421fe85c54
             ghci-8.2.2=00051a1ba1ccfd9947b0bd13766da652
             hoopl-3.10.2.2=976ef256e3a4dac14ada0d90bd3026fc
             unix-2.7.2.2=fdb14956a5b19c6bc5b505e3d2c05085
             terminfo-0.4.1.0=a9de8e576c50bd8ff5e7eb0eb416decc
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/ghc-8.2.2/ghc.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/ghc-8.2.2
pkgroot: "/usr/obj/ports/ghc-8.2.2/fake-i386/usr/local/lib/ghc"

EOF
