/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.instruction.fast.visitor;

import java.util.List;
import jd.core.model.instruction.bytecode.instruction.ANewArray;
import jd.core.model.instruction.bytecode.instruction.AThrow;
import jd.core.model.instruction.bytecode.instruction.ArrayLength;
import jd.core.model.instruction.bytecode.instruction.ArrayStoreInstruction;
import jd.core.model.instruction.bytecode.instruction.AssertInstruction;
import jd.core.model.instruction.bytecode.instruction.BinaryOperatorInstruction;
import jd.core.model.instruction.bytecode.instruction.CheckCast;
import jd.core.model.instruction.bytecode.instruction.ComplexConditionalBranchInstruction;
import jd.core.model.instruction.bytecode.instruction.ConvertInstruction;
import jd.core.model.instruction.bytecode.instruction.DupStore;
import jd.core.model.instruction.bytecode.instruction.GetField;
import jd.core.model.instruction.bytecode.instruction.IfCmp;
import jd.core.model.instruction.bytecode.instruction.IfInstruction;
import jd.core.model.instruction.bytecode.instruction.IncInstruction;
import jd.core.model.instruction.bytecode.instruction.InitArrayInstruction;
import jd.core.model.instruction.bytecode.instruction.InstanceOf;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.InvokeInstruction;
import jd.core.model.instruction.bytecode.instruction.InvokeNew;
import jd.core.model.instruction.bytecode.instruction.InvokeNoStaticInstruction;
import jd.core.model.instruction.bytecode.instruction.LookupSwitch;
import jd.core.model.instruction.bytecode.instruction.MonitorEnter;
import jd.core.model.instruction.bytecode.instruction.MonitorExit;
import jd.core.model.instruction.bytecode.instruction.MultiANewArray;
import jd.core.model.instruction.bytecode.instruction.NewArray;
import jd.core.model.instruction.bytecode.instruction.Pop;
import jd.core.model.instruction.bytecode.instruction.PutField;
import jd.core.model.instruction.bytecode.instruction.PutStatic;
import jd.core.model.instruction.bytecode.instruction.ReturnInstruction;
import jd.core.model.instruction.bytecode.instruction.StoreInstruction;
import jd.core.model.instruction.bytecode.instruction.TableSwitch;
import jd.core.model.instruction.bytecode.instruction.TernaryOpStore;
import jd.core.model.instruction.bytecode.instruction.TernaryOperator;
import jd.core.model.instruction.bytecode.instruction.UnaryOperatorInstruction;
import jd.core.model.instruction.fast.instruction.FastDeclaration;
import jd.core.model.instruction.fast.instruction.FastSynchronized;
import jd.core.model.instruction.fast.instruction.FastTestList;
import jd.core.model.instruction.fast.instruction.FastTry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplaceInstructionVisitor {
    private int offset;
    private Instruction newInstruction;
    private Instruction oldInstruction;

    public ReplaceInstructionVisitor(int offset, Instruction newInstruction) {
        this.init(offset, newInstruction);
    }

    public void init(int offset, Instruction newInstruction) {
        this.offset = offset;
        this.newInstruction = newInstruction;
        this.oldInstruction = null;
    }

    public void visit(Instruction instruction) {
        switch (instruction.opcode) {
            case 190: {
                ArrayLength al = (ArrayLength)instruction;
                if (al.arrayref.offset == this.offset) {
                    this.oldInstruction = al.arrayref;
                    al.arrayref = this.newInstruction;
                    break;
                }
                this.visit(al.arrayref);
                break;
            }
            case 83: 
            case 272: {
                ArrayStoreInstruction asi = (ArrayStoreInstruction)instruction;
                if (asi.arrayref.offset == this.offset) {
                    this.oldInstruction = asi.arrayref;
                    asi.arrayref = this.newInstruction;
                    break;
                }
                this.visit(asi.arrayref);
                if (this.oldInstruction != null) break;
                if (asi.indexref.offset == this.offset) {
                    this.oldInstruction = asi.indexref;
                    asi.indexref = this.newInstruction;
                    break;
                }
                this.visit(asi.indexref);
                if (this.oldInstruction != null) break;
                if (asi.valueref.offset == this.offset) {
                    this.oldInstruction = asi.valueref;
                    asi.valueref = this.newInstruction;
                    break;
                }
                this.visit(asi.valueref);
                break;
            }
            case 286: {
                AssertInstruction ai = (AssertInstruction)instruction;
                if (ai.test.offset == this.offset) {
                    this.oldInstruction = ai.test;
                    ai.test = this.newInstruction;
                    break;
                }
                this.visit(ai.test);
                if (this.oldInstruction != null || ai.msg == null) break;
                if (ai.msg.offset == this.offset) {
                    this.oldInstruction = ai.msg;
                    ai.msg = this.newInstruction;
                    break;
                }
                this.visit(ai.msg);
                break;
            }
            case 191: {
                AThrow aThrow = (AThrow)instruction;
                if (aThrow.value.offset == this.offset) {
                    this.oldInstruction = aThrow.value;
                    aThrow.value = this.newInstruction;
                    break;
                }
                this.visit(aThrow.value);
                break;
            }
            case 266: {
                UnaryOperatorInstruction uoi = (UnaryOperatorInstruction)instruction;
                if (uoi.value.offset == this.offset) {
                    this.oldInstruction = uoi.value;
                    uoi.value = this.newInstruction;
                    break;
                }
                this.visit(uoi.value);
                break;
            }
            case 265: 
            case 267: {
                BinaryOperatorInstruction boi = (BinaryOperatorInstruction)instruction;
                if (boi.value1.offset == this.offset) {
                    this.oldInstruction = boi.value1;
                    boi.value1 = this.newInstruction;
                    break;
                }
                this.visit(boi.value1);
                if (this.oldInstruction != null) break;
                if (boi.value2.offset == this.offset) {
                    this.oldInstruction = boi.value2;
                    boi.value2 = this.newInstruction;
                    break;
                }
                this.visit(boi.value2);
                break;
            }
            case 192: {
                CheckCast checkCast = (CheckCast)instruction;
                if (checkCast.objectref.offset == this.offset) {
                    this.oldInstruction = checkCast.objectref;
                    checkCast.objectref = this.newInstruction;
                    break;
                }
                this.visit(checkCast.objectref);
                break;
            }
            case 54: 
            case 58: 
            case 269: {
                StoreInstruction storeInstruction = (StoreInstruction)instruction;
                if (storeInstruction.valueref.offset == this.offset) {
                    this.oldInstruction = storeInstruction.valueref;
                    storeInstruction.valueref = this.newInstruction;
                    break;
                }
                this.visit(storeInstruction.valueref);
                break;
            }
            case 264: {
                DupStore dupStore = (DupStore)instruction;
                if (dupStore.objectref.offset == this.offset) {
                    this.oldInstruction = dupStore.objectref;
                    dupStore.objectref = this.newInstruction;
                    break;
                }
                this.visit(dupStore.objectref);
                break;
            }
            case 275: 
            case 276: {
                ConvertInstruction ci = (ConvertInstruction)instruction;
                if (ci.value.offset == this.offset) {
                    this.oldInstruction = ci.value;
                    ci.value = this.newInstruction;
                    break;
                }
                this.visit(ci.value);
                break;
            }
            case 261: {
                IfCmp ifCmp = (IfCmp)instruction;
                if (ifCmp.value1.offset == this.offset) {
                    this.oldInstruction = ifCmp.value1;
                    ifCmp.value1 = this.newInstruction;
                    break;
                }
                this.visit(ifCmp.value1);
                if (this.oldInstruction != null) break;
                if (ifCmp.value2.offset == this.offset) {
                    this.oldInstruction = ifCmp.value2;
                    ifCmp.value2 = this.newInstruction;
                    break;
                }
                this.visit(ifCmp.value2);
                break;
            }
            case 260: 
            case 262: {
                IfInstruction iff = (IfInstruction)instruction;
                if (iff.value.offset == this.offset) {
                    this.oldInstruction = iff.value;
                    iff.value = this.newInstruction;
                    break;
                }
                this.visit(iff.value);
                break;
            }
            case 284: {
                List<Instruction> branchList = ((ComplexConditionalBranchInstruction)instruction).instructions;
                int i = branchList.size() - 1;
                while (i >= 0) {
                    this.visit(branchList.get(i));
                    --i;
                }
                break;
            }
            case 193: {
                InstanceOf instanceOf = (InstanceOf)instruction;
                if (instanceOf.objectref.offset == this.offset) {
                    this.oldInstruction = instanceOf.objectref;
                    instanceOf.objectref = this.newInstruction;
                    break;
                }
                this.visit(instanceOf.objectref);
                break;
            }
            case 182: 
            case 183: 
            case 185: {
                InvokeNoStaticInstruction insi = (InvokeNoStaticInstruction)instruction;
                if (insi.objectref.offset == this.offset) {
                    this.oldInstruction = insi.objectref;
                    insi.objectref = this.newInstruction;
                } else {
                    this.visit(insi.objectref);
                }
            }
            case 184: {
                List<Instruction> list = ((InvokeInstruction)instruction).args;
                int i = list.size() - 1;
                while (i >= 0 && this.oldInstruction == null) {
                    Instruction instuction = list.get(i);
                    if (instuction.offset == this.offset) {
                        this.oldInstruction = instuction;
                        list.set(i, this.newInstruction);
                    } else {
                        this.visit(instuction);
                    }
                    --i;
                }
                break;
            }
            case 274: {
                List list = ((InvokeNew)instruction).args;
                int i = list.size() - 1;
                while (i >= 0 && this.oldInstruction == null) {
                    Instruction instuction = (Instruction)list.get(i);
                    if (instuction.offset == this.offset) {
                        this.oldInstruction = instuction;
                        list.set(i, this.newInstruction);
                    } else {
                        this.visit(instuction);
                    }
                    --i;
                }
                break;
            }
            case 171: {
                LookupSwitch ls = (LookupSwitch)instruction;
                if (ls.key.offset == this.offset) {
                    this.oldInstruction = ls.key;
                    ls.key = this.newInstruction;
                    break;
                }
                this.visit(ls.key);
                break;
            }
            case 194: {
                MonitorEnter monitorEnter = (MonitorEnter)instruction;
                if (monitorEnter.objectref.offset == this.offset) {
                    this.oldInstruction = monitorEnter.objectref;
                    monitorEnter.objectref = this.newInstruction;
                    break;
                }
                this.visit(monitorEnter.objectref);
                break;
            }
            case 195: {
                MonitorExit monitorExit = (MonitorExit)instruction;
                if (monitorExit.objectref.offset == this.offset) {
                    this.oldInstruction = monitorExit.objectref;
                    monitorExit.objectref = this.newInstruction;
                    break;
                }
                this.visit(monitorExit.objectref);
                break;
            }
            case 197: {
                Instruction[] dimensions = ((MultiANewArray)instruction).dimensions;
                int i = dimensions.length - 1;
                while (i >= 0 && this.oldInstruction == null) {
                    if (dimensions[i].offset == this.offset) {
                        this.oldInstruction = dimensions[i];
                        dimensions[i] = this.newInstruction;
                    } else {
                        this.visit(dimensions[i]);
                    }
                    --i;
                }
                break;
            }
            case 188: {
                NewArray newArray = (NewArray)instruction;
                if (newArray.dimension.offset == this.offset) {
                    this.oldInstruction = newArray.dimension;
                    newArray.dimension = this.newInstruction;
                    break;
                }
                this.visit(newArray.dimension);
                break;
            }
            case 189: {
                ANewArray aNewArray = (ANewArray)instruction;
                if (aNewArray.dimension.offset == this.offset) {
                    this.oldInstruction = aNewArray.dimension;
                    aNewArray.dimension = this.newInstruction;
                    break;
                }
                this.visit(aNewArray.dimension);
                break;
            }
            case 87: {
                Pop pop = (Pop)instruction;
                if (pop.objectref.offset == this.offset) {
                    this.oldInstruction = pop.objectref;
                    pop.objectref = this.newInstruction;
                    break;
                }
                this.visit(pop.objectref);
                break;
            }
            case 181: {
                PutField putField = (PutField)instruction;
                if (putField.objectref.offset == this.offset) {
                    this.oldInstruction = putField.objectref;
                    putField.objectref = this.newInstruction;
                    break;
                }
                this.visit(putField.objectref);
                if (this.oldInstruction != null) break;
                if (putField.valueref.offset == this.offset) {
                    this.oldInstruction = putField.valueref;
                    putField.valueref = this.newInstruction;
                    break;
                }
                this.visit(putField.valueref);
                break;
            }
            case 179: {
                PutStatic putStatic = (PutStatic)instruction;
                if (putStatic.valueref.offset == this.offset) {
                    this.oldInstruction = putStatic.valueref;
                    putStatic.valueref = this.newInstruction;
                    break;
                }
                this.visit(putStatic.valueref);
                break;
            }
            case 273: {
                ReturnInstruction ri = (ReturnInstruction)instruction;
                if (ri.valueref.offset == this.offset) {
                    this.oldInstruction = ri.valueref;
                    ri.valueref = this.newInstruction;
                    break;
                }
                this.visit(ri.valueref);
                break;
            }
            case 170: {
                TableSwitch ts = (TableSwitch)instruction;
                if (ts.key.offset == this.offset) {
                    this.oldInstruction = ts.key;
                    ts.key = this.newInstruction;
                    break;
                }
                this.visit(ts.key);
                break;
            }
            case 280: {
                TernaryOpStore tos = (TernaryOpStore)instruction;
                if (tos.objectref.offset == this.offset) {
                    this.oldInstruction = tos.objectref;
                    tos.objectref = this.newInstruction;
                    break;
                }
                this.visit(tos.objectref);
                break;
            }
            case 277: 
            case 278: {
                IncInstruction ii = (IncInstruction)instruction;
                if (ii.value.offset == this.offset) {
                    this.oldInstruction = ii.value;
                    ii.value = this.newInstruction;
                    break;
                }
                this.visit(ii.value);
                break;
            }
            case 180: {
                GetField gf = (GetField)instruction;
                if (gf.objectref.offset == this.offset) {
                    this.oldInstruction = gf.objectref;
                    gf.objectref = this.newInstruction;
                    break;
                }
                this.visit(gf.objectref);
                break;
            }
            case 282: 
            case 283: {
                InitArrayInstruction iai = (InitArrayInstruction)instruction;
                if (iai.newArray.offset == this.offset) {
                    this.oldInstruction = iai.newArray;
                    iai.newArray = this.newInstruction;
                    break;
                }
                this.visit(iai.newArray);
                if (iai.values == null) break;
                this.visit(iai.values);
                break;
            }
            case 281: {
                TernaryOperator to = (TernaryOperator)instruction;
                if (to.test.offset == this.offset) {
                    this.oldInstruction = to.test;
                    to.test = this.newInstruction;
                    break;
                }
                this.visit(to.test);
                if (this.oldInstruction != null) break;
                if (to.value1.offset == this.offset) {
                    this.oldInstruction = to.value1;
                    to.value1 = this.newInstruction;
                    break;
                }
                this.visit(to.value1);
                if (this.oldInstruction != null) break;
                if (to.value2.offset == this.offset) {
                    this.oldInstruction = to.value2;
                    to.value2 = this.newInstruction;
                    break;
                }
                this.visit(to.value2);
                break;
            }
            case 318: {
                FastTry ft = (FastTry)instruction;
                this.visit(ft.instructions);
                if (this.oldInstruction != null) break;
                if (ft.finallyInstructions != null) {
                    this.visit(ft.finallyInstructions);
                }
                int i = ft.catches.size() - 1;
                while (i >= 0 && this.oldInstruction == null) {
                    this.visit(ft.catches.get((int)i).instructions);
                    --i;
                }
                break;
            }
            case 317: {
                FastDeclaration fd = (FastDeclaration)instruction;
                if (fd.instruction == null) break;
                if (fd.instruction.offset == this.offset) {
                    this.oldInstruction = fd.instruction;
                    fd.instruction = this.newInstruction;
                    break;
                }
                this.visit(fd.instruction);
                break;
            }
            case 319: {
                FastSynchronized fsy = (FastSynchronized)instruction;
                if (fsy.monitor.offset == this.offset) {
                    this.oldInstruction = fsy.monitor;
                    fsy.monitor = this.newInstruction;
                    break;
                }
                this.visit(fsy.monitor);
                if (this.oldInstruction != null) break;
                this.visit(fsy.instructions);
                break;
            }
            case 306: {
                FastTestList ftl = (FastTestList)instruction;
                if (ftl.test.offset == this.offset) {
                    this.oldInstruction = ftl.test;
                    ftl.test = this.newInstruction;
                    break;
                }
                this.visit(ftl.test);
                if (this.oldInstruction != null || ftl.instructions == null) break;
                this.visit(ftl.instructions);
                break;
            }
            case 0: 
            case 1: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 25: 
            case 132: 
            case 167: 
            case 168: 
            case 169: 
            case 177: 
            case 178: 
            case 187: 
            case 256: 
            case 257: 
            case 258: 
            case 259: 
            case 263: 
            case 268: 
            case 270: 
            case 271: 
            case 279: 
            case 285: {
                break;
            }
            default: {
                System.err.println("Can not replace code in " + instruction.getClass().getName() + ", opcode=" + instruction.opcode);
            }
        }
    }

    private void visit(List<Instruction> instructions) {
        int i = instructions.size() - 1;
        while (i >= 0) {
            this.visit(instructions.get(i));
            --i;
        }
    }

    public Instruction getOldInstruction() {
        return this.oldInstruction;
    }
}

