/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.utils.struct;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.jcs.engine.control.group.GroupAttrName;
import org.apache.commons.jcs.engine.stats.StatElement;
import org.apache.commons.jcs.engine.stats.Stats;
import org.apache.commons.jcs.engine.stats.behavior.IStats;
import org.apache.commons.jcs.utils.struct.DoubleLinkedList;
import org.apache.commons.jcs.utils.struct.LRUElementDescriptor;
import org.apache.commons.jcs.utils.struct.LRUMapEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractLRUMap<K, V>
implements Map<K, V> {
    private static final Log log = LogFactory.getLog(AbstractLRUMap.class);
    private final DoubleLinkedList<LRUElementDescriptor<K, V>> list;
    private final Map<K, LRUElementDescriptor<K, V>> map;
    private final Lock lock = new ReentrantLock();
    private long hitCnt = 0L;
    private long missCnt = 0L;
    private long putCnt = 0L;

    public AbstractLRUMap() {
        this.list = new DoubleLinkedList();
        this.map = new ConcurrentHashMap<K, LRUElementDescriptor<K, V>>();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public void clear() {
        this.lock.lock();
        try {
            this.map.clear();
            this.list.removeAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Collection<V> values() {
        ArrayList valueList = new ArrayList(this.map.size());
        for (LRUElementDescriptor<K, V> value : this.map.values()) {
            valueList.add(value.getPayload());
        }
        return valueList;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> source) {
        if (source != null) {
            for (Map.Entry<K, V> entry : source.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public V get(Object key) {
        V retVal;
        LRUElementDescriptor<K, V> me;
        if (log.isDebugEnabled()) {
            log.debug("getting item  for key " + key);
        }
        if ((me = this.map.get(key)) == null) {
            ++this.missCnt;
            retVal = null;
        } else {
            ++this.hitCnt;
            retVal = (V)me.getPayload();
            this.list.makeFirst(me);
        }
        if (log.isDebugEnabled()) {
            if (me == null) {
                log.debug("LRUMap miss for " + key);
            } else {
                log.debug("LRUMap hit for " + key);
            }
        }
        return retVal;
    }

    public V getQuiet(Object key) {
        V ce = null;
        LRUElementDescriptor<K, V> me = this.map.get(key);
        if (me != null) {
            ce = (V)me.getPayload();
        }
        if (log.isDebugEnabled()) {
            if (me == null) {
                log.debug("LRUMap quiet miss for " + key);
            } else {
                log.debug("LRUMap quiet hit for " + key);
            }
        }
        return ce;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        if (log.isDebugEnabled()) {
            log.debug("removing item for key: " + key);
        }
        this.lock.lock();
        try {
            LRUElementDescriptor<K, V> me = this.map.remove(key);
            if (me != null) {
                this.list.remove(me);
                Object t = me.getPayload();
                return (V)t;
            }
        }
        finally {
            this.lock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        ++this.putCnt;
        LRUElementDescriptor<K, V> old = null;
        LRUElementDescriptor<K, V> me = new LRUElementDescriptor<K, V>(key, value);
        this.lock.lock();
        try {
            this.list.addFirst(me);
            old = this.map.put(key, me);
            if (old != null && key.equals(old.getKey())) {
                this.list.remove(old);
            }
        }
        finally {
            this.lock.unlock();
        }
        if (this.shouldRemove()) {
            if (log.isDebugEnabled()) {
                log.debug("In memory limit reached, removing least recently used.");
            }
            while (this.shouldRemove()) {
                this.lock.lock();
                try {
                    LRUElementDescriptor<K, V> last = this.list.getLast();
                    if (last != null) {
                        this.processRemovedLRU(last.getKey(), last.getPayload());
                        if (this.map.remove(last.getKey()) == null) {
                            log.warn("update: remove failed for key: " + last.getKey());
                            this.verifyCache();
                        }
                        this.list.removeLast();
                        continue;
                    }
                    this.verifyCache();
                    throw new Error("update: last is null!");
                }
                finally {
                    this.lock.unlock();
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("update: After spool map size: " + this.map.size());
            }
            if (this.map.size() != this.list.size()) {
                log.error("update: After spool, size mismatch: map.size() = " + this.map.size() + ", linked list size = " + this.list.size());
            }
        }
        if (old != null) {
            return (V)old.getPayload();
        }
        return null;
    }

    protected abstract boolean shouldRemove();

    public void dumpCacheEntries() {
        log.debug("dumpingCacheEntries");
        LRUElementDescriptor me = this.list.getFirst();
        while (me != null) {
            if (log.isDebugEnabled()) {
                log.debug("dumpCacheEntries> key=" + me.getKey() + ", val=" + me.getPayload());
            }
            me = (LRUElementDescriptor)me.next;
        }
    }

    public void dumpMap() {
        log.debug("dumpingMap");
        for (Map.Entry<K, LRUElementDescriptor<K, V>> e : this.map.entrySet()) {
            LRUElementDescriptor<K, V> me = e.getValue();
            if (!log.isDebugEnabled()) continue;
            log.debug("dumpMap> key=" + e.getKey() + ", val=" + me.getPayload());
        }
    }

    protected void verifyCache() {
        if (!log.isDebugEnabled()) {
            return;
        }
        boolean found = false;
        log.debug("verifycache: mapContains " + this.map.size() + " elements, linked list contains " + this.list.size() + " elements");
        log.debug("verifycache: checking linked list by key ");
        LRUElementDescriptor li = this.list.getFirst();
        while (li != null) {
            K key = li.getKey();
            if (!this.map.containsKey(key)) {
                log.error("verifycache: map does not contain key : " + li.getKey());
                log.error("li.hashcode=" + li.getKey().hashCode());
                log.error("key class=" + key.getClass());
                log.error("key hashcode=" + key.hashCode());
                log.error("key toString=" + key.toString());
                if (key instanceof GroupAttrName) {
                    GroupAttrName name = (GroupAttrName)key;
                    log.error("GroupID hashcode=" + name.groupId.hashCode());
                    log.error("GroupID.class=" + name.groupId.getClass());
                    log.error("AttrName hashcode=" + name.attrName.hashCode());
                    log.error("AttrName.class=" + name.attrName.getClass());
                }
                this.dumpMap();
            } else if (this.map.get(li.getKey()) == null) {
                log.error("verifycache: linked list retrieval returned null for key: " + li.getKey());
            }
            li = (LRUElementDescriptor)li.next;
        }
        log.debug("verifycache: checking linked list by value ");
        LRUElementDescriptor li3 = this.list.getFirst();
        while (li3 != null) {
            if (!this.map.containsValue(li3)) {
                log.error("verifycache: map does not contain value : " + li3);
                this.dumpMap();
            }
            li3 = (LRUElementDescriptor)li3.next;
        }
        log.debug("verifycache: checking via keysets!");
        Iterator<K> itr2 = this.map.keySet().iterator();
        while (itr2.hasNext()) {
            found = false;
            Serializable val = null;
            try {
                val = (Serializable)itr2.next();
            }
            catch (NoSuchElementException nse) {
                log.error("verifycache: no such element exception");
                continue;
            }
            LRUElementDescriptor li2 = this.list.getFirst();
            while (li2 != null) {
                if (val.equals(li2.getKey())) {
                    found = true;
                    break;
                }
                li2 = (LRUElementDescriptor)li2.next;
            }
            if (found) continue;
            log.error("verifycache: key not found in list : " + val);
            this.dumpCacheEntries();
            if (this.map.containsKey(val)) {
                log.error("verifycache: map contains key");
                continue;
            }
            log.error("verifycache: map does NOT contain key, what the HECK!");
        }
    }

    protected void processRemovedLRU(K key, V value) {
        if (log.isDebugEnabled()) {
            log.debug("Removing key: [" + key + "] from LRUMap store, value = [" + value + "]");
            log.debug("LRUMap store size: '" + this.size() + "'.");
        }
    }

    public IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("LRUMap");
        ArrayList elems = new ArrayList();
        elems.add(new StatElement<Integer>("List Size", this.list.size()));
        elems.add(new StatElement<Integer>("Map Size", this.map.size()));
        elems.add(new StatElement<Long>("Put Count", this.putCnt));
        elems.add(new StatElement<Long>("Hit Count", this.hitCnt));
        elems.add(new StatElement<Long>("Miss Count", this.missCnt));
        stats.setStatElements(elems);
        return stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.lock.lock();
        try {
            Set<Map.Entry<K, LRUElementDescriptor<K, V>>> entries = this.map.entrySet();
            HashSet unWrapped = new HashSet();
            for (Map.Entry<K, LRUElementDescriptor<K, V>> pre : entries) {
                LRUMapEntry post = new LRUMapEntry(pre.getKey(), pre.getValue().getPayload());
                unWrapped.add(post);
            }
            HashSet hashSet = unWrapped;
            return hashSet;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }
}

