/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.oauth;

import java.awt.Component;
import java.io.IOException;
import org.openstreetmap.josm.data.oauth.OAuthParameters;
import org.openstreetmap.josm.data.oauth.OAuthToken;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.oauth.OsmOAuthAuthorizationClient;
import org.openstreetmap.josm.gui.oauth.OsmOAuthAuthorizationException;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.OsmTransferCanceledException;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.xml.sax.SAXException;

public class RetrieveRequestTokenTask
extends PleaseWaitRunnable {
    private boolean canceled;
    private OAuthToken requestToken;
    private final OAuthParameters parameters;
    private OsmOAuthAuthorizationClient client;
    private final Component parent;

    public RetrieveRequestTokenTask(Component parent, OAuthParameters parameters) {
        super(parent, I18n.tr("Retrieving OAuth Request Token...", new Object[0]), false);
        CheckParameterUtil.ensureParameterNotNull(parameters, "parameters");
        this.parameters = parameters;
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cancel() {
        this.canceled = true;
        RetrieveRequestTokenTask retrieveRequestTokenTask = this;
        synchronized (retrieveRequestTokenTask) {
            if (this.client != null) {
                this.client.cancel();
            }
        }
    }

    @Override
    protected void finish() {
    }

    protected void alertRetrievingRequestTokenFailed() {
        HelpAwareOptionPane.showOptionDialog(this.parent, I18n.tr("<html>Retrieving an OAuth Request Token from ''{0}'' failed.</html>", this.parameters.getRequestTokenUrl()), I18n.tr("Request Failed", new Object[0]), 0, HelpUtil.ht("/OAuth#NotAuthorizedException"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void realRun() throws SAXException, IOException, OsmTransferException {
        try {
            RetrieveRequestTokenTask retrieveRequestTokenTask = this;
            synchronized (retrieveRequestTokenTask) {
                this.client = new OsmOAuthAuthorizationClient(this.parameters);
            }
            this.requestToken = this.client.getRequestToken(this.getProgressMonitor().createSubTaskMonitor(0, false));
        }
        catch (OsmTransferCanceledException e) {
            Logging.trace(e);
            return;
        }
        catch (OsmOAuthAuthorizationException e) {
            Logging.error(e);
            GuiHelper.runInEDT(this::alertRetrievingRequestTokenFailed);
            this.requestToken = null;
        }
        finally {
            RetrieveRequestTokenTask retrieveRequestTokenTask = this;
            synchronized (retrieveRequestTokenTask) {
                this.client = null;
            }
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public OAuthToken getRequestToken() {
        return this.requestToken;
    }
}

