/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0.0lf - dvec2(-0.10000000000000001lf, -1.2lf)) => dvec2(0.10000000000000001lf, 1.2lf)
 * (0.0lf - dvec2(-0.41999999999999998lf, 0.47999999999999998lf)) => dvec2(0.41999999999999998lf, -0.47999999999999998lf)
 * (-1.3333333333333333lf - dvec2(-0.10000000000000001lf, -1.2lf)) => dvec2(-1.2333333333333332lf, -0.1333333333333333lf)
 * (-1.3333333333333333lf - dvec2(-0.41999999999999998lf, 0.47999999999999998lf)) => dvec2(-0.91333333333333333lf, -1.8133333333333332lf)
 * (0.84999999999999998lf - dvec2(-0.10000000000000001lf, -1.2lf)) => dvec2(0.94999999999999996lf, 2.0499999999999998lf)
 * (0.84999999999999998lf - dvec2(-0.41999999999999998lf, 0.47999999999999998lf)) => dvec2(1.27lf, 0.37lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance((0.0lf - dvec2(-0.10000000000000001lf, -1.2lf)), dvec2(0.10000000000000001lf, 1.2lf)) <= 1.2041594578792297e-05lf ? 1 : -1] array0;
  double[distance((0.0lf - dvec2(-0.41999999999999998lf, 0.47999999999999998lf)), dvec2(0.41999999999999998lf, -0.47999999999999998lf)) <= 6.3780874876407906e-06lf ? 1 : -1] array1;
  double[distance((-1.3333333333333333lf - dvec2(-0.10000000000000001lf, -1.2lf)), dvec2(-1.2333333333333332lf, -0.1333333333333333lf)) <= 1.2405196043952264e-05lf ? 1 : -1] array2;
  double[distance((-1.3333333333333333lf - dvec2(-0.41999999999999998lf, 0.47999999999999998lf)), dvec2(-0.91333333333333333lf, -1.8133333333333332lf)) <= 2.0303584795684617e-05lf ? 1 : -1] array3;
  double[distance((0.84999999999999998lf - dvec2(-0.10000000000000001lf, -1.2lf)), dvec2(0.94999999999999996lf, 2.0499999999999998lf)) <= 2.2594247055390008e-05lf ? 1 : -1] array4;
  double[distance((0.84999999999999998lf - dvec2(-0.41999999999999998lf, 0.47999999999999998lf)), dvec2(1.27lf, 0.37lf)) <= 1.3228000604777731e-05lf ? 1 : -1] array5;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length());
}
