/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * exp(-2.0) => 0.13533528
 * exp(-0.66666669) => 0.51341712
 * exp(0.66666669) => 1.9477341
 * exp(2.0) => 7.3890562
 */
#version 120

void main()
{
  float[distance(exp(-2.0), 0.13533528) <= 1.3533528e-06 ? 1 : -1] array0;
  float[distance(exp(-0.66666669), 0.51341712) <= 5.1341713e-06 ? 1 : -1] array1;
  float[distance(exp(0.66666669), 1.9477341) <= 1.947734e-05 ? 1 : -1] array2;
  float[distance(exp(2.0), 7.3890562) <= 7.3890558e-05 ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
