/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) + dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf)) => dmat4(-2.0lf, 3.54lf, 0.17999999999999999lf, -1.8200000000000001lf, -1.1000000000000001lf, 1.24lf, -1.4199999999999999lf, -3.6400000000000001lf, -2.1600000000000001lf, 0.95999999999999996lf, -2.7799999999999998lf, -2.8599999999999999lf, 3.5800000000000001lf, -2.7000000000000002lf, -2.4199999999999999lf, 1.4399999999999999lf)
 * (dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) + dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf)) => dmat4(-0.93999999999999995lf, 3.3700000000000001lf, 1.3400000000000001lf, -1.0700000000000001lf, 0.76000000000000001lf, 0.29999999999999999lf, -0.25999999999999995lf, -1.3700000000000001lf, 0.43999999999999995lf, 0.98999999999999999lf, 0.51000000000000001lf, -2.3100000000000001lf, -0.16999999999999993lf, -3.1900000000000004lf, -1.9299999999999999lf, 1.1099999999999999lf)
 * (dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) + dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf)) => dmat4(-0.93999999999999995lf, 3.3700000000000001lf, 1.3400000000000001lf, -1.0700000000000001lf, 0.76000000000000001lf, 0.29999999999999999lf, -0.25999999999999995lf, -1.3700000000000001lf, 0.43999999999999995lf, 0.98999999999999999lf, 0.51000000000000001lf, -2.3100000000000001lf, -0.16999999999999993lf, -3.1900000000000004lf, -1.9299999999999999lf, 1.1099999999999999lf)
 * (dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) + dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf)) => dmat4(0.12lf, 3.2000000000000002lf, 2.5lf, -0.32000000000000001lf, 2.6200000000000001lf, -0.64000000000000001lf, 0.90000000000000002lf, 0.90000000000000002lf, 3.04lf, 1.02lf, 3.7999999999999998lf, -1.76lf, -3.9199999999999999lf, -3.6800000000000002lf, -1.4399999999999999lf, 0.78000000000000003lf)
 */
#version 400

void main()
{
  double[(distance((dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) + dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[0], dvec4(-2.0lf, 3.54lf, 0.17999999999999999lf, -1.8200000000000001lf)) * distance((dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) + dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[0], dvec4(-2.0lf, 3.54lf, 0.17999999999999999lf, -1.8200000000000001lf))) + (distance((dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) + dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[1], dvec4(-1.1000000000000001lf, 1.24lf, -1.4199999999999999lf, -3.6400000000000001lf)) * distance((dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) + dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[1], dvec4(-1.1000000000000001lf, 1.24lf, -1.4199999999999999lf, -3.6400000000000001lf))) + (distance((dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) + dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[2], dvec4(-2.1600000000000001lf, 0.95999999999999996lf, -2.7799999999999998lf, -2.8599999999999999lf)) * distance((dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) + dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[2], dvec4(-2.1600000000000001lf, 0.95999999999999996lf, -2.7799999999999998lf, -2.8599999999999999lf))) + (distance((dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) + dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[3], dvec4(3.5800000000000001lf, -2.7000000000000002lf, -2.4199999999999999lf, 1.4399999999999999lf)) * distance((dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) + dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[3], dvec4(3.5800000000000001lf, -2.7000000000000002lf, -2.4199999999999999lf, 1.4399999999999999lf))) <= 8.7421599999999995e-09lf ? 1 : -1] array0;
  double[(distance((dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) + dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[0], dvec4(-0.93999999999999995lf, 3.3700000000000001lf, 1.3400000000000001lf, -1.0700000000000001lf)) * distance((dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) + dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[0], dvec4(-0.93999999999999995lf, 3.3700000000000001lf, 1.3400000000000001lf, -1.0700000000000001lf))) + (distance((dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) + dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[1], dvec4(0.76000000000000001lf, 0.29999999999999999lf, -0.25999999999999995lf, -1.3700000000000001lf)) * distance((dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) + dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[1], dvec4(0.76000000000000001lf, 0.29999999999999999lf, -0.25999999999999995lf, -1.3700000000000001lf))) + (distance((dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) + dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[2], dvec4(0.43999999999999995lf, 0.98999999999999999lf, 0.51000000000000001lf, -2.3100000000000001lf)) * distance((dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) + dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[2], dvec4(0.43999999999999995lf, 0.98999999999999999lf, 0.51000000000000001lf, -2.3100000000000001lf))) + (distance((dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) + dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[3], dvec4(-0.16999999999999993lf, -3.1900000000000004lf, -1.9299999999999999lf, 1.1099999999999999lf)) * distance((dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) + dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[3], dvec4(-0.16999999999999993lf, -3.1900000000000004lf, -1.9299999999999999lf, 1.1099999999999999lf))) <= 3.9725000000000013e-09lf ? 1 : -1] array1;
  double[(distance((dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) + dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[0], dvec4(-0.93999999999999995lf, 3.3700000000000001lf, 1.3400000000000001lf, -1.0700000000000001lf)) * distance((dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) + dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[0], dvec4(-0.93999999999999995lf, 3.3700000000000001lf, 1.3400000000000001lf, -1.0700000000000001lf))) + (distance((dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) + dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[1], dvec4(0.76000000000000001lf, 0.29999999999999999lf, -0.25999999999999995lf, -1.3700000000000001lf)) * distance((dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) + dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[1], dvec4(0.76000000000000001lf, 0.29999999999999999lf, -0.25999999999999995lf, -1.3700000000000001lf))) + (distance((dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) + dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[2], dvec4(0.43999999999999995lf, 0.98999999999999999lf, 0.51000000000000001lf, -2.3100000000000001lf)) * distance((dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) + dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[2], dvec4(0.43999999999999995lf, 0.98999999999999999lf, 0.51000000000000001lf, -2.3100000000000001lf))) + (distance((dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) + dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[3], dvec4(-0.16999999999999993lf, -3.1900000000000004lf, -1.9299999999999999lf, 1.1099999999999999lf)) * distance((dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) + dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[3], dvec4(-0.16999999999999993lf, -3.1900000000000004lf, -1.9299999999999999lf, 1.1099999999999999lf))) <= 3.9725000000000013e-09lf ? 1 : -1] array2;
  double[(distance((dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) + dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[0], dvec4(0.12lf, 3.2000000000000002lf, 2.5lf, -0.32000000000000001lf)) * distance((dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) + dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[0], dvec4(0.12lf, 3.2000000000000002lf, 2.5lf, -0.32000000000000001lf))) + (distance((dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) + dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[1], dvec4(2.6200000000000001lf, -0.64000000000000001lf, 0.90000000000000002lf, 0.90000000000000002lf)) * distance((dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) + dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[1], dvec4(2.6200000000000001lf, -0.64000000000000001lf, 0.90000000000000002lf, 0.90000000000000002lf))) + (distance((dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) + dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[2], dvec4(3.04lf, 1.02lf, 3.7999999999999998lf, -1.76lf)) * distance((dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) + dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[2], dvec4(3.04lf, 1.02lf, 3.7999999999999998lf, -1.76lf))) + (distance((dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) + dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[3], dvec4(-3.9199999999999999lf, -3.6800000000000002lf, -1.4399999999999999lf, 0.78000000000000003lf)) * distance((dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) + dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[3], dvec4(-3.9199999999999999lf, -3.6800000000000002lf, -1.4399999999999999lf, 0.78000000000000003lf))) <= 8.4911200000000016e-09lf ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
