/*
 * Decompiled with CFR 0.152.
 */
package com.projity.datatype;

import com.projity.strings.Messages;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class Money
extends BigDecimal {
    private static final long serialVersionUID = -8182666966278921881L;
    private static NumberFormat moneyFormat = null;
    private static DecimalFormat moneyCompactFormat = null;

    public static NumberFormat getMoneyFormatInstance() {
        if (moneyFormat == null) {
            moneyFormat = NumberFormat.getCurrencyInstance();
            moneyFormat.setGroupingUsed(false);
        }
        return moneyFormat;
    }

    public static NumberFormat getMoneyCompactFormatInstance() {
        if (moneyCompactFormat == null) {
            moneyCompactFormat = (DecimalFormat)NumberFormat.getCurrencyInstance();
            moneyCompactFormat.setGroupingUsed(false);
            moneyCompactFormat.setMaximumFractionDigits(0);
        }
        return moneyCompactFormat;
    }

    public static NumberFormat getFormat(boolean bl) {
        return bl ? Money.getMoneyFormatInstance() : Money.getMoneyCompactFormatInstance();
    }

    public static Money getInstance(double d) {
        return new Money(d);
    }

    private Money(double d) {
        super(d);
    }

    public Money(String string) throws NumberFormatException {
        super(string);
    }

    public Money(BigInteger bigInteger) {
        super(bigInteger);
    }

    public Money(BigInteger bigInteger, int n) {
        super(bigInteger, n);
    }

    public double getPrimitiveTypeValue() {
        return this.doubleValue();
    }

    public static String formatCurrency(double d, boolean bl) {
        if (bl) {
            if (d < 100.0) {
                return Money.normalCurrencyFormat(d, Math.floor(d) == d);
            }
            if (d < 10000.0) {
                d = Math.floor(d);
                return Money.normalCurrencyFormat(d, true);
            }
            if (d < 100000.0) {
                return Money.normalCurrencyFormat(d, Math.floor(d /= 1000.0) == d) + Messages.getString("Text.thousandsAbbreviation");
            }
            if (d < 1000000.0) {
                return Money.normalCurrencyFormat(d /= 1000.0, true) + Messages.getString("Text.thousandsAbbreviation");
            }
            if (d < 1.0E8) {
                return Money.normalCurrencyFormat(d, Math.floor(d /= 1000000.0) == d) + Messages.getString("Text.millionsAbbreviation");
            }
            return Money.normalCurrencyFormat(d /= 1000000.0, true) + Messages.getString("Text.millionsAbbreviation");
        }
        return Money.normalCurrencyFormat(d, false);
    }

    public static String normalCurrencyFormat(double d, boolean bl) {
        return bl ? Money.getMoneyCompactFormatInstance().format(d) : Money.getMoneyFormatInstance().format(d);
    }
}

