/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.views;

import com.projity.pm.graphic.views.MainView;
import com.projity.pm.graphic.views.synchro.Synchronizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public abstract class SplittedView
extends JSplitPane {
    protected JScrollPane leftScrollPane;
    protected JScrollPane rightScrollPane;
    protected MainView parentView;
    boolean silent = false;
    protected boolean sync = true;
    protected boolean needVoidBar = true;
    private Synchronizer synchronizer;
    protected int deltaDivider = 0;

    public SplittedView(Synchronizer synchronizer) {
        super(1);
        this.synchronizer = synchronizer;
        this.setOneTouchExpandable(true);
    }

    public void cleanUp() {
        this.leftScrollPane = null;
        this.rightScrollPane = null;
        this.parentView = null;
        this.synchronizer = null;
    }

    public void init() {
        this.leftScrollPane = this.createLeftScrollPane();
        this.rightScrollPane = this.createRightScrollPane();
        this.setLeftComponent(this.leftScrollPane);
        this.setRightComponent(this.rightScrollPane);
        if (this.sync) {
            this.synchronizer.addSynchro(this.leftScrollPane, this.rightScrollPane, 0);
        }
        this.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (SplittedView.this.silent) {
                    SplittedView.this.silent = false;
                    return;
                }
                int n = (Integer)propertyChangeEvent.getNewValue();
                if (SplittedView.this.parentView != null) {
                    SplittedView.this.parentView.setChildrenDividerLocation(propertyChangeEvent.getSource(), n);
                }
            }
        });
    }

    public int getDeltaDivider() {
        return this.deltaDivider;
    }

    public void setDeltaDivider(int n) {
        this.deltaDivider = n;
    }

    public void setDividerLocationSilent(int n) {
        if (this.getLastDividerLocation() != n) {
            this.silent = true;
            super.setDividerLocation(n);
        }
    }

    protected abstract JScrollPane createLeftScrollPane();

    protected abstract JScrollPane createRightScrollPane();

    public MainView getParentView() {
        return this.parentView;
    }

    public void setParentView(MainView mainView) {
        this.parentView = mainView;
    }

    public JScrollPane getLeftScrollPane() {
        return this.leftScrollPane;
    }

    public JScrollPane getRightScrollPane() {
        return this.rightScrollPane;
    }

    public boolean isNeedVoidBar() {
        return this.needVoidBar;
    }

    public void setNeedVoidBar(boolean bl) {
        this.needVoidBar = bl;
    }

    public void updateSize() {
    }
}

