/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import net.sf.mpxj.TaskField;
import net.sf.mpxj.common.MPPTaskField14;
import net.sf.mpxj.mpp.ChartPattern;
import net.sf.mpxj.mpp.GanttBarMiddleShape;
import net.sf.mpxj.mpp.GanttBarShowForTasks;
import net.sf.mpxj.mpp.GanttBarStartEndShape;
import net.sf.mpxj.mpp.GanttBarStartEndType;
import net.sf.mpxj.mpp.GanttBarStyle;
import net.sf.mpxj.mpp.GanttBarStyleException;
import net.sf.mpxj.mpp.GanttBarStyleFactory;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.Props;

public class GanttBarStyleFactory14
implements GanttBarStyleFactory {
    private static final Integer DEFAULT_PROPERTIES = 574619656;
    private static final Integer EXCEPTION_PROPERTIES = 574619661;

    public GanttBarStyle[] processDefaultStyles(Props props) {
        int n;
        GanttBarStyle[] ganttBarStyleArray = null;
        byte[] byArray = props.getByteArray(DEFAULT_PROPERTIES);
        if (byArray != null && (n = MPPUtility.getByte(byArray, 2243)) > 0 && n < 65535) {
            ganttBarStyleArray = new GanttBarStyle[n];
            int n2 = 2255;
            for (int i = 0; i < n; ++i) {
                GanttBarStyle ganttBarStyle;
                ganttBarStyleArray[i] = ganttBarStyle = new GanttBarStyle();
                ganttBarStyle.setName(MPPUtility.getUnicodeString(byArray, n2 + 91));
                ganttBarStyle.setLeftText(this.getTaskField(MPPUtility.getShort(byArray, n2 + 67)));
                ganttBarStyle.setRightText(this.getTaskField(MPPUtility.getShort(byArray, n2 + 71)));
                ganttBarStyle.setTopText(this.getTaskField(MPPUtility.getShort(byArray, n2 + 75)));
                ganttBarStyle.setBottomText(this.getTaskField(MPPUtility.getShort(byArray, n2 + 79)));
                ganttBarStyle.setInsideText(this.getTaskField(MPPUtility.getShort(byArray, n2 + 83)));
                ganttBarStyle.setStartShape(GanttBarStartEndShape.getInstance(byArray[n2 + 15] % 25));
                ganttBarStyle.setStartType(GanttBarStartEndType.getInstance(byArray[n2 + 15] / 25));
                ganttBarStyle.setStartColor(MPPUtility.getColor(byArray, n2 + 16));
                ganttBarStyle.setMiddleShape(GanttBarMiddleShape.getInstance(byArray[n2]));
                ganttBarStyle.setMiddlePattern(ChartPattern.getInstance(byArray[n2 + 1]));
                ganttBarStyle.setMiddleColor(MPPUtility.getColor(byArray, n2 + 2));
                ganttBarStyle.setEndShape(GanttBarStartEndShape.getInstance(byArray[n2 + 28] % 25));
                ganttBarStyle.setEndType(GanttBarStartEndType.getInstance(byArray[n2 + 28] / 25));
                ganttBarStyle.setEndColor(MPPUtility.getColor(byArray, n2 + 29));
                ganttBarStyle.setFromField(this.getTaskField(MPPUtility.getShort(byArray, n2 + 41)));
                ganttBarStyle.setToField(this.getTaskField(MPPUtility.getShort(byArray, n2 + 45)));
                this.extractFlags(ganttBarStyle, GanttBarShowForTasks.NORMAL, MPPUtility.getLong(byArray, n2 + 49));
                this.extractFlags(ganttBarStyle, GanttBarShowForTasks.NOT_NORMAL, MPPUtility.getLong(byArray, n2 + 57));
                ganttBarStyle.setRow(MPPUtility.getShort(byArray, n2 + 65) + 1);
                n2 += 195;
            }
        }
        return ganttBarStyleArray;
    }

    public GanttBarStyleException[] processExceptionStyles(Props props) {
        GanttBarStyleException[] ganttBarStyleExceptionArray = null;
        byte[] byArray = props.getByteArray(EXCEPTION_PROPERTIES);
        if (byArray != null) {
            ganttBarStyleExceptionArray = new GanttBarStyleException[byArray.length / 71];
            int n = 0;
            for (int i = 0; i < ganttBarStyleExceptionArray.length; ++i) {
                GanttBarStyleException ganttBarStyleException;
                ganttBarStyleExceptionArray[i] = ganttBarStyleException = new GanttBarStyleException();
                ganttBarStyleException.setTaskUniqueID(MPPUtility.getInt(byArray, n));
                ganttBarStyleException.setBarStyleIndex(MPPUtility.getShort(byArray, n + 4) - 1);
                ganttBarStyleException.setStartShape(GanttBarStartEndShape.getInstance(byArray[n + 20] % 25));
                ganttBarStyleException.setStartType(GanttBarStartEndType.getInstance(byArray[n + 20] / 25));
                ganttBarStyleException.setStartColor(MPPUtility.getColor(byArray, n + 21));
                ganttBarStyleException.setMiddleShape(GanttBarMiddleShape.getInstance(byArray[n + 6]));
                ganttBarStyleException.setMiddlePattern(ChartPattern.getInstance(byArray[n + 7]));
                ganttBarStyleException.setMiddleColor(MPPUtility.getColor(byArray, n + 8));
                ganttBarStyleException.setEndShape(GanttBarStartEndShape.getInstance(byArray[n + 33] % 25));
                ganttBarStyleException.setEndType(GanttBarStartEndType.getInstance(byArray[n + 33] / 25));
                ganttBarStyleException.setEndColor(MPPUtility.getColor(byArray, n + 34));
                ganttBarStyleException.setLeftText(this.getTaskField(MPPUtility.getShort(byArray, n + 49)));
                ganttBarStyleException.setRightText(this.getTaskField(MPPUtility.getShort(byArray, n + 53)));
                ganttBarStyleException.setTopText(this.getTaskField(MPPUtility.getShort(byArray, n + 57)));
                ganttBarStyleException.setBottomText(this.getTaskField(MPPUtility.getShort(byArray, n + 61)));
                ganttBarStyleException.setInsideText(this.getTaskField(MPPUtility.getShort(byArray, n + 65)));
                n += 71;
            }
        }
        return ganttBarStyleExceptionArray;
    }

    private void extractFlags(GanttBarStyle ganttBarStyle, GanttBarShowForTasks ganttBarShowForTasks, long l) {
        long l2 = 1L;
        for (int i = 0; i < 64; ++i) {
            GanttBarShowForTasks ganttBarShowForTasks2;
            if ((l & l2) != 0L && (ganttBarShowForTasks2 = GanttBarShowForTasks.getInstance(ganttBarShowForTasks.getValue() + i)) != null) {
                ganttBarStyle.addShowForTasks(ganttBarShowForTasks2);
            }
            l2 <<= 1;
        }
    }

    private TaskField getTaskField(int n) {
        TaskField taskField = MPPTaskField14.getInstance(n);
        if (taskField != null) {
            switch (taskField) {
                case START_TEXT: {
                    taskField = TaskField.START;
                    break;
                }
                case FINISH_TEXT: {
                    taskField = TaskField.FINISH;
                    break;
                }
                case DURATION_TEXT: {
                    taskField = TaskField.DURATION;
                    break;
                }
            }
        }
        return taskField;
    }
}

