/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.sf.mpxj.AccrueType;
import net.sf.mpxj.Column;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EventManager;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.Priority;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.Rate;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.Table;
import net.sf.mpxj.TableContainer;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskType;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.MPPResourceField;
import net.sf.mpxj.common.MPPTaskField;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.common.Pair;
import net.sf.mpxj.common.RtfHelper;
import net.sf.mpxj.mpp.ExtendedData;
import net.sf.mpxj.mpp.FixDeferFix;
import net.sf.mpxj.mpp.FixFix;
import net.sf.mpxj.mpp.MPPReader;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.MPPVariantReader;
import net.sf.mpxj.mpp.ProjectPropertiesReader;
import net.sf.mpxj.mpp.Props;
import net.sf.mpxj.mpp.Props8;
import net.sf.mpxj.mpp.RecurringTaskReader;
import net.sf.mpxj.mpp.View8;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MPP8Reader
implements MPPVariantReader {
    private MPPReader m_reader;
    private ProjectFile m_file;
    private EventManager m_eventManager;
    private HashMap<Integer, ProjectCalendar> m_calendarMap;
    private DirectoryEntry m_root;
    private DirectoryEntry m_projectDir;
    private DirectoryEntry m_viewDir;
    private static final Integer TASK_WBS = 104;
    private static final Integer TASK_CONTACT = 105;
    private static final Integer TASK_TEXT1 = 106;
    private static final Integer TASK_TEXT2 = 107;
    private static final Integer TASK_TEXT3 = 108;
    private static final Integer TASK_TEXT4 = 109;
    private static final Integer TASK_TEXT5 = 110;
    private static final Integer TASK_TEXT6 = 111;
    private static final Integer TASK_TEXT7 = 112;
    private static final Integer TASK_TEXT8 = 113;
    private static final Integer TASK_TEXT9 = 114;
    private static final Integer TASK_TEXT10 = 115;
    private static final Integer TASK_START1 = 116;
    private static final Integer TASK_FINISH1 = 117;
    private static final Integer TASK_START2 = 118;
    private static final Integer TASK_FINISH2 = 119;
    private static final Integer TASK_START3 = 120;
    private static final Integer TASK_FINISH3 = 121;
    private static final Integer TASK_START4 = 122;
    private static final Integer TASK_FINISH4 = 123;
    private static final Integer TASK_START5 = 124;
    private static final Integer TASK_FINISH5 = 125;
    private static final Integer TASK_START6 = 126;
    private static final Integer TASK_FINISH6 = 127;
    private static final Integer TASK_START7 = 128;
    private static final Integer TASK_FINISH7 = 129;
    private static final Integer TASK_START8 = 130;
    private static final Integer TASK_FINISH8 = 131;
    private static final Integer TASK_START9 = 132;
    private static final Integer TASK_FINISH9 = 133;
    private static final Integer TASK_START10 = 134;
    private static final Integer TASK_FINISH10 = 135;
    private static final Integer TASK_NUMBER1 = 137;
    private static final Integer TASK_NUMBER2 = 138;
    private static final Integer TASK_NUMBER3 = 139;
    private static final Integer TASK_NUMBER4 = 140;
    private static final Integer TASK_NUMBER5 = 141;
    private static final Integer TASK_NUMBER6 = 142;
    private static final Integer TASK_NUMBER7 = 143;
    private static final Integer TASK_NUMBER8 = 144;
    private static final Integer TASK_NUMBER9 = 145;
    private static final Integer TASK_NUMBER10 = 146;
    private static final Integer TASK_DURATION1 = 147;
    private static final Integer TASK_DURATION1_UNITS = 148;
    private static final Integer TASK_DURATION2 = 149;
    private static final Integer TASK_DURATION2_UNITS = 150;
    private static final Integer TASK_DURATION3 = 151;
    private static final Integer TASK_DURATION3_UNITS = 152;
    private static final Integer TASK_DURATION4 = 153;
    private static final Integer TASK_DURATION4_UNITS = 154;
    private static final Integer TASK_DURATION5 = 155;
    private static final Integer TASK_DURATION5_UNITS = 156;
    private static final Integer TASK_DURATION6 = 157;
    private static final Integer TASK_DURATION6_UNITS = 158;
    private static final Integer TASK_DURATION7 = 159;
    private static final Integer TASK_DURATION7_UNITS = 160;
    private static final Integer TASK_DURATION8 = 161;
    private static final Integer TASK_DURATION8_UNITS = 162;
    private static final Integer TASK_DURATION9 = 163;
    private static final Integer TASK_DURATION9_UNITS = 164;
    private static final Integer TASK_DURATION10 = 165;
    private static final Integer TASK_DURATION10_UNITS = 166;
    private static final Integer TASK_RECURRING_DATA = 168;
    private static final Integer TASK_DATE1 = 174;
    private static final Integer TASK_DATE2 = 175;
    private static final Integer TASK_DATE3 = 176;
    private static final Integer TASK_DATE4 = 177;
    private static final Integer TASK_DATE5 = 178;
    private static final Integer TASK_DATE6 = 179;
    private static final Integer TASK_DATE7 = 180;
    private static final Integer TASK_DATE8 = 181;
    private static final Integer TASK_DATE9 = 182;
    private static final Integer TASK_DATE10 = 183;
    private static final Integer TASK_TEXT11 = 184;
    private static final Integer TASK_TEXT12 = 185;
    private static final Integer TASK_TEXT13 = 186;
    private static final Integer TASK_TEXT14 = 187;
    private static final Integer TASK_TEXT15 = 188;
    private static final Integer TASK_TEXT16 = 189;
    private static final Integer TASK_TEXT17 = 190;
    private static final Integer TASK_TEXT18 = 191;
    private static final Integer TASK_TEXT19 = 192;
    private static final Integer TASK_TEXT20 = 193;
    private static final Integer TASK_TEXT21 = 194;
    private static final Integer TASK_TEXT22 = 195;
    private static final Integer TASK_TEXT23 = 196;
    private static final Integer TASK_TEXT24 = 197;
    private static final Integer TASK_TEXT25 = 198;
    private static final Integer TASK_TEXT26 = 199;
    private static final Integer TASK_TEXT27 = 200;
    private static final Integer TASK_TEXT28 = 201;
    private static final Integer TASK_TEXT29 = 202;
    private static final Integer TASK_TEXT30 = 203;
    private static final Integer TASK_NUMBER11 = 204;
    private static final Integer TASK_NUMBER12 = 205;
    private static final Integer TASK_NUMBER13 = 206;
    private static final Integer TASK_NUMBER14 = 207;
    private static final Integer TASK_NUMBER15 = 208;
    private static final Integer TASK_NUMBER16 = 209;
    private static final Integer TASK_NUMBER17 = 210;
    private static final Integer TASK_NUMBER18 = 211;
    private static final Integer TASK_NUMBER19 = 212;
    private static final Integer TASK_NUMBER20 = 213;
    private static final Integer TASK_HYPERLINK = 236;
    private static final Integer TASK_COST1 = 237;
    private static final Integer TASK_COST2 = 238;
    private static final Integer TASK_COST3 = 239;
    private static final Integer TASK_COST4 = 240;
    private static final Integer TASK_COST5 = 241;
    private static final Integer TASK_COST6 = 242;
    private static final Integer TASK_COST7 = 243;
    private static final Integer TASK_COST8 = 244;
    private static final Integer TASK_COST9 = 245;
    private static final Integer TASK_COST10 = 246;
    private static final Integer TASK_NOTES = 247;
    private static final Integer RESOURCE_GROUP = 61;
    private static final Integer RESOURCE_CODE = 62;
    private static final Integer RESOURCE_EMAIL = 63;
    private static final Integer RESOURCE_TEXT1 = 64;
    private static final Integer RESOURCE_TEXT2 = 65;
    private static final Integer RESOURCE_TEXT3 = 66;
    private static final Integer RESOURCE_TEXT4 = 67;
    private static final Integer RESOURCE_TEXT5 = 68;
    private static final Integer RESOURCE_TEXT6 = 69;
    private static final Integer RESOURCE_TEXT7 = 70;
    private static final Integer RESOURCE_TEXT8 = 71;
    private static final Integer RESOURCE_TEXT9 = 72;
    private static final Integer RESOURCE_TEXT10 = 73;
    private static final Integer RESOURCE_TEXT11 = 74;
    private static final Integer RESOURCE_TEXT12 = 75;
    private static final Integer RESOURCE_TEXT13 = 76;
    private static final Integer RESOURCE_TEXT14 = 77;
    private static final Integer RESOURCE_TEXT15 = 78;
    private static final Integer RESOURCE_TEXT16 = 79;
    private static final Integer RESOURCE_TEXT17 = 80;
    private static final Integer RESOURCE_TEXT18 = 81;
    private static final Integer RESOURCE_TEXT19 = 82;
    private static final Integer RESOURCE_TEXT20 = 83;
    private static final Integer RESOURCE_TEXT21 = 84;
    private static final Integer RESOURCE_TEXT22 = 85;
    private static final Integer RESOURCE_TEXT23 = 86;
    private static final Integer RESOURCE_TEXT24 = 87;
    private static final Integer RESOURCE_TEXT25 = 88;
    private static final Integer RESOURCE_TEXT26 = 89;
    private static final Integer RESOURCE_TEXT27 = 90;
    private static final Integer RESOURCE_TEXT28 = 91;
    private static final Integer RESOURCE_TEXT29 = 92;
    private static final Integer RESOURCE_TEXT30 = 93;
    private static final Integer RESOURCE_START1 = 94;
    private static final Integer RESOURCE_START2 = 95;
    private static final Integer RESOURCE_START3 = 96;
    private static final Integer RESOURCE_START4 = 97;
    private static final Integer RESOURCE_START5 = 98;
    private static final Integer RESOURCE_START6 = 99;
    private static final Integer RESOURCE_START7 = 100;
    private static final Integer RESOURCE_START8 = 101;
    private static final Integer RESOURCE_START9 = 102;
    private static final Integer RESOURCE_START10 = 103;
    private static final Integer RESOURCE_FINISH1 = 104;
    private static final Integer RESOURCE_FINISH2 = 105;
    private static final Integer RESOURCE_FINISH3 = 106;
    private static final Integer RESOURCE_FINISH4 = 107;
    private static final Integer RESOURCE_FINISH5 = 108;
    private static final Integer RESOURCE_FINISH6 = 109;
    private static final Integer RESOURCE_FINISH7 = 110;
    private static final Integer RESOURCE_FINISH8 = 111;
    private static final Integer RESOURCE_FINISH9 = 112;
    private static final Integer RESOURCE_FINISH10 = 113;
    private static final Integer RESOURCE_NUMBER1 = 114;
    private static final Integer RESOURCE_NUMBER2 = 115;
    private static final Integer RESOURCE_NUMBER3 = 116;
    private static final Integer RESOURCE_NUMBER4 = 117;
    private static final Integer RESOURCE_NUMBER5 = 118;
    private static final Integer RESOURCE_NUMBER6 = 119;
    private static final Integer RESOURCE_NUMBER7 = 120;
    private static final Integer RESOURCE_NUMBER8 = 121;
    private static final Integer RESOURCE_NUMBER9 = 122;
    private static final Integer RESOURCE_NUMBER10 = 123;
    private static final Integer RESOURCE_NUMBER11 = 124;
    private static final Integer RESOURCE_NUMBER12 = 125;
    private static final Integer RESOURCE_NUMBER13 = 126;
    private static final Integer RESOURCE_NUMBER14 = 127;
    private static final Integer RESOURCE_NUMBER15 = 128;
    private static final Integer RESOURCE_NUMBER16 = 129;
    private static final Integer RESOURCE_NUMBER17 = 130;
    private static final Integer RESOURCE_NUMBER18 = 131;
    private static final Integer RESOURCE_NUMBER19 = 132;
    private static final Integer RESOURCE_NUMBER20 = 133;
    private static final Integer RESOURCE_DURATION1 = 134;
    private static final Integer RESOURCE_DURATION2 = 135;
    private static final Integer RESOURCE_DURATION3 = 136;
    private static final Integer RESOURCE_DURATION4 = 137;
    private static final Integer RESOURCE_DURATION5 = 138;
    private static final Integer RESOURCE_DURATION6 = 139;
    private static final Integer RESOURCE_DURATION7 = 140;
    private static final Integer RESOURCE_DURATION8 = 141;
    private static final Integer RESOURCE_DURATION9 = 142;
    private static final Integer RESOURCE_DURATION10 = 143;
    private static final Integer RESOURCE_DURATION1_UNITS = 144;
    private static final Integer RESOURCE_DURATION2_UNITS = 145;
    private static final Integer RESOURCE_DURATION3_UNITS = 146;
    private static final Integer RESOURCE_DURATION4_UNITS = 147;
    private static final Integer RESOURCE_DURATION5_UNITS = 148;
    private static final Integer RESOURCE_DURATION6_UNITS = 149;
    private static final Integer RESOURCE_DURATION7_UNITS = 150;
    private static final Integer RESOURCE_DURATION8_UNITS = 151;
    private static final Integer RESOURCE_DURATION9_UNITS = 152;
    private static final Integer RESOURCE_DURATION10_UNITS = 153;
    private static final Integer RESOURCE_DATE1 = 157;
    private static final Integer RESOURCE_DATE2 = 158;
    private static final Integer RESOURCE_DATE3 = 159;
    private static final Integer RESOURCE_DATE4 = 160;
    private static final Integer RESOURCE_DATE5 = 161;
    private static final Integer RESOURCE_DATE6 = 162;
    private static final Integer RESOURCE_DATE7 = 163;
    private static final Integer RESOURCE_DATE8 = 164;
    private static final Integer RESOURCE_DATE9 = 165;
    private static final Integer RESOURCE_DATE10 = 166;
    private static final Integer RESOURCE_NOTES = 169;
    private static final Integer RESOURCE_COST1 = 170;
    private static final Integer RESOURCE_COST2 = 171;
    private static final Integer RESOURCE_COST3 = 172;
    private static final Integer RESOURCE_COST4 = 173;
    private static final Integer RESOURCE_COST5 = 174;
    private static final Integer RESOURCE_COST6 = 175;
    private static final Integer RESOURCE_COST7 = 176;
    private static final Integer RESOURCE_COST8 = 177;
    private static final Integer RESOURCE_COST9 = 178;
    private static final Integer RESOURCE_COST10 = 179;
    private static final boolean[] DEFAULT_WORKING_WEEK = new boolean[]{false, true, true, true, true, true, false};

    MPP8Reader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(MPPReader mPPReader, ProjectFile projectFile, DirectoryEntry directoryEntry) throws MPXJException, IOException {
        try {
            this.populateMemberData(mPPReader, projectFile, directoryEntry);
            this.processProjectProperties();
            if (!mPPReader.getReadPropertiesOnly()) {
                this.processCalendarData();
                this.processResourceData();
                this.processTaskData();
                this.processConstraintData();
                this.processAssignmentData();
                if (mPPReader.getReadPresentationData()) {
                    this.processViewPropertyData();
                    this.processViewData();
                    this.processTableData();
                }
            }
        }
        finally {
            this.clearMemberData();
        }
    }

    private void populateMemberData(MPPReader mPPReader, ProjectFile projectFile, DirectoryEntry directoryEntry) throws IOException {
        this.m_reader = mPPReader;
        this.m_root = directoryEntry;
        this.m_file = projectFile;
        this.m_eventManager = projectFile.getEventManager();
        this.m_calendarMap = new HashMap();
        this.m_projectDir = (DirectoryEntry)directoryEntry.getEntry("   1");
        this.m_viewDir = (DirectoryEntry)directoryEntry.getEntry("   2");
        this.m_file.getProjectProperties().setMppFileType(8);
    }

    private void clearMemberData() {
        this.m_reader = null;
        this.m_root = null;
        this.m_eventManager = null;
        this.m_file = null;
        this.m_calendarMap = null;
        this.m_projectDir = null;
        this.m_viewDir = null;
    }

    private void processProjectProperties() throws MPXJException, IOException {
        Props8 props8 = new Props8(new DocumentInputStream((DocumentEntry)this.m_projectDir.getEntry("Props")));
        ProjectPropertiesReader projectPropertiesReader = new ProjectPropertiesReader();
        projectPropertiesReader.process(this.m_file, props8, this.m_root);
    }

    private void processViewPropertyData() throws IOException {
        Props8 props8 = new Props8(new DocumentInputStream((DocumentEntry)this.m_viewDir.getEntry("Props")));
        ProjectProperties projectProperties = this.m_file.getProjectProperties();
        projectProperties.setShowProjectSummaryTask(props8.getBoolean(Props.SHOW_PROJECT_SUMMARY_TASK));
    }

    private void processCalendarData() throws MPXJException, IOException {
        Date date;
        Date date2;
        Date date3;
        Date date4;
        DirectoryEntry directoryEntry = (DirectoryEntry)this.m_projectDir.getEntry("TBkndCal");
        FixFix fixFix = new FixFix(36, new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("FixFix   0")));
        FixDeferFix fixDeferFix = new FixDeferFix(new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("FixDeferFix   0")));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm");
        try {
            date4 = simpleDateFormat.parse("08:00");
            date3 = simpleDateFormat.parse("12:00");
            date2 = simpleDateFormat.parse("13:00");
            date = simpleDateFormat.parse("17:00");
        }
        catch (ParseException parseException) {
            throw new MPXJException("Invalid format", parseException);
        }
        int n = fixFix.getItemCount();
        LinkedList<Pair<ProjectCalendar, Integer>> linkedList = new LinkedList<Pair<ProjectCalendar, Integer>>();
        for (int i = 0; i < n; ++i) {
            ProjectCalendar projectCalendar;
            byte[] byArray = fixFix.getByteArrayValue(i);
            int n2 = MPPUtility.getInt(byArray, 0);
            int n3 = MPPUtility.getInt(byArray, 4);
            String string = fixDeferFix.getUnicodeString(this.getOffset(byArray, 20));
            if (n2 < 0) continue;
            ExtendedData extendedData = new ExtendedData(fixDeferFix, this.getOffset(byArray, 32));
            int n4 = -1 - extendedData.getInt(8);
            if (n4 == -1) {
                if (n3 > 0) {
                    projectCalendar = this.m_file.addDefaultDerivedCalendar();
                    linkedList.add(new Pair<ProjectCalendar, Integer>(projectCalendar, n3));
                } else {
                    projectCalendar = this.m_file.addDefaultBaseCalendar();
                    projectCalendar.setName(string);
                }
                projectCalendar.setUniqueID(n2);
            } else {
                long l;
                Date date5;
                int n5;
                int n6;
                if (n3 > 0) {
                    projectCalendar = this.m_file.addCalendar();
                    linkedList.add(new Pair<ProjectCalendar, Integer>(projectCalendar, n3));
                } else {
                    projectCalendar = this.m_file.addCalendar();
                    projectCalendar.setName(string);
                }
                projectCalendar.setUniqueID(n2);
                byte[] byArray2 = fixDeferFix.getByteArray(n4);
                for (n6 = 0; n6 < 7; ++n6) {
                    ProjectCalendarHours projectCalendarHours;
                    n4 = 4 + 40 * n6;
                    int n7 = MPPUtility.getShort(byArray2, n4);
                    Day day = Day.getInstance(n6 + 1);
                    if (n7 == 1) {
                        projectCalendar.setWorkingDay(day, DEFAULT_WORKING_WEEK[n6]);
                        if (!projectCalendar.isWorkingDay(day)) continue;
                        projectCalendarHours = projectCalendar.addCalendarHours(Day.getInstance(n6 + 1));
                        projectCalendarHours.addRange(new DateRange(date4, date3));
                        projectCalendarHours.addRange(new DateRange(date2, date));
                        continue;
                    }
                    n5 = MPPUtility.getShort(byArray2, n4 + 2);
                    if (n5 == 0) {
                        projectCalendar.setWorkingDay(day, false);
                        continue;
                    }
                    projectCalendar.setWorkingDay(day, true);
                    projectCalendarHours = projectCalendar.addCalendarHours(Day.getInstance(n6 + 1));
                    for (int j = 0; j < n5; ++j) {
                        date5 = MPPUtility.getTime(byArray2, n4 + 8 + j * 2);
                        l = MPPUtility.getDuration(byArray2, n4 + 16 + j * 4);
                        projectCalendarHours.addRange(new DateRange(date5, new Date(date5.getTime() + l)));
                    }
                }
                int n8 = MPPUtility.getShort(byArray2, 0);
                if (n8 != 0) {
                    for (n6 = 0; n6 < n8; ++n6) {
                        n4 = 284 + n6 * 44;
                        Date date6 = MPPUtility.getDate(byArray2, n4);
                        Date date7 = MPPUtility.getDate(byArray2, n4 + 2);
                        ProjectCalendarException projectCalendarException = projectCalendar.addCalendarException(date6, date7);
                        n5 = MPPUtility.getShort(byArray2, n4 + 6);
                        if (n5 == 0) continue;
                        for (int j = 0; j < n5; ++j) {
                            date5 = MPPUtility.getTime(byArray2, n4 + 12 + j * 2);
                            l = MPPUtility.getDuration(byArray2, n4 + 20 + j * 4);
                            projectCalendarException.addRange(new DateRange(date5, new Date(date5.getTime() + l)));
                        }
                    }
                }
            }
            this.m_calendarMap.put(n2, projectCalendar);
            this.m_eventManager.fireCalendarReadEvent(projectCalendar);
        }
        this.updateBaseCalendarNames(linkedList);
    }

    private void updateBaseCalendarNames(List<Pair<ProjectCalendar, Integer>> list) {
        for (Pair<ProjectCalendar, Integer> pair : list) {
            ProjectCalendar projectCalendar = pair.getFirst();
            Integer n = pair.getSecond();
            ProjectCalendar projectCalendar2 = this.m_calendarMap.get(n);
            if (projectCalendar2 == null) continue;
            projectCalendar.setParent(projectCalendar2);
        }
    }

    private void processTaskData() throws IOException {
        DirectoryEntry directoryEntry = (DirectoryEntry)this.m_projectDir.getEntry("TBkndTask");
        FixFix fixFix = new FixFix(316, new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("FixFix   0")));
        if (fixFix.getDiff() != 0) {
            fixFix = new FixFix(366, new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("FixFix   0")));
        }
        FixDeferFix fixDeferFix = null;
        ExtendedData extendedData = null;
        int n = fixFix.getItemCount();
        boolean bl = true;
        byte[] byArray = new byte[3];
        RecurringTaskReader recurringTaskReader = null;
        ProjectProperties projectProperties = this.m_file.getProjectProperties();
        TimeUnit timeUnit = projectProperties.getDefaultDurationUnits();
        for (int i = 0; i < n; ++i) {
            String string;
            int n2;
            byte[] byArray2 = fixFix.getByteArrayValue(i);
            int n3 = MPPUtility.getInt(byArray2, 0);
            if (n3 < 1 || ((n2 = MPPUtility.getShort(byArray2, 272)) & 0xC0) == 0 && (n2 & 3) != 0 && n2 != 49 && n2 != 8253) continue;
            if (fixDeferFix == null) {
                fixDeferFix = new FixDeferFix(new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("FixDeferFix   0")));
            }
            if ((byArray2[8] & 1) != 0) continue;
            extendedData = new ExtendedData(fixDeferFix, this.getOffset(byArray2, 312));
            byte[] byArray3 = extendedData.getByteArray(TASK_RECURRING_DATA);
            int n4 = MPPUtility.getInt(byArray2, 4);
            byArray[0] = (byte)(byArray2[268] & byArray2[303]);
            byArray[1] = (byte)(byArray2[269] & byArray2[304]);
            byArray[2] = (byte)(byArray2[270] & byArray2[305]);
            Task task = this.m_file.addTask();
            task.setActualCost(NumberHelper.getDouble((double)MPPUtility.getLong6(byArray2, 234) / 100.0));
            task.setActualDuration(MPPUtility.getAdjustedDuration(projectProperties, MPPUtility.getInt(byArray2, 74), MPPUtility.getDurationTimeUnits(MPPUtility.getShort(byArray2, 72), timeUnit)));
            task.setActualFinish(MPPUtility.getTimestamp(byArray2, 108));
            task.setActualOvertimeCost(NumberHelper.getDouble((double)MPPUtility.getLong6(byArray2, 210) / 100.0));
            task.setActualOvertimeWork(MPPUtility.getDuration((double)MPPUtility.getLong6(byArray2, 192) / 100.0, TimeUnit.HOURS));
            task.setActualStart(MPPUtility.getTimestamp(byArray2, 104));
            task.setActualWork(MPPUtility.getDuration((double)MPPUtility.getLong6(byArray2, 180) / 100.0, TimeUnit.HOURS));
            task.setBaselineCost(NumberHelper.getDouble((double)MPPUtility.getLong6(byArray2, 246) / 100.0));
            task.setBaselineDuration(MPPUtility.getAdjustedDuration(projectProperties, MPPUtility.getInt(byArray2, 82), MPPUtility.getDurationTimeUnits(MPPUtility.getShort(byArray2, 72), timeUnit)));
            task.setBaselineFinish(MPPUtility.getTimestamp(byArray2, 116));
            task.setBaselineStart(MPPUtility.getTimestamp(byArray2, 112));
            task.setBaselineWork(MPPUtility.getDuration((double)MPPUtility.getLong6(byArray2, 174) / 100.0, TimeUnit.HOURS));
            task.setConstraintDate(MPPUtility.getTimestamp(byArray2, 120));
            task.setConstraintType(ConstraintType.getInstance(MPPUtility.getShort(byArray2, 88)));
            task.setContact(extendedData.getUnicodeString(TASK_CONTACT));
            task.setCost(NumberHelper.getDouble((double)MPPUtility.getLong6(byArray2, 222) / 100.0));
            task.setCost(1, NumberHelper.getDouble((double)extendedData.getLong(TASK_COST1) / 100.0));
            task.setCost(2, NumberHelper.getDouble((double)extendedData.getLong(TASK_COST2) / 100.0));
            task.setCost(3, NumberHelper.getDouble((double)extendedData.getLong(TASK_COST3) / 100.0));
            task.setCost(4, NumberHelper.getDouble((double)extendedData.getLong(TASK_COST4) / 100.0));
            task.setCost(5, NumberHelper.getDouble((double)extendedData.getLong(TASK_COST5) / 100.0));
            task.setCost(6, NumberHelper.getDouble((double)extendedData.getLong(TASK_COST6) / 100.0));
            task.setCost(7, NumberHelper.getDouble((double)extendedData.getLong(TASK_COST7) / 100.0));
            task.setCost(8, NumberHelper.getDouble((double)extendedData.getLong(TASK_COST8) / 100.0));
            task.setCost(9, NumberHelper.getDouble((double)extendedData.getLong(TASK_COST9) / 100.0));
            task.setCost(10, NumberHelper.getDouble((double)extendedData.getLong(TASK_COST10) / 100.0));
            task.setCreateDate(MPPUtility.getTimestamp(byArray2, 138));
            task.setDate(1, extendedData.getTimestamp(TASK_DATE1));
            task.setDate(2, extendedData.getTimestamp(TASK_DATE2));
            task.setDate(3, extendedData.getTimestamp(TASK_DATE3));
            task.setDate(4, extendedData.getTimestamp(TASK_DATE4));
            task.setDate(5, extendedData.getTimestamp(TASK_DATE5));
            task.setDate(6, extendedData.getTimestamp(TASK_DATE6));
            task.setDate(7, extendedData.getTimestamp(TASK_DATE7));
            task.setDate(8, extendedData.getTimestamp(TASK_DATE8));
            task.setDate(9, extendedData.getTimestamp(TASK_DATE9));
            task.setDate(10, extendedData.getTimestamp(TASK_DATE10));
            task.setDuration(MPPUtility.getAdjustedDuration(projectProperties, MPPUtility.getInt(byArray2, 68), MPPUtility.getDurationTimeUnits(MPPUtility.getShort(byArray2, 72), timeUnit)));
            task.setDuration(1, MPPUtility.getAdjustedDuration(projectProperties, extendedData.getInt(TASK_DURATION1), MPPUtility.getDurationTimeUnits(extendedData.getShort(TASK_DURATION1_UNITS), timeUnit)));
            task.setDuration(2, MPPUtility.getAdjustedDuration(projectProperties, extendedData.getInt(TASK_DURATION2), MPPUtility.getDurationTimeUnits(extendedData.getShort(TASK_DURATION2_UNITS), timeUnit)));
            task.setDuration(3, MPPUtility.getAdjustedDuration(projectProperties, extendedData.getInt(TASK_DURATION3), MPPUtility.getDurationTimeUnits(extendedData.getShort(TASK_DURATION3_UNITS), timeUnit)));
            task.setDuration(4, MPPUtility.getAdjustedDuration(projectProperties, extendedData.getInt(TASK_DURATION4), MPPUtility.getDurationTimeUnits(extendedData.getShort(TASK_DURATION4_UNITS), timeUnit)));
            task.setDuration(5, MPPUtility.getAdjustedDuration(projectProperties, extendedData.getInt(TASK_DURATION5), MPPUtility.getDurationTimeUnits(extendedData.getShort(TASK_DURATION5_UNITS), timeUnit)));
            task.setDuration(6, MPPUtility.getAdjustedDuration(projectProperties, extendedData.getInt(TASK_DURATION6), MPPUtility.getDurationTimeUnits(extendedData.getShort(TASK_DURATION6_UNITS), timeUnit)));
            task.setDuration(7, MPPUtility.getAdjustedDuration(projectProperties, extendedData.getInt(TASK_DURATION7), MPPUtility.getDurationTimeUnits(extendedData.getShort(TASK_DURATION7_UNITS), timeUnit)));
            task.setDuration(8, MPPUtility.getAdjustedDuration(projectProperties, extendedData.getInt(TASK_DURATION8), MPPUtility.getDurationTimeUnits(extendedData.getShort(TASK_DURATION8_UNITS), timeUnit)));
            task.setDuration(9, MPPUtility.getAdjustedDuration(projectProperties, extendedData.getInt(TASK_DURATION9), MPPUtility.getDurationTimeUnits(extendedData.getShort(TASK_DURATION9_UNITS), timeUnit)));
            task.setDuration(10, MPPUtility.getAdjustedDuration(projectProperties, extendedData.getInt(TASK_DURATION10), MPPUtility.getDurationTimeUnits(extendedData.getShort(TASK_DURATION10_UNITS), timeUnit)));
            task.setEarlyFinish(MPPUtility.getTimestamp(byArray2, 20));
            task.setEarlyStart(MPPUtility.getTimestamp(byArray2, 96));
            task.setEffortDriven((byArray2[17] & 8) != 0);
            task.setFinish(MPPUtility.getTimestamp(byArray2, 20));
            task.setFinish(1, extendedData.getTimestamp(TASK_FINISH1));
            task.setFinish(2, extendedData.getTimestamp(TASK_FINISH2));
            task.setFinish(3, extendedData.getTimestamp(TASK_FINISH3));
            task.setFinish(4, extendedData.getTimestamp(TASK_FINISH4));
            task.setFinish(5, extendedData.getTimestamp(TASK_FINISH5));
            task.setFinish(6, extendedData.getTimestamp(TASK_FINISH6));
            task.setFinish(7, extendedData.getTimestamp(TASK_FINISH7));
            task.setFinish(8, extendedData.getTimestamp(TASK_FINISH8));
            task.setFinish(9, extendedData.getTimestamp(TASK_FINISH9));
            task.setFinish(10, extendedData.getTimestamp(TASK_FINISH10));
            task.setFixedCost(NumberHelper.getDouble((double)MPPUtility.getLong6(byArray2, 228) / 100.0));
            task.setFixedCostAccrual(AccrueType.getInstance(MPPUtility.getShort(byArray2, 136)));
            task.setFlag(1, (byArray[0] & 2) != 0);
            task.setFlag(2, (byArray[0] & 4) != 0);
            task.setFlag(3, (byArray[0] & 8) != 0);
            task.setFlag(4, (byArray[0] & 0x10) != 0);
            task.setFlag(5, (byArray[0] & 0x20) != 0);
            task.setFlag(6, (byArray[0] & 0x40) != 0);
            task.setFlag(7, (byArray[0] & 0x80) != 0);
            task.setFlag(8, (byArray[1] & 1) != 0);
            task.setFlag(9, (byArray[1] & 2) != 0);
            task.setFlag(10, (byArray[1] & 4) != 0);
            task.setFlag(11, (byArray[1] & 8) != 0);
            task.setFlag(12, (byArray[1] & 0x10) != 0);
            task.setFlag(13, (byArray[1] & 0x20) != 0);
            task.setFlag(14, (byArray[1] & 0x40) != 0);
            task.setFlag(15, (byArray[1] & 0x80) != 0);
            task.setFlag(16, (byArray[2] & 1) != 0);
            task.setFlag(17, (byArray[2] & 2) != 0);
            task.setFlag(18, (byArray[2] & 4) != 0);
            task.setFlag(19, (byArray[2] & 8) != 0);
            task.setFlag(20, (byArray[2] & 0x10) != 0);
            task.setHideBar((byArray2[16] & 1) != 0);
            this.processHyperlinkData(task, fixDeferFix.getByteArray(-1 - extendedData.getInt(TASK_HYPERLINK)));
            task.setID(n4);
            task.setLateFinish(MPPUtility.getTimestamp(byArray2, 160));
            task.setLateStart(MPPUtility.getTimestamp(byArray2, 24));
            task.setLevelAssignments((byArray2[19] & 0x10) != 0);
            task.setLevelingCanSplit((byArray2[19] & 8) != 0);
            task.setLevelingDelay(MPPUtility.getDuration((double)MPPUtility.getInt(byArray2, 90) / 3.0, MPPUtility.getDurationTimeUnits(MPPUtility.getShort(byArray2, 94), timeUnit)));
            task.setMarked((byArray2[13] & 2) != 0);
            task.setMilestone((byArray2[12] & 1) != 0);
            task.setName(fixDeferFix.getUnicodeString(this.getOffset(byArray2, 264)));
            task.setNumber(1, NumberHelper.getDouble(extendedData.getDouble(TASK_NUMBER1)));
            task.setNumber(2, NumberHelper.getDouble(extendedData.getDouble(TASK_NUMBER2)));
            task.setNumber(3, NumberHelper.getDouble(extendedData.getDouble(TASK_NUMBER3)));
            task.setNumber(4, NumberHelper.getDouble(extendedData.getDouble(TASK_NUMBER4)));
            task.setNumber(5, NumberHelper.getDouble(extendedData.getDouble(TASK_NUMBER5)));
            task.setNumber(6, NumberHelper.getDouble(extendedData.getDouble(TASK_NUMBER6)));
            task.setNumber(7, NumberHelper.getDouble(extendedData.getDouble(TASK_NUMBER7)));
            task.setNumber(8, NumberHelper.getDouble(extendedData.getDouble(TASK_NUMBER8)));
            task.setNumber(9, NumberHelper.getDouble(extendedData.getDouble(TASK_NUMBER9)));
            task.setNumber(10, NumberHelper.getDouble(extendedData.getDouble(TASK_NUMBER10)));
            task.setNumber(11, NumberHelper.getDouble(extendedData.getDouble(TASK_NUMBER11)));
            task.setNumber(12, NumberHelper.getDouble(extendedData.getDouble(TASK_NUMBER12)));
            task.setNumber(13, NumberHelper.getDouble(extendedData.getDouble(TASK_NUMBER13)));
            task.setNumber(14, NumberHelper.getDouble(extendedData.getDouble(TASK_NUMBER14)));
            task.setNumber(15, NumberHelper.getDouble(extendedData.getDouble(TASK_NUMBER15)));
            task.setNumber(16, NumberHelper.getDouble(extendedData.getDouble(TASK_NUMBER16)));
            task.setNumber(17, NumberHelper.getDouble(extendedData.getDouble(TASK_NUMBER17)));
            task.setNumber(18, NumberHelper.getDouble(extendedData.getDouble(TASK_NUMBER18)));
            task.setNumber(19, NumberHelper.getDouble(extendedData.getDouble(TASK_NUMBER19)));
            task.setNumber(20, NumberHelper.getDouble(extendedData.getDouble(TASK_NUMBER20)));
            task.setOutlineLevel(MPPUtility.getShort(byArray2, 48));
            task.setOvertimeCost(NumberHelper.getDouble((double)MPPUtility.getLong6(byArray2, 204) / 100.0));
            task.setPercentageComplete(MPPUtility.getPercentage(byArray2, 130));
            task.setPercentageWorkComplete(MPPUtility.getPercentage(byArray2, 132));
            task.setPreleveledFinish(MPPUtility.getTimestamp(byArray2, 148));
            task.setPreleveledStart(MPPUtility.getTimestamp(byArray2, 144));
            task.setPriority(Priority.getInstance((MPPUtility.getShort(byArray2, 128) + 1) * 100));
            task.setRecurring(MPPUtility.getShort(byArray2, 142) != 0);
            task.setRemainingCost(NumberHelper.getDouble((double)MPPUtility.getLong6(byArray2, 240) / 100.0));
            task.setRemainingDuration(MPPUtility.getAdjustedDuration(projectProperties, MPPUtility.getInt(byArray2, 78), MPPUtility.getDurationTimeUnits(MPPUtility.getShort(byArray2, 72), timeUnit)));
            task.setRemainingOvertimeCost(NumberHelper.getDouble((double)MPPUtility.getLong6(byArray2, 216) / 100.0));
            task.setRemainingOvertimeWork(MPPUtility.getDuration((double)MPPUtility.getLong6(byArray2, 198) / 100.0, TimeUnit.HOURS));
            task.setRemainingWork(MPPUtility.getDuration((double)MPPUtility.getLong6(byArray2, 186) / 100.0, TimeUnit.HOURS));
            task.setResume(MPPUtility.getTimestamp(byArray2, 32));
            task.setRollup((byArray2[15] & 4) != 0);
            task.setStart(MPPUtility.getTimestamp(byArray2, 96));
            task.setStart(1, extendedData.getTimestamp(TASK_START1));
            task.setStart(2, extendedData.getTimestamp(TASK_START2));
            task.setStart(3, extendedData.getTimestamp(TASK_START3));
            task.setStart(4, extendedData.getTimestamp(TASK_START4));
            task.setStart(5, extendedData.getTimestamp(TASK_START5));
            task.setStart(6, extendedData.getTimestamp(TASK_START6));
            task.setStart(7, extendedData.getTimestamp(TASK_START7));
            task.setStart(8, extendedData.getTimestamp(TASK_START8));
            task.setStart(9, extendedData.getTimestamp(TASK_START9));
            task.setStart(10, extendedData.getTimestamp(TASK_START10));
            task.setStop(MPPUtility.getTimestamp(byArray2, 124));
            task.setText(1, extendedData.getUnicodeString(TASK_TEXT1));
            task.setText(2, extendedData.getUnicodeString(TASK_TEXT2));
            task.setText(3, extendedData.getUnicodeString(TASK_TEXT3));
            task.setText(4, extendedData.getUnicodeString(TASK_TEXT4));
            task.setText(5, extendedData.getUnicodeString(TASK_TEXT5));
            task.setText(6, extendedData.getUnicodeString(TASK_TEXT6));
            task.setText(7, extendedData.getUnicodeString(TASK_TEXT7));
            task.setText(8, extendedData.getUnicodeString(TASK_TEXT8));
            task.setText(9, extendedData.getUnicodeString(TASK_TEXT9));
            task.setText(10, extendedData.getUnicodeString(TASK_TEXT10));
            task.setText(11, extendedData.getUnicodeString(TASK_TEXT11));
            task.setText(12, extendedData.getUnicodeString(TASK_TEXT12));
            task.setText(13, extendedData.getUnicodeString(TASK_TEXT13));
            task.setText(14, extendedData.getUnicodeString(TASK_TEXT14));
            task.setText(15, extendedData.getUnicodeString(TASK_TEXT15));
            task.setText(16, extendedData.getUnicodeString(TASK_TEXT16));
            task.setText(17, extendedData.getUnicodeString(TASK_TEXT17));
            task.setText(18, extendedData.getUnicodeString(TASK_TEXT18));
            task.setText(19, extendedData.getUnicodeString(TASK_TEXT19));
            task.setText(20, extendedData.getUnicodeString(TASK_TEXT20));
            task.setText(21, extendedData.getUnicodeString(TASK_TEXT21));
            task.setText(22, extendedData.getUnicodeString(TASK_TEXT22));
            task.setText(23, extendedData.getUnicodeString(TASK_TEXT23));
            task.setText(24, extendedData.getUnicodeString(TASK_TEXT24));
            task.setText(25, extendedData.getUnicodeString(TASK_TEXT25));
            task.setText(26, extendedData.getUnicodeString(TASK_TEXT26));
            task.setText(27, extendedData.getUnicodeString(TASK_TEXT27));
            task.setText(28, extendedData.getUnicodeString(TASK_TEXT28));
            task.setText(29, extendedData.getUnicodeString(TASK_TEXT29));
            task.setText(30, extendedData.getUnicodeString(TASK_TEXT30));
            task.setType(TaskType.getInstance(MPPUtility.getShort(byArray2, 134)));
            task.setUniqueID(n3);
            task.setWBS(extendedData.getUnicodeString(TASK_WBS));
            task.setWork(MPPUtility.getDuration((double)MPPUtility.getLong6(byArray2, 168) / 100.0, TimeUnit.HOURS));
            if (byArray3 != null) {
                if (recurringTaskReader == null) {
                    recurringTaskReader = new RecurringTaskReader(projectProperties);
                }
                recurringTaskReader.processRecurringTask(task, byArray3);
            }
            if ((string = extendedData.getString(TASK_NOTES)) != null) {
                if (!this.m_reader.getPreserveNoteFormatting()) {
                    string = RtfHelper.strip(string);
                }
                task.setNotes(string);
            }
            if (task.getWBS() != null) {
                bl = false;
            }
            this.m_eventManager.fireTaskReadEvent(task);
        }
        this.m_file.getProjectConfig().setAutoWBS(bl);
    }

    private void processHyperlinkData(Task task, byte[] byArray) {
        if (byArray != null) {
            int n = 12;
            String string = MPPUtility.getUnicodeString(byArray, n += 12);
            n += (string.length() + 1) * 2;
            String string2 = MPPUtility.getUnicodeString(byArray, n += 12);
            n += (string2.length() + 1) * 2;
            String string3 = MPPUtility.getUnicodeString(byArray, n += 12);
            task.setHyperlink(string);
            task.setHyperlinkAddress(string2);
            task.setHyperlinkSubAddress(string3);
        }
    }

    private void processConstraintData() throws IOException {
        DirectoryEntry directoryEntry;
        try {
            directoryEntry = (DirectoryEntry)this.m_projectDir.getEntry("TBkndCons");
        }
        catch (FileNotFoundException fileNotFoundException) {
            directoryEntry = null;
        }
        if (directoryEntry != null) {
            FixFix fixFix = new FixFix(36, new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("FixFix   0")));
            int n = fixFix.getItemCount();
            for (int i = 0; i < n; ++i) {
                int n2;
                int n3;
                byte[] byArray = fixFix.getByteArrayValue(i);
                if (MPPUtility.getInt(byArray, 28) != 0 || (n3 = MPPUtility.getInt(byArray, 12)) == (n2 = MPPUtility.getInt(byArray, 16))) continue;
                Task task = this.m_file.getTaskByUniqueID(n3);
                Task task2 = this.m_file.getTaskByUniqueID(n2);
                if (task == null || task2 == null) continue;
                RelationType relationType = RelationType.getInstance(MPPUtility.getShort(byArray, 20));
                TimeUnit timeUnit = MPPUtility.getDurationTimeUnits(MPPUtility.getShort(byArray, 22));
                Duration duration = MPPUtility.getDuration(MPPUtility.getInt(byArray, 24), timeUnit);
                Relation relation = task2.addPredecessor(task, relationType, duration);
                this.m_eventManager.fireRelationReadEvent(relation);
            }
        }
    }

    private void processResourceData() throws IOException {
        DirectoryEntry directoryEntry = (DirectoryEntry)this.m_projectDir.getEntry("TBkndRsc");
        FixFix fixFix = new FixFix(196, new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("FixFix   0")));
        FixDeferFix fixDeferFix = null;
        ExtendedData extendedData = null;
        int n = fixFix.getItemCount();
        for (int i = 0; i < n; ++i) {
            byte[] byArray = fixFix.getByteArrayValue(i);
            int n2 = MPPUtility.getInt(byArray, 0);
            if (n2 < 1 || (byArray[8] & 1) != 0 || MPPUtility.getShort(byArray, 164) != 0) continue;
            if (fixDeferFix == null) {
                fixDeferFix = new FixDeferFix(new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("FixDeferFix   0")));
            }
            extendedData = new ExtendedData(fixDeferFix, this.getOffset(byArray, 192));
            Resource resource = this.m_file.addResource();
            resource.setAccrueAt(AccrueType.getInstance(MPPUtility.getShort(byArray, 20)));
            resource.setActualCost(NumberHelper.getDouble((double)MPPUtility.getLong6(byArray, 114) / 100.0));
            resource.setActualOvertimeCost(NumberHelper.getDouble((double)MPPUtility.getLong6(byArray, 144) / 100.0));
            resource.setActualWork(MPPUtility.getDuration((double)MPPUtility.getLong6(byArray, 62) / 100.0, TimeUnit.HOURS));
            resource.setAvailableFrom(MPPUtility.getTimestamp(byArray, 28));
            resource.setAvailableTo(MPPUtility.getTimestamp(byArray, 32));
            resource.setBaselineCost(NumberHelper.getDouble((double)MPPUtility.getLong6(byArray, 126) / 100.0));
            resource.setBaselineWork(MPPUtility.getDuration((double)MPPUtility.getLong6(byArray, 68) / 100.0, TimeUnit.HOURS));
            resource.setCode(extendedData.getUnicodeString(RESOURCE_CODE));
            resource.setCost(NumberHelper.getDouble((double)MPPUtility.getLong6(byArray, 120) / 100.0));
            resource.setCost(1, NumberHelper.getDouble((double)extendedData.getLong(RESOURCE_COST1) / 100.0));
            resource.setCost(2, NumberHelper.getDouble((double)extendedData.getLong(RESOURCE_COST2) / 100.0));
            resource.setCost(3, NumberHelper.getDouble((double)extendedData.getLong(RESOURCE_COST3) / 100.0));
            resource.setCost(4, NumberHelper.getDouble((double)extendedData.getLong(RESOURCE_COST4) / 100.0));
            resource.setCost(5, NumberHelper.getDouble((double)extendedData.getLong(RESOURCE_COST5) / 100.0));
            resource.setCost(6, NumberHelper.getDouble((double)extendedData.getLong(RESOURCE_COST6) / 100.0));
            resource.setCost(7, NumberHelper.getDouble((double)extendedData.getLong(RESOURCE_COST7) / 100.0));
            resource.setCost(8, NumberHelper.getDouble((double)extendedData.getLong(RESOURCE_COST8) / 100.0));
            resource.setCost(9, NumberHelper.getDouble((double)extendedData.getLong(RESOURCE_COST9) / 100.0));
            resource.setCost(10, NumberHelper.getDouble((double)extendedData.getLong(RESOURCE_COST10) / 100.0));
            resource.setCostPerUse(NumberHelper.getDouble((double)MPPUtility.getLong6(byArray, 80) / 100.0));
            resource.setDate(1, extendedData.getTimestamp(RESOURCE_DATE1));
            resource.setDate(2, extendedData.getTimestamp(RESOURCE_DATE2));
            resource.setDate(3, extendedData.getTimestamp(RESOURCE_DATE3));
            resource.setDate(4, extendedData.getTimestamp(RESOURCE_DATE4));
            resource.setDate(5, extendedData.getTimestamp(RESOURCE_DATE5));
            resource.setDate(6, extendedData.getTimestamp(RESOURCE_DATE6));
            resource.setDate(7, extendedData.getTimestamp(RESOURCE_DATE7));
            resource.setDate(8, extendedData.getTimestamp(RESOURCE_DATE8));
            resource.setDate(9, extendedData.getTimestamp(RESOURCE_DATE9));
            resource.setDate(10, extendedData.getTimestamp(RESOURCE_DATE10));
            resource.setDuration(1, MPPUtility.getDuration(extendedData.getInt(RESOURCE_DURATION1), MPPUtility.getDurationTimeUnits(extendedData.getShort(RESOURCE_DURATION1_UNITS))));
            resource.setDuration(2, MPPUtility.getDuration(extendedData.getInt(RESOURCE_DURATION2), MPPUtility.getDurationTimeUnits(extendedData.getShort(RESOURCE_DURATION2_UNITS))));
            resource.setDuration(3, MPPUtility.getDuration(extendedData.getInt(RESOURCE_DURATION3), MPPUtility.getDurationTimeUnits(extendedData.getShort(RESOURCE_DURATION3_UNITS))));
            resource.setDuration(4, MPPUtility.getDuration(extendedData.getInt(RESOURCE_DURATION4), MPPUtility.getDurationTimeUnits(extendedData.getShort(RESOURCE_DURATION4_UNITS))));
            resource.setDuration(5, MPPUtility.getDuration(extendedData.getInt(RESOURCE_DURATION5), MPPUtility.getDurationTimeUnits(extendedData.getShort(RESOURCE_DURATION5_UNITS))));
            resource.setDuration(6, MPPUtility.getDuration(extendedData.getInt(RESOURCE_DURATION6), MPPUtility.getDurationTimeUnits(extendedData.getShort(RESOURCE_DURATION6_UNITS))));
            resource.setDuration(7, MPPUtility.getDuration(extendedData.getInt(RESOURCE_DURATION7), MPPUtility.getDurationTimeUnits(extendedData.getShort(RESOURCE_DURATION7_UNITS))));
            resource.setDuration(8, MPPUtility.getDuration(extendedData.getInt(RESOURCE_DURATION8), MPPUtility.getDurationTimeUnits(extendedData.getShort(RESOURCE_DURATION8_UNITS))));
            resource.setDuration(9, MPPUtility.getDuration(extendedData.getInt(RESOURCE_DURATION9), MPPUtility.getDurationTimeUnits(extendedData.getShort(RESOURCE_DURATION9_UNITS))));
            resource.setDuration(10, MPPUtility.getDuration(extendedData.getInt(RESOURCE_DURATION10), MPPUtility.getDurationTimeUnits(extendedData.getShort(RESOURCE_DURATION10_UNITS))));
            resource.setEmailAddress(extendedData.getUnicodeString(RESOURCE_EMAIL));
            resource.setFinish(1, extendedData.getTimestamp(RESOURCE_FINISH1));
            resource.setFinish(2, extendedData.getTimestamp(RESOURCE_FINISH2));
            resource.setFinish(3, extendedData.getTimestamp(RESOURCE_FINISH3));
            resource.setFinish(4, extendedData.getTimestamp(RESOURCE_FINISH4));
            resource.setFinish(5, extendedData.getTimestamp(RESOURCE_FINISH5));
            resource.setFinish(6, extendedData.getTimestamp(RESOURCE_FINISH6));
            resource.setFinish(7, extendedData.getTimestamp(RESOURCE_FINISH7));
            resource.setFinish(8, extendedData.getTimestamp(RESOURCE_FINISH8));
            resource.setFinish(9, extendedData.getTimestamp(RESOURCE_FINISH9));
            resource.setFinish(10, extendedData.getTimestamp(RESOURCE_FINISH10));
            resource.setGroup(extendedData.getUnicodeString(RESOURCE_GROUP));
            resource.setID(MPPUtility.getInt(byArray, 4));
            resource.setInitials(fixDeferFix.getUnicodeString(this.getOffset(byArray, 160)));
            resource.setMaxUnits(NumberHelper.getDouble((double)MPPUtility.getInt(byArray, 52) / 100.0));
            resource.setName(fixDeferFix.getUnicodeString(this.getOffset(byArray, 156)));
            resource.setNumber(1, NumberHelper.getDouble(extendedData.getDouble(RESOURCE_NUMBER1)));
            resource.setNumber(2, NumberHelper.getDouble(extendedData.getDouble(RESOURCE_NUMBER2)));
            resource.setNumber(3, NumberHelper.getDouble(extendedData.getDouble(RESOURCE_NUMBER3)));
            resource.setNumber(4, NumberHelper.getDouble(extendedData.getDouble(RESOURCE_NUMBER4)));
            resource.setNumber(5, NumberHelper.getDouble(extendedData.getDouble(RESOURCE_NUMBER5)));
            resource.setNumber(6, NumberHelper.getDouble(extendedData.getDouble(RESOURCE_NUMBER6)));
            resource.setNumber(7, NumberHelper.getDouble(extendedData.getDouble(RESOURCE_NUMBER7)));
            resource.setNumber(8, NumberHelper.getDouble(extendedData.getDouble(RESOURCE_NUMBER8)));
            resource.setNumber(9, NumberHelper.getDouble(extendedData.getDouble(RESOURCE_NUMBER9)));
            resource.setNumber(10, NumberHelper.getDouble(extendedData.getDouble(RESOURCE_NUMBER10)));
            resource.setNumber(11, NumberHelper.getDouble(extendedData.getDouble(RESOURCE_NUMBER11)));
            resource.setNumber(12, NumberHelper.getDouble(extendedData.getDouble(RESOURCE_NUMBER12)));
            resource.setNumber(13, NumberHelper.getDouble(extendedData.getDouble(RESOURCE_NUMBER13)));
            resource.setNumber(14, NumberHelper.getDouble(extendedData.getDouble(RESOURCE_NUMBER14)));
            resource.setNumber(15, NumberHelper.getDouble(extendedData.getDouble(RESOURCE_NUMBER15)));
            resource.setNumber(16, NumberHelper.getDouble(extendedData.getDouble(RESOURCE_NUMBER16)));
            resource.setNumber(17, NumberHelper.getDouble(extendedData.getDouble(RESOURCE_NUMBER17)));
            resource.setNumber(18, NumberHelper.getDouble(extendedData.getDouble(RESOURCE_NUMBER18)));
            resource.setNumber(19, NumberHelper.getDouble(extendedData.getDouble(RESOURCE_NUMBER19)));
            resource.setNumber(20, NumberHelper.getDouble(extendedData.getDouble(RESOURCE_NUMBER20)));
            resource.setOvertimeCost(NumberHelper.getDouble((double)MPPUtility.getLong6(byArray, 138) / 100.0));
            resource.setOvertimeRate(new Rate(MPPUtility.getDouble(byArray, 44), TimeUnit.HOURS));
            resource.setOvertimeWork(MPPUtility.getDuration((double)MPPUtility.getLong6(byArray, 74) / 100.0, TimeUnit.HOURS));
            resource.setPeakUnits(NumberHelper.getDouble((double)MPPUtility.getInt(byArray, 110) / 100.0));
            resource.setRegularWork(MPPUtility.getDuration((double)MPPUtility.getLong6(byArray, 92) / 100.0, TimeUnit.HOURS));
            resource.setRemainingCost(NumberHelper.getDouble((double)MPPUtility.getLong6(byArray, 132) / 100.0));
            resource.setRemainingOvertimeCost(NumberHelper.getDouble((double)MPPUtility.getLong6(byArray, 150) / 100.0));
            resource.setRemainingWork(MPPUtility.getDuration((double)MPPUtility.getLong6(byArray, 86) / 100.0, TimeUnit.HOURS));
            resource.setStandardRate(new Rate(MPPUtility.getDouble(byArray, 36), TimeUnit.HOURS));
            resource.setStart(1, extendedData.getTimestamp(RESOURCE_START1));
            resource.setStart(2, extendedData.getTimestamp(RESOURCE_START2));
            resource.setStart(3, extendedData.getTimestamp(RESOURCE_START3));
            resource.setStart(4, extendedData.getTimestamp(RESOURCE_START4));
            resource.setStart(5, extendedData.getTimestamp(RESOURCE_START5));
            resource.setStart(6, extendedData.getTimestamp(RESOURCE_START6));
            resource.setStart(7, extendedData.getTimestamp(RESOURCE_START7));
            resource.setStart(8, extendedData.getTimestamp(RESOURCE_START8));
            resource.setStart(9, extendedData.getTimestamp(RESOURCE_START9));
            resource.setStart(10, extendedData.getTimestamp(RESOURCE_START10));
            resource.setText(1, extendedData.getUnicodeString(RESOURCE_TEXT1));
            resource.setText(2, extendedData.getUnicodeString(RESOURCE_TEXT2));
            resource.setText(3, extendedData.getUnicodeString(RESOURCE_TEXT3));
            resource.setText(4, extendedData.getUnicodeString(RESOURCE_TEXT4));
            resource.setText(5, extendedData.getUnicodeString(RESOURCE_TEXT5));
            resource.setText(6, extendedData.getUnicodeString(RESOURCE_TEXT6));
            resource.setText(7, extendedData.getUnicodeString(RESOURCE_TEXT7));
            resource.setText(8, extendedData.getUnicodeString(RESOURCE_TEXT8));
            resource.setText(9, extendedData.getUnicodeString(RESOURCE_TEXT9));
            resource.setText(10, extendedData.getUnicodeString(RESOURCE_TEXT10));
            resource.setText(11, extendedData.getUnicodeString(RESOURCE_TEXT11));
            resource.setText(12, extendedData.getUnicodeString(RESOURCE_TEXT12));
            resource.setText(13, extendedData.getUnicodeString(RESOURCE_TEXT13));
            resource.setText(14, extendedData.getUnicodeString(RESOURCE_TEXT14));
            resource.setText(15, extendedData.getUnicodeString(RESOURCE_TEXT15));
            resource.setText(16, extendedData.getUnicodeString(RESOURCE_TEXT16));
            resource.setText(17, extendedData.getUnicodeString(RESOURCE_TEXT17));
            resource.setText(18, extendedData.getUnicodeString(RESOURCE_TEXT18));
            resource.setText(19, extendedData.getUnicodeString(RESOURCE_TEXT19));
            resource.setText(20, extendedData.getUnicodeString(RESOURCE_TEXT20));
            resource.setText(21, extendedData.getUnicodeString(RESOURCE_TEXT21));
            resource.setText(22, extendedData.getUnicodeString(RESOURCE_TEXT22));
            resource.setText(23, extendedData.getUnicodeString(RESOURCE_TEXT23));
            resource.setText(24, extendedData.getUnicodeString(RESOURCE_TEXT24));
            resource.setText(25, extendedData.getUnicodeString(RESOURCE_TEXT25));
            resource.setText(26, extendedData.getUnicodeString(RESOURCE_TEXT26));
            resource.setText(27, extendedData.getUnicodeString(RESOURCE_TEXT27));
            resource.setText(28, extendedData.getUnicodeString(RESOURCE_TEXT28));
            resource.setText(29, extendedData.getUnicodeString(RESOURCE_TEXT29));
            resource.setText(30, extendedData.getUnicodeString(RESOURCE_TEXT30));
            resource.setUniqueID(n2);
            resource.setWork(MPPUtility.getDuration((double)MPPUtility.getLong6(byArray, 56) / 100.0, TimeUnit.HOURS));
            ProjectCalendar projectCalendar = this.m_calendarMap.get(MPPUtility.getInt(byArray, 24));
            resource.setResourceCalendar(projectCalendar);
            String string = extendedData.getString(RESOURCE_NOTES);
            if (string != null) {
                if (!this.m_reader.getPreserveNoteFormatting()) {
                    string = RtfHelper.strip(string);
                }
                resource.setNotes(string);
            }
            this.m_eventManager.fireResourceReadEvent(resource);
        }
    }

    private void processAssignmentData() throws IOException {
        DirectoryEntry directoryEntry = (DirectoryEntry)this.m_projectDir.getEntry("TBkndAssn");
        FixFix fixFix = new FixFix(204, new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("FixFix   0")));
        if (fixFix.getDiff() != 0 || fixFix.getSize() % 238 == 0 && !this.testAssignmentTasks(fixFix)) {
            fixFix = new FixFix(238, new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("FixFix   0")));
        }
        int n = fixFix.getItemCount();
        FixDeferFix fixDeferFix = null;
        for (int i = 0; i < n; ++i) {
            byte[] byArray;
            if (fixDeferFix == null) {
                fixDeferFix = new FixDeferFix(new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("FixDeferFix   0")));
            }
            if (MPPUtility.getByte(byArray = fixFix.getByteArrayValue(i), 168) == 2) continue;
            Task task = this.m_file.getTaskByUniqueID(MPPUtility.getInt(byArray, 16));
            Resource resource = this.m_file.getResourceByUniqueID(MPPUtility.getInt(byArray, 20));
            if (task == null || resource == null) continue;
            ResourceAssignment resourceAssignment = task.addResourceAssignment(resource);
            resourceAssignment.setActualCost(NumberHelper.getDouble((double)MPPUtility.getLong6(byArray, 138) / 100.0));
            resourceAssignment.setActualWork(MPPUtility.getDuration((double)MPPUtility.getLong6(byArray, 96) / 100.0, TimeUnit.HOURS));
            resourceAssignment.setCost(NumberHelper.getDouble((double)MPPUtility.getLong6(byArray, 132) / 100.0));
            resourceAssignment.setFinish(MPPUtility.getTimestamp(byArray, 28));
            resourceAssignment.setOvertimeWork(MPPUtility.getDuration((double)MPPUtility.getLong6(byArray, 90) / 100.0, TimeUnit.HOURS));
            resourceAssignment.setRemainingWork(MPPUtility.getDuration((double)MPPUtility.getLong6(byArray, 114) / 100.0, TimeUnit.HOURS));
            resourceAssignment.setStart(MPPUtility.getTimestamp(byArray, 24));
            resourceAssignment.setUniqueID(MPPUtility.getInt(byArray, 0));
            resourceAssignment.setUnits((double)MPPUtility.getShort(byArray, 80) / 100.0);
            resourceAssignment.setWork(MPPUtility.getDuration((double)MPPUtility.getLong6(byArray, 84) / 100.0, TimeUnit.HOURS));
            this.m_eventManager.fireAssignmentReadEvent(resourceAssignment);
        }
    }

    private boolean testAssignmentTasks(FixFix fixFix) {
        boolean bl = true;
        int n = fixFix.getItemCount();
        for (int i = 0; i < n; ++i) {
            byte[] byArray = fixFix.getByteArrayValue(i);
            Task task = this.m_file.getTaskByUniqueID(MPPUtility.getInt(byArray, 16));
            Resource resource = this.m_file.getResourceByUniqueID(MPPUtility.getInt(byArray, 20));
            if (task != null || resource != null) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private void processViewData() throws IOException {
        DirectoryEntry directoryEntry = (DirectoryEntry)this.m_viewDir.getEntry("CV_iew");
        FixFix fixFix = new FixFix(138, new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("FixFix   0")));
        int n = fixFix.getItemCount();
        for (int i = 0; i < n; ++i) {
            byte[] byArray = fixFix.getByteArrayValue(i);
            View8 view8 = new View8(this.m_file, byArray);
            this.m_file.getViews().add(view8);
        }
    }

    private void processTableData() throws IOException {
        DirectoryEntry directoryEntry = (DirectoryEntry)this.m_viewDir.getEntry("CTable");
        FixFix fixFix = new FixFix(126, new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("FixFix   0")));
        FixDeferFix fixDeferFix = new FixDeferFix(new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("FixDeferFix   0")));
        int n = fixFix.getItemCount();
        StringBuilder stringBuilder = new StringBuilder();
        TableContainer tableContainer = this.m_file.getTables();
        for (int i = 0; i < n; ++i) {
            byte[] byArray = fixFix.getByteArrayValue(i);
            Table table = new Table();
            table.setID(MPPUtility.getInt(byArray, 0));
            String string = MPPUtility.getUnicodeString(byArray, 4);
            if (string.indexOf(38) != -1) {
                stringBuilder.setLength(0);
                for (int j = 0; j < string.length(); ++j) {
                    char c = string.charAt(j);
                    if (c == '&') continue;
                    stringBuilder.append(c);
                }
                string = stringBuilder.toString();
            }
            table.setName(MPPUtility.removeAmpersands(string));
            tableContainer.add(table);
            byte[] byArray2 = fixDeferFix.getByteArray(this.getOffset(byArray, 122));
            if (byArray2 == null) continue;
            byte[] byArray3 = fixDeferFix.getByteArray(this.getOffset(byArray2, 8));
            this.processColumnData(table, byArray3);
        }
    }

    private void processColumnData(Table table, byte[] byArray) {
        int n = MPPUtility.getShort(byArray, 4) + 1;
        int n2 = 8;
        for (int i = 0; i < n; ++i) {
            int n3;
            Column column = new Column(this.m_file);
            if (i == 0) {
                if (MPPUtility.getShort(byArray, n2) == 0) {
                    table.setResourceFlag(true);
                } else {
                    table.setResourceFlag(false);
                }
            }
            if (!table.getResourceFlag()) {
                column.setFieldType(MPPTaskField.getInstance(MPPUtility.getShort(byArray, n2)));
            } else {
                column.setFieldType(MPPResourceField.getInstance(MPPUtility.getShort(byArray, n2)));
            }
            column.setWidth(MPPUtility.getByte(byArray, n2 + 4));
            int n4 = MPPUtility.getShort(byArray, n2 + 6);
            if (n4 != 0) {
                column.setTitle(MPPUtility.getUnicodeString(byArray, n4));
            }
            if ((n3 = MPPUtility.getByte(byArray, n2 + 8)) == 32) {
                column.setAlignTitle(1);
            } else if (n3 == 33) {
                column.setAlignTitle(2);
            } else {
                column.setAlignTitle(3);
            }
            n3 = MPPUtility.getByte(byArray, n2 + 10);
            if (n3 == 32) {
                column.setAlignData(1);
            } else if (n3 == 33) {
                column.setAlignData(2);
            } else {
                column.setAlignData(3);
            }
            table.addColumn(column);
            n2 += 12;
        }
    }

    private int getOffset(byte[] byArray, int n) {
        return -1 - MPPUtility.getInt(byArray, n);
    }
}

