/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpx;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Locale;
import net.sf.mpxj.DateOrder;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.ProjectTimeFormat;
import net.sf.mpxj.mpx.MPXJDateFormat;
import net.sf.mpxj.mpx.MPXJNumberFormat;
import net.sf.mpxj.mpx.MPXJTimeFormat;

public final class MPXJFormats {
    private Locale m_locale;
    private String m_nullText;
    private ProjectFile m_projectFile;
    private MPXJNumberFormat m_unitsDecimalFormat = new MPXJNumberFormat();
    private MPXJNumberFormat m_decimalFormat = new MPXJNumberFormat();
    private MPXJNumberFormat m_currencyFormat = new MPXJNumberFormat();
    private MPXJNumberFormat m_durationDecimalFormat = new MPXJNumberFormat();
    private MPXJNumberFormat m_percentageDecimalFormat = new MPXJNumberFormat();
    private MPXJDateFormat m_dateTimeFormat = new MPXJDateFormat();
    private MPXJDateFormat m_dateFormat = new MPXJDateFormat();
    private MPXJTimeFormat m_timeFormat = new MPXJTimeFormat();

    public MPXJFormats(Locale locale, String string, ProjectFile projectFile) {
        this.m_locale = locale;
        this.m_nullText = string;
        this.m_projectFile = projectFile;
        this.update();
    }

    public void update() {
        ProjectProperties projectProperties = this.m_projectFile.getProjectProperties();
        char c = projectProperties.getDecimalSeparator();
        char c2 = projectProperties.getThousandsSeparator();
        this.m_unitsDecimalFormat.applyPattern("#.##", null, c, c2);
        this.m_decimalFormat.applyPattern("0.00#", null, c, c2);
        this.m_durationDecimalFormat.applyPattern("#.##", null, c, c2);
        this.m_percentageDecimalFormat.applyPattern("##0.##", null, c, c2);
        this.updateCurrencyFormats(projectProperties, c, c2);
        this.updateDateTimeFormats(projectProperties);
    }

    private void updateCurrencyFormats(ProjectProperties projectProperties, char c, char c2) {
        String string;
        String string2;
        String string3;
        String string4 = "";
        String string5 = "";
        String string6 = this.quoteFormatCharacters(projectProperties.getCurrencySymbol());
        switch (projectProperties.getSymbolPosition()) {
            case AFTER: {
                string5 = string6;
                break;
            }
            case BEFORE: {
                string4 = string6;
                break;
            }
            case AFTER_WITH_SPACE: {
                string5 = " " + string6;
                break;
            }
            case BEFORE_WITH_SPACE: {
                string4 = string6 + " ";
            }
        }
        StringBuilder stringBuilder = new StringBuilder(string4);
        stringBuilder.append("#0");
        int n = projectProperties.getCurrencyDigits();
        if (n > 0) {
            stringBuilder.append('.');
            for (int i = 0; i < n; ++i) {
                stringBuilder.append("0");
            }
        }
        stringBuilder.append(string5);
        String string7 = stringBuilder.toString();
        String[] stringArray = new String[7];
        stringArray[0] = string7 + ";(" + string7 + ")";
        stringBuilder.insert(string4.length(), "#,#");
        stringArray[1] = string3 = stringBuilder.toString();
        stringArray[2] = string3 + ";(" + string3 + ")";
        stringBuilder.setLength(0);
        stringBuilder.append("#0");
        if (n > 0) {
            stringBuilder.append('.');
            for (int i = 0; i < n; ++i) {
                stringBuilder.append("0");
            }
        }
        stringArray[3] = string2 = stringBuilder.toString();
        stringArray[4] = string2 + ";(" + string2 + ")";
        stringBuilder.insert(0, "#,#");
        stringArray[5] = string = stringBuilder.toString();
        stringArray[6] = string + ";(" + string + ")";
        this.m_currencyFormat.applyPattern(string7, stringArray, c, c2);
    }

    private String quoteFormatCharacters(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        block3: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '#': 
                case '%': 
                case ',': 
                case '-': 
                case '.': 
                case '0': 
                case ';': 
                case 'E': {
                    stringBuilder.append("'");
                    stringBuilder.append(c);
                    stringBuilder.append("'");
                    continue block3;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    private void updateDateTimeFormats(ProjectProperties projectProperties) {
        String string = "";
        String string2 = "";
        String[] stringArray = this.getTimeElement(projectProperties);
        char c = projectProperties.getDateSeparator();
        DateOrder dateOrder = projectProperties.getDateOrder();
        switch (dateOrder) {
            case DMY: {
                string = "dd" + c + "MM" + c + "yy";
                break;
            }
            case MDY: {
                string = "MM" + c + "dd" + c + "yy";
                break;
            }
            case YMD: {
                string = "yy" + c + "MM" + c + "dd";
            }
        }
        block5 : switch (projectProperties.getDateFormat()) {
            case DD_MM_YY_HH_MM: {
                switch (dateOrder) {
                    case DMY: {
                        string2 = "dd" + c + "MM" + c + "yy " + stringArray[0];
                        break;
                    }
                    case MDY: {
                        string2 = "MM" + c + "dd" + c + "yy " + stringArray[0];
                        break;
                    }
                    case YMD: {
                        string2 = "yy" + c + "MM" + c + "dd " + stringArray[0];
                    }
                }
                break;
            }
            case DD_MM_YY: {
                switch (dateOrder) {
                    case DMY: {
                        string2 = "dd" + c + "MM" + c + "yy";
                        break;
                    }
                    case MDY: {
                        string2 = "MM" + c + "dd" + c + "yy";
                        break;
                    }
                    case YMD: {
                        string2 = "yy" + c + "MM" + c + "dd";
                    }
                }
                break;
            }
            case DD_MMMMM_YYYY_HH_MM: {
                switch (dateOrder) {
                    case DMY: {
                        string2 = "dd MMMMM yyyy " + stringArray[0];
                        break;
                    }
                    case MDY: {
                        string2 = "MMMMM dd yyyy " + stringArray[0];
                        break;
                    }
                    case YMD: {
                        string2 = "yyyy MMMMM dd " + stringArray[0];
                    }
                }
                break;
            }
            case DD_MMMMM_YYYY: {
                switch (dateOrder) {
                    case DMY: {
                        string2 = "dd MMMMM yyyy";
                        break;
                    }
                    case MDY: {
                        string2 = "MMMMM dd yyyy";
                        break;
                    }
                    case YMD: {
                        string2 = "yyyy MMMMM dd";
                    }
                }
                break;
            }
            case DD_MMM_HH_MM: {
                switch (dateOrder) {
                    case DMY: {
                        string2 = "dd MMM " + stringArray[0];
                        break;
                    }
                    case MDY: 
                    case YMD: {
                        string2 = " MMM dd " + stringArray[0];
                    }
                }
                break;
            }
            case DD_MMM_YY: {
                switch (dateOrder) {
                    case DMY: {
                        string2 = "dd MMM ''yy";
                        break;
                    }
                    case MDY: {
                        string2 = "MMM dd ''yy";
                        break;
                    }
                    case YMD: {
                        string2 = "''yy MMM dd";
                    }
                }
                break;
            }
            case DD_MMMMM: {
                switch (dateOrder) {
                    case DMY: {
                        string2 = "dd MMMMM";
                        break;
                    }
                    case MDY: 
                    case YMD: {
                        string2 = "MMMMM dd";
                    }
                }
                break;
            }
            case DD_MMM: {
                switch (dateOrder) {
                    case DMY: {
                        string2 = "dd MMM";
                        break;
                    }
                    case MDY: 
                    case YMD: {
                        string2 = "MMM dd";
                    }
                }
                break;
            }
            case EEE_DD_MM_YY_HH_MM: {
                switch (dateOrder) {
                    case DMY: {
                        string2 = "EEE dd" + c + "MM" + c + "yy " + stringArray[0];
                        break;
                    }
                    case MDY: {
                        string2 = "EEE MM" + c + "dd" + c + "yy " + stringArray[0];
                        break;
                    }
                    case YMD: {
                        string2 = "EEE yy" + c + "MM" + c + "dd " + stringArray[0];
                    }
                }
                break;
            }
            case EEE_DD_MM_YY: {
                switch (dateOrder) {
                    case DMY: {
                        string2 = "EEE dd" + c + "MM" + c + "yy";
                        break;
                    }
                    case MDY: {
                        string2 = "EEE MM" + c + "dd" + c + "yy";
                        break;
                    }
                    case YMD: {
                        string2 = "EEE yy" + c + "MM" + c + "dd";
                    }
                }
                break;
            }
            case EEE_DD_MMM_YY: {
                switch (dateOrder) {
                    case DMY: {
                        string2 = "EEE dd MMM ''yy";
                        break;
                    }
                    case MDY: {
                        string2 = "EEE MM dd ''yy";
                        break;
                    }
                    case YMD: {
                        string2 = "EEE ''yy MMM dd";
                    }
                }
                break;
            }
            case EEE_HH_MM: {
                string2 = "EEE " + stringArray[0];
                break;
            }
            case DD_MM: {
                switch (dateOrder) {
                    case DMY: {
                        string2 = "dd" + c + "MM";
                        break;
                    }
                    case MDY: 
                    case YMD: {
                        string2 = "MM" + c + "dd";
                    }
                }
                break;
            }
            case DD: {
                string2 = "dd";
                break;
            }
            case HH_MM: {
                string2 = stringArray[0];
                break;
            }
            case EEE_DD_MMM: {
                switch (dateOrder) {
                    case DMY: {
                        string2 = "EEE dd MMM";
                        break;
                    }
                    case MDY: 
                    case YMD: {
                        string2 = "EEE MMM dd";
                    }
                }
                break;
            }
            case EEE_DD_MM: {
                switch (dateOrder) {
                    case DMY: {
                        string2 = "EEE dd" + c + "MM";
                        break;
                    }
                    case MDY: 
                    case YMD: {
                        string2 = "EEE MM" + c + "dd";
                    }
                }
                break;
            }
            case EEE_DD: {
                string2 = "EEE dd";
                break;
            }
            case DD_WWW: {
                string2 = "F" + c + "'W'ww";
                break;
            }
            case DD_WWW_YY_HH_MM: {
                string2 = "F" + c + "'W'ww" + c + "yy " + stringArray[0];
                break;
            }
            case DD_MM_YYYY: {
                switch (dateOrder) {
                    case DMY: {
                        string2 = "dd" + c + "MM" + c + "yyyy";
                        break block5;
                    }
                    case MDY: {
                        string2 = "MM" + c + "dd" + c + "yyyy";
                        break block5;
                    }
                    case YMD: {
                        string2 = "yyyy" + c + "MM" + c + "dd";
                    }
                }
            }
        }
        this.m_dateTimeFormat.applyPattern(string2);
        this.m_dateFormat.applyPattern(string);
        this.m_timeFormat.applyPatterns(stringArray);
        this.m_dateTimeFormat.setLocale(this.m_locale, this.m_nullText);
        this.m_dateFormat.setLocale(this.m_locale, this.m_nullText);
        this.m_timeFormat.setNullText(this.m_nullText);
        this.m_dateTimeFormat.setAmPmText(projectProperties.getAMText(), projectProperties.getPMText());
        this.m_timeFormat.setAmPmText(projectProperties.getAMText(), projectProperties.getPMText());
    }

    private String[] getTimeElement(ProjectProperties projectProperties) {
        char c = projectProperties.getTimeSeparator();
        ProjectTimeFormat projectTimeFormat = projectProperties.getTimeFormat();
        String[] stringArray = projectTimeFormat == null || projectTimeFormat == ProjectTimeFormat.TWELVE_HOUR ? new String[]{"hh" + c + "mm a"} : new String[]{"HH" + c + "mm", "HH"};
        return stringArray;
    }

    public NumberFormat getUnitsDecimalFormat() {
        return this.m_unitsDecimalFormat;
    }

    public NumberFormat getDecimalFormat() {
        return this.m_decimalFormat;
    }

    public NumberFormat getCurrencyFormat() {
        return this.m_currencyFormat;
    }

    public NumberFormat getDurationDecimalFormat() {
        return this.m_durationDecimalFormat;
    }

    public NumberFormat getPercentageDecimalFormat() {
        return this.m_percentageDecimalFormat;
    }

    public DateFormat getDateTimeFormat() {
        return this.m_dateTimeFormat;
    }

    public DateFormat getDateFormat() {
        return this.m_dateFormat;
    }

    public DateFormat getTimeFormat() {
        return this.m_timeFormat;
    }

    public String getNullText() {
        return this.m_nullText;
    }
}

