/*!
 * d3pie
 * @author Ben Keen
 * @version 0.2.1.20170923 (patched by Alexander Moisseev)
 * @date 2017-09-23
 * @repo https://github.com/moisseev/d3pie/tree/patched
 * @license MIT
 */
(function(a,b){if(typeof define==="function"&&define.amd){define([],b)}else{if(typeof exports==="object"){module.exports=b()}else{a.d3pie=b(a)}}}(this,function(){var g="d3pie";var f="0.2.1";var p=0;var h={header:{title:{text:"",color:"#333333",fontSize:18,font:"arial"},subtitle:{text:"",color:"#666666",fontSize:14,font:"arial"},location:"top-center",titleSubtitlePadding:8},footer:{text:"",color:"#666666",fontSize:14,font:"arial",location:"left"},size:{canvasHeight:500,canvasWidth:500,pieInnerRadius:"0%",pieOuterRadius:null},data:{sortOrder:"none",ignoreSmallSegments:{enabled:false,valueType:"percentage",value:null},smallSegmentGrouping:{enabled:false,value:1,valueType:"percentage",label:"Other",color:"#cccccc"},content:[]},labels:{outer:{format:"label",hideWhenLessThanPercentage:null,pieDistance:30},inner:{format:"percentage",hideWhenLessThanPercentage:null},mainLabel:{color:"#333333",font:"arial",fontSize:10},percentage:{color:"#dddddd",font:"arial",fontSize:10,decimalPlaces:0},value:{color:"#cccc44",font:"arial",fontSize:10},lines:{enabled:true,style:"curved",color:"segment"},truncation:{enabled:false,truncateLength:30},formatter:null},effects:{load:{effect:"default",speed:1000},pullOutSegmentOnClick:{effect:"bounce",speed:300,size:10},highlightSegmentOnMouseover:true,highlightLuminosity:-0.2},tooltips:{enabled:false,type:"placeholder",string:"",placeholderParser:null,styles:{fadeInSpeed:250,backgroundColor:"#000000",backgroundOpacity:0.5,color:"#efefef",borderRadius:2,font:"arial",fontSize:10,padding:4}},misc:{colors:{background:null,segments:["#2484c1","#65a620","#7b6888","#a05d56","#961a1a","#d8d23a","#e98125","#d0743c","#635222","#6ada6a","#0c6197","#7d9058","#207f33","#44b9b0","#bca44a","#e4a14b","#a3acb2","#8cc3e9","#69a6f9","#5b388f","#546e91","#8bde95","#d2ab58","#273c71","#98bf6e","#4daa4b","#98abc5","#cc1010","#31383b","#006391","#c2643f","#b0a474","#a5a39c","#a9c2bc","#22af8c","#7fcecf","#987ac6","#3d3b87","#b77b1c","#c9c2b6","#807ece","#8db27c","#be66a2","#9ed3c6","#00644b","#005064","#77979f","#77e079","#9c73ab","#1f79a7"],segmentStroke:"#ffffff"},gradient:{enabled:false,percentage:95,color:"#000000"},canvasPadding:{top:5,right:5,bottom:5,left:5},pieCenterOffset:{x:0,y:0},cssPrefix:null},callbacks:{onload:null,onMouseoverSegment:null,onMouseoutSegment:null,onClickSegment:null}};var m={initialCheck:function(q){var v=q.cssPrefix;var t=q.element;var r=q.options;if(!window.d3||!window.d3.hasOwnProperty("version")){console.error("d3pie error: d3 is not available");return false}if(!(t instanceof HTMLElement||t instanceof SVGElement)){console.error("d3pie error: the first d3pie() param must be a valid DOM element (not jQuery) or a ID string.");return false}if(!(/[a-zA-Z][a-zA-Z0-9_-]*$/.test(v))){console.error("d3pie error: invalid options.misc.cssPrefix");return false}if(!b.isArray(r.data.content)){console.error("d3pie error: invalid config structure: missing data.content property.");return false}if(r.data.content.length===0){console.error("d3pie error: no data supplied.");return false}var u=[];for(var s=0;s<r.data.content.length;s++){if(typeof r.data.content[s].value!=="number"||isNaN(r.data.content[s].value)){console.log("not valid: ",r.data.content[s]);continue}if(r.data.content[s].value<=0){console.log("not valid - should have positive value: ",r.data.content[s]);continue}u.push(r.data.content[s])}q.options.data.content=u;return true}};var b={addSVGSpace:function(r){var v=r.element;var q=r.options.size.canvasWidth;var u=r.options.size.canvasHeight;var t=r.options.misc.colors.background;var s=d3.select(v).append("svg:svg").attr("width",q).attr("height",u);if(t!=="transparent"){s.style("background-color",function(){return t})}return s},whenIdExists:function(u,t){var s=1;var r=1000;var q=setInterval(function(){if(document.getElementById(u)){clearInterval(q);t()}if(s>r){clearInterval(q)}s++},1)},whenElementsExist:function(r,u){var t=1;var s=1000;var q=setInterval(function(){var w=true;for(var v=0;v<r.length;v++){if(!document.getElementById(r[v])){w=false;break}}if(w){clearInterval(q);u()}if(t>s){clearInterval(q)}t++},1)},shuffleArray:function(t){var s=t.length,r,q;while(0!==s){q=Math.floor(Math.random()*s);s-=1;r=t[s];t[s]=t[q];t[q]=r}return t},processObj:function(s,q,r){if(typeof q==="string"){return b.processObj(s,q.split("."),r)}else{if(q.length===1&&r!==undefined){s[q[0]]=r;return s[q[0]]}else{if(q.length===0){return s}else{return b.processObj(s[q[0]],q.slice(1),r)}}}},getDimensions:function(u){var s=document.getElementById(u);var q=0,r=0;if(s){var t=s.getBBox();q=t.width;r=t.height}else{console.log("error: getDimensions() "+u+" not found.")}return{w:q,h:r}},rectIntersect:function(r,q){var s=((q.x>(r.x+r.w))||((q.x+q.w)<r.x)||((q.y+q.h)<r.y)||(q.y>(r.y+r.h)));return !s},getColorShade:function(t,r){t=String(t).replace(/[^0-9a-f]/gi,"");if(t.length<6){t=t[0]+t[0]+t[1]+t[1]+t[2]+t[2]}r=r||0;var q="#";for(var s=0;s<3;s++){var u=parseInt(t.substr(s*2,2),16);u=Math.round(Math.min(Math.max(0,u+(u*r)),255)).toString(16);q+=("00"+u).substr(u.length)}return q},initSegmentColors:function(s){var u=s.options.data.content;var r=s.options.misc.colors.segments;var q=[];for(var t=0;t<u.length;t++){if(u[t].hasOwnProperty("color")){q.push(u[t].color)}else{q.push(r[t])}}return q},applySmallSegmentGrouping:function(x,w){var q;if(w.valueType==="percentage"){q=n.getTotalPieSize(x)}var u=[];var t=[];var v=0;for(var s=0;s<x.length;s++){if(w.valueType==="percentage"){var r=(x[s].value/q)*100;if(r<=w.value){t.push(x[s]);v+=x[s].value;continue}x[s].isGrouped=false;u.push(x[s])}else{if(x[s].value<=w.value){t.push(x[s]);v+=x[s].value;continue}x[s].isGrouped=false;u.push(x[s])}}if(t.length){u.push({color:w.color,label:w.label,value:v,isGrouped:true,groupedData:t})}return u},showPoint:function(r,q,s){r.append("circle").attr("cx",q).attr("cy",s).attr("r",2).style("fill","black")},isFunction:function(q){var r={};return q&&r.toString.call(q)==="[object Function]"},isArray:function(q){return Object.prototype.toString.call(q)==="[object Array]"}};var k=function(){var D,s,q,r,y,z,x=arguments[0]||{},v=1,u=arguments.length,A=false,t=Object.prototype.toString,w=Object.prototype.hasOwnProperty,B={"[object Boolean]":"boolean","[object Number]":"number","[object String]":"string","[object Function]":"function","[object Array]":"array","[object Date]":"date","[object RegExp]":"regexp","[object Object]":"object"},C={isFunction:function(E){return C.type(E)==="function"},isArray:Array.isArray||function(E){return C.type(E)==="array"},isWindow:function(E){return E!==null&&E===E.window},isNumeric:function(E){return !isNaN(parseFloat(E))&&isFinite(E)},type:function(E){return E===null?String(E):B[t.call(E)]||"object"},isPlainObject:function(G){if(!G||C.type(G)!=="object"||G.nodeType){return false}try{if(G.constructor&&!w.call(G,"constructor")&&!w.call(G.constructor.prototype,"isPrototypeOf")){return false}}catch(F){return false}var E;for(E in G){}return E===undefined||w.call(G,E)}};if(typeof x==="boolean"){A=x;x=arguments[1]||{};v=2}if(typeof x!=="object"&&!C.isFunction(x)){x={}}if(u===v){x=this;--v}for(v;v<u;v++){if((D=arguments[v])!==null){for(s in D){q=x[s];r=D[s];if(x===r){continue}if(A&&r&&(C.isPlainObject(r)||(y=C.isArray(r)))){if(y){y=false;z=q&&C.isArray(q)?q:[]}else{z=q&&C.isPlainObject(q)?q:{}}x[s]=k(A,z,r)}else{if(r!==undefined){x[s]=r}}}}}return x};var n={toRadians:function(q){return q*(Math.PI/180)},toDegrees:function(q){return q*(180/Math.PI)},computePieRadius:function(t){var A=t.options.size;var q=t.options.misc.canvasPadding;var z=A.canvasWidth-q.left-q.right;var u=A.canvasHeight-q.top-q.bottom;if(t.options.header.location!=="pie-center"){u-=t.textComponents.headerHeight}if(t.textComponents.footer.exists){u-=t.textComponents.footer.h}u=(u<0)?0:u;var v=((z<u)?z:u)/3;var y,x;if(A.pieOuterRadius!==null){if(/%/.test(A.pieOuterRadius)){x=parseInt(A.pieOuterRadius.replace(/[\D]/,""),10);x=(x>99)?99:x;x=(x<0)?0:x;var r=(z<u)?z:u;if(t.options.labels.outer.format!=="none"){var s=parseInt(t.options.labels.outer.pieDistance,10)*2;if(r-s>0){r-=s}}v=Math.floor((r/100)*x)/2}else{v=parseInt(A.pieOuterRadius,10)}}if(/%/.test(A.pieInnerRadius)){x=parseInt(A.pieInnerRadius.replace(/[\D]/,""),10);x=(x>99)?99:x;x=(x<0)?0:x;y=Math.floor((v/100)*x)}else{y=parseInt(A.pieInnerRadius,10)}t.innerRadius=y;t.outerRadius=v},getTotalPieSize:function(s){var q=0;for(var r=0;r<s.length;r++){q+=s[r].value}return q},sortPieData:function(q){var s=q.options.data.content;var r=q.options.data.sortOrder;switch(r){case"none":break;case"random":s=b.shuffleArray(s);break;case"value-asc":s.sort(function(u,t){return(u.value<t.value)?-1:1});break;case"value-desc":s.sort(function(u,t){return(u.value<t.value)?1:-1});break;case"label-asc":s.sort(function(u,t){return(u.label.toLowerCase()>t.label.toLowerCase())?1:-1});break;case"label-desc":s.sort(function(u,t){return(u.label.toLowerCase()<t.label.toLowerCase())?1:-1});break}return s},getPieTranslateCenter:function(q){return"translate("+q.x+","+q.y+")"},calculatePieCenter:function(r){var u=r.options.misc.pieCenterOffset;var t=(r.textComponents.title.exists&&r.options.header.location!=="pie-center");var z=(r.textComponents.subtitle.exists&&r.options.header.location!=="pie-center");var w=r.options.misc.canvasPadding.top;if(t&&z){w+=r.textComponents.title.h+r.options.header.titleSubtitlePadding+r.textComponents.subtitle.h}else{if(t){w+=r.textComponents.title.h}else{if(z){w+=r.textComponents.subtitle.h}}}var s=0;if(r.textComponents.footer.exists){s=r.textComponents.footer.h+r.options.misc.canvasPadding.bottom}var q=((r.options.size.canvasWidth-r.options.misc.canvasPadding.left-r.options.misc.canvasPadding.right)/2)+r.options.misc.canvasPadding.left;var v=((r.options.size.canvasHeight-s-w)/2)+w;q+=u.x;v+=u.y;r.pieCenter={x:q,y:v}},rotate:function(w,u,s,q,v){v=v*Math.PI/180;var z=Math.cos,t=Math.sin,r=(w-s)*z(v)-(u-q)*t(v)+s,A=(w-s)*t(v)+(u-q)*z(v)+q;return{x:r,y:A}},translate:function(q,u,t,r){var s=n.toRadians(r);return{x:q+t*Math.sin(s),y:u-t*Math.cos(s)}},pointIsInArc:function(y,q,r){var t=r.innerRadius()(q),s=r.outerRadius()(q),w=r.startAngle()(q),v=r.endAngle()(q);var x=y.x*y.x+y.y*y.y,u=Math.atan2(y.x,-y.y);u=(u<0)?(u+Math.PI*2):u;return(t*t<=x)&&(x<=s*s)&&(w<=u)&&(u<=v)}};var e={add:function(r,x,t){var q=e.getIncludes(t);var u=r.options.labels;var v=r.svg.insert("g","."+r.cssPrefix+"labels-"+x).attr("class",r.cssPrefix+"labels-"+x);var s=v.selectAll("."+r.cssPrefix+"labelGroup-"+x).data(r.options.data.content).enter().append("g").attr("id",function(z,y){return r.cssPrefix+"labelGroup"+y+"-"+x}).attr("data-index",function(z,y){return y}).attr("class",r.cssPrefix+"labelGroup-"+x).style("opacity",0);var w={section:x,sectionDisplayType:t};if(q.mainLabel){s.append("text").attr("id",function(z,y){return r.cssPrefix+"segmentMainLabel"+y+"-"+x}).attr("class",r.cssPrefix+"segmentMainLabel-"+x).text(function(A,y){var z=A.label;if(u.formatter){w.index=y;w.part="mainLabel";w.value=A.value;w.label=z;z=u.formatter(w)}else{if(u.truncation.enabled&&A.label.length>u.truncation.truncateLength){z=A.label.substring(0,u.truncation.truncateLength)+"..."}}return z}).style("font-size",u.mainLabel.fontSize+"px").style("font-family",u.mainLabel.font).style("fill",u.mainLabel.color)}if(q.percentage){s.append("text").attr("id",function(z,y){return r.cssPrefix+"segmentPercentage"+y+"-"+x}).attr("class",r.cssPrefix+"segmentPercentage-"+x).text(function(A,z){var y=A.percentage;if(u.formatter){w.index=z;w.part="percentage";w.value=A.value;w.label=A.percentage;y=u.formatter(w)}else{y+="%"}return y}).style("font-size",u.percentage.fontSize+"px").style("font-family",u.percentage.font).style("fill",u.percentage.color)}if(q.value){s.append("text").attr("id",function(z,y){return r.cssPrefix+"segmentValue"+y+"-"+x}).attr("class",r.cssPrefix+"segmentValue-"+x).text(function(z,y){w.index=y;w.part="value";w.value=z.value;w.label=z.value;return u.formatter?u.formatter(w,z.value):z.value}).style("font-size",u.value.fontSize+"px").style("font-family",u.value.font).style("fill",u.value.color)}},positionLabelElements:function(q,t,r){e["dimensions-"+t]=[];var v=d3.selectAll("."+q.cssPrefix+"labelGroup-"+t);v.each(function(A,x){var z=d3.select(this).selectAll("."+q.cssPrefix+"segmentMainLabel-"+t);var w=d3.select(this).selectAll("."+q.cssPrefix+"segmentPercentage-"+t);var y=d3.select(this).selectAll("."+q.cssPrefix+"segmentValue-"+t);e["dimensions-"+t].push({mainLabel:(z.node()!==null)?z.node().getBBox():null,percentage:(w.node()!==null)?w.node().getBBox():null,value:(y.node()!==null)?y.node().getBBox():null})});var s=5;var u=e["dimensions-"+t];switch(r){case"label-value1":d3.selectAll("."+q.cssPrefix+"segmentValue-"+t).attr("dx",function(x,w){return u[w].mainLabel.width+s});break;case"label-value2":d3.selectAll("."+q.cssPrefix+"segmentValue-"+t).attr("dy",function(x,w){return u[w].mainLabel.height});break;case"label-percentage1":d3.selectAll("."+q.cssPrefix+"segmentPercentage-"+t).attr("dx",function(x,w){return u[w].mainLabel.width+s});break;case"label-percentage2":d3.selectAll("."+q.cssPrefix+"segmentPercentage-"+t).attr("dx",function(x,w){return(u[w].mainLabel.width/2)-(u[w].percentage.width/2)}).attr("dy",function(x,w){return u[w].mainLabel.height});break}},computeLabelLinePositions:function(q){q.lineCoordGroups=[];d3.selectAll("."+q.cssPrefix+"labelGroup-outer").each(function(s,r){return e.computeLinePosition(q,r)})},computeLinePosition:function(y,x){var w=d.getSegmentAngle(x,y.options.data.content,y.totalSize,{midpoint:true});var D=n.rotate(y.pieCenter.x,y.pieCenter.y-y.outerRadius,y.pieCenter.x,y.pieCenter.y,w);var r=y.outerLabelGroupData[x].h/5;var s=6;var u=Math.floor(w/90);var C=4;var t,B,q,A;if(u===2&&w===180){u=1}switch(u){case 0:t=y.outerLabelGroupData[x].x-s-((y.outerLabelGroupData[x].x-s-D.x)/2);B=y.outerLabelGroupData[x].y+((D.y-y.outerLabelGroupData[x].y)/C);q=y.outerLabelGroupData[x].x-s;A=y.outerLabelGroupData[x].y-r;break;case 1:t=D.x+(y.outerLabelGroupData[x].x-D.x)/C;B=D.y+(y.outerLabelGroupData[x].y-D.y)/C;q=y.outerLabelGroupData[x].x-s;A=y.outerLabelGroupData[x].y-r;break;case 2:var v=y.outerLabelGroupData[x].x+y.outerLabelGroupData[x].w+s;t=D.x-(D.x-v)/C;B=D.y+(y.outerLabelGroupData[x].y-D.y)/C;q=y.outerLabelGroupData[x].x+y.outerLabelGroupData[x].w+s;A=y.outerLabelGroupData[x].y-r;break;case 3:var z=y.outerLabelGroupData[x].x+y.outerLabelGroupData[x].w+s;t=z+((D.x-z)/C);B=y.outerLabelGroupData[x].y+(D.y-y.outerLabelGroupData[x].y)/C;q=y.outerLabelGroupData[x].x+y.outerLabelGroupData[x].w+s;A=y.outerLabelGroupData[x].y-r;break}if(y.options.labels.lines.style==="straight"){y.lineCoordGroups[x]=[{x:D.x,y:D.y},{x:q,y:A}]}else{y.lineCoordGroups[x]=[{x:D.x,y:D.y},{x:t,y:B},{x:q,y:A}]}},addLabelLines:function(q){var t=q.svg.insert("g","."+q.cssPrefix+"pieChart").attr("class",q.cssPrefix+"lineGroups").style("opacity",0);var s=t.selectAll("."+q.cssPrefix+"lineGroup").data(q.lineCoordGroups).enter().append("g").attr("class",q.cssPrefix+"lineGroup");var r=d3.line().curve(d3.curveBasis).x(function(u){return u.x}).y(function(u){return u.y});s.append("path").attr("d",r).attr("stroke",function(v,u){return(q.options.labels.lines.color==="segment")?q.options.colors[u]:q.options.labels.lines.color}).attr("stroke-width",1).attr("fill","none").style("opacity",function(x,w){var u=q.options.labels.outer.hideWhenLessThanPercentage;var v=(u!==null&&q.options.data.content[w].percentage<u)||q.options.data.content[w].label==="";return v?0:1})},positionLabelGroups:function(q,r){if(q.options.labels[r].format==="none"){return}d3.selectAll("."+q.cssPrefix+"labelGroup-"+r).style("opacity",0).attr("transform",function(w,u){var A,z;if(r==="outer"){A=q.outerLabelGroupData[u].x;z=q.outerLabelGroupData[u].y}else{var C=k(true,{},q.pieCenter);if(q.innerRadius>0){var t=d.getSegmentAngle(u,q.options.data.content,q.totalSize,{midpoint:true});var D=n.translate(q.pieCenter.x,q.pieCenter.y,q.innerRadius,t);C.x=D.x;C.y=D.y}var B=b.getDimensions(q.cssPrefix+"labelGroup"+u+"-inner");var v=B.w/2;var s=B.h/4;A=C.x+(q.lineCoordGroups[u][0].x-C.x)/1.8;z=C.y+(q.lineCoordGroups[u][0].y-C.y)/1.8;A=A-v;z=z+s}return"translate("+A+","+z+")"})},fadeInLabelsAndLines:function(q){var r=(q.options.effects.load.effect==="default")?q.options.effects.load.speed:1;setTimeout(function(){var s=(q.options.effects.load.effect==="default")?400:1;d3.selectAll("."+q.cssPrefix+"labelGroup-outer").transition().duration(s).style("opacity",function(v,u){var t=q.options.labels.outer.hideWhenLessThanPercentage;return(t!==null&&v.percentage<t)?0:1});d3.selectAll("."+q.cssPrefix+"labelGroup-inner").transition().duration(s).style("opacity",function(v,u){var t=q.options.labels.inner.hideWhenLessThanPercentage;return(t!==null&&v.percentage<t)?0:1});d3.selectAll("g."+q.cssPrefix+"lineGroups").transition().duration(s).style("opacity",1);if(b.isFunction(q.options.callbacks.onload)){setTimeout(function(){try{q.options.callbacks.onload()}catch(t){}},s)}},r)},getIncludes:function(t){var s=false;var q=false;var r=false;switch(t){case"label":s=true;break;case"value":q=true;break;case"percentage":r=true;break;case"label-value1":case"label-value2":s=true;q=true;break;case"label-percentage1":case"label-percentage2":s=true;r=true;break}return{mainLabel:s,value:q,percentage:r}},computeOuterLabelCoords:function(q){q.svg.selectAll("."+q.cssPrefix+"labelGroup-outer").each(function(s,r){return e.getIdealOuterLabelPositions(q,r)});e.resolveOuterLabelCollisions(q)},resolveOuterLabelCollisions:function(q){if(q.options.labels.outer.format==="none"){return}var r=q.options.data.content.length;e.checkConflict(q,0,"clockwise",r);e.checkConflict(q,r-1,"anticlockwise",r)},checkConflict:function(u,q,y,A){var t,z;if(A<=1){return}var x=u.outerLabelGroupData[q].hs;if(y==="clockwise"&&x!=="right"){return}if(y==="anticlockwise"&&x!=="left"){return}var w=(y==="clockwise")?q+1:q-1;var v=u.outerLabelGroupData[q];var s=u.outerLabelGroupData[w];var r={labelHeights:u.outerLabelGroupData[0].h,center:u.pieCenter,lineLength:(u.outerRadius+u.options.labels.outer.pieDistance),heightChange:u.outerLabelGroupData[0].h+1};if(y==="clockwise"){t=0;for(;t<=q;t++){z=u.outerLabelGroupData[t];if(!e.isLabelHidden(u,t)&&b.rectIntersect(z,s)){e.adjustLabelPos(u,w,v,r);break}}}else{t=A-1;for(;t>=q;t--){z=u.outerLabelGroupData[t];if(!e.isLabelHidden(u,t)&&b.rectIntersect(z,s)){e.adjustLabelPos(u,w,v,r);break}}}e.checkConflict(u,w,y,A)},isLabelHidden:function(r,s){var q=r.options.labels.outer.hideWhenLessThanPercentage;return(q!==null&&r.options.data.content[s].percentage<q)||r.options.data.content[s].label===""},adjustLabelPos:function(s,q,r,w){var x,u,v,t;t=r.y+w.heightChange;u=w.center.y-t;if(Math.abs(w.lineLength)>Math.abs(u)){x=Math.sqrt((w.lineLength*w.lineLength)-(u*u))}else{x=Math.sqrt((u*u)-(w.lineLength*w.lineLength))}if(r.hs==="right"){v=w.center.x+x}else{v=w.center.x-x-s.outerLabelGroupData[q].w}s.outerLabelGroupData[q].x=v;s.outerLabelGroupData[q].y=t},getIdealOuterLabelPositions:function(u,t){var x=d3.select("#"+u.cssPrefix+"labelGroup"+t+"-outer").node();if(!x){return}var s=x.getBBox();var r=d.getSegmentAngle(t,u.options.data.content,u.totalSize,{midpoint:true});var w=u.pieCenter.x;var v=u.pieCenter.y-(u.outerRadius+u.options.labels.outer.pieDistance);var y=n.rotate(w,v,u.pieCenter.x,u.pieCenter.y,r);var q="right";if(r>180){y.x-=(s.width+8);q="left"}else{y.x+=8}u.outerLabelGroupData[t]={x:y.x,y:y.y,w:s.width,h:s.height,hs:q}}};var d={effectMap:{none:d3.easeLinear,bounce:d3.easeBounce,linear:d3.easeLinear,sin:d3.easeSin,elastic:d3.easeElastic,back:d3.easeBack,quad:d3.easeQuad,circle:d3.easeCircle,exp:d3.easeExp},create:function(u){var w=u.pieCenter;var q=u.options.colors;var y=u.options.effects.load;var s=u.options.misc.colors.segmentStroke;var x=u.svg.insert("g","#"+u.cssPrefix+"title").attr("transform",function(){return n.getPieTranslateCenter(w)}).attr("class",u.cssPrefix+"pieChart");var t=d3.arc().innerRadius(u.innerRadius).outerRadius(u.outerRadius).startAngle(0).endAngle(function(z){return(z.value/u.totalSize)*2*Math.PI});var v=x.selectAll("."+u.cssPrefix+"arc").data(u.options.data.content).enter().append("g").attr("class",u.cssPrefix+"arc");var r=y.speed;if(y.effect==="none"){r=0}v.append("path").attr("id",function(A,z){return u.cssPrefix+"segment"+z}).attr("fill",function(B,A){var z=q[A];if(u.options.misc.gradient.enabled){z="url(#"+u.cssPrefix+"grad"+A+")"}return z}).attr("data-index",function(A,z){return z}).style("stroke",s).style("stroke-width",1).transition().ease(d3.easeCubicInOut).duration(r).attrTween("d",function(z){var A=d3.interpolate({value:0},z);return function(B){return u.arc(A(B))}});u.svg.selectAll("g."+u.cssPrefix+"arc").attr("transform",function(B,z){var A=0;if(z>0){A=d.getSegmentAngle(z-1,u.options.data.content,u.totalSize)}return"rotate("+A+")"});u.arc=t},addGradients:function(q){var r=q.svg.append("defs").selectAll("radialGradient").data(q.options.data.content).enter().append("radialGradient").attr("gradientUnits","userSpaceOnUse").attr("cx",0).attr("cy",0).attr("r","120%").attr("id",function(t,s){return q.cssPrefix+"grad"+s});r.append("stop").attr("offset","0%").style("stop-color",function(t,s){return q.options.colors[s]});r.append("stop").attr("offset",q.options.misc.gradient.percentage+"%").style("stop-color",q.options.misc.gradient.color)},addSegmentEventHandlers:function(q){var r=d3.selectAll("."+q.cssPrefix+"arc,."+q.cssPrefix+"labelGroup-inner,."+q.cssPrefix+"labelGroup-outer");r.on("click",function(){var u=d3.select(this);var t;if(u.attr("class")===q.cssPrefix+"arc"){t=u.select("path")}else{var s=u.attr("data-index");t=d3.select("#"+q.cssPrefix+"segment"+s)}var v=t.attr("class")===q.cssPrefix+"expanded";d.onSegmentEvent(q,q.options.callbacks.onClickSegment,t,v);if(q.options.effects.pullOutSegmentOnClick.effect!=="none"){if(v){d.closeSegment(q,t.node())}else{d.openSegment(q,t.node())}}});r.on("mouseover",function(){var v=d3.select(this);var u,s;if(v.attr("class")===q.cssPrefix+"arc"){u=v.select("path")}else{s=v.attr("data-index");u=d3.select("#"+q.cssPrefix+"segment"+s)}if(q.options.effects.highlightSegmentOnMouseover){s=u.attr("data-index");var t=q.options.colors[s];u.style("fill",b.getColorShade(t,q.options.effects.highlightLuminosity))}if(q.options.tooltips.enabled){s=u.attr("data-index");i.showTooltip(q,s)}var w=u.attr("class")===q.cssPrefix+"expanded";d.onSegmentEvent(q,q.options.callbacks.onMouseoverSegment,u,w)});r.on("mousemove",function(){i.moveTooltip(q)});r.on("mouseout",function(){var v=d3.select(this);var u,t;if(v.attr("class")===q.cssPrefix+"arc"){u=v.select("path")}else{t=v.attr("data-index");u=d3.select("#"+q.cssPrefix+"segment"+t)}if(q.options.effects.highlightSegmentOnMouseover){t=u.attr("data-index");var s=q.options.colors[t];if(q.options.misc.gradient.enabled){s="url(#"+q.cssPrefix+"grad"+t+")"}u.style("fill",s)}if(q.options.tooltips.enabled){t=u.attr("data-index");i.hideTooltip(q,t)}var w=u.attr("class")===q.cssPrefix+"expanded";d.onSegmentEvent(q,q.options.callbacks.onMouseoutSegment,u,w)})},onSegmentEvent:function(q,t,s,u){if(!b.isFunction(t)){return}var r=parseInt(s.attr("data-index"),10);t({segment:s.node(),index:r,expanded:u,data:q.options.data.content[r]})},openSegment:function(q,r){if(q.isOpeningSegment){return}q.isOpeningSegment=true;d.maybeCloseOpenSegment(q);d3.select(r).transition().ease(d.effectMap[q.options.effects.pullOutSegmentOnClick.effect]).duration(q.options.effects.pullOutSegmentOnClick.speed).attr("transform",function(w,u){var A=q.arc.centroid(w),s=A[0],z=A[1],v=Math.sqrt(s*s+z*z),t=parseInt(q.options.effects.pullOutSegmentOnClick.size,10);return"translate("+((s/v)*t)+","+((z/v)*t)+")"}).on("end",function(t,s){q.currentlyOpenSegment=r;q.isOpeningSegment=false;d3.select(r).attr("class",q.cssPrefix+"expanded")})},maybeCloseOpenSegment:function(q){if(d3.selectAll("."+q.cssPrefix+"expanded").size()>0){d.closeSegment(q,d3.select("."+q.cssPrefix+"expanded").node())}},closeSegment:function(q,r){d3.select(r).transition().duration(400).attr("transform","translate(0,0)").on("end",function(t,s){d3.select(r).attr("class","");q.currentlyOpenSegment=null})},getCentroid:function(q){var r=q.getBBox();return{x:r.x+r.width/2,y:r.y+r.height/2}},getSegmentAngle:function(w,t,y,q){var z=k({compounded:true,midpoint:false},q);var s=t[w].value;var v;if(z.compounded){v=0;for(var u=0;u<=w;u++){v+=t[u].value}}if(typeof v==="undefined"){v=s}var r=(v/y)*360;if(z.midpoint){var x=(s/y)*360;r-=(x/2)}return r}};var o={offscreenCoord:-10000,addTitle:function(q){var r=q.svg.selectAll("."+q.cssPrefix+"title").data([q.options.header.title]).enter().append("text").text(function(s){return s.text}).attr("id",q.cssPrefix+"title").attr("class",q.cssPrefix+"title").attr("x",o.offscreenCoord).attr("y",o.offscreenCoord).attr("text-anchor",function(){var s;if(q.options.header.location==="top-center"||q.options.header.location==="pie-center"){s="middle"}else{s="left"}return s}).attr("fill",function(s){return s.color}).style("font-size",function(s){return s.fontSize+"px"}).style("font-family",function(s){return s.font})},positionTitle:function(s){var t=s.textComponents;var z=s.options.header.location;var q=s.options.misc.canvasPadding;var r=s.options.size.canvasWidth;var A=s.options.header.titleSubtitlePadding;var w;if(z==="top-left"){w=q.left}else{w=((r-q.right)/2)+q.left}w+=s.options.misc.pieCenterOffset.x;var v=q.top+t.title.h;if(z==="pie-center"){v=s.pieCenter.y;if(t.subtitle.exists){var u=t.title.h+A+t.subtitle.h;v=v-(u/2)+t.title.h}else{v+=(t.title.h/4)}}s.svg.select("#"+s.cssPrefix+"title").attr("x",w).attr("y",v)},addSubtitle:function(q){var r=q.options.header.location;q.svg.selectAll("."+q.cssPrefix+"subtitle").data([q.options.header.subtitle]).enter().append("text").text(function(s){return s.text}).attr("x",o.offscreenCoord).attr("y",o.offscreenCoord).attr("id",q.cssPrefix+"subtitle").attr("class",q.cssPrefix+"subtitle").attr("text-anchor",function(){var s;if(r==="top-center"||r==="pie-center"){s="middle"}else{s="left"}return s}).attr("fill",function(s){return s.color}).style("font-size",function(s){return s.fontSize+"px"}).style("font-family",function(s){return s.font})},positionSubtitle:function(s){var t=s.options.misc.canvasPadding;var r=s.options.size.canvasWidth;var q;if(s.options.header.location==="top-left"){q=t.left}else{q=((r-t.right)/2)+t.left}q+=s.options.misc.pieCenterOffset.x;var u=o.getHeaderHeight(s);s.svg.select("#"+s.cssPrefix+"subtitle").attr("x",q).attr("y",u)},addFooter:function(q){q.svg.selectAll("."+q.cssPrefix+"footer").data([q.options.footer]).enter().append("text").text(function(r){return r.text}).attr("x",o.offscreenCoord).attr("y",o.offscreenCoord).attr("id",q.cssPrefix+"footer").attr("class",q.cssPrefix+"footer").attr("text-anchor",function(){var r="left";if(q.options.footer.location==="bottom-center"){r="middle"}else{if(q.options.footer.location==="bottom-right"){r="left"}}return r}).attr("fill",function(r){return r.color}).style("font-size",function(r){return r.fontSize+"px"}).style("font-family",function(r){return r.font})},positionFooter:function(t){var w=t.options.footer.location;var s=t.textComponents.footer.w;var r=t.options.size.canvasWidth;var u=t.options.size.canvasHeight;var v=t.options.misc.canvasPadding;var q;if(w==="bottom-left"){q=v.left}else{if(w==="bottom-right"){q=r-s-v.right}else{q=r/2}}t.svg.select("#"+t.cssPrefix+"footer").attr("x",q).attr("y",u-v.bottom)},getHeaderHeight:function(r){var s;if(r.textComponents.title.exists){var q=r.textComponents.title.h+r.options.header.titleSubtitlePadding+r.textComponents.subtitle.h;if(r.options.header.location==="pie-center"){s=r.pieCenter.y-(q/2)+q}else{s=q+r.options.misc.canvasPadding.top}}else{if(r.options.header.location==="pie-center"){var t=r.options.misc.canvasPadding.bottom+r.textComponents.footer.h;s=((r.options.size.canvasHeight-t)/2)+r.options.misc.canvasPadding.top+(r.textComponents.subtitle.h/2)}else{s=r.options.misc.canvasPadding.top+r.textComponents.subtitle.h}}return s}};var i={addTooltips:function(q){var r=q.svg.insert("g").attr("class",q.cssPrefix+"tooltips");r.selectAll("."+q.cssPrefix+"tooltip").data(q.options.data.content).enter().append("g").attr("class",q.cssPrefix+"tooltip").attr("id",function(t,s){return q.cssPrefix+"tooltip"+s}).style("opacity",0).append("rect").attr("rx",q.options.tooltips.styles.borderRadius).attr("ry",q.options.tooltips.styles.borderRadius).attr("x",-q.options.tooltips.styles.padding).attr("opacity",q.options.tooltips.styles.backgroundOpacity).style("fill",q.options.tooltips.styles.backgroundColor);r.selectAll("."+q.cssPrefix+"tooltip").data(q.options.data.content).append("text").attr("fill",function(s){return q.options.tooltips.styles.color}).style("font-size",function(s){return q.options.tooltips.styles.fontSize}).style("font-family",function(s){return q.options.tooltips.styles.font}).text(function(u,t){var s=q.options.tooltips.string;if(q.options.tooltips.type==="caption"){s=u.caption}return i.replacePlaceholders(q,s,t,{label:u.label,value:u.value,percentage:u.percentage})});r.selectAll("."+q.cssPrefix+"tooltip rect").attr("width",function(u,s){var t=b.getDimensions(q.cssPrefix+"tooltip"+s);return t.w+(2*q.options.tooltips.styles.padding)}).attr("height",function(u,s){var t=b.getDimensions(q.cssPrefix+"tooltip"+s);return t.h+(2*q.options.tooltips.styles.padding)}).attr("y",function(u,s){var t=b.getDimensions(q.cssPrefix+"tooltip"+s);return -(t.h/2)+1})},showTooltip:function(q,r){var s=q.options.tooltips.styles.fadeInSpeed;if(i.currentTooltip===r){s=1}i.currentTooltip=r;d3.select("#"+q.cssPrefix+"tooltip"+r).transition().duration(s).style("opacity",function(){return 1});i.moveTooltip(q)},moveTooltip:function(q){d3.selectAll("#"+q.cssPrefix+"tooltip"+i.currentTooltip).attr("transform",function(t){var s=d3.mouse(this.parentNode);var r=s[0]+q.options.tooltips.styles.padding+2;var u=s[1]-(2*q.options.tooltips.styles.padding)-2;return"translate("+r+","+u+")"})},hideTooltip:function(q,r){d3.select("#"+q.cssPrefix+"tooltip"+r).style("opacity",function(){return 0});d3.select("#"+q.cssPrefix+"tooltip"+i.currentTooltip).attr("transform",function(u,t){var s=q.options.size.canvasWidth+1000;var v=q.options.size.canvasHeight+1000;return"translate("+s+","+v+")"})},replacePlaceholders:function(q,u,r,t){if(b.isFunction(q.options.tooltips.placeholderParser)){q.options.tooltips.placeholderParser(r,t)}var s=function(){return function(v){var w=arguments[1];if(t.hasOwnProperty(w)){return t[arguments[1]]}else{return arguments[0]}}};return u.replace(/\{(\w+)\}/g,s(t))}};var c=function(r,q){this.element=r;if(typeof r==="string"){var s=r.replace(/^#/,"");this.element=document.getElementById(s)}var t={};k(true,t,h,q);this.options=t;if(this.options.misc.cssPrefix!==null){this.cssPrefix=this.options.misc.cssPrefix}else{this.cssPrefix="p"+p+"_";p++}if(!m.initialCheck(this)){return}d3.select(this.element).attr(g,f);j.call(this);l.call(this)};c.prototype.recreate=function(){if(!m.initialCheck(this)){return}j.call(this);l.call(this)};c.prototype.redraw=function(){this.element.innerHTML="";l.call(this)};c.prototype.destroy=function(){this.element.innerHTML="";d3.select(this.element).attr(g,null)};c.prototype.getOpenSegment=function(){var r=this.currentlyOpenSegment;if(r!==null&&typeof r!=="undefined"){var q=parseInt(d3.select(r).attr("data-index"),10);return{element:r,index:q,data:this.options.data.content[q]}}else{return null}};c.prototype.openSegment=function(q){q=parseInt(q,10);if(q<0||q>this.options.data.content.length-1){return}d.openSegment(this,d3.select("#"+this.cssPrefix+"segment"+q).node())};c.prototype.closeSegment=function(){d.maybeCloseOpenSegment()};c.prototype.updateProp=function(s,t){switch(s){case"header.title.text":var q=b.processObj(this.options,s);b.processObj(this.options,s,t);d3.select("#"+this.cssPrefix+"title").html(t);if((q===""&&t!=="")||(q!==""&&t==="")){this.redraw()}break;case"header.subtitle.text":var r=b.processObj(this.options,s);b.processObj(this.options,s,t);d3.select("#"+this.cssPrefix+"subtitle").html(t);if((r===""&&t!=="")||(r!==""&&t==="")){this.redraw()}break;case"callbacks.onload":case"callbacks.onMouseoverSegment":case"callbacks.onMouseoutSegment":case"callbacks.onClickSegment":case"effects.pullOutSegmentOnClick.effect":case"effects.pullOutSegmentOnClick.speed":case"effects.pullOutSegmentOnClick.size":case"effects.highlightSegmentOnMouseover":case"effects.highlightLuminosity":b.processObj(this.options,s,t);break;default:b.processObj(this.options,s,t);this.destroy();this.recreate();break}};var j=function(){this.options.data.content=n.sortPieData(this);if(this.options.data.smallSegmentGrouping.enabled){this.options.data.content=b.applySmallSegmentGrouping(this.options.data.content,this.options.data.smallSegmentGrouping)}this.options.colors=b.initSegmentColors(this);this.totalSize=n.getTotalPieSize(this.options.data.content);var t=this.options.labels.percentage.decimalPlaces;for(var s=0;s<this.options.data.content.length;s++){this.options.data.content[s].percentage=a(this.options.data.content[s].value,this.totalSize,t)}var q=0;for(var r=0;r<this.options.data.content.length;r++){if(r===this.options.data.content.length-1){this.options.data.content[r].percentage=(100-q).toFixed(t)}q+=parseFloat(this.options.data.content[r].percentage)}};var l=function(){this.svg=b.addSVGSpace(this);this.textComponents={headerHeight:0,title:{exists:this.options.header.title.text!=="",h:0,w:0},subtitle:{exists:this.options.header.subtitle.text!=="",h:0,w:0},footer:{exists:this.options.footer.text!=="",h:0,w:0}};this.outerLabelGroupData=[];if(this.textComponents.title.exists){o.addTitle(this)}if(this.textComponents.subtitle.exists){o.addSubtitle(this)}o.addFooter(this);var r=this;b.whenIdExists(this.cssPrefix+"footer",function(){o.positionFooter(r);var s=b.getDimensions(r.cssPrefix+"footer");r.textComponents.footer.h=s.h;r.textComponents.footer.w=s.w});var q=[];if(this.textComponents.title.exists){q.push(this.cssPrefix+"title")}if(this.textComponents.subtitle.exists){q.push(this.cssPrefix+"subtitle")}if(this.textComponents.footer.exists){q.push(this.cssPrefix+"footer")}b.whenElementsExist(q,function(){if(r.textComponents.title.exists){var u=b.getDimensions(r.cssPrefix+"title");r.textComponents.title.h=u.h;r.textComponents.title.w=u.w}if(r.textComponents.subtitle.exists){var t=b.getDimensions(r.cssPrefix+"subtitle");r.textComponents.subtitle.h=t.h;r.textComponents.subtitle.w=t.w}if(r.textComponents.title.exists||r.textComponents.subtitle.exists){var s=0;if(r.textComponents.title.exists){s+=r.textComponents.title.h;if(r.textComponents.subtitle.exists){s+=r.options.header.titleSubtitlePadding}}if(r.textComponents.subtitle.exists){s+=r.textComponents.subtitle.h}r.textComponents.headerHeight=s}n.computePieRadius(r);n.calculatePieCenter(r);o.positionTitle(r);o.positionSubtitle(r);if(r.options.misc.gradient.enabled){d.addGradients(r)}d.create(r);e.add(r,"inner",r.options.labels.inner.format);e.add(r,"outer",r.options.labels.outer.format);e.positionLabelElements(r,"inner",r.options.labels.inner.format);e.positionLabelElements(r,"outer",r.options.labels.outer.format);e.computeOuterLabelCoords(r);e.positionLabelGroups(r,"outer");e.computeLabelLinePositions(r);if(r.options.labels.lines.enabled&&r.options.labels.outer.format!=="none"){e.addLabelLines(r)}e.positionLabelGroups(r,"inner");e.fadeInLabelsAndLines(r);if(r.options.tooltips.enabled){i.addTooltips(r)}d.addSegmentEventHandlers(r)})};var a=function(s,r,q){var t=s/r;if(q<=0){return Math.round(t*100)}else{return(t*100).toFixed(q)}};return c}));