/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import com.carrotsearch.randomizedtesting.generators.RandomNumbers;
import java.io.IOException;
import java.util.Random;
import org.apache.lucene.search.AssertingLeafCollector;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.util.Bits;

final class AssertingBulkScorer
extends BulkScorer {
    final Random random;
    final BulkScorer in;
    final int maxDoc;
    int max = 0;

    public static BulkScorer wrap(Random random, BulkScorer other, int maxDoc) {
        if (other == null || other instanceof AssertingBulkScorer) {
            return other;
        }
        return new AssertingBulkScorer(random, other, maxDoc);
    }

    private AssertingBulkScorer(Random random, BulkScorer in, int maxDoc) {
        this.random = random;
        this.in = in;
        this.maxDoc = maxDoc;
    }

    public BulkScorer getIn() {
        return this.in;
    }

    public long cost() {
        return this.in.cost();
    }

    public void score(LeafCollector collector, Bits acceptDocs) throws IOException {
        assert (this.max == 0);
        collector = new AssertingLeafCollector(this.random, (LeafCollector)collector, 0, Integer.MAX_VALUE);
        if (this.random.nextBoolean()) {
            try {
                int next = this.score((LeafCollector)collector, acceptDocs, 0, Integer.MAX_VALUE);
                assert (next == Integer.MAX_VALUE);
            }
            catch (UnsupportedOperationException e) {
                this.in.score(collector, acceptDocs);
            }
        } else {
            this.in.score(collector, acceptDocs);
        }
    }

    public int score(LeafCollector collector, Bits acceptDocs, int min, int max) throws IOException {
        assert (min >= this.max) : "Scoring backward: min=" + min + " while previous max was max=" + this.max;
        assert (min <= max) : "max must be greater than min, got min=" + min + ", and max=" + max;
        this.max = max;
        collector = new AssertingLeafCollector(this.random, (LeafCollector)collector, min, max);
        int next = this.in.score(collector, acceptDocs, min, max);
        assert (next >= max);
        if (max >= this.maxDoc || next >= this.maxDoc) {
            assert (next == Integer.MAX_VALUE);
            return Integer.MAX_VALUE;
        }
        return RandomNumbers.randomIntBetween((Random)this.random, (int)max, (int)next);
    }

    public String toString() {
        return "AssertingBulkScorer(" + this.in + ")";
    }
}

