/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.cloud.autoscaling;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.cloud.autoscaling.AddReplicaSuggester;
import org.apache.solr.client.solrj.cloud.autoscaling.Clause;
import org.apache.solr.client.solrj.cloud.autoscaling.MoveReplicaSuggester;
import org.apache.solr.client.solrj.cloud.autoscaling.Preference;
import org.apache.solr.client.solrj.cloud.autoscaling.Row;
import org.apache.solr.client.solrj.cloud.autoscaling.SolrCloudManager;
import org.apache.solr.client.solrj.cloud.autoscaling.Suggester;
import org.apache.solr.client.solrj.cloud.autoscaling.Suggestion;
import org.apache.solr.client.solrj.cloud.autoscaling.Violation;
import org.apache.solr.client.solrj.impl.ClusterStateProvider;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;

public class Policy
implements MapWriter {
    public static final String POLICY = "policy";
    public static final String EACH = "#EACH";
    public static final String ANY = "#ANY";
    public static final String POLICIES = "policies";
    public static final String CLUSTER_POLICY = "cluster-policy";
    public static final String CLUSTER_PREFERENCES = "cluster-preferences";
    public static final Set<String> GLOBAL_ONLY_TAGS = Collections.singleton("cores");
    public static final Preference DEFAULT_PREFERENCE = new Preference((Map)Utils.fromJSONString("{minimize : cores, precision:1}"));
    final Map<String, List<Clause>> policies;
    final List<Clause> clusterPolicy;
    final List<Preference> clusterPreferences;
    final List<String> params;
    final List<String> perReplicaAttributes;
    private static final Map<CollectionParams.CollectionAction, Supplier<Suggester>> ops = new HashMap<CollectionParams.CollectionAction, Supplier<Suggester>>();

    public Policy() {
        this(Collections.emptyMap());
    }

    public Policy(Map<String, Object> jsonMap) {
        int[] idx = new int[1];
        List initialClusterPreferences = jsonMap.getOrDefault(CLUSTER_PREFERENCES, Collections.emptyList()).stream().map(m -> {
            int n = idx[0];
            idx[0] = n + 1;
            return new Preference((Map<String, Object>)m, n);
        }).collect(Collectors.toList());
        for (int i = 0; i < initialClusterPreferences.size() - 1; ++i) {
            Preference preference = (Preference)initialClusterPreferences.get(i);
            preference.next = (Preference)initialClusterPreferences.get(i + 1);
        }
        if (initialClusterPreferences.isEmpty()) {
            initialClusterPreferences.add(DEFAULT_PREFERENCE);
        }
        this.clusterPreferences = Collections.unmodifiableList(initialClusterPreferences);
        TreeSet<String> paramsOfInterest = new TreeSet<String>();
        for (Preference preference : this.clusterPreferences) {
            if (paramsOfInterest.contains(preference.name.name())) {
                throw new RuntimeException((Object)((Object)preference.name) + " is repeated");
            }
            paramsOfInterest.add(preference.name.toString());
        }
        ArrayList<String> newParams = new ArrayList<String>(paramsOfInterest);
        this.clusterPolicy = jsonMap.getOrDefault(CLUSTER_POLICY, Collections.emptyList()).stream().map(Clause::new).filter(clause -> {
            clause.addTags(newParams);
            return true;
        }).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        this.policies = Collections.unmodifiableMap(Policy.policiesFromMap(jsonMap.getOrDefault(POLICIES, Collections.emptyMap()), newParams));
        this.params = Collections.unmodifiableList(newParams);
        this.perReplicaAttributes = this.readPerReplicaAttrs();
    }

    private List<String> readPerReplicaAttrs() {
        return this.params.stream().map(Suggestion.tagVsPerReplicaVal::get).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private Policy(Map<String, List<Clause>> policies, List<Clause> clusterPolicy, List<Preference> clusterPreferences) {
        this.policies = policies != null ? Collections.unmodifiableMap(policies) : Collections.emptyMap();
        this.clusterPolicy = clusterPolicy != null ? Collections.unmodifiableList(clusterPolicy) : Collections.emptyList();
        this.clusterPreferences = clusterPreferences != null ? Collections.unmodifiableList(clusterPreferences) : Collections.singletonList(DEFAULT_PREFERENCE);
        this.params = Collections.unmodifiableList(this.buildParams(this.clusterPreferences, this.clusterPolicy, this.policies));
        this.perReplicaAttributes = this.readPerReplicaAttrs();
    }

    private List<String> buildParams(List<Preference> preferences, List<Clause> policy, Map<String, List<Clause>> policies) {
        TreeSet paramsOfInterest = new TreeSet();
        preferences.forEach(p -> {
            if (paramsOfInterest.contains(p.name.name())) {
                throw new RuntimeException((Object)((Object)p.name) + " is repeated");
            }
            paramsOfInterest.add(p.name.toString());
        });
        ArrayList<String> newParams = new ArrayList<String>(paramsOfInterest);
        policy.forEach(c -> c.addTags(newParams));
        policies.values().forEach(clauses -> clauses.forEach(c -> c.addTags(newParams)));
        return newParams;
    }

    public Policy withPolicies(Map<String, List<Clause>> policies) {
        return new Policy(policies, this.clusterPolicy, this.clusterPreferences);
    }

    public Policy withClusterPreferences(List<Preference> clusterPreferences) {
        return new Policy(this.policies, this.clusterPolicy, clusterPreferences);
    }

    public Policy withClusterPolicy(List<Clause> clusterPolicy) {
        return new Policy(this.policies, clusterPolicy, this.clusterPreferences);
    }

    public Policy withParams(List<String> params) {
        return new Policy(this.policies, this.clusterPolicy, this.clusterPreferences);
    }

    public List<Clause> getClusterPolicy() {
        return this.clusterPolicy;
    }

    public List<Preference> getClusterPreferences() {
        return this.clusterPreferences;
    }

    @Override
    public void writeMap(MapWriter.EntryWriter ew) throws IOException {
        if (!this.policies.isEmpty()) {
            ew.put(POLICIES, ew1 -> {
                for (Map.Entry<String, List<Clause>> e : this.policies.entrySet()) {
                    ew1.put(e.getKey(), e.getValue());
                }
            });
        }
        if (!this.clusterPreferences.isEmpty()) {
            ew.put(CLUSTER_PREFERENCES, iw -> {
                for (Preference p : this.clusterPreferences) {
                    iw.add(p);
                }
            });
        }
        if (!this.clusterPolicy.isEmpty()) {
            ew.put(CLUSTER_POLICY, iw -> {
                for (Clause c : this.clusterPolicy) {
                    iw.add(c);
                }
            });
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Policy policy = (Policy)o;
        if (!this.getPolicies().equals(policy.getPolicies())) {
            return false;
        }
        if (!this.getClusterPolicy().equals(policy.getClusterPolicy())) {
            return false;
        }
        if (!this.getClusterPreferences().equals(policy.getClusterPreferences())) {
            return false;
        }
        return this.params.equals(policy.params);
    }

    static void setApproxValuesAndSortNodes(List<Preference> clusterPreferences, List<Row> matrix) {
        if (!clusterPreferences.isEmpty()) {
            ArrayList<Row> tmpMatrix = new ArrayList<Row>(matrix);
            for (Preference p : clusterPreferences) {
                Collections.sort(tmpMatrix, (r1, r2) -> p.compare((Row)r1, (Row)r2, false));
                p.setApproxVal(tmpMatrix);
            }
            Collections.sort(matrix, (r1, r2) -> {
                int result = ((Preference)clusterPreferences.get(0)).compare((Row)r1, (Row)r2, true);
                if (result == 0) {
                    result = ((Preference)clusterPreferences.get(0)).compare((Row)r1, (Row)r2, false);
                }
                return result;
            });
        }
    }

    public Session createSession(SolrCloudManager cloudManager) {
        return new Session(cloudManager);
    }

    public static Map<String, List<Clause>> policiesFromMap(Map<String, List<Map<String, Object>>> map, List<String> newParams) {
        HashMap<String, List<Clause>> newPolicies = new HashMap<String, List<Clause>>();
        map.forEach((s, l1) -> newPolicies.put((String)s, l1.stream().map(Clause::new).filter(clause -> {
            if (!clause.isPerCollectiontag()) {
                throw new RuntimeException(clause.globalTag.name + " is only allowed in 'cluster-policy'");
            }
            clause.addTags(newParams);
            return true;
        }).sorted().collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList))));
        return newPolicies;
    }

    public static List<Clause> mergePolicies(String coll, List<Clause> collPolicy, List<Clause> globalPolicy) {
        List<Clause> merged = Policy.insertColl(coll, collPolicy);
        List<Clause> global = Policy.insertColl(coll, globalPolicy);
        merged.addAll(global.stream().filter(clusterPolicyClause -> merged.stream().noneMatch(perCollPolicy -> perCollPolicy.doesOverride((Clause)clusterPolicyClause))).collect(Collectors.toList()));
        return merged;
    }

    static List<Clause> insertColl(String coll, Collection<Clause> conditions) {
        return conditions.stream().filter(Clause::isPerCollectiontag).map(clause -> {
            LinkedHashMap<String, Object> copy = new LinkedHashMap<String, Object>(clause.original);
            if (!copy.containsKey("collection")) {
                copy.put("collection", coll);
            }
            return new Clause(copy);
        }).filter(it -> it.collection.isPass(coll)).collect(Collectors.toList());
    }

    public Map<String, List<Clause>> getPolicies() {
        return this.policies;
    }

    public List<String> getParams() {
        return this.params;
    }

    static int compareRows(Row r1, Row r2, Policy policy) {
        return policy.clusterPreferences.get(0).compare(r1, r2, true);
    }

    public String toString() {
        return Utils.toJSONString(this);
    }

    static {
        ops.put(CollectionParams.CollectionAction.ADDREPLICA, () -> new AddReplicaSuggester());
        ops.put(CollectionParams.CollectionAction.MOVEREPLICA, () -> new MoveReplicaSuggester());
    }

    static enum Sort {
        maximize(1),
        minimize(-1);

        final int sortval;

        private Sort(int i) {
            this.sortval = i;
        }

        static Sort get(Map<String, Object> m) {
            if (m.containsKey(maximize.name()) && m.containsKey(minimize.name())) {
                throw new RuntimeException("Cannot have both 'maximize' and 'minimize'");
            }
            if (m.containsKey(maximize.name())) {
                return maximize;
            }
            if (m.containsKey(minimize.name())) {
                return minimize;
            }
            throw new RuntimeException("must have either 'maximize' or 'minimize'");
        }
    }

    public static enum SortParam {
        freedisk(0, Integer.MAX_VALUE),
        cores(0, Integer.MAX_VALUE),
        heapUsage(0, Integer.MAX_VALUE),
        sysLoadAvg(0, 100);

        public final int min;
        public final int max;

        private SortParam(int min, int max) {
            this.min = min;
            this.max = max;
        }

        static SortParam get(String m) {
            for (SortParam p : SortParam.values()) {
                if (!p.name().equals(m)) continue;
                return p;
            }
            throw new RuntimeException(StrUtils.formatString("Invalid sort {0} Sort must be on one of these {1}", m, Arrays.asList(SortParam.values())));
        }
    }

    public class Session
    implements MapWriter {
        final List<String> nodes;
        final SolrCloudManager cloudManager;
        final List<Row> matrix;
        Set<String> collections = new HashSet<String>();
        List<Clause> expandedClauses;
        List<Violation> violations = new ArrayList<Violation>();

        private Session(List<String> nodes, SolrCloudManager cloudManager, List<Row> matrix, List<Clause> expandedClauses) {
            this.nodes = nodes;
            this.cloudManager = cloudManager;
            this.matrix = matrix;
            this.expandedClauses = expandedClauses;
        }

        Session(SolrCloudManager cloudManager) {
            this.nodes = new ArrayList<String>(cloudManager.getClusterStateProvider().getLiveNodes());
            this.cloudManager = cloudManager;
            for (String node : this.nodes) {
                this.collections.addAll(cloudManager.getNodeStateProvider().getReplicaInfo(node, Collections.emptyList()).keySet());
            }
            this.expandedClauses = Policy.this.clusterPolicy.stream().filter(clause -> !clause.isPerCollectiontag()).collect(Collectors.toList());
            ClusterStateProvider stateProvider = cloudManager.getClusterStateProvider();
            for (String c : this.collections) {
                this.addClausesForCollection(stateProvider, c);
            }
            Collections.sort(this.expandedClauses);
            this.matrix = new ArrayList<Row>(this.nodes.size());
            for (String node : this.nodes) {
                this.matrix.add(new Row(node, Policy.this.params, Policy.this.perReplicaAttributes, cloudManager));
            }
            this.applyRules();
        }

        void addClausesForCollection(ClusterStateProvider stateProvider, String c) {
            List<Clause> perCollPolicy;
            String p = stateProvider.getPolicyNameByCollection(c);
            if (p != null && (perCollPolicy = Policy.this.policies.get(p)) == null) {
                return;
            }
            this.expandedClauses.addAll(Policy.mergePolicies(c, Policy.this.policies.getOrDefault(p, Collections.emptyList()), Policy.this.clusterPolicy));
        }

        Session copy() {
            return new Session(this.nodes, this.cloudManager, this.getMatrixCopy(), this.expandedClauses);
        }

        List<Row> getMatrixCopy() {
            return this.matrix.stream().map(Row::copy).collect(Collectors.toList());
        }

        Policy getPolicy() {
            return Policy.this;
        }

        void applyRules() {
            Policy.setApproxValuesAndSortNodes(Policy.this.clusterPreferences, this.matrix);
            for (Clause clause : this.expandedClauses) {
                List<Violation> errs = clause.test(this.matrix);
                this.violations.addAll(errs);
            }
        }

        public List<Violation> getViolations() {
            return this.violations;
        }

        public Suggester getSuggester(CollectionParams.CollectionAction action) {
            Suggester op = (Suggester)((Supplier)ops.get((Object)action)).get();
            if (op == null) {
                throw new UnsupportedOperationException(action.toString() + "is not supported");
            }
            op._init(this);
            return op;
        }

        @Override
        public void writeMap(MapWriter.EntryWriter ew) throws IOException {
            for (int i = 0; i < this.matrix.size(); ++i) {
                Row row = this.matrix.get(i);
                ew.put(row.node, row);
            }
        }

        public String toString() {
            return Utils.toJSONString(this.toMap(new LinkedHashMap<String, Object>()));
        }

        public List<Row> getSorted() {
            return Collections.unmodifiableList(this.matrix);
        }
    }
}

