/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.solr.common.util.Utils;
import org.apache.solr.common.util.Validator;

class RequiredValidator
extends Validator<List<String>> {
    private Set<String> requiredProps;

    RequiredValidator(Map schema, List<String> requiredProps) {
        super(schema, requiredProps);
        this.requiredProps = new HashSet<String>(requiredProps);
    }

    @Override
    boolean validate(Object o, List<String> errs) {
        if (o instanceof Map) {
            Set fnames = ((Map)o).keySet();
            for (String requiredProp : this.requiredProps) {
                if (fnames.contains(requiredProp)) continue;
                errs.add("Missing required attribute '" + requiredProp + "' in object " + Utils.toJSONString(o));
                return false;
            }
            return true;
        }
        return false;
    }
}

