/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function;

import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FilterScorer;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

public final class FunctionScoreQuery
extends Query {
    private final Query in;
    private final DoubleValuesSource source;

    public FunctionScoreQuery(Query in, DoubleValuesSource source) {
        this.in = in;
        this.source = source;
    }

    public Weight createWeight(IndexSearcher searcher, boolean needsScores, float boost) throws IOException {
        Weight inner = this.in.createWeight(searcher, needsScores && this.source.needsScores(), 1.0f);
        if (!needsScores) {
            return inner;
        }
        return new FunctionScoreWeight(this, inner, this.source.rewrite(searcher), boost);
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query rewritten = this.in.rewrite(reader);
        if (rewritten == this.in) {
            return this;
        }
        return new FunctionScoreQuery(rewritten, this.source);
    }

    public String toString(String field) {
        return "FunctionScoreQuery(" + this.in.toString(field) + ", scored by " + this.source.toString() + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        FunctionScoreQuery that = (FunctionScoreQuery)((Object)o);
        return Objects.equals(this.in, that.in) && Objects.equals(this.source, that.source);
    }

    public int hashCode() {
        return Objects.hash(this.in, this.source);
    }

    private static class FunctionScoreWeight
    extends Weight {
        final Weight inner;
        final DoubleValuesSource valueSource;
        final float boost;

        FunctionScoreWeight(Query query, Weight inner, DoubleValuesSource valueSource, float boost) {
            super(query);
            this.inner = inner;
            this.valueSource = valueSource;
            this.boost = boost;
        }

        public void extractTerms(Set<Term> terms) {
            this.inner.extractTerms(terms);
        }

        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            Scorer scorer = this.inner.scorer(context);
            if (scorer.iterator().advance(doc) != doc) {
                return Explanation.noMatch((String)"No match", (Explanation[])new Explanation[0]);
            }
            Explanation scoreExplanation = this.inner.explain(context, doc);
            Explanation expl = this.valueSource.explain(context, doc, scoreExplanation);
            return Explanation.match((float)(expl.getValue() * this.boost), (String)"product of:", (Explanation[])new Explanation[]{Explanation.match((float)this.boost, (String)"boost", (Explanation[])new Explanation[0]), expl});
        }

        public Scorer scorer(LeafReaderContext context) throws IOException {
            Scorer in = this.inner.scorer(context);
            if (in == null) {
                return null;
            }
            final DoubleValues scores = this.valueSource.getValues(context, DoubleValuesSource.fromScorer((Scorer)in));
            return new FilterScorer(in){

                public float score() throws IOException {
                    if (scores.advanceExact(this.docID())) {
                        return (float)(scores.doubleValue() * (double)boost);
                    }
                    return 0.0f;
                }
            };
        }

        public boolean isCacheable(LeafReaderContext ctx) {
            return this.inner.isCacheable(ctx) && this.valueSource.isCacheable(ctx);
        }
    }
}

