/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.common.MapSerializable;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.util.DOMUtil;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PluginInfo
implements MapSerializable {
    public final String name;
    public final String className;
    public final String type;
    public final NamedList initArgs;
    public final Map<String, String> attributes;
    public final List<PluginInfo> children;
    private boolean isFromSolrConfig;
    public static final PluginInfo EMPTY_INFO = new PluginInfo("", Collections.emptyMap(), new NamedList(), Collections.emptyList());
    private static final HashSet<String> NL_TAGS = new HashSet<String>(Arrays.asList("lst", "arr", "bool", "str", "int", "long", "float", "double"));
    public static final String DEFAULTS = "defaults";
    public static final String APPENDS = "appends";
    public static final String INVARIANTS = "invariants";

    public PluginInfo(String type, Map<String, String> attrs, NamedList initArgs, List<PluginInfo> children) {
        this.type = type;
        this.name = attrs.get("name");
        this.className = attrs.get("class");
        this.initArgs = initArgs;
        this.attributes = Collections.unmodifiableMap(attrs);
        this.children = children == null ? Collections.emptyList() : Collections.unmodifiableList(children);
        this.isFromSolrConfig = false;
    }

    public PluginInfo(Node node, String err, boolean requireName, boolean requireClass) {
        this.type = node.getNodeName();
        this.name = DOMUtil.getAttr(node, "name", requireName ? err : null);
        this.className = DOMUtil.getAttr(node, "class", requireClass ? err : null);
        this.initArgs = DOMUtil.childNodesToNamedList(node);
        this.attributes = Collections.unmodifiableMap(DOMUtil.toMap(node.getAttributes()));
        this.children = this.loadSubPlugins(node);
        this.isFromSolrConfig = true;
    }

    public PluginInfo(String type, Map<String, Object> map) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>(map);
        this.initArgs = new NamedList();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if ("name".equals(entry.getKey()) || "class".equals(entry.getKey())) continue;
            Object value = entry.getValue();
            if (value instanceof List) {
                List list = (List)value;
                if (!list.isEmpty() && list.get(0) instanceof Map) {
                    for (Object o : list) {
                        if (o instanceof Map) {
                            o = new NamedList((Map)o);
                        }
                        this.initArgs.add(entry.getKey(), o);
                    }
                    continue;
                }
                this.initArgs.add(entry.getKey(), value);
                continue;
            }
            if (value instanceof Map) {
                value = new NamedList((Map)value);
            }
            this.initArgs.add(entry.getKey(), value);
        }
        this.type = type;
        this.name = (String)m.get("name");
        this.className = (String)m.get("class");
        this.attributes = Collections.unmodifiableMap(m);
        this.children = Collections.emptyList();
        this.isFromSolrConfig = true;
    }

    private List<PluginInfo> loadSubPlugins(Node node) {
        ArrayList<PluginInfo> children = new ArrayList<PluginInfo>();
        NodeList nlst = node.getChildNodes();
        for (int i = 0; i < nlst.getLength(); ++i) {
            PluginInfo pluginInfo;
            Node nd = nlst.item(i);
            if (nd.getNodeType() != 1 || NL_TAGS.contains(nd.getNodeName()) || !(pluginInfo = new PluginInfo(nd, null, false, false)).isEnabled()) continue;
            children.add(pluginInfo);
        }
        return children.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(children);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.type != null) {
            sb.append("type = " + this.type + ",");
        }
        if (this.name != null) {
            sb.append("name = " + this.name + ",");
        }
        if (this.className != null) {
            sb.append("class = " + this.className + ",");
        }
        if (this.attributes != null && this.attributes.size() > 0) {
            sb.append("attributes = " + this.attributes + ",");
        }
        if (this.initArgs != null && this.initArgs.size() > 0) {
            sb.append("args = " + this.initArgs);
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean isEnabled() {
        String enable = this.attributes.get("enable");
        return enable == null || Boolean.parseBoolean(enable);
    }

    public boolean isDefault() {
        return Boolean.parseBoolean(this.attributes.get("default"));
    }

    public PluginInfo getChild(String type) {
        List<PluginInfo> l = this.getChildren(type);
        return l.isEmpty() ? null : l.get(0);
    }

    public Map<String, Object> toMap(Map<String, Object> map) {
        map.putAll(this.attributes);
        Map<String, Object> m = map;
        if (this.initArgs != null) {
            m.putAll(this.initArgs.asMap(3));
        }
        if (this.children != null) {
            for (PluginInfo child : this.children) {
                Object old = m.get(child.name);
                if (old == null) {
                    m.put(child.name, child.toMap(new LinkedHashMap<String, Object>()));
                    continue;
                }
                if (old instanceof List) {
                    List list = (List)old;
                    list.add(child.toMap(new LinkedHashMap<String, Object>()));
                    continue;
                }
                ArrayList<Object> l = new ArrayList<Object>();
                l.add(old);
                l.add(child.toMap(new LinkedHashMap<String, Object>()));
                m.put(child.name, l);
            }
        }
        return m;
    }

    public List<PluginInfo> getChildren(String type) {
        if (this.children.isEmpty()) {
            return this.children;
        }
        ArrayList<PluginInfo> result = new ArrayList<PluginInfo>();
        for (PluginInfo child : this.children) {
            if (!type.equals(child.type)) continue;
            result.add(child);
        }
        return result;
    }

    public boolean isFromSolrConfig() {
        return this.isFromSolrConfig;
    }

    public PluginInfo copy() {
        PluginInfo result = new PluginInfo(this.type, this.attributes, this.initArgs != null ? this.initArgs.clone() : null, this.children);
        result.isFromSolrConfig = this.isFromSolrConfig;
        return result;
    }
}

