/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import com.google.common.primitives.Longs;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BitDocIdSet;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.FixedBitSet;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.StrField;
import org.apache.solr.search.BitsFilteredDocIdSet;
import org.apache.solr.search.DelegatingCollector;
import org.apache.solr.search.ExtendedQueryBase;
import org.apache.solr.search.Filter;
import org.apache.solr.search.PostFilter;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.search.SolrIndexSearcher;

public class HashQParserPlugin
extends QParserPlugin {
    public static final String NAME = "hash";

    @Override
    public QParser createParser(String query, SolrParams localParams, SolrParams params, SolrQueryRequest request) {
        return new HashQParser(query, localParams, params, request);
    }

    private static class CompositeHash
    implements HashKey {
        private HashKey key1;
        private HashKey key2;
        private HashKey key3;
        private HashKey key4;

        public CompositeHash(HashKey[] hashKeys) {
            this.key1 = hashKeys[0];
            this.key2 = hashKeys[1];
            this.key3 = hashKeys.length > 2 ? hashKeys[2] : new ZeroHash();
            this.key4 = hashKeys.length > 3 ? hashKeys[3] : new ZeroHash();
        }

        @Override
        public void setNextReader(LeafReaderContext context) throws IOException {
            this.key1.setNextReader(context);
            this.key2.setNextReader(context);
            this.key3.setNextReader(context);
            this.key4.setNextReader(context);
        }

        @Override
        public long hashCode(int doc) throws IOException {
            return this.key1.hashCode(doc) + this.key2.hashCode(doc) + this.key3.hashCode(doc) + this.key4.hashCode(doc);
        }
    }

    private static class ZeroHash
    implements HashKey {
        private ZeroHash() {
        }

        @Override
        public long hashCode(int doc) {
            return 0L;
        }

        @Override
        public void setNextReader(LeafReaderContext context) {
        }
    }

    private static class NumericHash
    implements HashKey {
        private NumericDocValues values;
        private String field;

        public NumericHash(String field) {
            this.field = field;
        }

        @Override
        public void setNextReader(LeafReaderContext context) throws IOException {
            this.values = context.reader().getNumericDocValues(this.field);
        }

        @Override
        public long hashCode(int doc) throws IOException {
            int valuesDocID = this.values.docID();
            if (valuesDocID < doc) {
                valuesDocID = this.values.advance(doc);
            }
            long l = valuesDocID == doc ? this.values.longValue() : 0L;
            return Longs.hashCode((long)l);
        }
    }

    private static class BytesHash
    implements HashKey {
        private SortedDocValues values;
        private String field;
        private FieldType fieldType;
        private CharsRefBuilder charsRefBuilder = new CharsRefBuilder();

        public BytesHash(String field, FieldType fieldType) {
            this.field = field;
            this.fieldType = fieldType;
        }

        @Override
        public void setNextReader(LeafReaderContext context) throws IOException {
            this.values = context.reader().getSortedDocValues(this.field);
        }

        @Override
        public long hashCode(int doc) throws IOException {
            if (doc > this.values.docID()) {
                this.values.advance(doc);
            }
            BytesRef ref = doc == this.values.docID() ? this.values.binaryValue() : null;
            this.fieldType.indexedToReadable(ref, this.charsRefBuilder);
            CharsRef charsRef = this.charsRefBuilder.get();
            return charsRef.hashCode();
        }
    }

    private static interface HashKey {
        public void setNextReader(LeafReaderContext var1) throws IOException;

        public long hashCode(int var1) throws IOException;
    }

    private static class HashCollector
    extends DelegatingCollector {
        private int worker;
        private int workers;
        private HashKey hashKey;
        private LeafCollector leafCollector;

        public HashCollector(HashKey hashKey, int workers, int worker) {
            this.hashKey = hashKey;
            this.workers = workers;
            this.worker = worker;
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            this.leafCollector.setScorer(scorer);
        }

        @Override
        public void doSetNextReader(LeafReaderContext context) throws IOException {
            this.hashKey.setNextReader(context);
            this.leafCollector = this.delegate.getLeafCollector(context);
        }

        @Override
        public void collect(int doc) throws IOException {
            if ((this.hashKey.hashCode(doc) & Integer.MAX_VALUE) % (long)this.workers == (long)this.worker) {
                this.leafCollector.collect(doc);
            }
        }
    }

    private static class HashQuery
    extends ExtendedQueryBase
    implements PostFilter {
        private String keysParam;
        private int workers;
        private int worker;

        @Override
        public boolean getCache() {
            if (this.getCost() > 99) {
                return false;
            }
            return super.getCache();
        }

        public int hashCode() {
            return this.classHash() + 31 * this.keysParam.hashCode() + 31 * this.workers + 31 * this.worker;
        }

        public boolean equals(Object other) {
            return this.sameClassAs(other) && this.equalsTo((HashQuery)this.getClass().cast(other));
        }

        private boolean equalsTo(HashQuery other) {
            return this.keysParam.equals(other.keysParam) && this.workers == other.workers && this.worker == other.worker;
        }

        public HashQuery(String keysParam, int workers, int worker) {
            this.keysParam = keysParam;
            this.workers = workers;
            this.worker = worker;
        }

        public Weight createWeight(IndexSearcher searcher, boolean needsScores, float boost) throws IOException {
            String[] keys = this.keysParam.split(",");
            SolrIndexSearcher solrIndexSearcher = (SolrIndexSearcher)searcher;
            IndexReaderContext context = solrIndexSearcher.getTopReaderContext();
            List leaves = context.leaves();
            FixedBitSet[] fixedBitSets = new FixedBitSet[leaves.size()];
            for (LeafReaderContext leaf : leaves) {
                try {
                    SegmentPartitioner segmentPartitioner = new SegmentPartitioner(leaf, this.worker, this.workers, keys, solrIndexSearcher);
                    segmentPartitioner.run();
                    fixedBitSets[segmentPartitioner.context.ord] = segmentPartitioner.docs;
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            ConstantScoreQuery constantScoreQuery = new ConstantScoreQuery((Query)new BitsFilter(fixedBitSets));
            return searcher.rewrite((Query)constantScoreQuery).createWeight(searcher, false, boost);
        }

        @Override
        public DelegatingCollector getFilterCollector(IndexSearcher indexSearcher) {
            String[] keys = this.keysParam.split(",");
            HashKey[] hashKeys = new HashKey[keys.length];
            SolrIndexSearcher searcher = (SolrIndexSearcher)indexSearcher;
            IndexSchema schema = searcher.getSchema();
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                FieldType ft = schema.getField(key).getType();
                HashKey h = null;
                h = ft instanceof StrField ? new BytesHash(key, ft) : new NumericHash(key);
                hashKeys[i] = h;
            }
            HashKey k = hashKeys.length > 1 ? new CompositeHash(hashKeys) : hashKeys[0];
            return new HashCollector(k, this.workers, this.worker);
        }

        static class SegmentPartitioner
        implements Runnable {
            public LeafReaderContext context;
            private int worker;
            private int workers;
            private HashKey k;
            public FixedBitSet docs;

            public SegmentPartitioner(LeafReaderContext context, int worker, int workers, String[] keys, SolrIndexSearcher solrIndexSearcher) {
                this.context = context;
                this.worker = worker;
                this.workers = workers;
                HashKey[] hashKeys = new HashKey[keys.length];
                IndexSchema schema = solrIndexSearcher.getSchema();
                for (int i = 0; i < keys.length; ++i) {
                    String key = keys[i];
                    FieldType ft = schema.getField(key).getType();
                    HashKey h = null;
                    h = ft instanceof StrField ? new BytesHash(key, ft) : new NumericHash(key);
                    hashKeys[i] = h;
                }
                this.k = hashKeys.length > 1 ? new CompositeHash(hashKeys) : hashKeys[0];
            }

            @Override
            public void run() {
                LeafReader reader = this.context.reader();
                try {
                    this.k.setNextReader(this.context);
                    this.docs = new FixedBitSet(reader.maxDoc());
                    int maxDoc = reader.maxDoc();
                    for (int i = 0; i < maxDoc; ++i) {
                        if ((this.k.hashCode(i) & Integer.MAX_VALUE) % (long)this.workers != (long)this.worker) continue;
                        this.docs.set(i);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public static class BitsFilter
        extends Filter {
            private FixedBitSet[] bitSets;

            public BitsFilter(FixedBitSet[] bitSets) {
                this.bitSets = bitSets;
            }

            public String toString(String s) {
                return s;
            }

            @Override
            public DocIdSet getDocIdSet(LeafReaderContext context, Bits bits) {
                return BitsFilteredDocIdSet.wrap((DocIdSet)new BitDocIdSet((BitSet)this.bitSets[context.ord]), bits);
            }

            public boolean equals(Object other) {
                return this.sameClassAs(other) && this.equalsTo((BitsFilter)((Object)((Object)((Object)this)).getClass().cast(other)));
            }

            private boolean equalsTo(BitsFilter other) {
                return Arrays.equals(this.bitSets, other.bitSets);
            }

            public int hashCode() {
                return this.classHash() + Arrays.asList(this.bitSets).hashCode();
            }
        }
    }

    private static class HashQParser
    extends QParser {
        public HashQParser(String query, SolrParams localParams, SolrParams params, SolrQueryRequest request) {
            super(query, localParams, params, request);
        }

        @Override
        public Query parse() {
            int workers = this.localParams.getInt("workers", 0);
            int worker = this.localParams.getInt("worker", 0);
            String keys = this.params.get("partitionKeys");
            keys = keys.replace(" ", "");
            return new HashQuery(keys, workers, worker);
        }
    }
}

