/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.ByteSink;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.ByteSource$AsCharSource;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.ByteStreams;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.CharSource;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.Closer;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;

public abstract class ByteSource {
    protected ByteSource() {
    }

    public CharSource asCharSource(Charset charset) {
        return new ByteSource$AsCharSource(this, charset, null);
    }

    public abstract InputStream openStream();

    public long copyTo(ByteSink byteSink) {
        Preconditions.checkNotNull(byteSink);
        Closer closer = Closer.create();
        try {
            InputStream inputStream = (InputStream)closer.register(this.openStream());
            OutputStream outputStream = (OutputStream)closer.register(byteSink.openStream());
            long l = ByteStreams.copy(inputStream, outputStream);
            return l;
        }
        catch (Throwable throwable) {
            throw closer.rethrow(throwable);
        }
        finally {
            closer.close();
        }
    }

    public byte[] read() {
        Closer closer = Closer.create();
        try {
            InputStream inputStream = (InputStream)closer.register(this.openStream());
            byte[] byArray = ByteStreams.toByteArray(inputStream);
            return byArray;
        }
        catch (Throwable throwable) {
            throw closer.rethrow(throwable);
        }
        finally {
            closer.close();
        }
    }
}

