/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.solr.client.solrj.io.eval.Matrix;
import org.apache.solr.client.solrj.io.eval.OLSRegressionEvaluator;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.eval.RegressionEvaluator;
import org.apache.solr.client.solrj.io.eval.TwoValueWorker;
import org.apache.solr.client.solrj.io.eval.VectorFunction;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class PredictEvaluator
extends RecursiveObjectEvaluator
implements TwoValueWorker {
    protected static final long serialVersionUID = 1L;

    public PredictEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    @Override
    public Object doWork(Object first, Object second) throws IOException {
        if (null == first) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - null found for the first value", this.toExpression(this.constructingFactory)));
        }
        if (null == second) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - null found for the second value", this.toExpression(this.constructingFactory)));
        }
        if (!(first instanceof VectorFunction || first instanceof RegressionEvaluator.RegressionTuple || first instanceof OLSRegressionEvaluator.MultipleRegressionTuple)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - found type %s for the first value, expecting a RegressionTuple", this.toExpression(this.constructingFactory), first.getClass().getSimpleName()));
        }
        if (!(second instanceof Number || second instanceof List || second instanceof Matrix)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - found type %s for the second value, expecting a Number, Array or Matrix", this.toExpression(this.constructingFactory), first.getClass().getSimpleName()));
        }
        if (first instanceof RegressionEvaluator.RegressionTuple) {
            RegressionEvaluator.RegressionTuple regressedTuple = (RegressionEvaluator.RegressionTuple)first;
            if (second instanceof Number) {
                return regressedTuple.predict(((Number)second).doubleValue());
            }
            return ((List)second).stream().map(value -> regressedTuple.predict(((Number)value).doubleValue())).collect(Collectors.toList());
        }
        if (first instanceof OLSRegressionEvaluator.MultipleRegressionTuple) {
            OLSRegressionEvaluator.MultipleRegressionTuple regressedTuple = (OLSRegressionEvaluator.MultipleRegressionTuple)first;
            if (second instanceof List) {
                List list = (List)second;
                double[] predictors = new double[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    predictors[i] = ((Number)list.get(i)).doubleValue();
                }
                return regressedTuple.predict(predictors);
            }
            if (second instanceof Matrix) {
                Matrix m = (Matrix)second;
                double[][] data = m.getData();
                ArrayList<Double> predictions = new ArrayList<Double>();
                for (double[] predictors : data) {
                    predictions.add(regressedTuple.predict(predictors));
                }
                return predictions;
            }
        } else if (first instanceof VectorFunction) {
            VectorFunction vectorFunction = (VectorFunction)first;
            UnivariateFunction univariateFunction = (UnivariateFunction)vectorFunction.getFunction();
            if (second instanceof Number) {
                double x = ((Number)second).doubleValue();
                return univariateFunction.value(x);
            }
            return ((List)second).stream().map(value -> univariateFunction.value(((Number)value).doubleValue())).collect(Collectors.toList());
        }
        return null;
    }
}

