/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.extraction;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class ExtractionDateUtil {
    public static final String PATTERN_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final String PATTERN_RFC1036 = "EEEE, dd-MMM-yy HH:mm:ss zzz";
    public static final String PATTERN_ASCTIME = "EEE MMM d HH:mm:ss yyyy";
    private static final Collection<String> DEFAULT_HTTP_CLIENT_PATTERNS = Arrays.asList("EEE MMM d HH:mm:ss yyyy", "EEEE, dd-MMM-yy HH:mm:ss zzz", "EEE, dd MMM yyyy HH:mm:ss zzz");
    private static final Date DEFAULT_TWO_DIGIT_YEAR_START;
    private static final TimeZone GMT;
    public static final DateTimeFormatter ISO_8601_PARSER;
    public static final Collection<String> DEFAULT_DATE_FORMATS;

    public static Date parseDate(String d) throws ParseException {
        return ExtractionDateUtil.parseDate(d, DEFAULT_DATE_FORMATS);
    }

    public static Date parseDate(String d, Collection<String> fmts) throws ParseException {
        if (d.length() > 0 && d.charAt(d.length() - 1) == 'Z') {
            try {
                return new Date(ISO_8601_PARSER.parse((CharSequence)d, Instant::from).toEpochMilli());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ExtractionDateUtil.parseDate(d, fmts, null);
    }

    public static Date parseDate(String dateValue, Collection<String> dateFormats, Date startDate) throws ParseException {
        if (dateValue == null) {
            throw new IllegalArgumentException("dateValue is null");
        }
        if (dateFormats == null) {
            dateFormats = DEFAULT_HTTP_CLIENT_PATTERNS;
        }
        if (startDate == null) {
            startDate = DEFAULT_TWO_DIGIT_YEAR_START;
        }
        if (dateValue.length() > 1 && dateValue.startsWith("'") && dateValue.endsWith("'")) {
            dateValue = dateValue.substring(1, dateValue.length() - 1);
        }
        SimpleDateFormat dateParser = null;
        for (String format : dateFormats) {
            if (dateParser == null) {
                dateParser = new SimpleDateFormat(format, Locale.ENGLISH);
                dateParser.setTimeZone(GMT);
                dateParser.set2DigitYearStart(startDate);
            } else {
                dateParser.applyPattern(format);
            }
            try {
                return dateParser.parse(dateValue);
            }
            catch (ParseException parseException) {
            }
        }
        throw new ParseException("Unable to parse the date " + dateValue, 0);
    }

    static {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.ROOT);
        calendar.set(2000, 0, 1, 0, 0);
        DEFAULT_TWO_DIGIT_YEAR_START = calendar.getTime();
        GMT = TimeZone.getTimeZone("GMT");
        ISO_8601_PARSER = new DateTimeFormatterBuilder().parseCaseInsensitive().parseLenient().appendInstant().toFormatter(Locale.ROOT);
        DEFAULT_DATE_FORMATS = new ArrayList<String>();
        DEFAULT_DATE_FORMATS.add("yyyy-MM-dd'T'HH:mm:ss'Z'");
        DEFAULT_DATE_FORMATS.add("yyyy-MM-dd'T'HH:mm:ss");
        DEFAULT_DATE_FORMATS.add("yyyy-MM-dd");
        DEFAULT_DATE_FORMATS.add("yyyy-MM-dd hh:mm:ss");
        DEFAULT_DATE_FORMATS.add("yyyy-MM-dd HH:mm:ss");
        DEFAULT_DATE_FORMATS.add("EEE MMM d hh:mm:ss z yyyy");
        DEFAULT_DATE_FORMATS.addAll(DEFAULT_HTTP_CLIENT_PATTERNS);
    }
}

