/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.Vector;
import org.apache.uima.cas.FSFloatConstraint;
import org.apache.uima.internal.util.IntVector;

class FSFloatConstraintImpl
implements FSFloatConstraint {
    private static final long serialVersionUID = 4649271745827863437L;
    private static final int LT = 0;
    private static final int LEQ = 1;
    private static final int EQ = 2;
    private static final int GEQ = 3;
    private static final int GT = 4;
    private IntVector codes = new IntVector();
    private Vector<Float> values = new Vector();

    FSFloatConstraintImpl() {
    }

    public boolean match(float f) {
        int max = this.codes.size();
        block7: for (int i = 0; i < max; ++i) {
            switch (this.codes.get(i)) {
                case 0: {
                    if (!(f >= this.values.get(i).floatValue())) continue block7;
                    return false;
                }
                case 1: {
                    if (!(f > this.values.get(i).floatValue())) continue block7;
                    return false;
                }
                case 2: {
                    if (f == this.values.get(i).floatValue()) continue block7;
                    return false;
                }
                case 3: {
                    if (!(f < this.values.get(i).floatValue())) continue block7;
                    return false;
                }
                case 4: {
                    if (!(f <= this.values.get(i).floatValue())) continue block7;
                    return false;
                }
                default: {
                    throw new Error("Internal error.");
                }
            }
        }
        return true;
    }

    public void eq(float f) {
        this.codes.add(2);
        this.values.add(Float.valueOf(f));
    }

    public void lt(float f) {
        this.codes.add(0);
        this.values.add(Float.valueOf(f));
    }

    public void leq(float f) {
        this.codes.add(1);
        this.values.add(Float.valueOf(f));
    }

    public void gt(float f) {
        this.codes.add(4);
        this.values.add(Float.valueOf(f));
    }

    public void geq(float f) {
        this.codes.add(3);
        this.values.add(Float.valueOf(f));
    }

    public String toString() {
        if (this.codes.size() == 1) {
            return FSFloatConstraintImpl.toString(this.codes.get(0)) + " " + this.values.get(0).toString();
        }
        StringBuffer buf = new StringBuffer();
        buf.append("( ");
        for (int i = 0; i < this.codes.size(); ++i) {
            buf.append(FSFloatConstraintImpl.toString(this.codes.get(i)));
            buf.append(" ");
            buf.append(this.values.get(i).toString());
            buf.append(" ");
        }
        buf.append(")");
        return buf.toString();
    }

    static final String toString(int comp) {
        switch (comp) {
            case 1: {
                return "<=";
            }
            case 0: {
                return "<";
            }
            case 2: {
                return "=";
            }
            case 3: {
                return ">=";
            }
            case 4: {
                return ">";
            }
        }
        return "";
    }
}

