/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.compare;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.httpclient.URI;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.RecordHistory;
import org.parosproxy.paros.db.TableHistory;
import org.parosproxy.paros.db.paros.ParosDatabase;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.SessionChangedListener;
import org.parosproxy.paros.extension.option.DatabaseParam;
import org.parosproxy.paros.extension.report.ReportGenerator;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SessionListener;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.utils.DesktopUtils;

public class ExtensionCompare
extends ExtensionAdaptor
implements SessionChangedListener,
SessionListener {
    private static final String NAME = "ExtensionCompare";
    private static final String CRLF = "\r\n";
    private JMenuItem menuCompare = null;
    private static Logger log = Logger.getLogger(ExtensionCompare.class);

    public ExtensionCompare() {
        super(NAME);
        this.setOrder(44);
    }

    @Override
    public String getUIName() {
        return Constant.messages.getString("cmp.name");
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        if (this.getView() != null) {
            extensionHook.getHookMenu().addReportMenuItem(this.getMenuCompare());
        }
    }

    @Override
    public void sessionChanged(final Session session) {
        if (EventQueue.isDispatchThread()) {
            this.sessionChangedEventHandler(session);
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ExtensionCompare.this.sessionChangedEventHandler(session);
                    }
                });
            }
            catch (Exception e) {
                log.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void sessionChangedEventHandler(Session session) {
    }

    @Override
    public void sessionScopeChanged(Session session) {
    }

    private JMenuItem getMenuCompare() {
        if (this.menuCompare == null) {
            this.menuCompare = new JMenuItem();
            this.menuCompare.setText(Constant.messages.getString("cmp.file.menu.compare"));
            this.menuCompare.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExtensionCompare.this.compareSessions();
                }
            });
        }
        return this.menuCompare;
    }

    private void buildHistoryMap(TableHistory th, Map<String, String> map) throws DatabaseException, HttpMalformedHeaderException {
        RecordHistory rh = null;
        for (int i = 0; i < 100 && (rh = th.read(i)) == null; ++i) {
        }
        if (rh == null) {
            return;
        }
        List<Integer> hIds = th.getHistoryIdsOfHistType(rh.getSessionId(), 1, 15, 2, 10);
        for (Integer hId : hIds) {
            RecordHistory recH = th.read(hId);
            URI uri = recH.getHttpMessage().getRequestHeader().getURI();
            String mapKey = recH.getHttpMessage().getRequestHeader().getMethod() + " " + uri.toString();
            if (mapKey.indexOf("?") > -1) {
                mapKey = mapKey.substring(0, mapKey.indexOf("?"));
            }
            String val = map.get(mapKey);
            String code = recH.getHttpMessage().getResponseHeader().getStatusCode() + " ";
            if (val == null) {
                map.put(mapKey, code);
                continue;
            }
            if (val.indexOf(code) >= 0) continue;
            map.put(mapKey, val + code);
        }
    }

    private void compareSessions() {
        block13: {
            JFileChooser chooser = new JFileChooser(Model.getSingleton().getOptionsParam().getUserDirectory());
            File file = null;
            chooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    return file.isFile() && file.getName().endsWith(".session");
                }

                @Override
                public String getDescription() {
                    return Constant.messages.getString("file.format.zap.session");
                }
            });
            int rc = chooser.showOpenDialog(View.getSingleton().getMainFrame());
            if (rc == 0) {
                try {
                    file = chooser.getSelectedFile();
                    if (file == null) {
                        return;
                    }
                    Model cmpModel = new Model();
                    Session session = cmpModel.getSession();
                    cmpModel.openSession(file, (SessionListener)this);
                    ParosDatabase db = new ParosDatabase();
                    db.setDatabaseParam(new DatabaseParam());
                    db.open(file.getAbsolutePath());
                    HashMap<String, String> curMap = new HashMap<String, String>();
                    HashMap<String, String> cmpMap = new HashMap<String, String>();
                    this.buildHistoryMap(Model.getSingleton().getDb().getTableHistory(), curMap);
                    this.buildHistoryMap(db.getTableHistory(), cmpMap);
                    File outputFile = this.getOutputFile();
                    if (outputFile == null) break block13;
                    try {
                        TreeSet sset = new TreeSet();
                        sset.addAll(curMap.keySet());
                        sset.addAll(cmpMap.keySet());
                        StringBuilder sb = new StringBuilder(500);
                        sb.append("<?xml version=\"1.0\"?>");
                        sb.append(CRLF);
                        sb.append("<report>");
                        sb.append(CRLF);
                        sb.append("<session-names>");
                        sb.append(CRLF);
                        sb.append("<session1>");
                        sb.append(Model.getSingleton().getSession().getSessionName());
                        sb.append("</session1>");
                        sb.append(CRLF);
                        sb.append("<session2>");
                        sb.append(session.getSessionName());
                        sb.append("</session2>");
                        sb.append(CRLF);
                        sb.append("</session-names>");
                        sb.append(CRLF);
                        Iterator iter = sset.iterator();
                        while (iter.hasNext()) {
                            sb.append("<urlrow>");
                            sb.append(CRLF);
                            String key = (String)iter.next();
                            String method = key.substring(0, key.indexOf(" "));
                            String url = key.substring(key.indexOf(" ") + 1);
                            sb.append("<method>");
                            sb.append(method);
                            sb.append("</method>");
                            sb.append(CRLF);
                            sb.append("<url>");
                            sb.append(url);
                            sb.append("</url>");
                            sb.append(CRLF);
                            sb.append("<code1>");
                            if (curMap.containsKey(key)) {
                                sb.append((String)curMap.get(key));
                            } else {
                                sb.append("---");
                            }
                            sb.append("</code1>");
                            sb.append(CRLF);
                            sb.append("<code2>");
                            if (cmpMap.containsKey(key)) {
                                sb.append((String)cmpMap.get(key));
                            } else {
                                sb.append("---");
                            }
                            sb.append("</code2>");
                            sb.append(CRLF);
                            sb.append("</urlrow>");
                            sb.append(CRLF);
                        }
                        sb.append("</report>");
                        sb.append(CRLF);
                        ReportGenerator.stringToHtml(sb.toString(), Constant.getZapInstall() + File.separator + "xml" + File.separator + "reportCompare.xsl", outputFile.getAbsolutePath());
                        try {
                            DesktopUtils.openUrlInBrowser(outputFile.toURI());
                        }
                        catch (Exception e) {
                            log.error((Object)e.getMessage(), (Throwable)e);
                            View.getSingleton().showMessageDialog(Constant.messages.getString("report.complete.warning", outputFile.getAbsolutePath()));
                        }
                    }
                    catch (Exception e1) {
                        log.warn((Object)e1.getMessage(), (Throwable)e1);
                    }
                }
                catch (Exception e) {
                    log.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private File getOutputFile() {
        JFileChooser chooser = new JFileChooser(this.getModel().getOptionsParam().getUserDirectory());
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                if (file.isFile() && file.getName().toLowerCase().endsWith(".htm")) {
                    return true;
                }
                return file.isFile() && file.getName().toLowerCase().endsWith(".html");
            }

            @Override
            public String getDescription() {
                return Constant.messages.getString("file.format.html");
            }
        });
        File file = null;
        int rc = chooser.showSaveDialog(this.getView().getMainFrame());
        if (rc == 0) {
            file = chooser.getSelectedFile();
            if (file == null) {
                return file;
            }
            this.getModel().getOptionsParam().setUserDirectory(chooser.getCurrentDirectory());
            String fileNameLc = file.getAbsolutePath().toLowerCase();
            if (!fileNameLc.endsWith(".htm") && !fileNameLc.endsWith(".html")) {
                file = new File(file.getAbsolutePath() + ".html");
            }
            return file;
        }
        return file;
    }

    @Override
    public void sessionOpened(File file, Exception e) {
    }

    @Override
    public void sessionSaved(Exception e) {
    }

    @Override
    public void sessionAboutToChange(Session session) {
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public String getDescription() {
        return Constant.messages.getString("cmp.desc");
    }

    @Override
    public URL getURL() {
        try {
            return new URL("http://www.owasp.org/index.php/ZAP");
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public void sessionModeChanged(Control.Mode mode) {
    }

    @Override
    public void sessionSnapshot(Exception e) {
    }
}

