#!/usr/bin/perl
#  reports.pl - code for various reports
#
#  Written by Curtis Olson.  Started November 12, 1994.
#
#  Copyright (C) 1994 - 1997  Curtis L. Olson  - curt@sledge.mn.org
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

# $Id: reports.pl,v 2.5 1997/01/18 03:28:45 curt Exp $
# (Log is kept at end of this file)


package CBB;

use strict;    # don't take no guff


my($cbb_incl_dir);


# specify the installed location of the necessary pieces.

$cbb_incl_dir = "..";
unshift(@INC, $cbb_incl_dir);

require "common.pl";


# process arguments
sub process_rep_args {
    my($fromdate, $todate) = ("all", "all");
    my($arg, $nicefrom, $niceto, $month, $day, $year, $cur_year);
    my($i, @account_list);

    $cur_year = substr(&raw_date, 0, 4);

    $i = 0;

    while ( $#ARGV >= 0 ) {
        $arg = shift(@ARGV);
        if ( substr($arg, 0 , 1) eq "-" ) {
            if ( $arg eq "-from" ) {
                $nicefrom = shift(@ARGV);

                ($month, $day, $year) = split(/\//, $nicefrom);
                $month = &pad($month);
                $day = &pad($day);
		if ( defined($year) ) {
                    $year = &pad($year);
		} else {
		    $year = $cur_year;
		}
                if ( length($year) == 2 ) {
                    $year = &century() . "$year";
                }
                $fromdate = "$year" . "$month" . "$day";

                # print "from $fromdate\n";
            } elsif ( $arg eq "-to" ) {
                $niceto = shift(@ARGV);

                ($month, $day, $year) = split(/\//, $niceto);
                $month = &pad($month);
                $day = &pad($day);
		if ( defined($year) ) {
                    $year = &pad($year);
		} else {
		    $year = $cur_year;
		}
                $year = &pad($year);
                if ( length($year) == 2 ) {
                    $year = &century() . "$year";
                }
                $todate = "$year" . "$month" . "$day";

                # print "to $todate\n";
            } elsif ( $arg eq "-to" ) {
                $niceto = shift(@ARGV);
                # print "to $todate\n";
            }
        } else {
	    $account_list[$i++] = $arg;
        }
    }

    return($fromdate, $todate, @account_list);
}


1;


# ----------------------------------------------------------------------------
# $Log: reports.pl,v $
# Revision 2.5  1997/01/18 03:28:45  curt
# Added "use strict" pragma to enforce good scoping habits.
#
# Revision 2.4  1996/12/17 14:54:02  curt
# Updated copyright date.
#
# Revision 2.3  1996/10/03 03:52:58  curt
# CBB now determines the current century automatically ... no need for it
# to be hard coded.  Removed all hardcoded instances of the century (especially
# in reports.pl and recur.pl)
#
# Added an optional --debug flag to the invocation of CBB.
#
# Revision 2.2  1996/07/13 02:57:52  curt
# Version 0.65
# Packing Changes
# Documenation changes
# Changes to handle a value in both debit and credit fields.
#
# Revision 2.1  1996/02/27  05:35:51  curt
# Just stumbling around a bit with cvs ... :-(
#
# Revision 2.0  1996/02/27  04:43:04  curt
# Initial 2.0 revision.  (See "Log" files for old history.)
