<?php

/**
 * Spreed WebRTC Plugin
 *
 * Integrates Spreed Web RTC into the Kopano environment
 *
 */

include_once('class.webmeetingsauth.php');

class Pluginspreedwebrtc extends Plugin {
	/**
	 * Constructor
	 */
	function Pluginspreedwebrtc(){}

	/**
	 * Called to initialize the plugin and register for hooks.
	 */
	function init(){
		$this->registerHook('server.core.settings.init.before');
	}

	/**
	 *
	 * @param String $eventID Identifier of the hook
	 * @param Array $data Reference to the data of the triggered hook
	 */
	function execute($eventID, &$data){
		switch($eventID){
			case 'server.core.settings.init.before':
				$this->onBeforeSettingsInit($data);
				break;
		}
	}

	/**
	 * Called when the core Settings class is initialized and ready to accept sysadmin default
	 * settings. Registers the sysadmin defaults for the example plugin.
	 * @param Array $data Reference to the data of the triggered hook
	 */
	function onBeforeSettingsInit(&$data){
		$data['settingsObj']->addSysAdminDefaults(Array(
			'zarafa' => Array(
				'v1' => Array(
					'plugins' => Array(
						'spreedwebrtc' => Array(
							'enable' => PLUGIN_SPREEDWEBRTC_USER_DEFAULT_ENABLE,
								'domain' => PLUGIN_SPREEDWEBRTC_SPREED_DOMAIN,
								'url' => PLUGIN_SPREEDWEBRTC_SPREED_URL,
								'debug' => PLUGIN_SPREEDWEBRTC_DEBUG,
								'autostart' => PLUGIN_SPREEDWEBRTC_AUTO_START
						)
					)
				)
			)
		));
	}
}
?>
