# KPropertyCoreConfig.cmake provides information about the installed KPropertyCore library.
# It can be used directly from CMake via find_package(KPropertyCore NO_MODULE)
#
# Any changes in this ".cmake" file will be overwritten by CMake, the source is the ".cmake.in" file.
#
# The following CMake variables are provided:
#   KPropertyCore_VERSION_MAJOR - the major version number of KPropertyCore
#   KPropertyCore_VERSION_MINOR - the minor version number of KPropertyCore
#   KPropertyCore_VERSION_PATCH - the patch version number of KPropertyCore
#   KPropertyCore_INCLUDE_DIRS  - the include directories to use
#
# Additionally, the following imported library targets are created, which may be used directly
# with target_link_libraries():
#   KPropertyCore - the KPropertyCore library


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was KPropertyCoreConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

include(CMakeFindDependencyMacro)
include(FeatureSummary)

find_dependency(Qt5Core 5.4.0)

include("${CMAKE_CURRENT_LIST_DIR}/KPropertyCoreTargets.cmake")

set_package_properties(KPropertyCore PROPERTIES
   DESCRIPTION "A property editing framework (core)"
   URL "https://community.kde.org/KProperty")

# "public" variables:
# TODO
