# KReportConfig.cmake provides information about the installed KReport library.
# It can be used directly from CMake via find_package(KReport NO_MODULE)
#
# Any changes in this ".cmake" file will be overwritten by CMake, the source is the ".cmake.in" file.
#
# The following CMake variables are provided:
#   KReport_VERSION_MAJOR - the major version number of KReport
#   KReport_VERSION_MINOR - the minor version number of KReport
#   KReport_VERSION_PATCH - the patch version number of KReport
#   KReport_INCLUDE_DIRS  - the include directories to use
#
# Additionally, the following imported library targets are created, which may be used directly
# with target_link_libraries():
#   KReport - the KReport library


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was KReportConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

include(CMakeFindDependencyMacro)

find_dependency(Qt5Core 5.4.0)
find_dependency(Qt5Widgets 5.4.0)
find_dependency(Qt5Xml 5.4.0)
find_dependency(KPropertyWidgets 3.0)

include("${CMAKE_CURRENT_LIST_DIR}/KReportTargets.cmake")

# "public" variables:

set(KREPORT_SCRIPTING ON)

include(FeatureSummary)
set_package_properties(KReport PROPERTIES
   DESCRIPTION "Framework for the creation and generation of reports in multiple formats"
   URL "https://community.kde.org/KReport")

# TODO
