/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.LookupTable;

public class ByteLookupTable
extends LookupTable {
    private byte[][] data;

    public ByteLookupTable(int offset, byte[][] data) throws IllegalArgumentException {
        super(offset, data.length);
        this.data = new byte[data.length][];
        int i = 0;
        while (i < data.length) {
            this.data[i] = data[i];
            ++i;
        }
    }

    public ByteLookupTable(int offset, byte[] data) throws IllegalArgumentException {
        super(offset, 1);
        if (data == null) {
            throw new NullPointerException("Null 'data' argument.");
        }
        this.data = new byte[][]{data};
    }

    public final byte[][] getTable() {
        return this.data;
    }

    public int[] lookupPixel(int[] src, int[] dst) throws ArrayIndexOutOfBoundsException {
        if (dst == null) {
            dst = new int[src.length];
        }
        if (this.data.length == 1) {
            int i = 0;
            while (i < src.length) {
                dst[i] = this.data[0][src[i] - this.offset];
                ++i;
            }
        } else {
            int i = 0;
            while (i < src.length) {
                dst[i] = this.data[i][src[i] - this.offset];
                ++i;
            }
        }
        return dst;
    }

    public byte[] lookupPixel(byte[] src, byte[] dst) throws ArrayIndexOutOfBoundsException {
        if (dst == null) {
            dst = new byte[src.length];
        }
        if (this.data.length == 1) {
            int i = 0;
            while (i < src.length) {
                dst[i] = this.data[0][src[i] - this.offset];
                ++i;
            }
        } else {
            int i = 0;
            while (i < src.length) {
                dst[i] = this.data[i][src[i] - this.offset];
                ++i;
            }
        }
        return dst;
    }
}

