"""Generated client library for kubernetespolicy version v1alpha1."""
# NOTE: This file is autogenerated and should not be edited by hand.
from apitools.base.py import base_api
from googlecloudsdk.third_party.apis.kubernetespolicy.v1alpha1 import kubernetespolicy_v1alpha1_messages as messages


class KubernetespolicyV1alpha1(base_api.BaseApiClient):
  """Generated client library for service kubernetespolicy version v1alpha1."""

  MESSAGES_MODULE = messages
  BASE_URL = u'https://kubernetespolicy.googleapis.com/'

  _PACKAGE = u'kubernetespolicy'
  _SCOPES = [u'https://www.googleapis.com/auth/cloud-platform']
  _VERSION = u'v1alpha1'
  _CLIENT_ID = '1042881264118.apps.googleusercontent.com'
  _CLIENT_SECRET = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _USER_AGENT = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _CLIENT_CLASS_NAME = u'KubernetespolicyV1alpha1'
  _URL_VERSION = u'v1alpha1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new kubernetespolicy handle."""
    url = url or self.BASE_URL
    super(KubernetespolicyV1alpha1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.projects_namespaces = self.ProjectsNamespacesService(self)
    self.projects = self.ProjectsService(self)

  class ProjectsNamespacesService(base_api.BaseApiService):
    """Service class for the projects_namespaces resource."""

    _NAME = u'projects_namespaces'

    def __init__(self, client):
      super(KubernetespolicyV1alpha1.ProjectsNamespacesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a Kubernetes Policy Namespace with the provided properties.
Returns a created Namespace object with the generated name populated

      Args:
        request: (Namespace) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Namespace) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/namespaces',
        http_method=u'POST',
        method_id=u'kubernetespolicy.projects.namespaces.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1alpha1/{+parent}/namespaces',
        request_field='<request>',
        request_type_name=u'Namespace',
        response_type_name=u'Namespace',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a Kubernetes Policy Namespace given a One Platform namespace name.
such as projects/{project}/namespaces/{namespace}
Delete will hard delete the namespace immediately (no trash/purge period)

      Args:
        request: (KubernetespolicyProjectsNamespacesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/namespaces/{namespacesId}',
        http_method=u'DELETE',
        method_id=u'kubernetespolicy.projects.namespaces.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'validateOnly'],
        relative_path=u'v1alpha1/{+name}',
        request_field='',
        request_type_name=u'KubernetespolicyProjectsNamespacesDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieves a Kubernetes Policy Namespace given a One Platform namespace name.
such as projects/{project}/namespaces/{namespace}

      Args:
        request: (KubernetespolicyProjectsNamespacesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Namespace) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/namespaces/{namespacesId}',
        http_method=u'GET',
        method_id=u'kubernetespolicy.projects.namespaces.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha1/{+name}',
        request_field='',
        request_type_name=u'KubernetespolicyProjectsNamespacesGetRequest',
        response_type_name=u'Namespace',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the Kubernetes Policy Namespace given a Project Id using the format.
projects/{project}. Currently each project can have at most one namespace.

      Args:
        request: (KubernetespolicyProjectsNamespacesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListNamespacesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/namespaces',
        http_method=u'GET',
        method_id=u'kubernetespolicy.projects.namespaces.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v1alpha1/{+parent}/namespaces',
        request_field='',
        request_type_name=u'KubernetespolicyProjectsNamespacesListRequest',
        response_type_name=u'ListNamespacesResponse',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = u'projects'

    def __init__(self, client):
      super(KubernetespolicyV1alpha1.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }
