/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.listener.adapter;

import javax.jms.JMSException;
import javax.jms.Session;
import org.springframework.jms.listener.adapter.AbstractAdaptableMessageListener;
import org.springframework.jms.listener.adapter.ListenerExecutionFailedException;
import org.springframework.jms.support.converter.MessageConversionException;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;

public class MessagingMessageListenerAdapter
extends AbstractAdaptableMessageListener {
    private InvocableHandlerMethod handlerMethod;

    public void setHandlerMethod(InvocableHandlerMethod handlerMethod) {
        this.handlerMethod = handlerMethod;
    }

    @Override
    public void onMessage(javax.jms.Message jmsMessage, Session session) throws JMSException {
        Object result;
        Message<?> message = this.toMessagingMessage(jmsMessage);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Processing [" + message + "]"));
        }
        if ((result = this.invokeHandler(jmsMessage, session, message)) != null) {
            this.handleResult(result, jmsMessage, session);
        } else {
            this.logger.trace((Object)"No result object given - no result to handle");
        }
    }

    protected Message<?> toMessagingMessage(javax.jms.Message jmsMessage) {
        try {
            return (Message)this.getMessagingMessageConverter().fromMessage(jmsMessage);
        }
        catch (JMSException ex) {
            throw new MessageConversionException("Could not convert JMS message", ex);
        }
    }

    private Object invokeHandler(javax.jms.Message jmsMessage, Session session, Message<?> message) {
        try {
            return this.handlerMethod.invoke(message, new Object[]{jmsMessage, session});
        }
        catch (MessagingException ex) {
            throw new ListenerExecutionFailedException(this.createMessagingErrorMessage("Listener method could not be invoked with incoming message"), ex);
        }
        catch (Exception ex) {
            throw new ListenerExecutionFailedException("Listener method '" + this.handlerMethod.getMethod().toGenericString() + "' threw exception", ex);
        }
    }

    private String createMessagingErrorMessage(String description) {
        StringBuilder sb = new StringBuilder(description).append("\n").append("Endpoint handler details:\n").append("Method [").append(this.handlerMethod.getMethod()).append("]\n").append("Bean [").append(this.handlerMethod.getBean()).append("]\n");
        return sb.toString();
    }
}

