/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mailvalidator;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.trans.steps.mailvalidator.MailValidationResult;
import org.pentaho.di.trans.steps.mailvalidator.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailValidation {
    private static LogWriter log = LogWriter.getInstance();

    public static boolean isRegExValid(String emailAdress) {
        Pattern p = Pattern.compile(".+@.+\\.[a-z]+");
        Matcher m = p.matcher(emailAdress);
        return m.matches();
    }

    public static int mailServersCount(String hostName) throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        InitialDirContext ictx = new InitialDirContext(env);
        Attributes attrs = ictx.getAttributes(hostName, new String[]{"MX"});
        Attribute attr = attrs.get("MX");
        if (attr == null) {
            return 0;
        }
        return attr.size();
    }

    private static String className() {
        return Messages.getString("MailValidator.ClassName");
    }

    private static int hear(BufferedReader in) throws IOException {
        String line = null;
        int res = 0;
        while ((line = in.readLine()) != null) {
            String pfx = line.substring(0, 3);
            try {
                res = Integer.parseInt(pfx);
            }
            catch (Exception ex) {
                res = -1;
            }
            if (line.charAt(3) == '-') continue;
            break;
        }
        return res;
    }

    private static void say(BufferedWriter wr, String text) throws IOException {
        wr.write(text + "\r\n");
        wr.flush();
    }

    private static ArrayList<String> getMX(String hostName) throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        InitialDirContext ictx = new InitialDirContext(env);
        Attributes attrs = ictx.getAttributes(hostName, new String[]{"MX"});
        Attribute attr = attrs.get("MX");
        if ((attr == null || attr.size() == 0) && (attr = (attrs = ictx.getAttributes(hostName, new String[]{"A"})).get("A")) == null) {
            throw new NamingException(Messages.getString("MailValidator.NoMatchName", hostName));
        }
        ArrayList<String> res = new ArrayList<String>();
        NamingEnumeration<?> en = attr.getAll();
        while (en.hasMore()) {
            String x = (String)en.next();
            String[] f = x.split(" ");
            if (f[1].endsWith(".")) {
                f[1] = f[1].substring(0, f[1].length() - 1);
            }
            res.add(f[1]);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static MailValidationResult isAddressValid(String address, String senderAddress, String defaultSMTPServer, int timeout, boolean deepCheck) {
        ArrayList<Object> mxList;
        String domain;
        MailValidationResult result;
        block51: {
            result = new MailValidationResult();
            if (!MailValidation.isRegExValid(address)) {
                result.setErrorMessage(Messages.getString("MailValidator.MalformedAddress", address));
                return result;
            }
            int pos = address.indexOf(64);
            if (pos == -1) {
                return result;
            }
            if (!deepCheck) {
                result.setValide(true);
                return result;
            }
            domain = address.substring(++pos);
            mxList = new ArrayList<String>();
            if (Const.isEmpty((String)defaultSMTPServer)) {
                try {
                    mxList = MailValidation.getMX(domain);
                    if (mxList == null || mxList.size() == 0) {
                        result.setErrorMessage(Messages.getString("MailValidator.NoMachinesInDomain", domain));
                        return result;
                    }
                    break block51;
                }
                catch (Exception ex) {
                    result.setErrorMessage(Messages.getString("MailValidator.ErrorGettingMachinesInDomain", ex.getMessage()));
                    return result;
                }
            }
            mxList.add(defaultSMTPServer);
        }
        if (log.isDebug()) {
            log.logDebug(MailValidation.className(), Messages.getString("MailValidator.ExchangersFound", "" + mxList.size()), new Object[0]);
        }
        for (int mx = 0; mx < mxList.size(); ++mx) {
            Exception e2222;
            Object var17_18;
            Socket skt;
            BufferedWriter wtr;
            BufferedReader rdr;
            boolean valid;
            block52: {
                valid = false;
                rdr = null;
                wtr = null;
                skt = null;
                String exhanger = (String)mxList.get(mx);
                if (log.isDebug()) {
                    log.logDebug(MailValidation.className(), Messages.getString("MailValidator.TryingExchanger", exhanger), new Object[0]);
                }
                skt = new Socket(exhanger, 25);
                if (timeout > 0) {
                    skt.setSoTimeout(timeout);
                }
                if (log.isDebug()) {
                    log.logDebug(MailValidation.className(), Messages.getString("MailValidator.ConnectingTo", exhanger, "25", skt.isConnected() + ""), new Object[0]);
                }
                rdr = new BufferedReader(new InputStreamReader(skt.getInputStream()));
                wtr = new BufferedWriter(new OutputStreamWriter(skt.getOutputStream()));
                int res = MailValidation.hear(rdr);
                if (res != 220) {
                    throw new Exception(Messages.getString("MailValidator.InvalidHeader"));
                }
                if (log.isDebug()) {
                    log.logDebug(MailValidation.className(), Messages.getString("MailValidator.SayHello", domain), new Object[0]);
                }
                MailValidation.say(wtr, "EHLO " + domain);
                res = MailValidation.hear(rdr);
                if (res != 250) {
                    throw new Exception("Not ESMTP");
                }
                if (log.isDebug()) {
                    log.logDebug(MailValidation.className(), Messages.getString("MailValidator.ServerReplied", "" + res), new Object[0]);
                }
                if (log.isDebug()) {
                    log.logDebug(MailValidation.className(), Messages.getString("MailValidator.CheckSender", senderAddress), new Object[0]);
                }
                MailValidation.say(wtr, "MAIL FROM: <" + senderAddress + ">");
                res = MailValidation.hear(rdr);
                if (res != 250) {
                    throw new Exception(Messages.getString("MailValidator.SenderRejected"));
                }
                if (log.isDebug()) {
                    log.logDebug(MailValidation.className(), Messages.getString("MailValidator.SenderAccepted", "" + res), new Object[0]);
                }
                if (log.isDebug()) {
                    log.logDebug(MailValidation.className(), Messages.getString("MailValidator.CheckReceiver", address), new Object[0]);
                }
                MailValidation.say(wtr, "RCPT TO: <" + address + ">");
                res = MailValidation.hear(rdr);
                MailValidation.say(wtr, "RSET");
                MailValidation.hear(rdr);
                MailValidation.say(wtr, "QUIT");
                MailValidation.hear(rdr);
                if (res != 250) {
                    throw new Exception(Messages.getString("MailValidator.AddressNotValid", address));
                }
                if (log.isDebug()) {
                    log.logDebug(MailValidation.className(), Messages.getString("MailValidator.ReceiverAccepted", address, "" + res), new Object[0]);
                }
                valid = true;
                var17_18 = null;
                if (rdr == null) break block52;
                try {
                    rdr.close();
                }
                catch (Exception e2222) {
                    // empty catch block
                }
            }
            if (wtr != null) {
                try {
                    wtr.close();
                }
                catch (Exception e2222) {
                    // empty catch block
                }
            }
            if (skt != null) {
                try {
                    skt.close();
                }
                catch (Exception e2222) {
                    // empty catch block
                }
            }
            if (!valid) continue;
            result.setValide(true);
            result.setErrorMessage(null);
            if (log.isDebug()) {
                log.logDebug(MailValidation.className(), "=============================================", new Object[0]);
            }
            return result;
            {
                catch (Exception ex) {
                    result.setValide(false);
                    result.setErrorMessage(ex.getMessage());
                    var17_18 = null;
                    if (rdr != null) {
                        try {
                            rdr.close();
                        }
                        catch (Exception e2222) {
                            // empty catch block
                        }
                    }
                    if (wtr != null) {
                        try {
                            wtr.close();
                        }
                        catch (Exception e2222) {
                            // empty catch block
                        }
                    }
                    if (skt != null) {
                        try {
                            skt.close();
                        }
                        catch (Exception e2222) {
                            // empty catch block
                        }
                    }
                    if (!valid) continue;
                    result.setValide(true);
                    result.setErrorMessage(null);
                    if (log.isDebug()) {
                        log.logDebug(MailValidation.className(), "=============================================", new Object[0]);
                    }
                    return result;
                }
            }
            catch (Throwable throwable) {
                var17_18 = null;
                if (rdr != null) {
                    try {
                        rdr.close();
                    }
                    catch (Exception e2222) {
                        // empty catch block
                    }
                }
                if (wtr != null) {
                    try {
                        wtr.close();
                    }
                    catch (Exception e2222) {
                        // empty catch block
                    }
                }
                if (skt != null) {
                    try {
                        skt.close();
                    }
                    catch (Exception e2222) {
                        // empty catch block
                    }
                }
                if (valid) {
                    result.setValide(true);
                    result.setErrorMessage(null);
                    if (log.isDebug()) {
                        log.logDebug(MailValidation.className(), "=============================================", new Object[0]);
                    }
                    return result;
                }
                throw throwable;
            }
        }
        if (log.isDebug()) {
            log.logDebug(MailValidation.className(), "=============================================", new Object[0]);
        }
        return result;
    }
}

