/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.build.aws.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.springframework.build.aws.maven.TransferProgress;

final class TransferProgressFileInputStream
extends FileInputStream {
    private final TransferProgress transferProgress;

    TransferProgressFileInputStream(File file2, TransferProgress transferProgress) throws FileNotFoundException {
        super(file2);
        this.transferProgress = transferProgress;
    }

    @Override
    public int read() throws IOException {
        int b = super.read();
        this.transferProgress.notify(new byte[]{(byte)b}, 1);
        return b;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int count2 = super.read(b);
        this.transferProgress.notify(b, b.length);
        return count2;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int count2 = super.read(b, off, len);
        if (off == 0) {
            this.transferProgress.notify(b, len);
        } else {
            byte[] bytes2 = new byte[len];
            System.arraycopy(b, off, bytes2, 0, len);
            this.transferProgress.notify(bytes2, len);
        }
        return count2;
    }
}

