/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.util.Map;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.TemplateScript;

public final class RenameProcessor
extends AbstractProcessor {
    public static final String TYPE = "rename";
    private final TemplateScript.Factory field;
    private final TemplateScript.Factory targetField;
    private final boolean ignoreMissing;

    RenameProcessor(String tag, TemplateScript.Factory field, TemplateScript.Factory targetField, boolean ignoreMissing) {
        super(tag);
        this.field = field;
        this.targetField = targetField;
        this.ignoreMissing = ignoreMissing;
    }

    TemplateScript.Factory getField() {
        return this.field;
    }

    TemplateScript.Factory getTargetField() {
        return this.targetField;
    }

    boolean isIgnoreMissing() {
        return this.ignoreMissing;
    }

    public void execute(IngestDocument document) {
        String path = document.renderTemplate(this.field);
        if (!document.hasField(path, true)) {
            if (this.ignoreMissing) {
                return;
            }
            throw new IllegalArgumentException("field [" + path + "] doesn't exist");
        }
        String target = document.renderTemplate(this.targetField);
        if (document.hasField(target, true)) {
            throw new IllegalArgumentException("field [" + target + "] already exists");
        }
        Object value = document.getFieldValue(path, Object.class);
        document.removeField(path);
        try {
            document.setFieldValue(target, value);
        }
        catch (Exception e) {
            document.setFieldValue(path, value);
            throw e;
        }
    }

    public String getType() {
        return TYPE;
    }

    public static final class Factory
    implements Processor.Factory {
        private final ScriptService scriptService;

        public Factory(ScriptService scriptService) {
            this.scriptService = scriptService;
        }

        public RenameProcessor create(Map<String, Processor.Factory> registry, String processorTag, Map<String, Object> config) throws Exception {
            String field = ConfigurationUtils.readStringProperty((String)RenameProcessor.TYPE, (String)processorTag, config, (String)"field");
            TemplateScript.Factory fieldTemplate = ConfigurationUtils.compileTemplate((String)RenameProcessor.TYPE, (String)processorTag, (String)"field", (String)field, (ScriptService)this.scriptService);
            String targetField = ConfigurationUtils.readStringProperty((String)RenameProcessor.TYPE, (String)processorTag, config, (String)"target_field");
            TemplateScript.Factory targetFieldTemplate = ConfigurationUtils.compileTemplate((String)RenameProcessor.TYPE, (String)processorTag, (String)"target_field", (String)targetField, (ScriptService)this.scriptService);
            boolean ignoreMissing = ConfigurationUtils.readBooleanProperty((String)RenameProcessor.TYPE, (String)processorTag, config, (String)"ignore_missing", (boolean)false);
            return new RenameProcessor(processorTag, fieldTemplate, targetFieldTemplate, ignoreMissing);
        }
    }
}

