/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.engine.control;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.jcs.access.exception.CacheException;
import org.apache.commons.jcs.access.exception.ObjectNotFoundException;
import org.apache.commons.jcs.auxiliary.AuxiliaryCache;
import org.apache.commons.jcs.engine.CacheStatus;
import org.apache.commons.jcs.engine.behavior.ICache;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.jcs.engine.behavior.ICacheType;
import org.apache.commons.jcs.engine.behavior.ICompositeCacheAttributes;
import org.apache.commons.jcs.engine.behavior.IElementAttributes;
import org.apache.commons.jcs.engine.behavior.IRequireScheduler;
import org.apache.commons.jcs.engine.control.CompositeCacheManager;
import org.apache.commons.jcs.engine.control.event.ElementEvent;
import org.apache.commons.jcs.engine.control.event.behavior.ElementEventType;
import org.apache.commons.jcs.engine.control.event.behavior.IElementEventHandler;
import org.apache.commons.jcs.engine.control.event.behavior.IElementEventQueue;
import org.apache.commons.jcs.engine.control.group.GroupId;
import org.apache.commons.jcs.engine.match.KeyMatcherPatternImpl;
import org.apache.commons.jcs.engine.match.behavior.IKeyMatcher;
import org.apache.commons.jcs.engine.memory.behavior.IMemoryCache;
import org.apache.commons.jcs.engine.memory.lru.LRUMemoryCache;
import org.apache.commons.jcs.engine.memory.shrinking.ShrinkerThread;
import org.apache.commons.jcs.engine.stats.CacheStats;
import org.apache.commons.jcs.engine.stats.StatElement;
import org.apache.commons.jcs.engine.stats.behavior.ICacheStats;
import org.apache.commons.jcs.engine.stats.behavior.IStats;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CompositeCache<K, V>
implements ICache<K, V>,
IRequireScheduler {
    private static final Log log = LogFactory.getLog(CompositeCache.class);
    private IElementEventQueue elementEventQ;
    private AuxiliaryCache<K, V>[] auxCaches = new AuxiliaryCache[0];
    private AtomicBoolean alive;
    private IElementAttributes attr;
    private ICompositeCacheAttributes cacheAttr;
    private AtomicInteger updateCount;
    private AtomicInteger removeCount;
    private AtomicInteger hitCountRam;
    private AtomicInteger hitCountAux;
    private AtomicInteger missCountNotFound;
    private AtomicInteger missCountExpired;
    private CompositeCacheManager cacheManager = null;
    private IMemoryCache<K, V> memCache;
    private IKeyMatcher<K> keyMatcher = new KeyMatcherPatternImpl();
    private ScheduledFuture<?> future;

    public CompositeCache(ICompositeCacheAttributes cattr, IElementAttributes attr) {
        this.attr = attr;
        this.cacheAttr = cattr;
        this.alive = new AtomicBoolean(true);
        this.updateCount = new AtomicInteger(0);
        this.removeCount = new AtomicInteger(0);
        this.hitCountRam = new AtomicInteger(0);
        this.hitCountAux = new AtomicInteger(0);
        this.missCountNotFound = new AtomicInteger(0);
        this.missCountExpired = new AtomicInteger(0);
        this.createMemoryCache(cattr);
        if (log.isInfoEnabled()) {
            log.info("Constructed cache with name [" + this.cacheAttr.getCacheName() + "] and cache attributes " + cattr);
        }
    }

    public void setElementEventQueue(IElementEventQueue queue) {
        this.elementEventQ = queue;
    }

    public void setCompositeCacheManager(CompositeCacheManager manager) {
        this.cacheManager = manager;
    }

    @Override
    public void setScheduledExecutorService(ScheduledExecutorService scheduledExecutor) {
        if (this.cacheAttr.isUseMemoryShrinker()) {
            this.future = scheduledExecutor.scheduleAtFixedRate(new ShrinkerThread(this), 0L, this.cacheAttr.getShrinkerIntervalSeconds(), TimeUnit.SECONDS);
        }
    }

    public void setAuxCaches(AuxiliaryCache<K, V>[] auxCaches) {
        this.auxCaches = auxCaches;
    }

    public AuxiliaryCache<K, V>[] getAuxCaches() {
        return this.auxCaches;
    }

    @Override
    public void update(ICacheElement<K, V> ce) throws IOException {
        this.update(ce, false);
    }

    public void localUpdate(ICacheElement<K, V> ce) throws IOException {
        this.update(ce, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update(ICacheElement<K, V> cacheElement, boolean localOnly) throws IOException {
        if (cacheElement.getKey() instanceof String && cacheElement.getKey().toString().endsWith(":")) {
            throw new IllegalArgumentException("key must not end with : for a put operation");
        }
        if (cacheElement.getKey() instanceof GroupId) {
            throw new IllegalArgumentException("key cannot be a GroupId  for a put operation");
        }
        if (log.isDebugEnabled()) {
            log.debug("Updating memory cache " + cacheElement.getKey());
        }
        this.updateCount.incrementAndGet();
        CompositeCache compositeCache = this;
        synchronized (compositeCache) {
            this.memCache.update(cacheElement);
            this.updateAuxiliaries(cacheElement, localOnly);
        }
        cacheElement.getElementAttributes().setLastAccessTimeNow();
    }

    protected void updateAuxiliaries(ICacheElement<K, V> cacheElement, boolean localOnly) throws IOException {
        if (log.isDebugEnabled()) {
            if (this.auxCaches.length > 0) {
                log.debug("Updating auxiliary caches");
            } else {
                log.debug("No auxiliary cache to update");
            }
        }
        block7: for (AuxiliaryCache<K, V> aux : this.auxCaches) {
            if (aux == null) continue;
            if (log.isDebugEnabled()) {
                log.debug("Auxiliary cache type: " + (Object)((Object)aux.getCacheType()));
            }
            switch (aux.getCacheType()) {
                case REMOTE_CACHE: {
                    if (log.isDebugEnabled()) {
                        log.debug("ce.getElementAttributes().getIsRemote() = " + cacheElement.getElementAttributes().getIsRemote());
                    }
                    if (!cacheElement.getElementAttributes().getIsRemote() || localOnly) continue block7;
                    try {
                        aux.update(cacheElement);
                        if (!log.isDebugEnabled()) continue block7;
                        log.debug("Updated remote store for " + cacheElement.getKey() + cacheElement);
                    }
                    catch (IOException ex) {
                        log.error("Failure in updateExclude", ex);
                    }
                    continue block7;
                }
                case LATERAL_CACHE: {
                    if (log.isDebugEnabled()) {
                        log.debug("lateralcache in aux list: cattr " + this.cacheAttr.isUseLateral());
                    }
                    if (!this.cacheAttr.isUseLateral() || !cacheElement.getElementAttributes().getIsLateral() || localOnly) continue block7;
                    aux.update(cacheElement);
                    if (!log.isDebugEnabled()) continue block7;
                    log.debug("updated lateral cache for " + cacheElement.getKey());
                    continue block7;
                }
                case DISK_CACHE: {
                    if (log.isDebugEnabled()) {
                        log.debug("diskcache in aux list: cattr " + this.cacheAttr.isUseDisk());
                    }
                    if (!this.cacheAttr.isUseDisk() || this.cacheAttr.getDiskUsagePattern() != ICompositeCacheAttributes.DiskUsagePattern.UPDATE || !cacheElement.getElementAttributes().getIsSpool()) continue block7;
                    aux.update(cacheElement);
                    if (!log.isDebugEnabled()) continue block7;
                    log.debug("updated disk cache for " + cacheElement.getKey());
                    continue block7;
                }
            }
        }
    }

    public void spoolToDisk(ICacheElement<K, V> ce) {
        if (!ce.getElementAttributes().getIsSpool()) {
            this.handleElementEvent(ce, ElementEventType.SPOOLED_NOT_ALLOWED);
            return;
        }
        boolean diskAvailable = false;
        for (AuxiliaryCache<K, V> aux : this.auxCaches) {
            if (aux == null || aux.getCacheType() != ICacheType.CacheType.DISK_CACHE) continue;
            diskAvailable = true;
            if (this.cacheAttr.getDiskUsagePattern() == ICompositeCacheAttributes.DiskUsagePattern.SWAP) {
                try {
                    this.handleElementEvent(ce, ElementEventType.SPOOLED_DISK_AVAILABLE);
                    aux.update(ce);
                }
                catch (IOException ex) {
                    log.error("Problem spooling item to disk cache.", ex);
                    throw new IllegalStateException(ex.getMessage());
                }
                if (!log.isDebugEnabled()) continue;
                log.debug("spoolToDisk done for: " + ce.getKey() + " on disk cache[" + aux.getCacheName() + "]");
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("DiskCache available, but JCS is not configured to use the DiskCache as a swap.");
        }
        if (!diskAvailable) {
            try {
                this.handleElementEvent(ce, ElementEventType.SPOOLED_DISK_NOT_AVAILABLE);
            }
            catch (Exception e) {
                log.error("Trouble handling the ELEMENT_EVENT_SPOOLED_DISK_NOT_AVAILABLE  element event", e);
            }
        }
    }

    @Override
    public ICacheElement<K, V> get(K key) {
        return this.get(key, false);
    }

    public ICacheElement<K, V> localGet(K key) {
        return this.get(key, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ICacheElement<K, V> get(K key, boolean localOnly) {
        ICacheElement<K, V> element = null;
        boolean found = false;
        if (log.isDebugEnabled()) {
            log.debug("get: key = " + key + ", localOnly = " + localOnly);
        }
        CompositeCache compositeCache = this;
        synchronized (compositeCache) {
            block24: {
                try {
                    element = this.memCache.get(key);
                    if (element != null) {
                        if (this.isExpired(element)) {
                            if (log.isDebugEnabled()) {
                                log.debug(this.cacheAttr.getCacheName() + " - Memory cache hit, but element expired");
                            }
                            this.doExpires(element);
                            element = null;
                        } else {
                            if (log.isDebugEnabled()) {
                                log.debug(this.cacheAttr.getCacheName() + " - Memory cache hit");
                            }
                            this.hitCountRam.incrementAndGet();
                        }
                        found = true;
                        break block24;
                    }
                    for (AuxiliaryCache<K, V> aux : this.auxCaches) {
                        if (aux == null) continue;
                        ICacheType.CacheType cacheType = aux.getCacheType();
                        if (!localOnly || cacheType == ICacheType.CacheType.DISK_CACHE) {
                            if (log.isDebugEnabled()) {
                                log.debug("Attempting to get from aux [" + aux.getCacheName() + "] which is of type: " + (Object)((Object)cacheType));
                            }
                            try {
                                element = aux.get(key);
                            }
                            catch (IOException e) {
                                log.error("Error getting from aux", e);
                            }
                        }
                        if (log.isDebugEnabled()) {
                            log.debug("Got CacheElement: " + element);
                        }
                        if (element == null) continue;
                        if (this.isExpired(element)) {
                            if (log.isDebugEnabled()) {
                                log.debug(this.cacheAttr.getCacheName() + " - Aux cache[" + aux.getCacheName() + "] hit, but element expired.");
                            }
                            this.doExpires(element);
                            element = null;
                        } else {
                            if (log.isDebugEnabled()) {
                                log.debug(this.cacheAttr.getCacheName() + " - Aux cache[" + aux.getCacheName() + "] hit");
                            }
                            this.hitCountAux.incrementAndGet();
                            this.copyAuxiliaryRetrievedItemToMemory(element);
                        }
                        found = true;
                        break;
                    }
                }
                catch (IOException e) {
                    log.error("Problem encountered getting element.", e);
                }
            }
        }
        if (!found) {
            this.missCountNotFound.incrementAndGet();
            if (log.isDebugEnabled()) {
                log.debug(this.cacheAttr.getCacheName() + " - Miss");
            }
        }
        if (element != null) {
            element.getElementAttributes().setLastAccessTimeNow();
        }
        return element;
    }

    protected void doExpires(ICacheElement<K, V> element) {
        this.missCountExpired.incrementAndGet();
        this.remove(element.getKey());
    }

    @Override
    public Map<K, ICacheElement<K, V>> getMultiple(Set<K> keys) {
        return this.getMultiple(keys, false);
    }

    public Map<K, ICacheElement<K, V>> localGetMultiple(Set<K> keys) {
        return this.getMultiple(keys, true);
    }

    protected Map<K, ICacheElement<K, V>> getMultiple(Set<K> keys, boolean localOnly) {
        HashMap<K, ICacheElement<K, V>> elements = new HashMap<K, ICacheElement<K, V>>();
        if (log.isDebugEnabled()) {
            log.debug("get: key = " + keys + ", localOnly = " + localOnly);
        }
        try {
            elements.putAll(this.getMultipleFromMemory(keys));
            if (elements.size() != keys.size()) {
                Set<K> remainingKeys = this.pruneKeysFound(keys, elements);
                elements.putAll(this.getMultipleFromAuxiliaryCaches(remainingKeys, localOnly));
            }
        }
        catch (IOException e) {
            log.error("Problem encountered getting elements.", e);
        }
        if (elements.size() != keys.size()) {
            this.missCountNotFound.addAndGet(keys.size() - elements.size());
            if (log.isDebugEnabled()) {
                log.debug(this.cacheAttr.getCacheName() + " - " + (keys.size() - elements.size()) + " Misses");
            }
        }
        return elements;
    }

    private Map<K, ICacheElement<K, V>> getMultipleFromMemory(Set<K> keys) throws IOException {
        Map<K, ICacheElement<K, V>> elementsFromMemory = this.memCache.getMultiple(keys);
        for (ICacheElement<K, V> element : new HashMap<K, ICacheElement<K, V>>(elementsFromMemory).values()) {
            if (element == null) continue;
            if (this.isExpired(element)) {
                if (log.isDebugEnabled()) {
                    log.debug(this.cacheAttr.getCacheName() + " - Memory cache hit, but element expired");
                }
                this.doExpires(element);
                elementsFromMemory.remove(element.getKey());
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug(this.cacheAttr.getCacheName() + " - Memory cache hit");
            }
            this.hitCountRam.incrementAndGet();
        }
        return elementsFromMemory;
    }

    private Map<K, ICacheElement<K, V>> getMultipleFromAuxiliaryCaches(Set<K> keys, boolean localOnly) throws IOException {
        HashMap elements = new HashMap();
        Set<K> remainingKeys = new HashSet<K>(keys);
        for (AuxiliaryCache<K, V> aux : this.auxCaches) {
            if (aux == null) continue;
            HashMap elementsFromAuxiliary = new HashMap();
            ICacheType.CacheType cacheType = aux.getCacheType();
            if (!localOnly || cacheType == ICacheType.CacheType.DISK_CACHE) {
                if (log.isDebugEnabled()) {
                    log.debug("Attempting to get from aux [" + aux.getCacheName() + "] which is of type: " + (Object)((Object)cacheType));
                }
                try {
                    elementsFromAuxiliary.putAll(aux.getMultiple(remainingKeys));
                }
                catch (IOException e) {
                    log.error("Error getting from aux", e);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("Got CacheElements: " + elementsFromAuxiliary);
            }
            this.processRetrievedElements(aux, elementsFromAuxiliary);
            elements.putAll(elementsFromAuxiliary);
            if (elements.size() == keys.size()) break;
            remainingKeys = this.pruneKeysFound(keys, elements);
        }
        return elements;
    }

    @Override
    public Map<K, ICacheElement<K, V>> getMatching(String pattern) {
        return this.getMatching(pattern, false);
    }

    public Map<K, ICacheElement<K, V>> localGetMatching(String pattern) {
        return this.getMatching(pattern, true);
    }

    protected Map<K, ICacheElement<K, V>> getMatching(String pattern, boolean localOnly) {
        HashMap<K, ICacheElement<K, V>> elements = new HashMap<K, ICacheElement<K, V>>();
        if (log.isDebugEnabled()) {
            log.debug("get: pattern [" + pattern + "], localOnly = " + localOnly);
        }
        try {
            elements.putAll(this.getMatchingFromAuxiliaryCaches(pattern, localOnly));
            elements.putAll(this.getMatchingFromMemory(pattern));
        }
        catch (Exception e) {
            log.error("Problem encountered getting elements.", e);
        }
        return elements;
    }

    protected Map<K, ICacheElement<K, V>> getMatchingFromMemory(String pattern) throws IOException {
        Set<K> keyArray = this.memCache.getKeySet();
        Set<K> matchingKeys = this.getKeyMatcher().getMatchingKeysFromArray(pattern, keyArray);
        return this.getMultipleFromMemory(matchingKeys);
    }

    private Map<K, ICacheElement<K, V>> getMatchingFromAuxiliaryCaches(String pattern, boolean localOnly) throws IOException {
        HashMap elements = new HashMap();
        for (int i = this.auxCaches.length - 1; i >= 0; --i) {
            AuxiliaryCache<K, V> aux = this.auxCaches[i];
            if (aux == null) continue;
            HashMap elementsFromAuxiliary = new HashMap();
            ICacheType.CacheType cacheType = aux.getCacheType();
            if (localOnly && cacheType != ICacheType.CacheType.DISK_CACHE) continue;
            if (log.isDebugEnabled()) {
                log.debug("Attempting to get from aux [" + aux.getCacheName() + "] which is of type: " + (Object)((Object)cacheType));
            }
            try {
                elementsFromAuxiliary.putAll(aux.getMatching(pattern));
            }
            catch (IOException e) {
                log.error("Error getting from aux", e);
            }
            if (log.isDebugEnabled()) {
                log.debug("Got CacheElements: " + elementsFromAuxiliary);
            }
            this.processRetrievedElements(aux, elementsFromAuxiliary);
            elements.putAll(elementsFromAuxiliary);
        }
        return elements;
    }

    private void processRetrievedElements(AuxiliaryCache<K, V> aux, Map<K, ICacheElement<K, V>> elementsFromAuxiliary) throws IOException {
        for (ICacheElement<K, V> element : new HashMap<K, ICacheElement<K, V>>(elementsFromAuxiliary).values()) {
            if (element == null) continue;
            if (this.isExpired(element)) {
                if (log.isDebugEnabled()) {
                    log.debug(this.cacheAttr.getCacheName() + " - Aux cache[" + aux.getCacheName() + "] hit, but element expired.");
                }
                this.doExpires(element);
                elementsFromAuxiliary.remove(element.getKey());
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug(this.cacheAttr.getCacheName() + " - Aux cache[" + aux.getCacheName() + "] hit");
            }
            this.hitCountAux.incrementAndGet();
            this.copyAuxiliaryRetrievedItemToMemory(element);
        }
    }

    private void copyAuxiliaryRetrievedItemToMemory(ICacheElement<K, V> element) throws IOException {
        if (this.memCache.getCacheAttributes().getMaxObjects() > 0) {
            this.memCache.update(element);
        } else if (log.isDebugEnabled()) {
            log.debug("Skipping memory update since no items are allowed in memory");
        }
    }

    private Set<K> pruneKeysFound(Set<K> keys, Map<K, ICacheElement<K, V>> foundElements) {
        HashSet<K> remainingKeys = new HashSet<K>(keys);
        for (K key : foundElements.keySet()) {
            remainingKeys.remove(key);
        }
        return remainingKeys;
    }

    public Set<K> getKeySet() {
        return this.getKeySet(false);
    }

    public Set<K> getKeySet(boolean localOnly) {
        HashSet<K> allKeys = new HashSet<K>();
        allKeys.addAll(this.memCache.getKeySet());
        for (AuxiliaryCache<K, V> aux : this.auxCaches) {
            if (aux == null || localOnly && aux.getCacheType() != ICacheType.CacheType.DISK_CACHE) continue;
            try {
                allKeys.addAll(aux.getKeySet());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return allKeys;
    }

    @Override
    public boolean remove(K key) {
        return this.remove(key, false);
    }

    public boolean localRemove(K key) {
        return this.remove(key, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean remove(K key, boolean localOnly) {
        this.removeCount.incrementAndGet();
        boolean removed = false;
        CompositeCache compositeCache = this;
        synchronized (compositeCache) {
            try {
                removed = this.memCache.remove(key);
            }
            catch (IOException e) {
                log.error(e);
            }
            for (AuxiliaryCache<K, V> aux : this.auxCaches) {
                if (aux == null) continue;
                ICacheType.CacheType cacheType = aux.getCacheType();
                if (localOnly && (cacheType == ICacheType.CacheType.REMOTE_CACHE || cacheType == ICacheType.CacheType.LATERAL_CACHE)) continue;
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("Removing " + key + " from cacheType" + (Object)((Object)cacheType));
                    }
                    boolean b = aux.remove(key);
                    if (removed || cacheType == ICacheType.CacheType.REMOTE_CACHE) continue;
                    removed = b;
                }
                catch (IOException ex) {
                    log.error("Failure removing from aux", ex);
                }
            }
        }
        return removed;
    }

    @Override
    public void removeAll() throws IOException {
        this.removeAll(false);
    }

    public void localRemoveAll() throws IOException {
        this.removeAll(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAll(boolean localOnly) throws IOException {
        CompositeCache compositeCache = this;
        synchronized (compositeCache) {
            try {
                this.memCache.removeAll();
                if (log.isDebugEnabled()) {
                    log.debug("Removed All keys from the memory cache.");
                }
            }
            catch (IOException ex) {
                log.error("Trouble updating memory cache.", ex);
            }
            for (AuxiliaryCache<K, V> aux : this.auxCaches) {
                if (aux == null || aux.getCacheType() != ICacheType.CacheType.DISK_CACHE && localOnly) continue;
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("Removing All keys from cacheType" + (Object)((Object)aux.getCacheType()));
                    }
                    aux.removeAll();
                }
                catch (IOException ex) {
                    log.error("Failure removing all from aux", ex);
                }
            }
        }
    }

    @Override
    public void dispose() {
        this.dispose(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose(boolean fromRemote) {
        if (!this.alive.compareAndSet(true, false)) {
            return;
        }
        if (log.isInfoEnabled()) {
            log.info("In DISPOSE, [" + this.cacheAttr.getCacheName() + "] fromRemote [" + fromRemote + "]");
        }
        CompositeCache compositeCache = this;
        synchronized (compositeCache) {
            if (this.cacheManager != null) {
                this.cacheManager.freeCache(this.getCacheName(), fromRemote);
            }
            if (this.future != null) {
                this.future.cancel(true);
            }
            if (this.elementEventQ != null) {
                this.elementEventQ.dispose();
                this.elementEventQ = null;
            }
            for (AuxiliaryCache<K, V> aux : this.auxCaches) {
                try {
                    if (aux == null || aux.getStatus() != CacheStatus.ALIVE || fromRemote && aux.getCacheType() == ICacheType.CacheType.REMOTE_CACHE) {
                        if (!log.isInfoEnabled()) continue;
                        log.info("In DISPOSE, [" + this.cacheAttr.getCacheName() + "] SKIPPING auxiliary [" + aux.getCacheName() + "] fromRemote [" + fromRemote + "]");
                        continue;
                    }
                    if (log.isInfoEnabled()) {
                        log.info("In DISPOSE, [" + this.cacheAttr.getCacheName() + "] auxiliary [" + aux.getCacheName() + "]");
                    }
                    if (aux.getCacheType() == ICacheType.CacheType.DISK_CACHE) {
                        int numToFree = this.memCache.getSize();
                        this.memCache.freeElements(numToFree);
                        if (log.isInfoEnabled()) {
                            log.info("In DISPOSE, [" + this.cacheAttr.getCacheName() + "] put " + numToFree + " into auxiliary " + aux.getCacheName());
                        }
                    }
                    aux.dispose();
                }
                catch (IOException ex) {
                    log.error("Failure disposing of aux.", ex);
                }
            }
            if (log.isInfoEnabled()) {
                log.info("In DISPOSE, [" + this.cacheAttr.getCacheName() + "] disposing of memory cache.");
            }
            try {
                this.memCache.dispose();
            }
            catch (IOException ex) {
                log.error("Failure disposing of memCache", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        if (!this.alive.compareAndSet(true, false)) {
            return;
        }
        CompositeCache compositeCache = this;
        synchronized (compositeCache) {
            for (AuxiliaryCache<K, V> aux : this.auxCaches) {
                try {
                    if (aux.getStatus() != CacheStatus.ALIVE) continue;
                    for (K key : this.memCache.getKeySet()) {
                        ICacheElement<K, V> ce = this.memCache.get(key);
                        if (ce == null) continue;
                        aux.update(ce);
                    }
                }
                catch (IOException ex) {
                    log.error("Failure saving aux caches.", ex);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Called save for [" + this.cacheAttr.getCacheName() + "]");
        }
    }

    @Override
    public int getSize() {
        return this.memCache.getSize();
    }

    @Override
    public ICacheType.CacheType getCacheType() {
        return ICacheType.CacheType.CACHE_HUB;
    }

    @Override
    public CacheStatus getStatus() {
        return this.alive.get() ? CacheStatus.ALIVE : CacheStatus.DISPOSED;
    }

    @Override
    public String getStats() {
        return this.getStatistics().toString();
    }

    public ICacheStats getStatistics() {
        CacheStats stats = new CacheStats();
        stats.setRegionName(this.getCacheName());
        ArrayList elems = new ArrayList();
        elems.add(new StatElement<Integer>("HitCountRam", this.getHitCountRam()));
        elems.add(new StatElement<Integer>("HitCountAux", this.getHitCountAux()));
        stats.setStatElements(elems);
        int total = this.auxCaches.length + 1;
        ArrayList<IStats> auxStats = new ArrayList<IStats>(total);
        auxStats.add(this.getMemoryCache().getStatistics());
        for (AuxiliaryCache<K, V> aux : this.auxCaches) {
            auxStats.add(aux.getStatistics());
        }
        stats.setAuxiliaryCacheStats(auxStats);
        return stats;
    }

    @Override
    public String getCacheName() {
        return this.cacheAttr.getCacheName();
    }

    public IElementAttributes getElementAttributes() {
        if (this.attr != null) {
            return this.attr.clone();
        }
        return null;
    }

    public void setElementAttributes(IElementAttributes attr) {
        this.attr = attr;
    }

    public ICompositeCacheAttributes getCacheAttributes() {
        return this.cacheAttr;
    }

    public void setCacheAttributes(ICompositeCacheAttributes cattr) {
        this.cacheAttr = cattr;
        this.memCache.initialize(this);
    }

    public IElementAttributes getElementAttributes(K key) throws CacheException, IOException {
        ICacheElement<K, V> ce = this.get(key);
        if (ce == null) {
            throw new ObjectNotFoundException("key " + key + " is not found");
        }
        return ce.getElementAttributes();
    }

    public boolean isExpired(ICacheElement<K, V> element) {
        return this.isExpired(element, System.currentTimeMillis(), ElementEventType.EXCEEDED_MAXLIFE_ONREQUEST, ElementEventType.EXCEEDED_IDLETIME_ONREQUEST);
    }

    public boolean isExpired(ICacheElement<K, V> element, long timestamp, ElementEventType eventMaxlife, ElementEventType eventIdle) {
        try {
            IElementAttributes attributes = element.getElementAttributes();
            if (!attributes.getIsEternal()) {
                long maxLifeSeconds = attributes.getMaxLife();
                long createTime = attributes.getCreateTime();
                long timeFactorForMilliseconds = attributes.getTimeFactorForMilliseconds();
                if (maxLifeSeconds != -1L && timestamp - createTime > maxLifeSeconds * timeFactorForMilliseconds) {
                    if (log.isDebugEnabled()) {
                        log.debug("Exceeded maxLife: " + element.getKey());
                    }
                    this.handleElementEvent(element, eventMaxlife);
                    return true;
                }
                long idleTime = attributes.getIdleTime();
                long lastAccessTime = attributes.getLastAccessTime();
                if (idleTime != -1L && timestamp - lastAccessTime > idleTime * timeFactorForMilliseconds) {
                    if (log.isDebugEnabled()) {
                        log.debug("Exceeded maxIdle: " + element.getKey());
                    }
                    this.handleElementEvent(element, eventIdle);
                    return true;
                }
            }
        }
        catch (Exception e) {
            log.error("Error determining expiration period, expiring", e);
            return true;
        }
        return false;
    }

    public void handleElementEvent(ICacheElement<K, V> element, ElementEventType eventType) {
        ArrayList<IElementEventHandler> eventHandlers = element.getElementAttributes().getElementEventHandlers();
        if (eventHandlers != null) {
            if (log.isDebugEnabled()) {
                log.debug("Element Handlers are registered.  Create event type " + (Object)((Object)eventType));
            }
            if (this.elementEventQ == null) {
                log.warn("No element event queue available for cache " + this.getCacheName());
                return;
            }
            ElementEvent<ICacheElement<K, V>> event = new ElementEvent<ICacheElement<K, V>>(element, eventType);
            for (IElementEventHandler hand : eventHandlers) {
                try {
                    this.elementEventQ.addElementEvent(hand, event);
                }
                catch (IOException e) {
                    log.error("Trouble adding element event to queue", e);
                }
            }
        }
    }

    private void createMemoryCache(ICompositeCacheAttributes cattr) {
        if (this.memCache == null) {
            try {
                IMemoryCache newInstance;
                Class<?> c = Class.forName(cattr.getMemoryCacheName());
                this.memCache = newInstance = (IMemoryCache)c.newInstance();
                this.memCache.initialize(this);
            }
            catch (Exception e) {
                log.warn("Failed to init mem cache, using: LRUMemoryCache", e);
                this.memCache = new LRUMemoryCache();
                this.memCache.initialize(this);
            }
        } else {
            log.warn("Refusing to create memory cache -- already exists.");
        }
    }

    public IMemoryCache<K, V> getMemoryCache() {
        return this.memCache;
    }

    public int getHitCountRam() {
        return this.hitCountRam.get();
    }

    public int getHitCountAux() {
        return this.hitCountAux.get();
    }

    public int getMissCountNotFound() {
        return this.missCountNotFound.get();
    }

    public int getMissCountExpired() {
        return this.missCountExpired.get();
    }

    public int getUpdateCount() {
        return this.updateCount.get();
    }

    @Override
    public void setKeyMatcher(IKeyMatcher<K> keyMatcher) {
        if (keyMatcher != null) {
            this.keyMatcher = keyMatcher;
        }
    }

    public IKeyMatcher<K> getKeyMatcher() {
        return this.keyMatcher;
    }

    public String toString() {
        return this.getStats();
    }
}

