/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.utils.threadpool;

import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.jcs.utils.config.PropertySetter;
import org.apache.commons.jcs.utils.threadpool.DaemonThreadFactory;
import org.apache.commons.jcs.utils.threadpool.PoolConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ThreadPoolManager {
    private static final Log log = LogFactory.getLog(ThreadPoolManager.class);
    private PoolConfiguration defaultConfig;
    private static final String PROP_NAME_ROOT = "thread_pool";
    private static final String DEFAULT_PROP_NAME_ROOT = "thread_pool.default";
    private static final String PROP_NAME_SCHEDULER_ROOT = "scheduler_pool";
    private static final String DEFAULT_PROP_NAME_SCHEDULER_ROOT = "scheduler_pool.default";
    private static volatile Properties props = null;
    private static ThreadPoolManager INSTANCE = null;
    private ConcurrentHashMap<String, ExecutorService> pools = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ScheduledExecutorService> schedulerPools = new ConcurrentHashMap();

    private ThreadPoolManager() {
        this.configure();
    }

    public ExecutorService createPool(PoolConfiguration config, String threadNamePrefix) {
        return this.createPool(config, threadNamePrefix, 5);
    }

    public ExecutorService createPool(PoolConfiguration config, String threadNamePrefix, int threadPriority) {
        LinkedBlockingQueue<Runnable> queue = null;
        if (config.isUseBoundary()) {
            if (log.isDebugEnabled()) {
                log.debug("Creating a Bounded Buffer to use for the pool");
            }
            queue = new LinkedBlockingQueue(config.getBoundarySize());
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Creating a non bounded Linked Queue to use for the pool");
            }
            queue = new LinkedBlockingQueue<Runnable>();
        }
        ThreadPoolExecutor pool = new ThreadPoolExecutor(config.getStartUpSize(), config.getMaximumPoolSize(), (long)config.getKeepAliveTime(), TimeUnit.MILLISECONDS, queue, new DaemonThreadFactory(threadNamePrefix, threadPriority));
        switch (config.getWhenBlockedPolicy()) {
            case ABORT: {
                pool.setRejectedExecutionHandler(new ThreadPoolExecutor.AbortPolicy());
                break;
            }
            case RUN: {
                pool.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
                break;
            }
            case WAIT: {
                throw new RuntimeException("POLICY_WAIT no longer supported");
            }
            case DISCARDOLDEST: {
                pool.setRejectedExecutionHandler(new ThreadPoolExecutor.DiscardOldestPolicy());
                break;
            }
        }
        pool.prestartAllCoreThreads();
        return pool;
    }

    public ScheduledExecutorService createSchedulerPool(PoolConfiguration config, String threadNamePrefix, int threadPriority) {
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(config.getMaximumPoolSize(), new DaemonThreadFactory(threadNamePrefix, threadPriority));
        return scheduler;
    }

    public static synchronized ThreadPoolManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ThreadPoolManager();
        }
        return INSTANCE;
    }

    public static synchronized void dispose() {
        if (INSTANCE != null) {
            for (ExecutorService executorService : ThreadPoolManager.INSTANCE.pools.values()) {
                try {
                    executorService.shutdownNow();
                }
                catch (Throwable t) {
                    log.warn("Failed to close pool " + executorService, t);
                }
            }
            for (ScheduledExecutorService scheduledExecutorService : ThreadPoolManager.INSTANCE.schedulerPools.values()) {
                try {
                    scheduledExecutorService.shutdownNow();
                }
                catch (Throwable t) {
                    log.warn("Failed to close pool " + scheduledExecutorService, t);
                }
            }
            INSTANCE = null;
        }
    }

    public ExecutorService getExecutorService(String name) {
        ExecutorService pool = this.pools.get(name);
        if (pool == null) {
            PoolConfiguration config;
            ExecutorService _pool;
            if (log.isDebugEnabled()) {
                log.debug("Creating pool for name [" + name + "]");
            }
            if ((pool = this.pools.putIfAbsent(name, _pool = this.createPool(config = this.loadConfig("thread_pool." + name), "JCS-ThreadPoolManager-" + name + "-"))) == null) {
                pool = _pool;
            } else {
                _pool.shutdownNow();
            }
            if (log.isDebugEnabled()) {
                log.debug("PoolName = " + this.getPoolNames());
            }
        }
        return pool;
    }

    public ScheduledExecutorService getSchedulerPool(String name) {
        ScheduledExecutorService pool = this.schedulerPools.get(name);
        if (pool == null) {
            if (log.isDebugEnabled()) {
                log.debug("Creating scheduler pool for name [" + name + "]");
            }
            PoolConfiguration defaultSchedulerConfig = this.loadConfig(DEFAULT_PROP_NAME_SCHEDULER_ROOT);
            PoolConfiguration config = this.loadConfig("scheduler_pool." + name, defaultSchedulerConfig);
            ScheduledExecutorService _pool = this.createSchedulerPool(config, "JCS-ThreadPoolManager-" + name + "-", 5);
            pool = this.schedulerPools.putIfAbsent(name, _pool);
            if (pool == null) {
                pool = _pool;
            } else {
                _pool.shutdownNow();
            }
        }
        return pool;
    }

    public ArrayList<String> getPoolNames() {
        return new ArrayList<String>(this.pools.keySet());
    }

    public static void setProps(Properties props) {
        ThreadPoolManager.props = props;
    }

    private void configure() {
        if (log.isDebugEnabled()) {
            log.debug("Initializing ThreadPoolManager");
        }
        if (props == null) {
            log.warn("No configuration settings found.  Using hardcoded default values for all pools.");
            props = new Properties();
        }
        this.defaultConfig = new PoolConfiguration();
        this.defaultConfig = this.loadConfig(DEFAULT_PROP_NAME_ROOT);
    }

    private PoolConfiguration loadConfig(String root) {
        return this.loadConfig(root, this.defaultConfig);
    }

    private PoolConfiguration loadConfig(String root, PoolConfiguration defaultPoolConfiguration) {
        PoolConfiguration config = defaultPoolConfiguration.clone();
        PropertySetter.setProperties(config, props, root + ".");
        if (log.isDebugEnabled()) {
            log.debug(root + " PoolConfiguration = " + config);
        }
        return config;
    }
}

